/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.owl.core;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class DroolsQuadObject<T1, T2, T3, T4> {
    private final @NonNull T1 t1;
    private final @NonNull T2 t2;
    private final @NonNull T3 t3;
    private final @NonNull T4 t4;

    protected DroolsQuadObject(@NonNull T1 t1, @NonNull T2 t2, @NonNull T3 t3, @NonNull T4 t4) {
        this.t1 = t1;
        this.t2 = t2;
        this.t3 = t3;
        this.t4 = t4;
    }

    protected @NonNull T1 getT1() {
        return this.t1;
    }

    protected @NonNull T2 getT2() {
        return this.t2;
    }

    protected @NonNull T3 getT3() {
        return this.t3;
    }

    protected @NonNull T4 getT4() {
        return this.t4;
    }

    @SideEffectFree
    public @NonNull String toString() {
        return "(" + this.t1 + ", " + this.t2 + ", " + this.t3 + ", " + this.t4 + ")";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        @NonNull @NonNull @NonNull @NonNull DroolsQuadObject that = (DroolsQuadObject)o;
        if (!Objects.equals(this.t1, that.t1)) {
            return false;
        }
        if (!Objects.equals(this.t2, that.t2)) {
            return false;
        }
        if (!Objects.equals(this.t3, that.t3)) {
            return false;
        }
        return Objects.equals(this.t4, that.t4);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int result = this.t1 != null ? this.t1.hashCode() : 0;
        result = 31 * result + (this.t2 != null ? this.t2.hashCode() : 0);
        result = 31 * result + (this.t3 != null ? this.t3.hashCode() : 0);
        result = 31 * result + (this.t4 != null ? this.t4.hashCode() : 0);
        return result;
    }
}

