/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.owl.literals;

import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.drools.extractors.DroolsSWRLBuiltInArgumentExtractor;
import org.swrlapi.drools.owl.core.OO;
import org.swrlapi.drools.swrl.BA;
import org.swrlapi.exceptions.TargetSWRLRuleEngineException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;

public class L
implements OO,
BA,
Serializable {
    private static final long serialVersionUID = 1L;
    public final @NonNull String value;
    public final @NonNull String datatypeName;

    public L(@NonNull String value, @NonNull String datatypeName) {
        this.value = value;
        this.datatypeName = datatypeName;
    }

    public L(@NonNull L l) {
        this.value = l.value;
        this.datatypeName = l.datatypeName;
    }

    public L(@NonNull BA ba) {
        if (!(ba instanceof L)) {
            throw new TargetSWRLRuleEngineInternalException("expecting OWL literal from bound built-in argument, got " + ba.getClass().getCanonicalName());
        }
        L l = (L)ba;
        this.value = l.getValue();
        this.datatypeName = l.getTypeName();
    }

    public boolean isInt() {
        return this.datatypeName.equals(XSDVocabulary.INT.getPrefixedName());
    }

    public boolean isLong() {
        return this.datatypeName.equals(XSDVocabulary.LONG.getPrefixedName());
    }

    public boolean isFloat() {
        return this.datatypeName.equals(XSDVocabulary.FLOAT.getPrefixedName());
    }

    public boolean isDouble() {
        return this.datatypeName.equals(XSDVocabulary.DOUBLE.getPrefixedName());
    }

    public boolean isShort() {
        return this.datatypeName.equals(XSDVocabulary.SHORT.getPrefixedName());
    }

    public boolean isBoolean() {
        return this.datatypeName.equals(XSDVocabulary.BOOLEAN.getPrefixedName());
    }

    public boolean isByte() {
        return this.datatypeName.equals(XSDVocabulary.BYTE.getPrefixedName());
    }

    public boolean isAnyURI() {
        return this.datatypeName.equals(XSDVocabulary.ANY_URI.getPrefixedName());
    }

    public boolean isTime() {
        return this.datatypeName.equals(XSDVocabulary.TIME.getPrefixedName());
    }

    public boolean isDate() {
        return this.datatypeName.equals(XSDVocabulary.DATE.getPrefixedName());
    }

    public boolean isDateTime() {
        return this.datatypeName.equals(XSDVocabulary.DATE_TIME.getPrefixedName());
    }

    public boolean isDuration() {
        return this.datatypeName.equals(XSDVocabulary.DURATION.getPrefixedName());
    }

    public boolean isString() {
        return this.datatypeName.equals(XSDVocabulary.STRING.getPrefixedName());
    }

    @Override
    public @NonNull SWRLBuiltInArgument extract(@NonNull DroolsSWRLBuiltInArgumentExtractor extractor) throws TargetSWRLRuleEngineException {
        return extractor.extract(this);
    }

    @SideEffectFree
    public @NonNull String toString() {
        return "L(\"" + this.value + "\", " + this.datatypeName + ")";
    }

    public @NonNull String getTypeName() {
        return this.datatypeName;
    }

    public @NonNull String getValue() {
        return this.value;
    }

    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        L l = (L)o;
        if (!this.value.equals(l.value)) {
            return false;
        }
        return this.datatypeName.equals(l.datatypeName);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.datatypeName.hashCode();
        return result;
    }
}

