/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.reasoner;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.swrlapi.drools.owl.axioms.A;
import org.swrlapi.drools.owl.axioms.AOPA;
import org.swrlapi.drools.owl.axioms.APDA;
import org.swrlapi.drools.owl.axioms.AVisitor;
import org.swrlapi.drools.owl.axioms.CAA;
import org.swrlapi.drools.owl.axioms.CDA;
import org.swrlapi.drools.owl.axioms.DCA;
import org.swrlapi.drools.owl.axioms.DDPA;
import org.swrlapi.drools.owl.axioms.DIA;
import org.swrlapi.drools.owl.axioms.DJDPA;
import org.swrlapi.drools.owl.axioms.DJOPA;
import org.swrlapi.drools.owl.axioms.DOPA;
import org.swrlapi.drools.owl.axioms.DPAA;
import org.swrlapi.drools.owl.axioms.DPDA;
import org.swrlapi.drools.owl.axioms.DPRA;
import org.swrlapi.drools.owl.axioms.ECA;
import org.swrlapi.drools.owl.axioms.EDPA;
import org.swrlapi.drools.owl.axioms.EOPA;
import org.swrlapi.drools.owl.axioms.FDPA;
import org.swrlapi.drools.owl.axioms.FOPA;
import org.swrlapi.drools.owl.axioms.IDA;
import org.swrlapi.drools.owl.axioms.IFOPA;
import org.swrlapi.drools.owl.axioms.IOPA;
import org.swrlapi.drools.owl.axioms.IROPA;
import org.swrlapi.drools.owl.axioms.NDPAA;
import org.swrlapi.drools.owl.axioms.NOPAA;
import org.swrlapi.drools.owl.axioms.OPAA;
import org.swrlapi.drools.owl.axioms.OPDA;
import org.swrlapi.drools.owl.axioms.OPRA;
import org.swrlapi.drools.owl.axioms.SCA;
import org.swrlapi.drools.owl.axioms.SDPA;
import org.swrlapi.drools.owl.axioms.SIA;
import org.swrlapi.drools.owl.axioms.SOPA;
import org.swrlapi.drools.owl.axioms.SPA;
import org.swrlapi.drools.owl.axioms.TOPA;
import org.swrlapi.drools.owl.literals.L;
import org.swrlapi.drools.reasoner.DroolsOWLAxiomHandler;
import org.swrlapi.exceptions.TargetSWRLRuleEngineInternalException;
import org.swrlapi.owl2rl.OWL2RLInconsistencyDescription;

public class DefaultDroolsOWLAxiomHandler
implements DroolsOWLAxiomHandler,
AVisitor {
    private final @NonNull Set<@NonNull A> inferredOWLAxioms = new HashSet<A>();
    private final @NonNull Set<@NonNull A> assertedOWLAxioms = new HashSet<A>();
    private final @NonNull Set<@NonNull String> declaredClassIDs;
    private final @NonNull Set<@NonNull String> declaredIndividualIDs;
    private final @NonNull Set<@NonNull String> declaredObjectPropertyIDs;
    private final @NonNull Set<@NonNull String> declaredDataPropertyIDs;
    private final @NonNull Set<@NonNull String> declaredAnnotationPropertyIDs;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> classAssertions;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> subClasses;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> superClasses;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> disjointClasses;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> equivalentClasses;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> sameIndividual;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> differentIndividuals;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> subObjectProperties;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> superObjectProperties;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> disjointObjectProperties;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> equivalentObjectProperties;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> inverseObjectProperties;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> objectPropertyRanges;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> objectPropertyDomains;
    private final @NonNull Map<@NonNull String, @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>>> objectPropertyAssertions;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> subDataProperties;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> superDataProperties;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> disjointDataProperties;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> equivalentDataProperties;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> dataPropertyDomains;
    private final @NonNull Map<@NonNull String, @NonNull Map<@NonNull String, @NonNull Set<@NonNull L>>> dataPropertyAssertions;
    private final @NonNull Set<@NonNull String> inconsistentMessages = new HashSet<String>();
    private boolean isInconsistent = false;
    private @MonotonicNonNull StatefulKnowledgeSession knowledgeSession;

    public DefaultDroolsOWLAxiomHandler() {
        this.declaredClassIDs = new HashSet<String>();
        this.declaredIndividualIDs = new HashSet<String>();
        this.declaredObjectPropertyIDs = new HashSet<String>();
        this.declaredDataPropertyIDs = new HashSet<String>();
        this.declaredAnnotationPropertyIDs = new HashSet<String>();
        this.subClasses = new HashMap<String, Set<String>>();
        this.subObjectProperties = new HashMap<String, Set<String>>();
        this.subDataProperties = new HashMap<String, Set<String>>();
        this.superClasses = new HashMap<String, Set<String>>();
        this.superObjectProperties = new HashMap<String, Set<String>>();
        this.superDataProperties = new HashMap<String, Set<String>>();
        this.sameIndividual = new HashMap<String, Set<String>>();
        this.differentIndividuals = new HashMap<String, Set<String>>();
        this.disjointClasses = new HashMap<String, Set<String>>();
        this.disjointObjectProperties = new HashMap<String, Set<String>>();
        this.disjointDataProperties = new HashMap<String, Set<String>>();
        this.equivalentClasses = new HashMap<String, Set<String>>();
        this.equivalentObjectProperties = new HashMap<String, Set<String>>();
        this.equivalentDataProperties = new HashMap<String, Set<String>>();
        this.classAssertions = new HashMap<String, Set<String>>();
        this.inverseObjectProperties = new HashMap<String, Set<String>>();
        this.objectPropertyRanges = new HashMap<String, Set<String>>();
        this.objectPropertyDomains = new HashMap<String, Set<String>>();
        this.dataPropertyDomains = new HashMap<String, Set<String>>();
        this.objectPropertyAssertions = new HashMap<String, Map<String, Set<String>>>();
        this.dataPropertyAssertions = new HashMap<String, Map<String, Set<L>>>();
    }

    public void reset(StatefulKnowledgeSession knowledgeSession) {
        this.knowledgeSession = knowledgeSession;
        this.assertedOWLAxioms.clear();
        this.inferredOWLAxioms.clear();
        this.isInconsistent = false;
        this.inconsistentMessages.clear();
        this.declaredClassIDs.clear();
        this.declaredIndividualIDs.clear();
        this.declaredObjectPropertyIDs.clear();
        this.declaredDataPropertyIDs.clear();
        this.declaredAnnotationPropertyIDs.clear();
        this.subClasses.clear();
        this.subObjectProperties.clear();
        this.subDataProperties.clear();
        this.superClasses.clear();
        this.superObjectProperties.clear();
        this.superDataProperties.clear();
        this.sameIndividual.clear();
        this.differentIndividuals.clear();
        this.disjointClasses.clear();
        this.disjointObjectProperties.clear();
        this.disjointDataProperties.clear();
        this.equivalentClasses.clear();
        this.equivalentObjectProperties.clear();
        this.equivalentDataProperties.clear();
        this.classAssertions.clear();
        this.inverseObjectProperties.clear();
        this.objectPropertyRanges.clear();
        this.objectPropertyDomains.clear();
        this.dataPropertyDomains.clear();
        this.objectPropertyAssertions.clear();
        this.dataPropertyAssertions.clear();
    }

    @Override
    public boolean isInconsistent() {
        return this.isInconsistent;
    }

    @Override
    public void addAssertOWLAxioms(@NonNull Set<@NonNull A> newAssertedOWLAxioms) {
        this.assertedOWLAxioms.addAll(newAssertedOWLAxioms);
        for (A a : newAssertedOWLAxioms) {
            a.visit(this);
        }
    }

    @Override
    public void infer(A ... newInferredOWLAxioms) {
        if (this.knowledgeSession == null) {
            throw new TargetSWRLRuleEngineInternalException("knowledge session not initialized in axiom inferrer");
        }
        for (A newInferredOWLAxiom : newInferredOWLAxioms) {
            if (this.inferredOWLAxioms.contains(newInferredOWLAxiom) || this.assertedOWLAxioms.contains(newInferredOWLAxiom)) continue;
            this.inferredOWLAxioms.add(newInferredOWLAxiom);
            if (this.knowledgeSession != null) {
                this.knowledgeSession.insert((Object)newInferredOWLAxiom);
                newInferredOWLAxiom.visit(this);
                continue;
            }
            throw new TargetSWRLRuleEngineInternalException("No knowledge session!");
        }
    }

    @Override
    public @NonNull Set<@NonNull A> getAssertedOWLAxioms() {
        return Collections.unmodifiableSet(this.assertedOWLAxioms);
    }

    @Override
    public @NonNull Set<@NonNull A> getInferredOWLAxioms() {
        return Collections.unmodifiableSet(this.inferredOWLAxioms);
    }

    @Override
    public boolean isEntailed(@NonNull A a) {
        return this.assertedOWLAxioms.contains(a) || this.inferredOWLAxioms.contains(a);
    }

    @Override
    public boolean isEntailed(@NonNull Set<? extends @NonNull A> axioms) {
        for (A a : axioms) {
            if (!this.isEntailed(a)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDeclaredClass(@NonNull String classID) {
        return this.declaredClassIDs.contains(classID);
    }

    @Override
    public @NonNull Set<@NonNull String> getClassAssertions(@NonNull String classID) {
        if (this.classAssertions.get(classID) != null) {
            return this.classAssertions.get(classID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Set<@NonNull String> getSubClasses(@NonNull String classID, boolean direct) {
        HashSet<@NonNull String> subClasses = new HashSet<String>();
        if (this.subClasses.get(classID) != null) {
            for (String subClassID : this.subClasses.get(classID)) {
                if (direct) {
                    if (!this.directSubClassOf(classID, subClassID)) continue;
                    subClasses.add(subClassID);
                    continue;
                }
                if (!this.strictSubClassOf(classID, subClassID)) continue;
                subClasses.add(subClassID);
            }
        }
        return subClasses;
    }

    @Override
    public @NonNull Set<@NonNull String> getSuperClasses(@NonNull String classID, boolean direct) {
        HashSet<@NonNull String> superClasses = new HashSet<String>();
        if (this.superClasses.get(classID) != null) {
            for (String superClassID : this.superClasses.get(classID)) {
                if (direct) {
                    if (!this.directSubClassOf(superClassID, classID)) continue;
                    superClasses.add(superClassID);
                    continue;
                }
                if (!this.strictSubClassOf(superClassID, classID)) continue;
                superClasses.add(superClassID);
            }
        }
        return superClasses;
    }

    @Override
    public @NonNull Set<@NonNull String> getDisjointClasses(@NonNull String classID) {
        if (this.disjointClasses.get(classID) != null) {
            return this.disjointClasses.get(classID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Set<@NonNull String> getEquivalentClasses(@NonNull String classID) {
        if (this.equivalentClasses.get(classID) != null) {
            return this.equivalentClasses.get(classID);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean strictSubClassOf(@NonNull String ceid1, @NonNull String ceid2) {
        this.checkSubClassIDs(ceid1, ceid2);
        return this.subClasses.get(ceid1) != null && this.subClasses.get(ceid1).contains(ceid2) && this.subClasses.get(ceid2) != null && !this.subClasses.get(ceid2).contains(ceid1);
    }

    @Override
    public boolean directSubClassOf(@NonNull String ceid1, @NonNull String ceid2) {
        this.checkSubClassIDs(ceid1, ceid2);
        if (this.strictSubClassOf(ceid1, ceid2)) {
            if (this.subClasses.get(ceid1) != null) {
                for (String superClassID : this.subClasses.get(ceid1)) {
                    if (!this.strictSubClassOf(superClassID, ceid2)) continue;
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isDeclaredIndividual(@NonNull String individualID) {
        return this.declaredIndividualIDs.contains(individualID);
    }

    @Override
    public @NonNull Set<@NonNull String> getSameIndividual(@NonNull String individualID) {
        if (this.sameIndividual.get(individualID) != null) {
            return this.sameIndividual.get(individualID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Set<@NonNull String> getDifferentIndividuals(@NonNull String individualID) {
        if (this.differentIndividuals.get(individualID) != null) {
            return this.differentIndividuals.get(individualID);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isDeclaredObjectProperty(@NonNull String propertyID) {
        return this.declaredObjectPropertyIDs.contains(propertyID);
    }

    @Override
    public @NonNull Set<@NonNull String> getSubObjectProperties(@NonNull String propertyID, boolean direct) {
        HashSet<@NonNull String> subProperties = new HashSet<String>();
        if (this.subObjectProperties.get(propertyID) != null) {
            for (String subPropertyID : this.subObjectProperties.get(propertyID)) {
                if (direct) {
                    if (!this.directSubObjectPropertyOf(propertyID, subPropertyID)) continue;
                    subProperties.add(subPropertyID);
                    continue;
                }
                if (!this.strictSubObjectPropertyOf(propertyID, subPropertyID)) continue;
                subProperties.add(subPropertyID);
            }
        }
        return subProperties;
    }

    @Override
    public @NonNull Set<@NonNull String> getSuperObjectProperties(@NonNull String propertyID, boolean direct) {
        HashSet<@NonNull String> superProperties = new HashSet<String>();
        if (this.superObjectProperties.get(propertyID) != null) {
            for (String superPropertyID : this.superObjectProperties.get(propertyID)) {
                if (direct) {
                    if (!this.directSubObjectPropertyOf(superPropertyID, propertyID)) continue;
                    superProperties.add(superPropertyID);
                    continue;
                }
                if (!this.strictSubObjectPropertyOf(superPropertyID, propertyID)) continue;
                superProperties.add(superPropertyID);
            }
        }
        return superProperties;
    }

    @Override
    public @NonNull Set<@NonNull String> getObjectPropertyRanges(@NonNull String propertyID, boolean direct) {
        if (this.objectPropertyRanges.get(propertyID) != null) {
            return this.objectPropertyRanges.get(propertyID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Set<@NonNull String> getObjectPropertyDomains(@NonNull String propertyID, boolean direct) {
        if (this.objectPropertyRanges.get(propertyID) != null) {
            return this.objectPropertyRanges.get(propertyID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Set<@NonNull String> getDisjointObjectProperties(@NonNull String propertyID) {
        if (this.disjointObjectProperties.get(propertyID) != null) {
            return this.disjointObjectProperties.get(propertyID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Set<@NonNull String> getEquivalentObjectProperties(@NonNull String propertyID) {
        if (this.equivalentObjectProperties.get(propertyID) != null) {
            return this.equivalentObjectProperties.get(propertyID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Set<@NonNull String> getInverseObjectProperties(@NonNull String propertyID) {
        if (this.inverseObjectProperties.get(propertyID) != null) {
            return this.inverseObjectProperties.get(propertyID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull Set<@NonNull String>> getObjectPropertyAssertions(@NonNull String propertyID) {
        if (this.objectPropertyAssertions.get(propertyID) != null) {
            return this.objectPropertyAssertions.get(propertyID);
        }
        return Collections.emptyMap();
    }

    @Override
    public @NonNull Set<@NonNull String> getObjectPropertyValuesForIndividual(@NonNull String individualID, @NonNull String propertyID) {
        Map<String, Set<String>> values;
        HashSet<@NonNull String> individualIDs = new HashSet<String>();
        if (this.objectPropertyAssertions.get(propertyID) != null && (values = this.objectPropertyAssertions.get(propertyID)).get(individualID) != null) {
            individualIDs.addAll((Collection<String>)values.get(individualID));
        }
        return individualIDs;
    }

    @Override
    public boolean strictSubObjectPropertyOf(@NonNull String opid1, @NonNull String opid2) {
        this.checkSubObjectPropertyIDs(opid1, opid2);
        return this.subObjectProperties.get(opid1) != null && this.subObjectProperties.get(opid1).contains(opid2) && this.subObjectProperties.get(opid2) != null && !this.subObjectProperties.get(opid2).contains(opid1);
    }

    @Override
    public boolean directSubObjectPropertyOf(@NonNull String opid1, @NonNull String opid2) {
        this.checkSubObjectPropertyIDs(opid1, opid2);
        if (this.strictSubObjectPropertyOf(opid1, opid2)) {
            if (this.subObjectProperties.get(opid1) != null) {
                for (String superObjectPropertyID : this.subObjectProperties.get(opid1)) {
                    if (!this.strictSubObjectPropertyOf(superObjectPropertyID, opid2)) continue;
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isDeclaredDataProperty(@NonNull String propertyID) {
        return this.declaredDataPropertyIDs.contains(propertyID);
    }

    @Override
    public @NonNull Set<@NonNull String> getSubDataProperties(@NonNull String propertyID, boolean direct) {
        HashSet<@NonNull String> subProperties = new HashSet<String>();
        if (this.subDataProperties.get(propertyID) != null) {
            for (String subPropertyID : this.subDataProperties.get(propertyID)) {
                if (direct) {
                    if (!this.directSubDataPropertyOf(propertyID, subPropertyID)) continue;
                    subProperties.add(subPropertyID);
                    continue;
                }
                if (!this.strictSubDataPropertyOf(propertyID, subPropertyID)) continue;
                subProperties.add(subPropertyID);
            }
        }
        return subProperties;
    }

    @Override
    public @NonNull Set<@NonNull String> getSuperDataProperties(@NonNull String propertyID, boolean direct) {
        HashSet<@NonNull String> superProperties = new HashSet<String>();
        if (this.superDataProperties.get(propertyID) != null) {
            for (String superPropertyID : this.superDataProperties.get(propertyID)) {
                if (direct) {
                    if (!this.directSubDataPropertyOf(superPropertyID, propertyID)) continue;
                    superProperties.add(superPropertyID);
                    continue;
                }
                if (!this.strictSubDataPropertyOf(superPropertyID, propertyID)) continue;
                superProperties.add(superPropertyID);
            }
        }
        return superProperties;
    }

    @Override
    public @NonNull Set<@NonNull String> getDataPropertyDomains(@NonNull String propertyID, boolean direct) {
        if (this.dataPropertyDomains.get(propertyID) != null) {
            return this.dataPropertyDomains.get(propertyID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Set<@NonNull String> getDisjointDataProperties(@NonNull String propertyID) {
        if (this.disjointDataProperties.get(propertyID) != null) {
            return this.disjointDataProperties.get(propertyID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Set<@NonNull String> getEquivalentDataProperties(@NonNull String propertyID) {
        if (this.equivalentDataProperties.get(propertyID) != null) {
            return this.equivalentDataProperties.get(propertyID);
        }
        return Collections.emptySet();
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull Set<@NonNull L>> getDataPropertyAssertions(@NonNull String propertyID) {
        if (this.dataPropertyAssertions.get(propertyID) != null) {
            return this.dataPropertyAssertions.get(propertyID);
        }
        return Collections.emptyMap();
    }

    @Override
    public @NonNull Set<@NonNull L> getDataPropertyValuesForIndividual(@NonNull String individualID, @NonNull String propertyID) {
        Map<String, Set<L>> values;
        HashSet<@NonNull L> literals = new HashSet<L>();
        if (this.dataPropertyAssertions.get(propertyID) != null && (values = this.dataPropertyAssertions.get(propertyID)).get(individualID) != null) {
            literals.addAll((Collection<L>)values.get(individualID));
        }
        return literals;
    }

    @Override
    public boolean strictSubDataPropertyOf(@NonNull String opid1, @NonNull String opid2) {
        this.checkSubDataPropertyIDs(opid1, opid2);
        return this.subDataProperties.get(opid1) != null && this.subDataProperties.get(opid1).contains(opid2) && this.subDataProperties.get(opid2) != null && !this.subDataProperties.get(opid2).contains(opid1);
    }

    @Override
    public boolean directSubDataPropertyOf(@NonNull String dpid1, @NonNull String dpid2) {
        this.checkSubDataPropertyIDs(dpid1, dpid2);
        if (this.strictSubDataPropertyOf(dpid1, dpid2)) {
            if (this.subDataProperties.get(dpid1) != null) {
                for (String superDataPropertyID : this.subDataProperties.get(dpid1)) {
                    if (!this.strictSubDataPropertyOf(superDataPropertyID, dpid2)) continue;
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isDeclaredAnnotation(@NonNull String propertyID) {
        return this.declaredAnnotationPropertyIDs.contains(propertyID);
    }

    public @NonNull Set<@NonNull String> getInconsistentMessages() {
        return Collections.unmodifiableSet(this.inconsistentMessages);
    }

    @Override
    public void inferFalse(@NonNull String owl2RLRuleName, String ... arguments) {
        String inconsistentMessage = "OWL 2 RL rule detected an inconsistency in the ontology.\n See http://www.w3.org/TR/owl-profiles/#Reasoning_in_OWL_2_RL_and_RDF_Graphs_using_Rules for a list of inconsistency detection rules.\nRule that detected an inconsistency: " + owl2RLRuleName;
        Iterator<String> argumentsIterator = Arrays.asList(arguments).iterator();
        if (OWL2RLInconsistencyDescription.hasInconsistencyRuleArgumentsDescription((String)owl2RLRuleName)) {
            Optional ruleArguments = OWL2RLInconsistencyDescription.getRuleArguments((String)owl2RLRuleName);
            if (ruleArguments.isPresent()) {
                int argumentCount;
                if (((OWL2RLInconsistencyDescription.OWL2RLRuleArguments)ruleArguments.get()).hasClassArguments()) {
                    inconsistentMessage = inconsistentMessage + "\n Classes:";
                    for (argumentCount = 0; argumentCount < ((OWL2RLInconsistencyDescription.OWL2RLRuleArguments)ruleArguments.get()).getNumberOfClassArguments() && argumentsIterator.hasNext(); ++argumentCount) {
                        inconsistentMessage = inconsistentMessage + " " + argumentsIterator.next();
                    }
                }
                if (((OWL2RLInconsistencyDescription.OWL2RLRuleArguments)ruleArguments.get()).hasIndividualArguments()) {
                    inconsistentMessage = inconsistentMessage + "\n Individuals:";
                    for (argumentCount = 0; argumentCount < ((OWL2RLInconsistencyDescription.OWL2RLRuleArguments)ruleArguments.get()).getNumberOfIndividualArguments() && argumentsIterator.hasNext(); ++argumentCount) {
                        inconsistentMessage = inconsistentMessage + " " + argumentsIterator.next();
                    }
                }
                if (((OWL2RLInconsistencyDescription.OWL2RLRuleArguments)ruleArguments.get()).hasObjectPropertyArguments()) {
                    inconsistentMessage = inconsistentMessage + "\n Object Properties:";
                    for (argumentCount = 0; argumentCount < ((OWL2RLInconsistencyDescription.OWL2RLRuleArguments)ruleArguments.get()).getNumberOfObjectPropertyArguments() && argumentsIterator.hasNext(); ++argumentCount) {
                        inconsistentMessage = inconsistentMessage + " " + argumentsIterator.next();
                    }
                }
                if (((OWL2RLInconsistencyDescription.OWL2RLRuleArguments)ruleArguments.get()).hasDataPropertyArguments()) {
                    inconsistentMessage = inconsistentMessage + "\n Data Properties:";
                    for (argumentCount = 0; argumentCount < ((OWL2RLInconsistencyDescription.OWL2RLRuleArguments)ruleArguments.get()).getNumberOfObjectPropertyArguments() && argumentsIterator.hasNext(); ++argumentCount) {
                        inconsistentMessage = inconsistentMessage + " " + argumentsIterator.next();
                    }
                }
            }
            this.isInconsistent = true;
        }
        this.inconsistentMessages.add(inconsistentMessage);
    }

    @Override
    public void visit(@NonNull CDA cda) {
        this.declaredClassIDs.add(cda.getcid());
    }

    @Override
    public void visit(@NonNull OPDA opda) {
        this.declaredObjectPropertyIDs.add(opda.getpid());
    }

    @Override
    public void visit(@NonNull DPDA dpda) {
        this.declaredDataPropertyIDs.add(dpda.getpid());
    }

    @Override
    public void visit(@NonNull APDA apda) {
        this.declaredAnnotationPropertyIDs.add(apda.getpid());
    }

    @Override
    public void visit(@NonNull IDA ida) {
        this.declaredIndividualIDs.add(ida.getI().getid());
    }

    @Override
    public void visit(@NonNull SCA sca) {
        String subClassID = sca.getsubcid();
        String superClassID = sca.getsupercid();
        if (this.subClasses.containsKey(superClassID)) {
            this.subClasses.get(superClassID).add(subClassID);
        } else {
            HashSet<@NonNull String> subClasses = new HashSet<String>();
            subClasses.add(subClassID);
            this.subClasses.put(superClassID, subClasses);
        }
        if (this.superClasses.containsKey(subClassID)) {
            this.superClasses.get(subClassID).add(superClassID);
        } else {
            HashSet<@NonNull String> superClasses = new HashSet<String>();
            superClasses.add(superClassID);
            this.superClasses.put(subClassID, superClasses);
        }
    }

    @Override
    public void visit(@NonNull DCA dca) {
        String c1ID = dca.getc1id();
        String c2ID = dca.getc2id();
        if (this.disjointClasses.containsKey(c1ID)) {
            this.disjointClasses.get(c1ID).add(c2ID);
        } else {
            HashSet<@NonNull String> classIDs = new HashSet<String>();
            classIDs.add(c2ID);
            this.disjointClasses.put(c1ID, classIDs);
        }
    }

    @Override
    public void visit(@NonNull DDPA ddpa) {
        String propertyID = ddpa.getpid();
        String domainID = ddpa.getdid();
        if (this.dataPropertyDomains.containsKey(propertyID)) {
            this.dataPropertyDomains.get(propertyID).add(domainID);
        } else {
            HashSet<@NonNull String> classIDs = new HashSet<String>();
            classIDs.add(domainID);
            this.dataPropertyDomains.put(propertyID, classIDs);
        }
    }

    @Override
    public void visit(@NonNull DOPA dopa) {
        String propertyID = dopa.getpid();
        String domainID = dopa.getdid();
        if (this.objectPropertyDomains.containsKey(propertyID)) {
            this.objectPropertyDomains.get(propertyID).add(domainID);
        } else {
            HashSet<@NonNull String> classIDs = new HashSet<String>();
            classIDs.add(domainID);
            this.objectPropertyDomains.put(propertyID, classIDs);
        }
    }

    @Override
    public void visit(@NonNull EOPA eopa) {
        String p1ID = eopa.getp1id();
        String p2ID = eopa.getp2id();
        if (this.equivalentObjectProperties.containsKey(p1ID)) {
            this.equivalentObjectProperties.get(p1ID).add(p2ID);
        } else {
            HashSet<@NonNull String> properties = new HashSet<String>();
            properties.add(p2ID);
            this.equivalentObjectProperties.put(p1ID, properties);
        }
    }

    @Override
    public void visit(@NonNull DIA dia) {
        String i1ID = dia.geti1id();
        String i2ID = dia.geti2id();
        if (this.differentIndividuals.containsKey(i1ID)) {
            this.differentIndividuals.get(i1ID).add(i2ID);
        } else {
            HashSet<@NonNull String> individuals = new HashSet<String>();
            individuals.add(i2ID);
            this.differentIndividuals.put(i1ID, individuals);
        }
    }

    @Override
    public void visit(@NonNull DJDPA djdpa) {
        String p1ID = djdpa.getp1id();
        String p2ID = djdpa.getp2id();
        if (this.disjointDataProperties.containsKey(p1ID)) {
            this.disjointDataProperties.get(p1ID).add(p2ID);
        } else {
            HashSet<@NonNull String> properties = new HashSet<String>();
            properties.add(p2ID);
            this.disjointDataProperties.put(p1ID, properties);
        }
    }

    @Override
    public void visit(@NonNull DJOPA djopa) {
        String p1ID = djopa.getp1id();
        String p2ID = djopa.getp2id();
        if (this.disjointObjectProperties.containsKey(p1ID)) {
            this.disjointObjectProperties.get(p1ID).add(p2ID);
        } else {
            HashSet<@NonNull String> properties = new HashSet<String>();
            properties.add(p2ID);
            this.disjointObjectProperties.put(p1ID, properties);
        }
    }

    @Override
    public void visit(@NonNull OPRA opra) {
        String propertyID = opra.getpid();
        String rangeID = opra.getrid();
        if (this.objectPropertyRanges.containsKey(propertyID)) {
            this.objectPropertyRanges.get(propertyID).add(rangeID);
        } else {
            HashSet<@NonNull String> classIDs = new HashSet<String>();
            classIDs.add(rangeID);
            this.objectPropertyRanges.put(propertyID, classIDs);
        }
    }

    @Override
    public void visit(@NonNull OPAA opaa) {
        String subjectID = opaa.getsid();
        String propertyID = opaa.getpid();
        String objectID = opaa.getoid();
        if (this.objectPropertyAssertions.containsKey(subjectID)) {
            Map<@NonNull String, Set<@NonNull String>> property2Values = this.objectPropertyAssertions.get(subjectID);
            if (property2Values.containsKey(propertyID)) {
                Set<@NonNull String> values = property2Values.get(propertyID);
                values.add(objectID);
            } else {
                HashSet<@NonNull String> values = new HashSet<String>();
                values.add(objectID);
                property2Values.put(propertyID, values);
            }
        } else {
            HashMap<@NonNull String, HashSet<@NonNull E>> property2Values = new HashMap();
            HashSet<@NonNull String> values = new HashSet<String>();
            values.add(objectID);
            property2Values.put(propertyID, values);
            this.objectPropertyAssertions.put(subjectID, property2Values);
        }
    }

    @Override
    public void visit(@NonNull SOPA sopa) {
        String subPropertyID = sopa.getsubpid();
        String superPropertyID = sopa.getsuperpid();
        if (this.subObjectProperties.containsKey(superPropertyID)) {
            this.subObjectProperties.get(superPropertyID).add(subPropertyID);
        } else {
            HashSet<@NonNull String> subProperties = new HashSet<String>();
            subProperties.add(subPropertyID);
            this.subObjectProperties.put(superPropertyID, subProperties);
        }
        if (this.superObjectProperties.containsKey(subPropertyID)) {
            this.superObjectProperties.get(subPropertyID).add(superPropertyID);
        } else {
            HashSet<@NonNull String> superProperties = new HashSet<String>();
            superProperties.add(superPropertyID);
            this.superObjectProperties.put(subPropertyID, superProperties);
        }
    }

    @Override
    public void visit(@NonNull EDPA edpa) {
        String p1ID = edpa.getp1id();
        String p2ID = edpa.getp2id();
        if (this.equivalentDataProperties.containsKey(p1ID)) {
            this.equivalentDataProperties.get(p1ID).add(p2ID);
        } else {
            HashSet<@NonNull String> properties = new HashSet<String>();
            properties.add(p2ID);
            this.equivalentDataProperties.put(p1ID, properties);
        }
    }

    @Override
    public void visit(@NonNull CAA caa) {
        String classID = caa.getcid();
        String individualID = caa.getiid();
        if (this.classAssertions.containsKey(classID)) {
            this.classAssertions.get(classID).add(individualID);
        } else {
            HashSet<@NonNull String> individuals = new HashSet<String>();
            individuals.add(individualID);
            this.classAssertions.put(classID, individuals);
        }
    }

    @Override
    public void visit(@NonNull ECA eca) {
        String c1ID = eca.getc1id();
        String c2ID = eca.getc2id();
        if (this.equivalentClasses.containsKey(c1ID)) {
            this.equivalentClasses.get(c1ID).add(c2ID);
        } else {
            HashSet<@NonNull String> classIDs = new HashSet<String>();
            classIDs.add(c2ID);
            this.equivalentClasses.put(c1ID, classIDs);
        }
    }

    @Override
    public void visit(@NonNull DPAA dpaa) {
        String subjectID = dpaa.getsid();
        String propertyID = dpaa.getpid();
        L object = dpaa.geto();
        if (this.dataPropertyAssertions.containsKey(subjectID)) {
            Map<@NonNull String, @NonNull Set<@NonNull L>> property2Values = this.dataPropertyAssertions.get(subjectID);
            if (property2Values.containsKey(propertyID)) {
                Set<@NonNull L> values = property2Values.get(propertyID);
                values.add(object);
            } else {
                HashSet<@NonNull L> values = new HashSet<L>();
                values.add(object);
                property2Values.put(propertyID, values);
            }
        } else {
            HashMap<@NonNull String, @NonNull HashSet<@NonNull E>> property2Values = new HashMap();
            HashSet<@NonNull L> values = new HashSet<L>();
            values.add(object);
            property2Values.put(propertyID, values);
            this.dataPropertyAssertions.put(subjectID, property2Values);
        }
    }

    @Override
    public void visit(@NonNull SDPA sdpa) {
        String subPropertyID = sdpa.getsubpid();
        String superPropertyID = sdpa.getsuperpid();
        if (this.subDataProperties.containsKey(superPropertyID)) {
            this.subDataProperties.get(superPropertyID).add(subPropertyID);
        } else {
            HashSet<@NonNull String> subProperties = new HashSet<String>();
            subProperties.add(subPropertyID);
            this.subDataProperties.put(superPropertyID, subProperties);
        }
        if (this.superDataProperties.containsKey(subPropertyID)) {
            this.superDataProperties.get(subPropertyID).add(superPropertyID);
        } else {
            HashSet<@NonNull String> superProperties = new HashSet<String>();
            superProperties.add(superPropertyID);
            this.superDataProperties.put(subPropertyID, superProperties);
        }
    }

    @Override
    public void visit(@NonNull SIA sia) {
        String i1ID = sia.geti1id();
        String i2ID = sia.geti2id();
        if (this.sameIndividual.containsKey(i1ID)) {
            this.sameIndividual.get(i1ID).add(i2ID);
        } else {
            HashSet<@NonNull String> individuals = new HashSet<String>();
            individuals.add(i2ID);
            this.sameIndividual.put(i1ID, individuals);
        }
    }

    @Override
    public void visit(@NonNull IOPA iopa) {
        String p1ID = iopa.getp1id();
        String p2ID = iopa.getp2id();
        if (this.inverseObjectProperties.containsKey(p1ID)) {
            this.inverseObjectProperties.get(p1ID).add(p2ID);
        } else {
            HashSet<@NonNull String> properties = new HashSet<String>();
            properties.add(p2ID);
            this.inverseObjectProperties.put(p1ID, properties);
        }
    }

    @Override
    public void visit(NOPAA nopa) {
    }

    @Override
    public void visit(AOPA aopa) {
    }

    @Override
    public void visit(NDPAA ndpaa) {
    }

    @Override
    public void visit(FOPA fopa) {
    }

    @Override
    public void visit(TOPA topa) {
    }

    @Override
    public void visit(IROPA iropa) {
    }

    @Override
    public void visit(SPA spa) {
    }

    @Override
    public void visit(DPRA dpra) {
    }

    @Override
    public void visit(FDPA fdpa) {
    }

    @Override
    public void visit(IFOPA ifopa) {
    }

    private void checkSubClassIDs(String ... ceids) {
        for (String ceid : ceids) {
            if (this.subClasses.containsKey(ceid)) continue;
            throw new TargetSWRLRuleEngineInternalException("No recordOWLClassExpression of OWL class expression with ID " + ceid);
        }
    }

    private void checkSubObjectPropertyIDs(String ... opids) {
        for (String opid : opids) {
            if (this.subObjectProperties.containsKey(opid)) continue;
            throw new TargetSWRLRuleEngineInternalException("No recordOWLClassExpression of OWL object property expression with ID " + opid);
        }
    }

    private void checkSubDataPropertyIDs(String ... dpids) {
        for (String dpid : dpids) {
            if (this.subDataProperties.containsKey(dpid)) continue;
            throw new TargetSWRLRuleEngineInternalException("No recordOWLClassExpression of OWL data property expression with ID " + dpid);
        }
    }
}

