/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.drools.reasoner;

import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLReasonerBase;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.Version;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.swrlapi.drools.converters.oo.DroolsOWLClassExpressionHandler;
import org.swrlapi.drools.converters.oo.DroolsOWLEntity2OEConverter;
import org.swrlapi.drools.converters.oo.DroolsOWLIndividual2IConverter;
import org.swrlapi.drools.converters.oo.DroolsOWLPropertyExpressionHandler;
import org.swrlapi.drools.owl.classes.C;
import org.swrlapi.drools.owl.classes.CE;
import org.swrlapi.drools.owl.individuals.I;
import org.swrlapi.drools.owl.literals.L;
import org.swrlapi.drools.owl.properties.DP;
import org.swrlapi.drools.owl.properties.DPE;
import org.swrlapi.drools.owl.properties.OPE;
import org.swrlapi.drools.reasoner.DroolsOWLAxiomHandler;
import org.swrlapi.factory.OWLLiteralFactory;

public class DroolsOWLReasoner
extends OWLReasonerBase
implements OWLReasoner {
    private static final String REASONER_NAME = "DroolsOWL2RLReasoner";
    private static final Version REASONER_VERSION = new Version(0, 0, 0, 0);
    private static final String OWLThingPrefixedName = OWLRDFVocabulary.OWL_NOTHING.getPrefixedName();
    private static final String OWLNothingPrefixedName = OWLRDFVocabulary.OWL_NOTHING.getPrefixedName();
    private static final String OWLTopObjectPropertyPrefixedName = OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getPrefixedName();
    private static final String OWLBottomObjectPropertyPrefixedName = OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getPrefixedName();
    private static final String OWLTopDataPropertyPrefixedName = OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getPrefixedName();
    private static final String OWLBottomDataPropertyPrefixedName = OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getPrefixedName();
    private final @NonNull DroolsOWLAxiomHandler droolsOWLAxiomHandler;
    private final @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler;
    private final @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler;
    private final @NonNull DroolsOWLIndividual2IConverter droolsOWLIndividual2IConverter;
    private final @NonNull DroolsOWLEntity2OEConverter droolsOWLEntity2OEConverter;
    private final @NonNull OWLLiteralFactory owlLiteralFactory;
    private boolean prepared = false;
    private boolean interrupted = false;

    public DroolsOWLReasoner(@NonNull OWLOntology rootOntology, @NonNull OWLReasonerConfiguration configuration, @NonNull BufferingMode bufferingMode, @NonNull OWLLiteralFactory owlLiteralFactory, @NonNull DroolsOWLAxiomHandler droolsOWLAxiomHandler, @NonNull DroolsOWLClassExpressionHandler droolsOWLClassExpressionHandler, @NonNull DroolsOWLPropertyExpressionHandler droolsOWLPropertyExpressionHandler, @NonNull DroolsOWLIndividual2IConverter droolsOWLIndividual2IConverter, @NonNull DroolsOWLEntity2OEConverter droolsOWLEntity2OEConverter) {
        super(rootOntology, configuration, bufferingMode);
        this.droolsOWLAxiomHandler = droolsOWLAxiomHandler;
        this.droolsOWLClassExpressionHandler = droolsOWLClassExpressionHandler;
        this.droolsOWLPropertyExpressionHandler = droolsOWLPropertyExpressionHandler;
        this.droolsOWLIndividual2IConverter = droolsOWLIndividual2IConverter;
        this.droolsOWLEntity2OEConverter = droolsOWLEntity2OEConverter;
        this.owlLiteralFactory = owlLiteralFactory;
    }

    public @NonNull String getReasonerName() {
        return REASONER_NAME;
    }

    public @NonNull Version getReasonerVersion() {
        return REASONER_VERSION;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        this.prepareReasoner();
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        return true;
    }

    public @NonNull Set<@NonNull InferenceType> getPrecomputableInferenceTypes() {
        return CollectionFactory.createSet((Object[])new InferenceType[]{InferenceType.CLASS_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY});
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        return !this.getDroolsOWLAxiomHandler().isInconsistent();
    }

    public boolean isSatisfiable(@NonNull OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        if (!classExpression.isAnonymous()) {
            CE ce = this.resolveCE(classExpression);
            return this.getDroolsOWLAxiomHandler().getEquivalentClasses(OWLNothingPrefixedName).contains(ce.getceid());
        }
        return false;
    }

    public @NonNull Node<@NonNull OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        return this.getBottomClassNode();
    }

    public boolean isEntailed(@NonNull OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return EntitySearcher.containsAxiomIgnoreAnnotations((OWLAxiom)axiom, (OWLOntology)this.getRootOntology(), (boolean)true);
    }

    public boolean isEntailed(@NonNull Set<? extends @NonNull OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        for (OWLAxiom oWLAxiom : axioms) {
            if (EntitySearcher.containsAxiomIgnoreAnnotations((OWLAxiom)oWLAxiom, (OWLOntology)this.getRootOntology(), (boolean)true)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return false;
    }

    public @NonNull Node<@NonNull OWLClass> getTopClassNode() {
        HashSet<@NonNull OWLClass> classes = new HashSet<OWLClass>();
        for (String classID : this.getDroolsOWLAxiomHandler().getEquivalentClasses(OWLThingPrefixedName)) {
            OWLClass c = this.resolveOWLClass(classID);
            classes.add(c);
        }
        return new OWLClassNode(classes);
    }

    public @NonNull Node<@NonNull OWLClass> getBottomClassNode() {
        HashSet<@NonNull OWLClass> classes = new HashSet<OWLClass>();
        for (String classID : this.getDroolsOWLAxiomHandler().getEquivalentClasses(OWLNothingPrefixedName)) {
            OWLClass c = this.resolveOWLClass(classID);
            classes.add(c);
        }
        return new OWLClassNode(classes);
    }

    public @NonNull NodeSet<@NonNull OWLClass> getSubClasses(@NonNull OWLClassExpression classExpression, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!classExpression.isAnonymous()) {
            this.ensurePrepared();
            C c = this.resolveC(classExpression.asOWLClass());
            String classID = c.getceid();
            for (String subClassID : this.getDroolsOWLAxiomHandler().getSubClasses(classID, direct)) {
                OWLClassExpression subClassExpression = this.resolveOWLClassExpression(subClassID);
                Node<OWLClass> cNode = this.getEquivalentClasses(subClassExpression);
                ns.addNode(cNode);
            }
        }
        return ns;
    }

    public @NonNull NodeSet<@NonNull OWLClass> getSuperClasses(@NonNull OWLClassExpression classExpression, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!classExpression.isAnonymous()) {
            this.ensurePrepared();
            C c = this.resolveC(classExpression.asOWLClass());
            String classID = c.getceid();
            for (String superClassID : this.getDroolsOWLAxiomHandler().getSuperClasses(classID, direct)) {
                OWLClassExpression subClassExpression = this.resolveOWLClassExpression(superClassID);
                Node<OWLClass> cNode = this.getEquivalentClasses(subClassExpression);
                ns.addNode(cNode);
            }
        }
        return ns;
    }

    public @NonNull Node<@NonNull OWLClass> getEquivalentClasses(OWLClassExpression classExpression) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        HashSet<@NonNull OWLClass> classes = new HashSet<OWLClass>();
        CE ce = this.resolveCE(classExpression);
        String classID = ce.getceid();
        for (String equivalentClassID : this.getDroolsOWLAxiomHandler().getEquivalentClasses(classID)) {
            OWLClass c = this.resolveOWLClass(equivalentClassID);
            classes.add(c);
        }
        return new OWLClassNode(classes);
    }

    public @NonNull NodeSet<@NonNull OWLClass> getDisjointClasses(@NonNull OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        OWLClassNodeSet nodeSet = new OWLClassNodeSet();
        if (!classExpression.isAnonymous()) {
            this.ensurePrepared();
            C c = this.resolveC(classExpression.asOWLClass());
            String classID = c.getceid();
            for (String disjointClassID : this.getDroolsOWLAxiomHandler().getDisjointClasses(classID)) {
                OWLClassExpression disjointClassExpression = this.resolveOWLClassExpression(disjointClassID);
                Node<OWLClass> cNode = this.getEquivalentClasses(disjointClassExpression);
                nodeSet.addNode(cNode);
            }
        }
        return nodeSet;
    }

    public @NonNull Node<@NonNull OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        HashSet<@NonNull OWLObjectPropertyExpression> properties = new HashSet<OWLObjectPropertyExpression>();
        for (String propertyID : this.getDroolsOWLAxiomHandler().getEquivalentObjectProperties(OWLTopObjectPropertyPrefixedName)) {
            OWLObjectPropertyExpression property = this.resolveOWLObjectPropertyExpression(propertyID);
            properties.add(property);
        }
        return new OWLObjectPropertyNode(properties);
    }

    public @NonNull Node<@NonNull OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        HashSet<@NonNull OWLObjectPropertyExpression> properties = new HashSet<OWLObjectPropertyExpression>();
        for (String propertyID : this.getDroolsOWLAxiomHandler().getEquivalentObjectProperties(OWLBottomObjectPropertyPrefixedName)) {
            OWLObjectPropertyExpression property = this.resolveOWLObjectPropertyExpression(propertyID);
            properties.add(property);
        }
        return new OWLObjectPropertyNode(properties);
    }

    public @NonNull NodeSet<@NonNull OWLObjectPropertyExpression> getSubObjectProperties(@NonNull OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        this.ensurePrepared();
        OPE pe = this.resolveOPE(objectPropertyExpression);
        String propertyID = pe.getid();
        for (String subPropertyID : this.getDroolsOWLAxiomHandler().getSubObjectProperties(propertyID, direct)) {
            OWLObjectPropertyExpression subPropertyExpression = this.resolveOWLObjectPropertyExpression(subPropertyID);
            Node<OWLObjectPropertyExpression> opNode = this.getEquivalentObjectProperties(subPropertyExpression);
            ns.addNode(opNode);
        }
        return ns;
    }

    public @NonNull NodeSet<@NonNull OWLObjectPropertyExpression> getSuperObjectProperties(@NonNull OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        this.ensurePrepared();
        OPE pe = this.resolveOPE(objectPropertyExpression);
        String propertyID = pe.getid();
        for (String superPropertyID : this.getDroolsOWLAxiomHandler().getSuperObjectProperties(propertyID, direct)) {
            OWLObjectPropertyExpression superPropertyExpression = this.resolveOWLObjectPropertyExpression(superPropertyID);
            Node<OWLObjectPropertyExpression> opNode = this.getEquivalentObjectProperties(superPropertyExpression);
            ns.addNode(opNode);
        }
        return ns;
    }

    public @NonNull Node<@NonNull OWLObjectPropertyExpression> getEquivalentObjectProperties(@NonNull OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        HashSet<@NonNull OWLObjectPropertyExpression> properties = new HashSet<OWLObjectPropertyExpression>();
        OPE ope = this.resolveOPE(objectPropertyExpression);
        String propertyID = ope.getid();
        for (String equivalentPropertyID : this.getDroolsOWLAxiomHandler().getEquivalentObjectProperties(propertyID)) {
            OWLObjectPropertyExpression p = this.resolveOWLObjectPropertyExpression(equivalentPropertyID);
            properties.add(p);
        }
        return new OWLObjectPropertyNode(properties);
    }

    public @NonNull NodeSet<@NonNull OWLObjectPropertyExpression> getDisjointObjectProperties(@NonNull OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet nodeSet = new OWLObjectPropertyNodeSet();
        this.ensurePrepared();
        OPE ope = this.resolveOPE(objectPropertyExpression);
        String propertyID = ope.getid();
        for (String disjointPropertyID : this.getDroolsOWLAxiomHandler().getDisjointObjectProperties(propertyID)) {
            OWLObjectPropertyExpression disjointProperty = this.resolveOWLObjectPropertyExpression(disjointPropertyID);
            Node<OWLObjectPropertyExpression> opNode = this.getEquivalentObjectProperties(disjointProperty);
            nodeSet.addNode(opNode);
        }
        return nodeSet;
    }

    public @NonNull Node<@NonNull OWLObjectPropertyExpression> getInverseObjectProperties(@NonNull OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.ensurePrepared();
        OWLObjectPropertyExpression inv = objectPropertyExpression.getInverseProperty();
        return this.getEquivalentObjectProperties(inv);
    }

    public @NonNull NodeSet<@NonNull OWLClass> getObjectPropertyDomains(@NonNull OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        OPE ope = this.resolveOPE(objectPropertyExpression);
        String propertyID = ope.getid();
        for (String classID : this.getDroolsOWLAxiomHandler().getObjectPropertyDomains(propertyID, direct)) {
            OWLClass domainClass = this.resolveOWLClass(classID);
            Node<OWLClass> cNode = this.getEquivalentClasses((OWLClassExpression)domainClass);
            ns.addNode(cNode);
        }
        return ns;
    }

    public @NonNull NodeSet<@NonNull OWLClass> getObjectPropertyRanges(@NonNull OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        OPE ope = this.resolveOPE(objectPropertyExpression);
        String propertyID = ope.getid();
        for (String classID : this.getDroolsOWLAxiomHandler().getObjectPropertyRanges(propertyID, direct)) {
            OWLClass rangeClass = this.resolveOWLClass(classID);
            Node<OWLClass> cNode = this.getEquivalentClasses((OWLClassExpression)rangeClass);
            ns.addNode(cNode);
        }
        return ns;
    }

    public @NonNull Node<@NonNull OWLDataProperty> getTopDataPropertyNode() {
        HashSet<@NonNull OWLDataProperty> properties = new HashSet<OWLDataProperty>();
        for (String propertyID : this.getDroolsOWLAxiomHandler().getEquivalentDataProperties(OWLTopDataPropertyPrefixedName)) {
            OWLDataProperty property = this.resolveOWLDataProperty(propertyID);
            properties.add(property);
        }
        return new OWLDataPropertyNode(properties);
    }

    public @NonNull Node<@NonNull OWLDataProperty> getBottomDataPropertyNode() {
        HashSet<@NonNull OWLDataProperty> properties = new HashSet<OWLDataProperty>();
        for (String propertyID : this.getDroolsOWLAxiomHandler().getEquivalentDataProperties(OWLBottomDataPropertyPrefixedName)) {
            OWLDataProperty property = this.resolveOWLDataProperty(propertyID);
            properties.add(property);
        }
        return new OWLDataPropertyNode(properties);
    }

    public @NonNull NodeSet<@NonNull OWLDataProperty> getSubDataProperties(@NonNull OWLDataProperty dataProperty, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        this.ensurePrepared();
        DP dp = this.resolveDP(dataProperty);
        String propertyID = dp.getid();
        for (String subPropertyID : this.getDroolsOWLAxiomHandler().getSubDataProperties(propertyID, direct)) {
            OWLDataProperty subProperty = this.resolveOWLDataProperty(subPropertyID);
            Node<OWLDataProperty> opNode = this.getEquivalentDataProperties(subProperty);
            ns.addNode(opNode);
        }
        return ns;
    }

    public @NonNull NodeSet<@NonNull OWLDataProperty> getSuperDataProperties(@NonNull OWLDataProperty dataProperty, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        this.ensurePrepared();
        DP dp = this.resolveDP(dataProperty);
        String propertyID = dp.getid();
        for (String subPropertyID : this.getDroolsOWLAxiomHandler().getSuperDataProperties(propertyID, direct)) {
            OWLDataProperty subProperty = this.resolveOWLDataProperty(subPropertyID);
            Node<OWLDataProperty> opNode = this.getEquivalentDataProperties(subProperty);
            ns.addNode(opNode);
        }
        return ns;
    }

    public @NonNull Node<@NonNull OWLDataProperty> getEquivalentDataProperties(@NonNull OWLDataProperty dataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        HashSet<@NonNull OWLDataProperty> properties = new HashSet<OWLDataProperty>();
        DP dp = this.resolveDP(dataProperty);
        String propertyID = dp.getid();
        for (String equivalentPropertyID : this.getDroolsOWLAxiomHandler().getEquivalentDataProperties(propertyID)) {
            OWLDataProperty p = this.resolveOWLDataProperty(equivalentPropertyID);
            properties.add(p);
        }
        return new OWLDataPropertyNode(properties);
    }

    public @NonNull NodeSet<@NonNull OWLDataProperty> getDisjointDataProperties(@NonNull OWLDataPropertyExpression dataPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet nodeSet = new OWLDataPropertyNodeSet();
        this.ensurePrepared();
        DPE dpe = this.resolveDPE(dataPropertyExpression);
        String propertyID = dpe.getid();
        for (String disjointPropertyID : this.getDroolsOWLAxiomHandler().getDisjointDataProperties(propertyID)) {
            OWLDataProperty disjointProperty = this.resolveOWLDataProperty(disjointPropertyID);
            Node<OWLDataProperty> dpNode = this.getEquivalentDataProperties(disjointProperty);
            nodeSet.addNode(dpNode);
        }
        return nodeSet;
    }

    public @NonNull NodeSet<OWLClass> getDataPropertyDomains(@NonNull OWLDataProperty dataProperty, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        DP dp = this.resolveDP(dataProperty);
        String propertyID = dp.getid();
        for (String classID : this.getDroolsOWLAxiomHandler().getDataPropertyDomains(propertyID, direct)) {
            OWLClass domainClass = this.resolveOWLClass(classID);
            Node<OWLClass> cNode = this.getEquivalentClasses((OWLClassExpression)domainClass);
            ns.addNode(cNode);
        }
        return ns;
    }

    public @NonNull NodeSet<OWLClass> getTypes(@NonNull OWLNamedIndividual namedIndividual, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return new OWLClassNodeSet();
    }

    public @NonNull NodeSet<OWLNamedIndividual> getInstances(@NonNull OWLClassExpression classExpression, boolean b) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return new OWLNamedIndividualNodeSet();
    }

    public @NonNull NodeSet<OWLNamedIndividual> getObjectPropertyValues(@NonNull OWLNamedIndividual namedIndividual, @NonNull OWLObjectPropertyExpression owlObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLNamedIndividualNodeSet ns = new OWLNamedIndividualNodeSet();
        I i = this.resolveI(namedIndividual);
        OPE ope = this.resolveOPE(owlObjectPropertyExpression);
        String individualID = i.getid();
        String propertyID = ope.getid();
        for (String valueIndividualID : this.getDroolsOWLAxiomHandler().getObjectPropertyValuesForIndividual(individualID, propertyID)) {
            OWLNamedIndividual valueIndividual = this.resolveOWLNamedIndividual(valueIndividualID);
            Node<OWLNamedIndividual> valueIndividualsNode = this.getSameIndividuals(valueIndividual);
            ns.addNode(valueIndividualsNode);
        }
        return ns;
    }

    public @NonNull Set<@NonNull OWLLiteral> getDataPropertyValues(@NonNull OWLNamedIndividual namedIndividual, OWLDataProperty owlDataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        HashSet<@NonNull OWLLiteral> values = new HashSet<OWLLiteral>();
        I i = this.resolveI(namedIndividual);
        DP dp = this.resolveDP(owlDataProperty);
        String individualID = i.getid();
        String propertyID = dp.getid();
        for (L l : this.getDroolsOWLAxiomHandler().getDataPropertyValuesForIndividual(individualID, propertyID)) {
            OWLLiteral literal = this.l2OWLLiteral(l);
            values.add(literal);
        }
        return values;
    }

    public @NonNull Node<@NonNull OWLNamedIndividual> getSameIndividuals(@NonNull OWLNamedIndividual namedIndividual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        HashSet<@NonNull OWLNamedIndividual> individuals = new HashSet<OWLNamedIndividual>();
        I i = this.resolveI(namedIndividual);
        String individualID = i.getid();
        for (String sameIndividualID : this.getDroolsOWLAxiomHandler().getSameIndividual(individualID)) {
            OWLNamedIndividual individual = this.resolveOWLNamedIndividual(sameIndividualID);
            individuals.add(individual);
        }
        return new OWLNamedIndividualNode(individuals);
    }

    public @NonNull NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual namedIndividual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLNamedIndividualNodeSet ns = new OWLNamedIndividualNodeSet();
        I i = this.resolveI(namedIndividual);
        String individualID = i.getid();
        for (String sameIndividualID : this.getDroolsOWLAxiomHandler().getDifferentIndividuals(individualID)) {
            OWLNamedIndividual sameIndividual = this.resolveOWLNamedIndividual(sameIndividualID);
            Node<OWLNamedIndividual> sameIndividualsNode = this.getSameIndividuals(sameIndividual);
            ns.addNode(sameIndividualsNode);
        }
        return ns;
    }

    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.prepared = true;
    }

    protected void handleChanges(Set<OWLAxiom> owlAxioms, @NonNull Set<@NonNull OWLAxiom> owlAxioms2) {
    }

    private void ensurePrepared() {
        if (!this.prepared) {
            this.prepareReasoner();
        }
    }

    protected void throwExceptionIfInterrupted() {
        if (this.interrupted) {
            this.interrupted = false;
            throw new ReasonerInterruptedException();
        }
    }

    private @NonNull OWLClass resolveOWLClass(@NonNull String classID) {
        return this.droolsOWLClassExpressionHandler.resolveOWLClass(classID);
    }

    private @NonNull OWLClassExpression resolveOWLClassExpression(@NonNull String classID) {
        return this.droolsOWLClassExpressionHandler.resolveOWLClassExpression(classID);
    }

    private @NonNull OWLNamedIndividual resolveOWLNamedIndividual(@NonNull String individualID) {
        throw new RuntimeException("DroolsOWLReasoner.resolveOWLNamedIndividual not implemented");
    }

    private @NonNull OWLObjectPropertyExpression resolveOWLObjectPropertyExpression(@NonNull String propertyID) {
        return this.droolsOWLPropertyExpressionHandler.resolveOWLObjectPropertyExpression(propertyID);
    }

    private @NonNull OWLObjectProperty resolveOWLObjectProperty(@NonNull String propertyID) {
        throw new RuntimeException("DroolsOWLReasoner.resolveOWLObjectProperty not implemented");
    }

    private @NonNull OWLDataPropertyExpression resolveOWLDataPropertyExpression(@NonNull String propertyID) {
        return this.droolsOWLPropertyExpressionHandler.resolveOWLDataPropertyExpression(propertyID);
    }

    private @NonNull OWLDataProperty resolveOWLDataProperty(@NonNull String propertyID) {
        throw new RuntimeException("DroolsOWLReasoner.resolveDataProperty not implemented");
    }

    private @NonNull C resolveC(@NonNull OWLClass cls) {
        return this.getDroolsOWLClassExpressionHandler().convert(cls);
    }

    private @NonNull CE resolveCE(@NonNull OWLClassExpression classExpression) {
        return this.getDroolsOWLClassExpressionHandler().convert(classExpression);
    }

    private @NonNull I resolveI(@NonNull OWLNamedIndividual namedIndividual) {
        return this.getDroolsOWLIndividual2IConverter().convert((OWLIndividual)namedIndividual);
    }

    private @NonNull OPE resolveOPE(@NonNull OWLObjectPropertyExpression objectPropertyExpression) {
        return this.getDroolsOWLPropertyExpressionHandler().convert(objectPropertyExpression);
    }

    private @NonNull DP resolveDP(@NonNull OWLDataProperty dataProperty) {
        return this.getDroolsOWLEntity2OEConverter().convert(dataProperty);
    }

    private @NonNull DPE resolveDPE(@NonNull OWLDataPropertyExpression dataPropertyExpression) {
        return this.getDroolsOWLPropertyExpressionHandler().convert(dataPropertyExpression);
    }

    private @NonNull OWLLiteral l2OWLLiteral(@NonNull L l) {
        throw new RuntimeException("DroolsOWLReasoner.l2OWLLiteral not implemented");
    }

    private @NonNull OWLLiteralFactory getOWLLiteralFactory() {
        return this.owlLiteralFactory;
    }

    private @NonNull DroolsOWLAxiomHandler getDroolsOWLAxiomHandler() {
        return this.droolsOWLAxiomHandler;
    }

    @NonNull DroolsOWLClassExpressionHandler getDroolsOWLClassExpressionHandler() {
        return this.droolsOWLClassExpressionHandler;
    }

    @NonNull DroolsOWLPropertyExpressionHandler getDroolsOWLPropertyExpressionHandler() {
        return this.droolsOWLPropertyExpressionHandler;
    }

    @NonNull DroolsOWLIndividual2IConverter getDroolsOWLIndividual2IConverter() {
        return this.droolsOWLIndividual2IConverter;
    }

    @NonNull DroolsOWLEntity2OEConverter getDroolsOWLEntity2OEConverter() {
        return this.droolsOWLEntity2OEConverter;
    }
}

