/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.bridge.converters;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.converters.TargetRuleEngineConverter;

public abstract class TargetRuleEngineConverterBase
implements TargetRuleEngineConverter {
    private final @NonNull SWRLRuleEngineBridge bridge;

    protected TargetRuleEngineConverterBase(@NonNull SWRLRuleEngineBridge bridge) {
        this.bridge = bridge;
    }

    protected @NonNull String iri2PrefixedName(IRI iri) {
        Optional<@NonNull String> prefixedName = this.bridge.getIRIResolver().iri2PrefixedName(iri);
        if (prefixedName.isPresent()) {
            return prefixedName.get();
        }
        throw new IllegalArgumentException("could not get prefixed name for IRI " + iri);
    }

    protected @NonNull SWRLRuleEngineBridge getBridge() {
        return this.bridge;
    }
}

