/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.bridge.extractors;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.swrlapi.bridge.SWRLRuleEngineBridge;
import org.swrlapi.bridge.extractors.TargetRuleEngineExtractor;
import org.swrlapi.factory.OWLDatatypeFactory;
import org.swrlapi.factory.OWLLiteralFactory;
import org.swrlapi.factory.SWRLAPIOWLDataFactory;
import org.swrlapi.factory.SWRLBuiltInArgumentFactory;

public abstract class TargetRuleEngineExtractorBase
implements TargetRuleEngineExtractor {
    private final @NonNull SWRLRuleEngineBridge bridge;

    protected TargetRuleEngineExtractorBase(@NonNull SWRLRuleEngineBridge bridge) {
        this.bridge = bridge;
    }

    protected @NonNull SWRLBuiltInArgumentFactory getSWRLBuiltInArgumentFactory() {
        return this.getBridge().getSWRLBuiltInArgumentFactory();
    }

    protected @NonNull SWRLAPIOWLDataFactory getSWRLAPIOWLDataFactory() {
        return this.getBridge().getSWRLAPIOWLDataFactory();
    }

    protected @NonNull OWLDataFactory getOWLDataFactory() {
        return this.getBridge().getSWRLAPIOWLDataFactory();
    }

    protected @NonNull OWLDatatypeFactory getOWLDatatypeFactory() {
        return this.getBridge().getOWLDatatypeFactory();
    }

    protected @NonNull OWLLiteralFactory getOWLLiteralFactory() {
        return this.getBridge().getOWLLiteralFactory();
    }

    protected @NonNull IRI prefixedName2IRI(String prefixedName) {
        Optional<@NonNull IRI> iri = this.getBridge().getIRIResolver().prefixedName2IRI(prefixedName);
        if (iri.isPresent()) {
            return iri.get();
        }
        throw new IllegalArgumentException("could not loadExternalSWRLBuiltInLibraries IRI for prefixed name " + prefixedName);
    }

    private @NonNull SWRLRuleEngineBridge getBridge() {
        return this.bridge;
    }
}

