/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.swrlapi.builtins.SWRLBuiltInBridge;
import org.swrlapi.builtins.SWRLBuiltInLibrary;
import org.swrlapi.builtins.arguments.SQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentCreator;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentType;
import org.swrlapi.builtins.arguments.SWRLBuiltInInputArgumentHandler;
import org.swrlapi.builtins.arguments.SWRLBuiltInResultArgumentHandler;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLPropertyBuiltInArgument;
import org.swrlapi.exceptions.InvalidSWRLBuiltInArgumentException;
import org.swrlapi.exceptions.InvalidSWRLBuiltInArgumentNumberException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLBuiltInLibraryException;
import org.swrlapi.exceptions.SWRLBuiltInMethodRuntimeException;
import org.swrlapi.factory.LiteralFactory;
import org.swrlapi.factory.OWLLiteralFactory;
import org.swrlapi.factory.SQWRLResultValueFactory;
import org.swrlapi.factory.SWRLAPIOWLDataFactory;
import org.swrlapi.factory.SWRLBuiltInArgumentFactory;
import org.swrlapi.literal.Literal;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;

public abstract class AbstractSWRLBuiltInLibrary
implements SWRLBuiltInLibrary,
SWRLBuiltInInputArgumentHandler,
SWRLBuiltInResultArgumentHandler,
SWRLBuiltInArgumentCreator {
    private final @NonNull String prefix;
    private final @NonNull String namespace;
    private final @NonNull Set<@NonNull String> builtInNames;
    private @Nullable SWRLBuiltInBridge invokingBridge = null;
    private @NonNull String invokingRuleName = "";
    private @NonNull Long invocationPatternID;
    private @NonNull Map<@NonNull String, @NonNull Long> invocationPatternMap;
    private int invokingBuiltInIndex = -1;
    private boolean isInConsequent = false;

    protected AbstractSWRLBuiltInLibrary(@NonNull String prefix, @NonNull String namespace, @NonNull Set<@NonNull String> builtInNames) {
        this.prefix = prefix;
        this.namespace = namespace;
        this.builtInNames = new HashSet<String>(builtInNames);
        this.invocationPatternID = 0L;
        this.invocationPatternMap = new HashMap<String, Long>();
    }

    @Override
    public @NonNull String getPrefix() {
        return this.prefix;
    }

    @Override
    public @NonNull String getNamespace() {
        return this.namespace;
    }

    @Override
    public @NonNull Set<@NonNull String> getBuiltInNames() {
        return new HashSet<String>(this.builtInNames);
    }

    @Override
    public @NonNull Set<@NonNull IRI> getBuiltInIRIs() {
        return this.builtInNames.stream().map(s -> IRI.create((String)(this.namespace + s))).collect(Collectors.toSet());
    }

    @Override
    public @NonNull SWRLBuiltInBridge getBuiltInBridge() throws SWRLBuiltInLibraryException {
        if (this.invokingBridge == null) {
            throw new SWRLBuiltInLibraryException("invalid call to getInvokingBridge - should only be called from within a built-in");
        }
        return this.invokingBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull String getInvokingRuleName() throws SWRLBuiltInLibraryException {
        AbstractSWRLBuiltInLibrary abstractSWRLBuiltInLibrary = this;
        synchronized (abstractSWRLBuiltInLibrary) {
            if (this.invokingRuleName.length() == 0) {
                throw new SWRLBuiltInLibraryException("invalid call to getInvokingRuleName - should only be called from within a built-in");
            }
        }
        return this.invokingRuleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInvokingBuiltInIndex() throws SWRLBuiltInLibraryException {
        AbstractSWRLBuiltInLibrary abstractSWRLBuiltInLibrary = this;
        synchronized (abstractSWRLBuiltInLibrary) {
            if (this.invokingBuiltInIndex == -1) {
                throw new SWRLBuiltInLibraryException("invalid call to getInvokingBuiltInIndex - should only be called from within a built-in");
            }
        }
        return this.invokingBuiltInIndex;
    }

    @Override
    public boolean getIsInConsequent() throws SWRLBuiltInLibraryException {
        if (this.invokingBridge == null) {
            throw new SWRLBuiltInLibraryException("invalid call to getIsInConsequent - should only be called from within a built-in");
        }
        return this.isInConsequent;
    }

    @Override
    public void checkThatInConsequent() throws SWRLBuiltInException {
        if (this.invokingBridge == null) {
            throw new SWRLBuiltInLibraryException("invalid call to checkThatInConsequent - should only be called from within a built-in");
        }
        if (!this.isInConsequent) {
            throw new SWRLBuiltInException("built-in can only be used in consequent");
        }
    }

    @Override
    public void checkThatInAntecedent() throws SWRLBuiltInException {
        if (this.invokingBridge == null) {
            throw new SWRLBuiltInLibraryException("invalid call to checkThatInAntecedent - should only be called from within a built-in");
        }
        if (this.isInConsequent) {
            throw new SWRLBuiltInException("built-in can only be used in antecedent");
        }
    }

    @Override
    public abstract void reset() throws SWRLBuiltInLibraryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeResetMethod(@NonNull SWRLBuiltInBridge bridge) throws SWRLBuiltInLibraryException {
        AbstractSWRLBuiltInLibrary abstractSWRLBuiltInLibrary = this;
        synchronized (abstractSWRLBuiltInLibrary) {
            this.invokingBridge = bridge;
            this.reset();
            this.invocationPatternID = 0L;
            this.invocationPatternMap = new HashMap<String, Long>();
            this.invokingBridge = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invokeBuiltInMethod(@NonNull Method method, @NonNull SWRLBuiltInBridge bridge, @NonNull String ruleName, @NonNull String prefix, @NonNull String builtInMethodName, int builtInIndex, boolean inConsequent, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        Boolean result;
        String builtInName = prefix + ":" + builtInMethodName;
        AbstractSWRLBuiltInLibrary abstractSWRLBuiltInLibrary = this;
        synchronized (abstractSWRLBuiltInLibrary) {
            this.invokingBridge = bridge;
            this.invokingRuleName = ruleName;
            this.invokingBuiltInIndex = builtInIndex;
            this.isInConsequent = inConsequent;
            try {
                result = (Boolean)method.invoke((Object)this, arguments);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof SWRLBuiltInException) {
                    throw new SWRLBuiltInException("exception thrown by built-in " + builtInName + " in rule " + ruleName + ": " + targetException.getMessage(), targetException);
                }
                if (targetException instanceof RuntimeException) {
                    throw new SWRLBuiltInMethodRuntimeException(ruleName, builtInName, targetException.getMessage(), targetException);
                }
                throw new SWRLBuiltInException("unknown exception thrown by built-in " + builtInName + " in rule " + ruleName + ": " + e.toString(), e);
            }
            catch (Throwable e) {
                throw new SWRLBuiltInLibraryException("internal built-in library exception when invoking built-in " + builtInName + " in rule " + ruleName + ": " + e.getMessage(), e);
            }
            this.invokingBridge = null;
            this.invokingRuleName = "";
            this.invokingBuiltInIndex = -1;
            this.isInConsequent = false;
        }
        return result;
    }

    @Override
    public void checkNumberOfArgumentsAtLeastOne(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (arguments.size() < 1) {
            throw new InvalidSWRLBuiltInArgumentNumberException(1, 0, "at least");
        }
    }

    @Override
    public void checkNumberOfArgumentsEqualTo(int expecting, int actual) throws InvalidSWRLBuiltInArgumentNumberException {
        if (expecting != actual) {
            throw new InvalidSWRLBuiltInArgumentNumberException(expecting, actual);
        }
    }

    @Override
    public void checkNumberOfArgumentsAtLeast(int expectingAtLeast, int actual) throws InvalidSWRLBuiltInArgumentNumberException {
        if (actual < expectingAtLeast) {
            throw new InvalidSWRLBuiltInArgumentNumberException(expectingAtLeast, actual, "at least");
        }
    }

    @Override
    public void checkNumberOfArgumentsAtMost(int expectingAtMost, int actual) throws InvalidSWRLBuiltInArgumentNumberException {
        if (actual > expectingAtMost) {
            throw new InvalidSWRLBuiltInArgumentNumberException(expectingAtMost, actual, "at most");
        }
    }

    @Override
    public void checkNumberOfArgumentsInRange(int expectingAtLeast, int expectingAtMost, int actual) throws InvalidSWRLBuiltInArgumentNumberException {
        if (actual > expectingAtMost || actual < expectingAtLeast) {
            throw new InvalidSWRLBuiltInArgumentNumberException(expectingAtMost, actual, expectingAtLeast + " to");
        }
    }

    @Override
    public void checkThatAllArgumentsAreOWLLiterals(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            this.checkThatArgumentIsALiteral(argumentNumber, arguments);
        }
    }

    public @NonNull String getLiteralArgumentDatatypeName(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsALiteral(argumentNumber, arguments);
        return this.getArgumentAsALiteral(argumentNumber, arguments).getOWLDatatypeName();
    }

    @Override
    public void checkThatAllArgumentsAreNumeric(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            this.checkThatArgumentIsNumeric(argumentNumber, arguments);
        }
    }

    @Override
    public void checkThatAllArgumentsAreInts(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            this.checkThatArgumentIsAnInt(argumentNumber, arguments);
        }
    }

    @Override
    public boolean areAllArgumentsBytes(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentAByte(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsShorts(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentAShort(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsInts(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentAnInt(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsLongs(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentALong(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsFloats(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentAFloat(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsDoubles(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentADouble(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsDecimals(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentADecimal(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsIntegers(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentAnInteger(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isArgumentConvertibleToByte(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentNumeric(argumentNumber, arguments) && this.isArgumentAByte(argumentNumber, arguments);
    }

    @Override
    public boolean isArgumentConvertibleToShort(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentAByte(argumentNumber, arguments) || this.isArgumentAShort(argumentNumber, arguments);
    }

    @Override
    public boolean isArgumentConvertibleToInt(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentAByte(argumentNumber, arguments) || this.isArgumentAShort(argumentNumber, arguments) || this.isArgumentAnInt(argumentNumber, arguments);
    }

    @Override
    public boolean isArgumentConvertibleToLong(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentAByte(argumentNumber, arguments) || this.isArgumentAShort(argumentNumber, arguments) || this.isArgumentAnInt(argumentNumber, arguments) || this.isArgumentALong(argumentNumber, arguments);
    }

    @Override
    public boolean isArgumentConvertibleToFloat(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentAByte(argumentNumber, arguments) && this.isArgumentAShort(argumentNumber, arguments) || this.isArgumentAnInt(argumentNumber, arguments) || this.isArgumentALong(argumentNumber, arguments) || this.isArgumentAFloat(argumentNumber, arguments);
    }

    @Override
    public boolean isArgumentConvertibleToDouble(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentAByte(argumentNumber, arguments) || this.isArgumentAShort(argumentNumber, arguments) || this.isArgumentAnInt(argumentNumber, arguments) || this.isArgumentALong(argumentNumber, arguments) || this.isArgumentAnInteger(argumentNumber, arguments) || this.isArgumentAFloat(argumentNumber, arguments) || this.isArgumentADouble(argumentNumber, arguments);
    }

    @Override
    public boolean isWidestNumericArgumentAByte(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (!this.isArgumentAShort(argumentNumber, arguments) && !this.isArgumentAnInt(argumentNumber, arguments) && !this.isArgumentALong(argumentNumber, arguments) && !this.isArgumentAnInteger(argumentNumber, arguments) && !this.isArgumentAFloat(argumentNumber, arguments) && !this.isArgumentADouble(argumentNumber, arguments) && !this.isArgumentADecimal(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isWidestNumericArgumentAShort(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (!this.isArgumentAnInt(argumentNumber, arguments) && !this.isArgumentALong(argumentNumber, arguments) && !this.isArgumentAnInteger(argumentNumber, arguments) && !this.isArgumentAFloat(argumentNumber, arguments) && !this.isArgumentADouble(argumentNumber, arguments) && !this.isArgumentADecimal(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isWidestNumericArgumentAnInt(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (!this.isArgumentALong(argumentNumber, arguments) && !this.isArgumentAnInteger(argumentNumber, arguments) && !this.isArgumentAFloat(argumentNumber, arguments) && !this.isArgumentADouble(argumentNumber, arguments) && !this.isArgumentADecimal(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isWidestNumericArgumentALong(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (!this.isArgumentAnInteger(argumentNumber, arguments) && !this.isArgumentAFloat(argumentNumber, arguments) && !this.isArgumentADouble(argumentNumber, arguments) && !this.isArgumentADecimal(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isWidestNumericArgumentAnInteger(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (!this.isArgumentAFloat(argumentNumber, arguments) && !this.isArgumentADouble(argumentNumber, arguments) && !this.isArgumentADecimal(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isWidestNumericArgumentAFloat(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (!this.isArgumentADouble(argumentNumber, arguments) && !this.isArgumentADecimal(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isWidestNumericArgumentADouble(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (!this.isArgumentADecimal(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsBooleans(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentABoolean(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentLiterals(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentALiteral(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsNumeric(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentNumeric(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsStrings(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentAString(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllArgumentsOfAnOrderedType(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (this.isArgumentOfAnOrderedType(argumentNumber, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkThatAllArgumentsAreFloats(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            this.checkThatArgumentIsAFloat(argumentNumber, arguments);
        }
    }

    @Override
    public void checkThatAllArgumentsAreStrings(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            this.checkThatArgumentIsAString(argumentNumber, arguments);
        }
    }

    @Override
    public void checkThatAllArgumentsAreOfAnOrderedType(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            this.checkThatArgumentIsOfAnOrderedType(argumentNumber, arguments);
        }
    }

    @Override
    public void checkThatArgumentIsNumeric(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentNumeric(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "numeric"));
        }
    }

    @Override
    public void checkThatArgumentIsOfAnOrderedType(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentOfAnOrderedType(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "ordered type"));
        }
    }

    @Override
    public boolean isArgumentOfAnOrderedType(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentNumeric(argumentNumber, arguments) || this.isArgumentAString(argumentNumber, arguments);
    }

    @Override
    public boolean isArgumentAnOWLNamedIndividual(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkArgumentNumber(argumentNumber, arguments);
        return arguments.get(argumentNumber) instanceof SWRLNamedIndividualBuiltInArgument;
    }

    @Override
    public void checkThatArgumentIsANamedIndividual(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAnOWLNamedIndividual(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "individual"));
        }
    }

    @Override
    public void checkThatArgumentIsALiteral(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentALiteral(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "literal"));
        }
    }

    @Override
    public @NonNull IRI getArgumentAsANamedIndividualIRI(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsANamedIndividual(argumentNumber, arguments);
        return ((SWRLNamedIndividualBuiltInArgument)arguments.get(argumentNumber)).getIRI();
    }

    @Override
    public @NonNull SWRLNamedIndividualBuiltInArgument getArgumentAsANamedIndividual(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsANamedIndividual(argumentNumber, arguments);
        return arguments.get(argumentNumber).asSWRLNamedIndividualBuiltInArgument();
    }

    @Override
    public @NonNull IRI getArgumentAsAClassIRI(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsAClass(argumentNumber, arguments);
        return ((SWRLClassBuiltInArgument)arguments.get(argumentNumber)).getIRI();
    }

    @Override
    public @NonNull SWRLClassBuiltInArgument getArgumentAsAClass(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsAClass(argumentNumber, arguments);
        return (SWRLClassBuiltInArgument)arguments.get(argumentNumber);
    }

    @Override
    public @NonNull SWRLClassExpressionBuiltInArgument getArgumentAsAClassExpression(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsAClassExpression(argumentNumber, arguments);
        return arguments.get(argumentNumber).asSWRLClassExpressionBuiltInArgument();
    }

    public @NonNull SWRLPropertyBuiltInArgument getArgumentAsAProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsAProperty(argumentNumber, arguments);
        return (SWRLPropertyBuiltInArgument)arguments.get(argumentNumber);
    }

    @Override
    public @NonNull SWRLObjectPropertyBuiltInArgument getArgumentAsAnObjectProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsAnObjectProperty(argumentNumber, arguments);
        return (SWRLObjectPropertyBuiltInArgument)arguments.get(argumentNumber);
    }

    @Override
    public @NonNull SWRLObjectPropertyExpressionBuiltInArgument getArgumentAsAnObjectPropertyExpression(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsAnObjectPropertyExpression(argumentNumber, arguments);
        return arguments.get(argumentNumber).asSWRLObjectPropertyExpressionBuiltInArgument();
    }

    @Override
    public @NonNull SWRLDataPropertyBuiltInArgument getArgumentAsADataProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsADataProperty(argumentNumber, arguments);
        return (SWRLDataPropertyBuiltInArgument)arguments.get(argumentNumber);
    }

    @Override
    public @NonNull SWRLDataPropertyExpressionBuiltInArgument getArgumentAsADataPropertyExpression(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsADataPropertyExpression(argumentNumber, arguments);
        return arguments.get(argumentNumber).asSWRLDataPropertyExpressionBuiltInArgument();
    }

    @Override
    public @NonNull SWRLAnnotationPropertyBuiltInArgument getArgumentAsAnAnnotationProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsAnAnnotationProperty(argumentNumber, arguments);
        return (SWRLAnnotationPropertyBuiltInArgument)arguments.get(argumentNumber);
    }

    @Override
    public @NonNull SWRLDatatypeBuiltInArgument getArgumentAsADatatype(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsADatatype(argumentNumber, arguments);
        return (SWRLDatatypeBuiltInArgument)arguments.get(argumentNumber);
    }

    @Override
    public @NonNull IRI getArgumentAsAnIRI(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsAClassPropertyOrNamedIndividual(argumentNumber, arguments);
        if (this.isArgumentAClass(argumentNumber, arguments)) {
            return ((SWRLClassBuiltInArgument)arguments.get(argumentNumber)).getIRI();
        }
        if (this.isArgumentAProperty(argumentNumber, arguments)) {
            return ((SWRLPropertyBuiltInArgument)arguments.get(argumentNumber)).getIRI();
        }
        if (this.isArgumentAnOWLNamedIndividual(argumentNumber, arguments)) {
            return ((SWRLNamedIndividualBuiltInArgument)arguments.get(argumentNumber)).getIRI();
        }
        throw new SWRLBuiltInException("internal error: unknown argument type " + arguments.get(argumentNumber).getClass());
    }

    @Override
    public @NonNull IRI getArgumentAsAPropertyIRI(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsAProperty(argumentNumber, arguments);
        return ((SWRLPropertyBuiltInArgument)arguments.get(argumentNumber)).getIRI();
    }

    @Override
    public void checkArgumentNumber(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (argumentNumber < 0 || argumentNumber >= arguments.size()) {
            throw new SWRLBuiltInException("(0-offset) argument number #" + argumentNumber + " is out of bounds");
        }
    }

    @Override
    public boolean isArgumentNumeric(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isNumeric();
    }

    @Override
    public boolean isArgumentNonNumeric(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && !this.getArgumentAsALiteral(argumentNumber, arguments).isNumeric();
    }

    @Override
    public void checkThatArgumentIsNonNumeric(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentNonNumeric(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "non-numeric"));
        }
    }

    @Override
    public void checkThatArgumentIsAByte(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAByte(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "byte"));
        }
    }

    @Override
    public boolean isArgumentAByte(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isByte();
    }

    @Override
    public short getArgumentAsAByte(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argumentNumber, arguments).getByte();
    }

    @Override
    public void checkThatArgumentIsAShort(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAShort(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:short"));
        }
    }

    @Override
    public boolean isArgumentAShort(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isShort();
    }

    @Override
    public short getArgumentAsAShort(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argumentNumber, arguments).getShort();
    }

    @Override
    public void checkThatArgumentIsAnInt(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAnInt(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:int"));
        }
    }

    @Override
    public boolean isArgumentAnInt(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isInt();
    }

    @Override
    public int getArgumentAsAnInt(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argumentNumber, arguments).getInt();
    }

    @Override
    public int getArgumentAsAPositiveInt(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        int i = this.getArgumentAsALiteral(argumentNumber, arguments).getInt();
        if (i < 0) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "expecting positive xsd:int"));
        }
        return i;
    }

    @Override
    public @NonNull BigInteger getArgumentAsAnInteger(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argumentNumber, arguments).getInteger();
    }

    @Override
    public @NonNull BigInteger getArgumentAsAnInteger(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argument).getInteger();
    }

    @Override
    public boolean isArgumentAnInteger(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isInteger();
    }

    @Override
    public BigInteger getArgumentAsAPositiveInteger(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        BigInteger i = this.getArgumentAsALiteral(argumentNumber, arguments).getInteger();
        if (i.compareTo(BigInteger.ZERO) < 0) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "expecting positive xsd:integer"));
        }
        return i;
    }

    @Override
    public @NonNull BigDecimal getArgumentAsADecimal(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argumentNumber, arguments).getDecimal();
    }

    @Override
    public @NonNull BigDecimal getArgumentAsADecimal(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argument).getDecimal();
    }

    @Override
    public boolean isArgumentADecimal(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isDecimal();
    }

    @Override
    public boolean isArgumentALiteral(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber) instanceof SWRLLiteralBuiltInArgument;
    }

    @Override
    public boolean isArgumentAProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber) instanceof SWRLPropertyBuiltInArgument;
    }

    @Override
    public boolean isArgumentADataProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber) instanceof SWRLDataPropertyBuiltInArgument;
    }

    @Override
    public boolean isArgumentAnAnnotationProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber) instanceof SWRLAnnotationPropertyBuiltInArgument;
    }

    @Override
    public boolean isArgumentADatatype(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber) instanceof SWRLDatatypeBuiltInArgument;
    }

    @Override
    public boolean isArgumentADataPropertyExpression(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber).getSWRLBuiltInArgumentType() == SWRLBuiltInArgumentType.DATA_PROPERTY_EXPRESSION || arguments.get(argumentNumber).getSWRLBuiltInArgumentType() == SWRLBuiltInArgumentType.DATA_PROPERTY;
    }

    @Override
    public boolean isArgumentAnObjectProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber).getSWRLBuiltInArgumentType() == SWRLBuiltInArgumentType.OBJECT_PROPERTY;
    }

    @Override
    public boolean isArgumentAnObjectPropertyExpression(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber).getSWRLBuiltInArgumentType() == SWRLBuiltInArgumentType.OBJECT_PROPERTY_EXPRESSION || arguments.get(argumentNumber).getSWRLBuiltInArgumentType() == SWRLBuiltInArgumentType.OBJECT_PROPERTY;
    }

    @Override
    public void checkThatArgumentIsAProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAProperty(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "property"));
        }
    }

    @Override
    public void checkThatArgumentIsAnObjectProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAnObjectProperty(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "object property"));
        }
    }

    @Override
    public void checkThatArgumentIsAnObjectPropertyExpression(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAnObjectPropertyExpression(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "object property expression"));
        }
    }

    @Override
    public void checkThatArgumentIsADataProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentADataProperty(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "data property"));
        }
    }

    @Override
    public void checkThatArgumentIsAnAnnotationProperty(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAnAnnotationProperty(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "annotation property"));
        }
    }

    @Override
    public void checkThatArgumentIsADatatype(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentADatatype(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "datatype"));
        }
    }

    @Override
    public void checkThatArgumentIsADataPropertyExpression(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentADataPropertyExpression(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "data property expression"));
        }
    }

    @Override
    public void checkThatArgumentIsAClassPropertyOrNamedIndividual(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAClassPropertyOrNamedIndividual(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "class, property, or individual"));
        }
    }

    @Override
    public boolean isArgumentAClassPropertyOrNamedIndividual(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentAClass(argumentNumber, arguments) || this.isArgumentAProperty(argumentNumber, arguments) || this.isArgumentAnOWLNamedIndividual(argumentNumber, arguments);
    }

    @Override
    public boolean isArgumentAClass(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber).getSWRLBuiltInArgumentType() == SWRLBuiltInArgumentType.CLASS;
    }

    @Override
    public boolean isArgumentAClassExpression(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        return arguments.get(argumentNumber).getSWRLBuiltInArgumentType() == SWRLBuiltInArgumentType.CLASS_EXPRESSION || arguments.get(argumentNumber).getSWRLBuiltInArgumentType() == SWRLBuiltInArgumentType.CLASS;
    }

    @Override
    public void checkThatArgumentIsAClass(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAClass(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "class"));
        }
    }

    @Override
    public void checkThatArgumentIsAClassExpression(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAClassExpression(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "class expression"));
        }
    }

    @Override
    public @NonNull OWLLiteral getArgumentAsAnOWLLiteral(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsALiteral(argumentNumber, arguments);
        SWRLLiteralBuiltInArgument argument = (SWRLLiteralBuiltInArgument)arguments.get(argumentNumber);
        return argument.getLiteral();
    }

    @Override
    public @NonNull OWLLiteral getArgumentAsAnOWLLiteral(SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        if (!(argument instanceof SWRLLiteralBuiltInArgument)) {
            throw new InvalidSWRLBuiltInArgumentException(this.makeInvalidArgumentTypeMessage(argument, "data value"));
        }
        SWRLLiteralBuiltInArgument a = (SWRLLiteralBuiltInArgument)argument;
        return a.getLiteral();
    }

    @Override
    public void checkThatArgumentIsALong(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentALong(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "long"));
        }
    }

    @Override
    public boolean isArgumentALong(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isLong();
    }

    @Override
    public long getArgumentAsALong(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argumentNumber, arguments).getLong();
    }

    @Override
    public long getArgumentAsAPositiveLong(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        long l = this.getArgumentAsALiteral(argumentNumber, arguments).getLong();
        if (l < 0L) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "expecting positive xsd:long"));
        }
        return l;
    }

    @Override
    public void checkThatArgumentIsAFloat(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAFloat(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:float"));
        }
    }

    @Override
    public boolean isArgumentAFloat(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isFloat();
    }

    @Override
    public float getArgumentAsAFloat(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argumentNumber, arguments).getFloat();
    }

    @Override
    public float getArgumentAsAFloat(SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argument).getFloat();
    }

    @Override
    public void checkThatArgumentIsADouble(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentADouble(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:double"));
        }
    }

    @Override
    public boolean isArgumentADouble(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isDouble();
    }

    @Override
    public double getArgumentAsADouble(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkArgumentNumber(argumentNumber, arguments);
        return this.getArgumentAsADouble(arguments.get(argumentNumber));
    }

    @Override
    public double getArgumentAsADouble(SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        return this.getArgumentAsALiteral(argument).getDouble();
    }

    @Override
    public void checkThatArgumentIsABoolean(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentABoolean(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:boolean"));
        }
    }

    @Override
    public boolean isArgumentABoolean(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isBoolean();
    }

    @Override
    public boolean getArgumentAsABoolean(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsABoolean(argumentNumber, arguments);
        return this.getArgumentAsALiteral(argumentNumber, arguments).getBoolean();
    }

    @Override
    public void checkThatArgumentIsAString(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentAString(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:string"));
        }
    }

    @Override
    public boolean isArgumentAString(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isString();
    }

    @Override
    public @NonNull String getArgumentAsAString(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.isArgumentAString(argumentNumber, arguments);
        return this.getArgumentAsALiteral(argumentNumber, arguments).getString();
    }

    @Override
    public @NonNull String getLiteralArgumentAsAString(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.isArgumentALiteral(argumentNumber, arguments);
        return this.getArgumentAsALiteral(argumentNumber, arguments).getString();
    }

    @Override
    public @NonNull String representArgumentAsAString(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return "\"" + this.getArgumentAsALiteral(argumentNumber, arguments).getValue() + "\"^^" + this.getArgumentAsALiteral(argumentNumber, arguments).getOWLDatatype();
    }

    @Override
    public void checkThatArgumentIsATime(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentATime(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:time"));
        }
    }

    @Override
    public boolean isArgumentATime(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isTime();
    }

    @Override
    public @NonNull XSDTime getArgumentAsATime(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsATime(argumentNumber, arguments);
        return this.getArgumentAsALiteral(argumentNumber, arguments).getTime();
    }

    @Override
    public void checkThatArgumentIsADate(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentADate(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:Date"));
        }
    }

    @Override
    public boolean isArgumentADate(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isDate();
    }

    @Override
    public @NonNull XSDDate getArgumentAsADate(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsADate(argumentNumber, arguments);
        return this.getArgumentAsALiteral(argumentNumber, arguments).getDate();
    }

    @Override
    public void checkThatArgumentIsADateTime(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentADateTime(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:DateTime"));
        }
    }

    @Override
    public boolean isArgumentADateTime(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isDateTime();
    }

    @Override
    public @NonNull XSDDateTime getArgumentAsADateTime(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsADateTime(argumentNumber, arguments);
        return this.getArgumentAsALiteral(argumentNumber, arguments).getDateTime();
    }

    @Override
    public void checkThatArgumentIsADuration(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isArgumentADuration(argumentNumber, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "xsd:Duration"));
        }
    }

    @Override
    public boolean isArgumentADuration(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.isArgumentALiteral(argumentNumber, arguments) && this.getArgumentAsALiteral(argumentNumber, arguments).isDuration();
    }

    @Override
    public @NonNull XSDDuration getArgumentAsADuration(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsADuration(argumentNumber, arguments);
        return this.getArgumentAsALiteral(argumentNumber, arguments).getDuration();
    }

    @Override
    public boolean hasUnboundArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (SWRLBuiltInArgument argument : arguments) {
            if (!argument.isVariable() || !argument.asVariable().isUnbound()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkThatAllArgumentsAreBound(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (this.hasUnboundArguments(arguments)) {
            throw new SWRLBuiltInException("all arguments must be bound");
        }
    }

    @Override
    public void checkThatArgumentIsBound(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (this.isUnboundArgument(argumentNumber, arguments)) {
            throw new SWRLBuiltInException("not expecting an unbound argument for (0-offset) argument #" + argumentNumber);
        }
    }

    @Override
    public boolean isUnboundArgument(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkArgumentNumber(argumentNumber, arguments);
        return arguments.get(argumentNumber).isVariable() && arguments.get(argumentNumber).asVariable().isUnbound();
    }

    @Override
    public boolean isBoundArgument(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkArgumentNumber(argumentNumber, arguments);
        return arguments.get(argumentNumber).isVariable() && arguments.get(argumentNumber).asVariable().isBound();
    }

    @Override
    public int getFirstUnboundArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int index = 0; index < arguments.size(); ++index) {
            if (!arguments.get(index).isVariable() || !arguments.get(index).asVariable().isUnbound()) continue;
            return index;
        }
        return -1;
    }

    @Override
    public void checkForUnboundArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkForUnboundArguments(arguments, "built-in does not support variable binding - unbound argument '" + this.getFirstUnboundArgument(arguments) + "'");
    }

    @Override
    public void checkForUnboundArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, @NonNull String message) throws SWRLBuiltInException {
        if (this.hasUnboundArguments(arguments)) {
            throw new SWRLBuiltInException(message + " (0-offset) argument #" + this.getFirstUnboundArgument(arguments));
        }
    }

    @Override
    public void checkThatAllArgumentsAreBoundVariables(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, @NonNull String message) throws SWRLBuiltInException {
        for (SWRLBuiltInArgument argument : arguments) {
            if (argument.wasBoundVariable()) continue;
            throw new SWRLBuiltInException(message + " " + argument);
        }
    }

    @Override
    public void checkForUnboundNonFirstArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (this.hasUnboundArguments(arguments.subList(1, arguments.size()))) {
            throw new SWRLBuiltInException("built-in supports variable binding only for the first argument - unbound variables used as other arguments");
        }
    }

    @Override
    public String getVariableName(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkArgumentNumber(argumentNumber, arguments);
        if (!arguments.get(argumentNumber).isVariable()) {
            throw new SWRLBuiltInException("internal error: attempt to get variable prefix of non-variable argument " + argumentNumber);
        }
        return arguments.get(argumentNumber).asVariable().getVariableName();
    }

    @Override
    public Object getArgumentAsAPropertyValue(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsBound(argumentNumber, arguments);
        SWRLBuiltInArgument argument = arguments.get(argumentNumber);
        if (argument instanceof SWRLClassBuiltInArgument) {
            SWRLClassBuiltInArgument classArgument = (SWRLClassBuiltInArgument)argument;
            return classArgument.getIRI();
        }
        if (argument instanceof SWRLPropertyBuiltInArgument) {
            SWRLPropertyBuiltInArgument propertyArgument = (SWRLPropertyBuiltInArgument)argument;
            return propertyArgument.getIRI();
        }
        if (argument instanceof SWRLNamedIndividualBuiltInArgument) {
            SWRLNamedIndividualBuiltInArgument individualArgument = (SWRLNamedIndividualBuiltInArgument)argument;
            return individualArgument.getIRI();
        }
        if (argument instanceof SWRLLiteralBuiltInArgument) {
            Literal literal = this.getArgumentAsALiteral(argument);
            if (literal.isInteger()) {
                return literal.getInteger();
            }
            if (literal.isDecimal()) {
                return literal.getDecimal();
            }
            if (literal.isByte()) {
                return literal.getByte();
            }
            if (literal.isShort()) {
                return literal.getShort();
            }
            if (literal.isInt()) {
                return literal.getInt();
            }
            if (literal.isLong()) {
                return literal.getLong();
            }
            if (literal.isFloat()) {
                return Float.valueOf(literal.getFloat());
            }
            if (literal.isDouble()) {
                return literal.getDouble();
            }
            if (literal.isString()) {
                return literal.getString();
            }
            throw new SWRLBuiltInException("literal with value " + literal.toString() + " not supported - strings and numeric literals only");
        }
        throw new SWRLBuiltInException("argument " + argument + " of unknown type " + argument.getClass());
    }

    @Override
    public void checkForUnboundArguments(@NonNull String ruleName, @NonNull String builtInName, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (SWRLBuiltInArgument argument : arguments) {
            if (argument.isVariable() && argument.asVariable().isUnbound()) {
                throw new SWRLBuiltInException("built-in " + builtInName + " in rule " + ruleName + " returned with unbound argument ?" + argument.asVariable().getVariableName());
            }
            if (argument.getSWRLBuiltInArgumentType() != SWRLBuiltInArgumentType.MULTI_VALUE_VARIABLE || !argument.asMultiValueVariable().hasNoArguments()) continue;
            throw new SWRLBuiltInException("built-in " + builtInName + " in rule " + ruleName + " returned with empty multi-argument ?" + argument.asVariable().getVariableName());
        }
    }

    @Override
    public @NonNull List<@NonNull SWRLBuiltInArgument> cloneArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) {
        return new ArrayList<SWRLBuiltInArgument>(arguments);
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, @NonNull Collection<SWRLBuiltInArgument> resultArguments) throws SWRLBuiltInException {
        this.checkArgumentNumber(resultArgumentNumber, arguments);
        if (this.isUnboundArgument(resultArgumentNumber, arguments)) {
            IRI variableIRI = arguments.get(resultArgumentNumber).asVariable().getIRI();
            SWRLMultiValueVariableBuiltInArgument resultMultiArgument = this.createSWRLMultiValueVariableBuiltInArgument(variableIRI);
            resultArguments.forEach(resultMultiArgument::addArgument);
            arguments.get(resultArgumentNumber).asVariable().setBuiltInResult(resultMultiArgument);
            return !resultMultiArgument.hasNoArguments();
        }
        SWRLBuiltInArgument argument = arguments.get(resultArgumentNumber);
        return resultArguments.contains(argument);
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, SWRLBuiltInArgument resultArgument) throws SWRLBuiltInException {
        this.checkArgumentNumber(resultArgumentNumber, arguments);
        if (this.isUnboundArgument(resultArgumentNumber, arguments)) {
            arguments.get(resultArgumentNumber).asVariable().setBuiltInResult(resultArgument);
            return true;
        }
        SWRLBuiltInArgument argument = arguments.get(resultArgumentNumber);
        return argument.equals(resultArgument);
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, SWRLLiteralBuiltInArgument resultArgument) throws SWRLBuiltInException {
        this.checkArgumentNumber(resultArgumentNumber, arguments);
        if (this.isUnboundArgument(resultArgumentNumber, arguments)) {
            arguments.get(resultArgumentNumber).asVariable().setBuiltInResult(resultArgument);
            return true;
        }
        Literal argumentLiteral = this.getArgumentAsALiteral(resultArgumentNumber, arguments);
        Literal resultArgumentLiteral = this.getArgumentAsALiteral(resultArgument);
        return argumentLiteral.equals(resultArgumentLiteral);
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, OWLLiteral resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, byte resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, short resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, int resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, long resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, float resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, double resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, BigDecimal resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, BigInteger resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, @NonNull String resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, boolean resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, @NonNull XSDTime resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, @NonNull XSDDate resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, @NonNull XSDDateTime resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public boolean processResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, @NonNull XSDDuration resultArgument) throws SWRLBuiltInException {
        return this.processResultArgument(arguments, resultArgumentNumber, this.createLiteralBuiltInArgument(resultArgument));
    }

    @Override
    public @NonNull SWRLClassBuiltInArgument createClassBuiltInArgument(OWLClass cls) {
        return this.getSWRLBuiltInArgumentFactory().getClassBuiltInArgument(cls);
    }

    @Override
    public @NonNull SWRLClassExpressionBuiltInArgument createClassExpressionBuiltInArgument(OWLClassExpression ce) {
        return this.getSWRLBuiltInArgumentFactory().getClassExpressionBuiltInArgument(ce);
    }

    @Override
    public @NonNull SWRLNamedIndividualBuiltInArgument createNamedIndividualBuiltInArgument(OWLNamedIndividual individual) {
        return this.getSWRLBuiltInArgumentFactory().getNamedIndividualBuiltInArgument(individual);
    }

    @Override
    public @NonNull SWRLObjectPropertyBuiltInArgument createObjectPropertyBuiltInArgument(OWLObjectProperty property) {
        return this.getSWRLBuiltInArgumentFactory().getObjectPropertyBuiltInArgument(property);
    }

    @Override
    public @NonNull SWRLObjectPropertyExpressionBuiltInArgument createObjectPropertyExpressionBuiltInArgument(@NonNull OWLObjectPropertyExpression pe) {
        return this.getSWRLBuiltInArgumentFactory().getObjectPropertyExpressionBuiltInArgument(pe);
    }

    @Override
    public @NonNull SWRLDataPropertyBuiltInArgument createDataPropertyBuiltInArgument(@NonNull OWLDataProperty property) {
        return this.getSWRLBuiltInArgumentFactory().getDataPropertyBuiltInArgument(property);
    }

    @Override
    public @NonNull SWRLDataPropertyExpressionBuiltInArgument createDataPropertyExpressionBuiltInArgument(@NonNull OWLDataPropertyExpression pe) {
        return this.getSWRLBuiltInArgumentFactory().getDataPropertyExpressionBuiltInArgument(pe);
    }

    @Override
    public @NonNull SWRLAnnotationPropertyBuiltInArgument createAnnotationPropertyBuiltInArgument(@NonNull OWLAnnotationProperty property) {
        return this.getSWRLBuiltInArgumentFactory().getAnnotationPropertyBuiltInArgument(property);
    }

    @Override
    public @NonNull SWRLDatatypeBuiltInArgument createDatatypeBuiltInArgument(@NonNull OWLDatatype datatype) {
        return this.getSWRLBuiltInArgumentFactory().getDatatypeBuiltInArgument(datatype);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(@NonNull OWLLiteral literal) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(literal);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(@NonNull String s) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(s);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(boolean b) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(b);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(byte b) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(b);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(short s) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(s);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(int i) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(i);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(long l) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(l);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(float f) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(f);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(double d) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(d);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(BigDecimal d) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(d);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(BigInteger d) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(d);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(XSDDate date) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(date);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(XSDTime time) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(time);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(XSDDateTime dateTime) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(dateTime);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(XSDDuration duration) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(duration);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLiteralBuiltInArgument(URI uri) {
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(uri);
    }

    @Override
    public @NonNull SWRLMultiValueVariableBuiltInArgument createSWRLMultiValueVariableBuiltInArgument(IRI variableIRI) {
        return this.getSWRLBuiltInArgumentFactory().getMultiValueVariableBuiltInArgument(variableIRI);
    }

    @Override
    public @NonNull SWRLMultiValueVariableBuiltInArgument createSWRLMultiValueVariableBuiltInArgument(IRI variableIRI, List<@NonNull SWRLBuiltInArgument> arguments) {
        return this.getSWRLBuiltInArgumentFactory().getMultiValueVariableBuiltInArgument(variableIRI, arguments);
    }

    @Override
    public @NonNull SQWRLCollectionVariableBuiltInArgument createSQWRLCollectionVariableBuiltInArgument(@NonNull IRI variableIRI, @NonNull String queryName, @NonNull String collectionName, @NonNull String collectionGroupID) {
        return this.getSWRLBuiltInArgumentFactory().getSQWRLCollectionVariableBuiltInArgument(variableIRI, queryName, collectionName, collectionGroupID);
    }

    @Override
    public @NonNull Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> createOutputMultiValueArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        HashMap<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = new HashMap<Integer, SWRLMultiValueVariableBuiltInArgument>();
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (!arguments.get(argumentNumber).isVariable()) continue;
            IRI variableIRI = arguments.get(argumentNumber).asVariable().getIRI();
            outputMultiValueArguments.put(argumentNumber, this.createSWRLMultiValueVariableBuiltInArgument(variableIRI));
        }
        return outputMultiValueArguments;
    }

    @Override
    public @NonNull Map<@NonNull Integer, @NonNull OWLObject> getInputArgumentValues(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, SWRLBuiltInArgumentType<?> ... builtInArgumentTypes) throws SWRLBuiltInException {
        HashMap<@NonNull Integer, @NonNull OWLObject> boundInputArgumentValues = new HashMap<Integer, OWLObject>();
        if (arguments.size() != builtInArgumentTypes.length) {
            throw new SWRLBuiltInException("internal error: expecting " + arguments.size() + " entries for bound argument types, got" + builtInArgumentTypes.length);
        }
        for (int argumentNumber = 0; argumentNumber < arguments.size(); ++argumentNumber) {
            if (arguments.get(argumentNumber).isVariable()) continue;
            SWRLBuiltInArgumentType<?> builtInArgumentType = builtInArgumentTypes[argumentNumber];
            if (builtInArgumentType == SWRLBuiltInArgumentType.LITERAL) {
                this.checkThatArgumentIsALiteral(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLLiteralBuiltInArgument().getLiteral());
                continue;
            }
            if (builtInArgumentType == SWRLBuiltInArgumentType.CLASS) {
                this.checkThatArgumentIsAClass(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLClassBuiltInArgument().getOWLClass());
                continue;
            }
            if (builtInArgumentType == SWRLBuiltInArgumentType.CLASS_EXPRESSION) {
                this.checkThatArgumentIsAClassExpression(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLClassExpressionBuiltInArgument().getOWLClassExpression());
                continue;
            }
            if (builtInArgumentType == SWRLBuiltInArgumentType.NAMED_INDIVIDUAL) {
                this.checkThatArgumentIsANamedIndividual(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLNamedIndividualBuiltInArgument().getOWLNamedIndividual());
                continue;
            }
            if (builtInArgumentType == SWRLBuiltInArgumentType.OBJECT_PROPERTY) {
                this.checkThatArgumentIsAnObjectProperty(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLObjectPropertyBuiltInArgument().getOWLObjectProperty());
                continue;
            }
            if (builtInArgumentType == SWRLBuiltInArgumentType.OBJECT_PROPERTY_EXPRESSION) {
                this.checkThatArgumentIsAnObjectPropertyExpression(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLObjectPropertyExpressionBuiltInArgument().getOWLObjectPropertyExpression());
                continue;
            }
            if (builtInArgumentType == SWRLBuiltInArgumentType.DATA_PROPERTY) {
                this.checkThatArgumentIsADataProperty(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLDataPropertyBuiltInArgument().getOWLDataProperty());
                continue;
            }
            if (builtInArgumentType == SWRLBuiltInArgumentType.DATA_PROPERTY_EXPRESSION) {
                this.checkThatArgumentIsADataPropertyExpression(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLDataPropertyExpressionBuiltInArgument().getOWLDataPropertyExpression());
                continue;
            }
            if (builtInArgumentType == SWRLBuiltInArgumentType.ANNOTATION_PROPERTY) {
                this.checkThatArgumentIsAnAnnotationProperty(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLAnnotationPropertyBuiltInArgument().getOWLAnnotationProperty());
                continue;
            }
            if (builtInArgumentType == SWRLBuiltInArgumentType.DATATYPE) {
                this.checkThatArgumentIsADatatype(argumentNumber, arguments);
                boundInputArgumentValues.put(argumentNumber, (OWLObject)arguments.get(argumentNumber).asSWRLDatatypeBuiltInArgument().getOWLDatatype());
                continue;
            }
            throw new SWRLBuiltInException("internal error: unexpected argument type " + builtInArgumentType + " for argument number " + argumentNumber);
        }
        return boundInputArgumentValues;
    }

    @Override
    public boolean processResultMultiValueArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, @NonNull Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> resultMultiValueArguments) throws SWRLBuiltInException {
        if (resultMultiValueArguments.values().stream().filter(a -> a.hasArguments()).collect(Collectors.toSet()).isEmpty()) {
            return false;
        }
        for (Integer argumentNumber : resultMultiValueArguments.keySet()) {
            arguments.get(argumentNumber).asVariable().setBuiltInResult(resultMultiValueArguments.get(argumentNumber));
        }
        return true;
    }

    private @NonNull OWLLiteral createLeastNarrowNumericOWLLiteral(double value, @NonNull List<@NonNull SWRLBuiltInArgument> boundInputNumericArguments) throws SWRLBuiltInException {
        if (this.isWidestNumericArgumentAByte(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral((byte)value);
        }
        if (this.isWidestNumericArgumentAShort(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral((short)value);
        }
        if (this.isWidestNumericArgumentAnInt(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral((int)value);
        }
        if (this.isWidestNumericArgumentALong(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral((long)value);
        }
        if (this.isWidestNumericArgumentAFloat(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral((float)value);
        }
        return this.getOWLLiteralFactory().getOWLLiteral(value);
    }

    private @NonNull OWLLiteral createLeastNarrowNumericOWLLiteral(BigDecimal value, @NonNull List<@NonNull SWRLBuiltInArgument> boundInputNumericArguments) throws SWRLBuiltInException {
        if (this.isWidestNumericArgumentAByte(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral(value.byteValue());
        }
        if (this.isWidestNumericArgumentAShort(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral(value.shortValue());
        }
        if (this.isWidestNumericArgumentAnInt(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral(value.intValue());
        }
        if (this.isWidestNumericArgumentALong(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral(value.longValue());
        }
        if (this.isWidestNumericArgumentAnInteger(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral(value.toBigInteger());
        }
        if (this.isWidestNumericArgumentAFloat(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral(value.floatValue());
        }
        if (this.isWidestNumericArgumentADouble(boundInputNumericArguments)) {
            return this.getOWLLiteralFactory().getOWLLiteral(value.doubleValue());
        }
        return this.getOWLLiteralFactory().getOWLLiteral(value);
    }

    private @NonNull Literal getArgumentAsALiteral(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatArgumentIsALiteral(argumentNumber, arguments);
        SWRLLiteralBuiltInArgument argument = (SWRLLiteralBuiltInArgument)arguments.get(argumentNumber);
        return this.getLiteralFactory().getLiteral(argument.getLiteral());
    }

    private @NonNull Literal getArgumentAsALiteral(SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        if (!(argument instanceof SWRLLiteralBuiltInArgument)) {
            throw new InvalidSWRLBuiltInArgumentException(this.makeInvalidArgumentTypeMessage(argument, "data value"));
        }
        SWRLLiteralBuiltInArgument a = (SWRLLiteralBuiltInArgument)argument;
        return this.getLiteralFactory().getLiteral(a.getLiteral());
    }

    @Override
    public @NonNull String makeInvalidArgumentTypeMessage(@NonNull SWRLBuiltInArgument argument, @NonNull String expectedTypeName) throws SWRLBuiltInException {
        String message = "expecting " + expectedTypeName + ", got ";
        if (argument.isVariable() && argument.asVariable().isUnbound()) {
            message = message + "unbound argument with variable prefix " + argument.asVariable().getVariableName();
        } else if (argument instanceof SWRLClassBuiltInArgument) {
            SWRLClassBuiltInArgument classArgument = (SWRLClassBuiltInArgument)argument;
            message = message + "class with IRI " + classArgument.getIRI();
        } else if (argument instanceof SWRLPropertyBuiltInArgument) {
            SWRLPropertyBuiltInArgument propertyArgument = (SWRLPropertyBuiltInArgument)argument;
            message = message + "property with IRI " + propertyArgument.getIRI();
        } else if (argument instanceof SWRLNamedIndividualBuiltInArgument) {
            SWRLNamedIndividualBuiltInArgument individualArgument = (SWRLNamedIndividualBuiltInArgument)argument;
            message = message + "individual with IRI " + individualArgument.getIRI();
        } else if (argument instanceof SWRLLiteralBuiltInArgument) {
            SWRLLiteralBuiltInArgument literalBuiltInArgument = (SWRLLiteralBuiltInArgument)argument;
            message = message + "literal with value " + literalBuiltInArgument.getLiteral().getLiteral() + " and type " + literalBuiltInArgument.getLiteral().getDatatype();
        } else {
            message = message + "unknown type " + argument.getClass();
        }
        return message;
    }

    protected @NonNull String createInvocationPattern(@NonNull SWRLBuiltInBridge bridge, @NonNull String ruleName, int builtInIndex, boolean inConsequent, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        String result;
        String pattern = "" + bridge.hashCode() + "." + ruleName + "." + builtInIndex + "." + inConsequent;
        for (int i = 0; i < arguments.size(); ++i) {
            pattern = pattern + "." + this.getArgumentAsAPropertyValue(i, arguments);
        }
        if (this.invocationPatternMap.containsKey(pattern)) {
            result = this.invocationPatternMap.get(pattern).toString();
        } else {
            this.invocationPatternMap.put(pattern, this.invocationPatternID);
            result = this.invocationPatternID.toString();
            Long l = this.invocationPatternID;
            Long l2 = this.invocationPatternID = Long.valueOf(this.invocationPatternID + 1L);
        }
        return result;
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLeastNarrowNumericLiteralBuiltInArgument(double value, @NonNull List<@NonNull SWRLBuiltInArgument> boundInputNumericArguments) throws SWRLBuiltInException {
        OWLLiteral literal = this.createLeastNarrowNumericOWLLiteral(value, boundInputNumericArguments);
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(literal);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument createLeastNarrowNumericLiteralBuiltInArgument(@NonNull BigDecimal value, @NonNull List<@NonNull SWRLBuiltInArgument> boundInputNumericArguments) throws SWRLBuiltInException {
        OWLLiteral literal = this.createLeastNarrowNumericOWLLiteral(value, boundInputNumericArguments);
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(literal);
    }

    protected @NonNull OWLNamedIndividual injectOWLNamedIndividualOfClass(@NonNull OWLClass cls) {
        OWLNamedIndividual individual = this.getSWRLAPIOWLDataFactory().getInjectedOWLNamedIndividual();
        OWLDeclarationAxiom declarationAxiom = this.getSWRLAPIOWLDataFactory().getOWLIndividualDeclarationAxiom(individual);
        OWLClassAssertionAxiom classAssertionAxiom = this.getSWRLAPIOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)individual);
        this.getBuiltInBridge().injectOWLAxiom((OWLAxiom)declarationAxiom);
        this.getBuiltInBridge().injectOWLAxiom((OWLAxiom)classAssertionAxiom);
        return individual;
    }

    protected @NonNull SWRLAPIOWLDataFactory getSWRLAPIOWLDataFactory() throws SWRLBuiltInLibraryException {
        return this.getBuiltInBridge().getSWRLAPIOWLDataFactory();
    }

    protected @NonNull SQWRLResultValueFactory getSQWRLResultValueFactory() throws SWRLBuiltInLibraryException {
        return this.getSWRLAPIOWLDataFactory().getSQWRLResultValueFactory();
    }

    private @NonNull LiteralFactory getLiteralFactory() throws SWRLBuiltInLibraryException {
        return this.getSWRLAPIOWLDataFactory().getLiteralFactory();
    }

    private @NonNull OWLLiteralFactory getOWLLiteralFactory() throws SWRLBuiltInLibraryException {
        return this.getSWRLAPIOWLDataFactory().getOWLLiteralFactory();
    }

    private @NonNull SWRLBuiltInArgumentFactory getSWRLBuiltInArgumentFactory() throws SWRLBuiltInLibraryException {
        return this.getSWRLAPIOWLDataFactory().getSWRLBuiltInArgumentFactory();
    }
}

