/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swrlapi.builtins.SWRLBuiltInBridge;
import org.swrlapi.builtins.SWRLBuiltInLibrary;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.exceptions.IncompatibleBuiltInMethodException;
import org.swrlapi.exceptions.IncompatibleSWRLBuiltInClassException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLBuiltInLibraryException;
import org.swrlapi.exceptions.UnresolvedSWRLBuiltInClassException;
import org.swrlapi.exceptions.UnresolvedSWRLBuiltInMethodException;

public class SWRLBuiltInLibraryManager {
    private static final Logger log = LoggerFactory.getLogger(SWRLBuiltInLibraryManager.class);
    private static final String SWRLBuiltInLibraryPackageBaseName = "org.swrlapi.builtins";
    private static final String SWRLBuiltInLibraryImplementationClassName = "SWRLBuiltInLibraryImpl";
    private static final String[] preCannedSWRLBuiltInLibraryPrefixNames = new String[]{"swrlb", "sqwrl", "swrlx", "swrlm", "abox", "tbox", "rbox", "temporal"};
    private static final Set<String> preCannedSWRLBuiltInLibraryPrefixes = new HashSet<String>(Arrays.asList(preCannedSWRLBuiltInLibraryPrefixNames));
    private final @NonNull Map<@NonNull IRI, @NonNull String> swrlBuiltInIRI2PrefixedName = new HashMap<IRI, String>();
    private final @NonNull Map<@NonNull String, @NonNull IRI> swrlBuiltInPrefixedName2IRI = new HashMap<String, IRI>();
    private final @NonNull Map<@NonNull String, @NonNull SWRLBuiltInLibrary> swrlBuiltInLibraryImplementations = new HashMap<String, SWRLBuiltInLibrary>();
    private final @NonNull Map<@NonNull String, @NonNull Method> swrlBuiltInMethods = new HashMap<String, Method>();

    public SWRLBuiltInLibraryManager() {
        this.loadInternalSWRLBuiltInLibraries(preCannedSWRLBuiltInLibraryPrefixes);
    }

    public void loadExternalSWRLBuiltInLibraries(@NonNull File swrlBuiltInLibraryDirectory) {
        if (swrlBuiltInLibraryDirectory.exists() && swrlBuiltInLibraryDirectory.isDirectory()) {
            File[] swrlBuiltInLibrarySubDirectories = swrlBuiltInLibraryDirectory.listFiles();
            for (int builtInLibraryIndex = 0; builtInLibraryIndex < swrlBuiltInLibrarySubDirectories.length; ++builtInLibraryIndex) {
                if (swrlBuiltInLibrarySubDirectories[builtInLibraryIndex].isDirectory()) {
                    File swrlBuiltInLibrarySubDirectory = swrlBuiltInLibrarySubDirectories[builtInLibraryIndex];
                    String swrlBuiltInLibrarySubDirectoryName = swrlBuiltInLibrarySubDirectory.getName();
                    try {
                        URL swrlBuiltInLibrarySubDirectoryURL = new URL("file:" + swrlBuiltInLibrarySubDirectory.getCanonicalPath());
                        URLClassLoader classLoader = new URLClassLoader(new URL[]{swrlBuiltInLibrarySubDirectoryURL}, this.getClass().getClassLoader());
                        SWRLBuiltInLibrary swrlBuiltInLibrary = this.instantiateSWRLBuiltInLibraryImplementation(swrlBuiltInLibrarySubDirectoryName);
                        String swrlBuiltInLibraryPrefix = swrlBuiltInLibrary.getPrefix();
                        if (preCannedSWRLBuiltInLibraryPrefixes.contains(swrlBuiltInLibraryPrefix)) {
                            log.warn("External built-in library prefix " + swrlBuiltInLibraryPrefix + " collides with in-built library prefix");
                            continue;
                        }
                        if (swrlBuiltInLibraryPrefix.equals(swrlBuiltInLibrarySubDirectoryName)) {
                            log.info("Loading external SWRL built-in library " + swrlBuiltInLibraryPrefix);
                            this.registerSWRLBuiltIns(swrlBuiltInLibraryPrefix, swrlBuiltInLibrary.getNamespace(), swrlBuiltInLibrary.getBuiltInNames());
                            this.swrlBuiltInLibraryImplementations.put(swrlBuiltInLibraryPrefix, swrlBuiltInLibrary);
                            continue;
                        }
                        log.warn("Invalid sub-directory name " + swrlBuiltInLibrarySubDirectoryName + " for SWRL built-in library with prefix " + swrlBuiltInLibraryPrefix + " - sub-directory and prefix should match!");
                    }
                    catch (IOException e) {
                        log.warn("Internal error processing SWRL built-in directory " + swrlBuiltInLibraryDirectory.getAbsolutePath());
                    }
                    continue;
                }
                log.warn("SWRL built-in directory " + swrlBuiltInLibraryDirectory.getAbsolutePath() + " does not exist or is not a directory!");
            }
        }
    }

    private void loadInternalSWRLBuiltInLibraries(Set<@NonNull String> swrlBuiltInLibraryPrefixes) {
        for (String swrlBuiltInLibraryPrefix : swrlBuiltInLibraryPrefixes) {
            SWRLBuiltInLibrary swrlBuiltInLibrary = this.instantiateSWRLBuiltInLibraryImplementation(swrlBuiltInLibraryPrefix);
            this.registerSWRLBuiltIns(swrlBuiltInLibrary.getPrefix(), swrlBuiltInLibrary.getNamespace(), swrlBuiltInLibrary.getBuiltInNames());
            this.swrlBuiltInLibraryImplementations.put(swrlBuiltInLibraryPrefix, swrlBuiltInLibrary);
        }
    }

    public boolean isSWRLBuiltInIRI(@NonNull IRI iri) {
        return this.swrlBuiltInIRI2PrefixedName.containsKey(iri);
    }

    public boolean isSWRLBuiltIn(@NonNull String prefixedName) {
        return this.swrlBuiltInPrefixedName2IRI.containsKey(prefixedName);
    }

    public Optional<@NonNull IRI> swrlBuiltInPrefixedName2IRI(@NonNull String prefixedName) {
        if (this.swrlBuiltInPrefixedName2IRI.containsKey(prefixedName)) {
            return Optional.of(this.swrlBuiltInPrefixedName2IRI.get(prefixedName));
        }
        return Optional.empty();
    }

    public Optional<@NonNull String> swrlBuiltInIRI2PrefixedName(@NonNull IRI iri) {
        if (this.swrlBuiltInIRI2PrefixedName.containsKey(iri)) {
            return Optional.of(this.swrlBuiltInIRI2PrefixedName.get(iri));
        }
        return Optional.empty();
    }

    public @NonNull Set<@NonNull IRI> getSWRLBuiltInIRIs() {
        return Collections.unmodifiableSet(this.swrlBuiltInIRI2PrefixedName.keySet());
    }

    public @NonNull List<@NonNull List<@NonNull SWRLBuiltInArgument>> invokeSWRLBuiltIn(@NonNull SWRLBuiltInBridge bridge, @NonNull String ruleName, @NonNull String builtInMethodPrefixedName, int builtInIndex, boolean isInConsequent, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        String prefix = this.getPrefixFromPrefixedName(builtInMethodPrefixedName);
        String builtInMethodName = this.getBuiltInMethodNameFromPrefixedName(builtInMethodPrefixedName);
        SWRLBuiltInLibrary swrlBuiltInLibrary = this.getSWRLBuiltInLibraryImplementation(prefix);
        Method method = this.resolveSWRLBuiltInMethod(ruleName, swrlBuiltInLibrary, prefix, builtInMethodName);
        ArrayList<@NonNull List<@NonNull SWRLBuiltInArgument>> argumentPatterns = new ArrayList<List<SWRLBuiltInArgument>>();
        if (swrlBuiltInLibrary.invokeBuiltInMethod(method, bridge, ruleName, prefix, builtInMethodName, builtInIndex, isInConsequent, arguments)) {
            if (this.hasUnboundArguments(arguments)) {
                throw new SWRLBuiltInException("built-in " + builtInMethodPrefixedName + "(index " + builtInIndex + ") in rule " + ruleName + " returned with unbound arguments");
            }
            this.processBoundArguments(arguments);
            argumentPatterns.addAll(this.generateBuiltInArgumentPattern(ruleName, builtInMethodPrefixedName, builtInIndex, arguments).stream().collect(Collectors.toList()));
        }
        return argumentPatterns;
    }

    private void processBoundArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (int argumentIndex = 0; argumentIndex < arguments.size(); ++argumentIndex) {
            Optional<SWRLBuiltInArgument> builtInResult;
            SWRLBuiltInArgument argument = arguments.get(argumentIndex);
            if (!argument.isVariable() || !argument.asVariable().hasBuiltInResult() || !(builtInResult = argument.asVariable().getBuiltInResult()).isPresent()) continue;
            arguments.set(argumentIndex, builtInResult.get());
        }
    }

    private @NonNull SWRLBuiltInLibrary getSWRLBuiltInLibraryImplementation(@NonNull String prefix) throws SWRLBuiltInLibraryException {
        if (this.swrlBuiltInLibraryImplementations.containsKey(prefix)) {
            return this.swrlBuiltInLibraryImplementations.get(prefix);
        }
        throw new SWRLBuiltInLibraryException("could not find built-in library for prefix " + prefix);
    }

    private void invokeBuiltInLibraryResetMethod(@NonNull SWRLBuiltInBridge bridge, @NonNull SWRLBuiltInLibrary library) throws SWRLBuiltInLibraryException {
        try {
            library.invokeResetMethod(bridge);
        }
        catch (Exception e) {
            throw new SWRLBuiltInLibraryException("error calling reset method in built-in library " + library.getClass());
        }
    }

    public void invokeAllBuiltInLibrariesResetMethod(@NonNull SWRLBuiltInBridge bridge) throws SWRLBuiltInLibraryException {
        for (SWRLBuiltInLibrary library : this.swrlBuiltInLibraryImplementations.values()) {
            this.invokeBuiltInLibraryResetMethod(bridge, library);
        }
    }

    private @NonNull Set<@NonNull List<@NonNull SWRLBuiltInArgument>> generateBuiltInArgumentPattern(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        List<@NonNull Integer> multiValueBuiltInArgumentIndexes = this.getMultiValueBuiltInArgumentIndexes(arguments);
        HashSet<@NonNull List<@NonNull SWRLBuiltInArgument>> pattern = new HashSet<List<SWRLBuiltInArgument>>();
        if (multiValueBuiltInArgumentIndexes.isEmpty()) {
            pattern.add(arguments);
        } else {
            int firstMultiValueBuiltInArgumentIndex = multiValueBuiltInArgumentIndexes.get(0);
            SWRLMultiValueVariableBuiltInArgument multiValueBuiltInArgument = this.getArgumentAsASWRLMultiValueBuiltInArgument(arguments, firstMultiValueBuiltInArgumentIndex);
            int numberOfArgumentsInMultiValueBuiltInArgument = multiValueBuiltInArgument.getNumberOfArguments();
            if (numberOfArgumentsInMultiValueBuiltInArgument < 1) {
                throw new SWRLBuiltInException("empty multi-value argument for built-in " + builtInName + "(index " + builtInIndex + ") in rule " + ruleName);
            }
            for (int i = 1; i < multiValueBuiltInArgumentIndexes.size(); ++i) {
                int multiValueBuiltInArgumentIndex = multiValueBuiltInArgumentIndexes.get(i);
                multiValueBuiltInArgument = this.getArgumentAsASWRLMultiValueBuiltInArgument(arguments, multiValueBuiltInArgumentIndex);
                if (numberOfArgumentsInMultiValueBuiltInArgument == multiValueBuiltInArgument.getNumberOfArguments()) continue;
                throw new SWRLBuiltInException("all multi-value arguments must have the same number of elements for built-in " + builtInName + "(index " + builtInIndex + ") in rule " + ruleName);
            }
            for (int multiValueBuiltInArgumentArgumentIndex = 0; multiValueBuiltInArgumentArgumentIndex < numberOfArgumentsInMultiValueBuiltInArgument; ++multiValueBuiltInArgumentArgumentIndex) {
                List<@NonNull SWRLBuiltInArgument> argumentsPattern = this.generateArgumentsPattern(arguments, multiValueBuiltInArgumentArgumentIndex);
                pattern.add(argumentsPattern);
            }
        }
        return pattern;
    }

    private @NonNull SWRLMultiValueVariableBuiltInArgument getArgumentAsASWRLMultiValueBuiltInArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int argumentIndex) throws SWRLBuiltInException {
        if (arguments.get(argumentIndex) instanceof SWRLMultiValueVariableBuiltInArgument) {
            return (SWRLMultiValueVariableBuiltInArgument)arguments.get(argumentIndex);
        }
        throw new SWRLBuiltInException("expecting milti-argment for (0-indexed) argument #" + argumentIndex);
    }

    private @NonNull List<@NonNull Integer> getMultiValueBuiltInArgumentIndexes(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) {
        ArrayList<@NonNull Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < arguments.size(); ++i) {
            if (!(arguments.get(i) instanceof SWRLMultiValueVariableBuiltInArgument)) continue;
            result.add(i);
        }
        return result;
    }

    private @NonNull List<@NonNull SWRLBuiltInArgument> generateArgumentsPattern(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int multiValueBuiltInArgumentArgumentIndex) {
        ArrayList<@NonNull SWRLBuiltInArgument> result = new ArrayList<SWRLBuiltInArgument>();
        for (SWRLBuiltInArgument argument : arguments) {
            if (argument instanceof SWRLMultiValueVariableBuiltInArgument) {
                SWRLMultiValueVariableBuiltInArgument multiValueBuiltInArgument = (SWRLMultiValueVariableBuiltInArgument)argument;
                result.add(multiValueBuiltInArgument.getArguments().get(multiValueBuiltInArgumentArgumentIndex));
                continue;
            }
            result.add(argument);
        }
        return result;
    }

    private @NonNull Method resolveSWRLBuiltInMethod(@NonNull String ruleName, @NonNull SWRLBuiltInLibrary library, @NonNull String prefix, @NonNull String builtInMethodName) throws UnresolvedSWRLBuiltInMethodException {
        String key = prefix + ":" + builtInMethodName;
        if (this.swrlBuiltInMethods.containsKey(key)) {
            return this.swrlBuiltInMethods.get(key);
        }
        try {
            Method method = library.getClass().getMethod(builtInMethodName, List.class);
            this.checkSWRLBuiltInMethodSignature(ruleName, prefix, builtInMethodName, method);
            this.swrlBuiltInMethods.put(key, method);
            return method;
        }
        catch (Exception e) {
            throw new UnresolvedSWRLBuiltInMethodException(ruleName, prefix, builtInMethodName, e.getMessage() != null ? e.getMessage() : "", e);
        }
    }

    private @NonNull SWRLBuiltInLibrary instantiateSWRLBuiltInLibraryImplementation(@NonNull String swrlBuiltInLibraryPrefix) throws SWRLBuiltInLibraryException {
        Class<?> swrlBuiltInLibraryImplementationClass;
        String swrlBuiltInLibraryImplementationClassName = "org.swrlapi.builtins." + swrlBuiltInLibraryPrefix + "." + SWRLBuiltInLibraryImplementationClassName;
        try {
            swrlBuiltInLibraryImplementationClass = Class.forName(swrlBuiltInLibraryImplementationClassName);
        }
        catch (Exception e) {
            throw new UnresolvedSWRLBuiltInClassException(swrlBuiltInLibraryImplementationClassName, e.getMessage() != null ? e.getMessage() : "", e);
        }
        this.checkSWRLBuiltInLibraryImplementationClassCompatibility(swrlBuiltInLibraryImplementationClassName, swrlBuiltInLibraryImplementationClass);
        try {
            return (SWRLBuiltInLibrary)swrlBuiltInLibraryImplementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IncompatibleSWRLBuiltInClassException(swrlBuiltInLibraryImplementationClassName, e.getMessage() != null ? e.getMessage() : "", e);
        }
    }

    private void checkSWRLBuiltInMethodSignature(@NonNull String ruleName, @NonNull String prefix, @NonNull String builtInURI, @NonNull Method method) throws IncompatibleBuiltInMethodException {
        if (method.getReturnType() != Boolean.TYPE) {
            throw new IncompatibleBuiltInMethodException(ruleName, prefix, builtInURI, "Java method must return a boolean");
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length != 1 || exceptionTypes[0] != SWRLBuiltInException.class) {
            throw new IncompatibleBuiltInMethodException(ruleName, prefix, builtInURI, "Java method must throw a single exception of type BuiltInException");
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length != 1 || !(parameterTypes[0] instanceof ParameterizedType) || ((ParameterizedType)parameterTypes[0]).getRawType() != List.class || ((ParameterizedType)parameterTypes[0]).getActualTypeArguments().length != 1 || ((ParameterizedType)parameterTypes[0]).getActualTypeArguments()[0] != SWRLBuiltInArgument.class) {
            throw new IncompatibleBuiltInMethodException(ruleName, prefix, builtInURI, "Java built-in method implementation must accept a single List of SWRLBuiltInArgument objects");
        }
    }

    private void checkSWRLBuiltInLibraryImplementationClassCompatibility(@NonNull String prefix, @NonNull Class<?> cls) throws IncompatibleSWRLBuiltInClassException {
        if (!SWRLBuiltInLibrary.class.isAssignableFrom(cls)) {
            throw new IncompatibleSWRLBuiltInClassException(cls.getName(), "Java class does not extend " + SWRLBuiltInLibrary.class.getCanonicalName());
        }
    }

    private boolean hasUnboundArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (SWRLBuiltInArgument argument : arguments) {
            if (!argument.isVariable() || !argument.asVariable().isUnbound()) continue;
            return true;
        }
        return false;
    }

    private @NonNull Optional<String> extractSWRLBuiltInLibraryPrefixFromClassName(@NonNull String swrlBuiltInLibraryImplementationClassName) {
        if (swrlBuiltInLibraryImplementationClassName.length() > SWRLBuiltInLibraryPackageBaseName.length() + SWRLBuiltInLibraryImplementationClassName.length()) {
            String swrlBuiltInLibraryPrefix = swrlBuiltInLibraryImplementationClassName.substring(SWRLBuiltInLibraryPackageBaseName.length(), swrlBuiltInLibraryImplementationClassName.length() - SWRLBuiltInLibraryImplementationClassName.length());
            if (SWRLBuiltInLibraryManager.isValidJavaIdentifier(swrlBuiltInLibraryPrefix)) {
                return Optional.of(swrlBuiltInLibraryPrefix);
            }
            log.warn("Invalid SWRL built-in library implementation prefix " + swrlBuiltInLibraryImplementationClassName);
            return Optional.empty();
        }
        log.warn("Invalid SWRL built-in library implementation class name " + swrlBuiltInLibraryImplementationClassName);
        return Optional.empty();
    }

    private void registerSWRLBuiltIns(@NonNull String swrlBuiltInLibraryPrefix, @NonNull String swrlBuiltInLibraryNamespace, @NonNull Set<@NonNull String> builtInNames) {
        for (String builtInName : builtInNames) {
            this.registerSWRLBuiltIn(swrlBuiltInLibraryPrefix, swrlBuiltInLibraryNamespace, builtInName);
        }
    }

    private void registerSWRLBuiltIn(@NonNull String swrlBuiltInLibraryPrefix, @NonNull String swrlBuiltInLibraryNamespace, @NonNull String builtInName) {
        IRI builtInIRI = IRI.create((String)swrlBuiltInLibraryNamespace, (String)builtInName);
        String builtInPrefixedName = swrlBuiltInLibraryPrefix + ":" + builtInName;
        this.swrlBuiltInIRI2PrefixedName.put(builtInIRI, builtInPrefixedName);
        this.swrlBuiltInPrefixedName2IRI.put(builtInPrefixedName, builtInIRI);
    }

    private @NonNull String getPrefixFromPrefixedName(@NonNull String builtInPrefixedName) {
        int hashIndex = builtInPrefixedName.indexOf(58);
        if (hashIndex != -1) {
            return builtInPrefixedName.substring(0, hashIndex);
        }
        return "";
    }

    private @NonNull String getSWRLBuiltInLibraryImplementationClassName(@NonNull String prefix) {
        if (prefix.length() == 0) {
            return "org.swrlapi.builtinsSWRLBuiltInLibraryImpl";
        }
        return "org.swrlapi.builtins." + prefix + "." + SWRLBuiltInLibraryImplementationClassName;
    }

    private @NonNull String getBuiltInMethodNameFromPrefixedName(@NonNull String builtInPrefixedName) {
        if (!builtInPrefixedName.contains(":")) {
            return builtInPrefixedName;
        }
        return builtInPrefixedName.substring(builtInPrefixedName.indexOf(":") + 1, builtInPrefixedName.length());
    }

    private @NonNull String getClassNameFromEntry(@NonNull ZipEntry entry) {
        StringBuilder className = new StringBuilder();
        for (String part : entry.getName().split("/")) {
            if (className.length() != 0) {
                className.append(".");
            }
            className.append(part);
            if (!part.endsWith(".class")) continue;
            className.setLength(className.length() - ".class".length());
        }
        return className.toString();
    }

    private static boolean isValidJavaIdentifier(@NonNull String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }
}

