/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.abox;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.swrlapi.builtins.AbstractSWRLBuiltInLibrary;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentType;
import org.swrlapi.builtins.arguments.SWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.exceptions.SWRLBuiltInException;

public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static final String PREFIX = "abox";
    private static final String NAMESPACE = "http://swrl.stanford.edu/ontologies/built-ins/5.0.0/abox.owl#";
    private static final String[] BUILT_IN_NAMES = new String[]{"caa", "sia", "dia", "opaa", "nopaa", "dpaa", "ndpaa"};

    public SWRLBuiltInLibraryImpl() {
        super(PREFIX, NAMESPACE, new HashSet<String>(Arrays.asList(BUILT_IN_NAMES)));
    }

    @Override
    public void reset() {
    }

    public boolean caa(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.CLASS_ASSERTION, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.CLASS, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLClassAssertionAxiom axiom : axioms) {
            OWLClassExpression candidateValue1 = axiom.getClassExpression();
            OWLNamedIndividual candidateValue2 = axiom.getIndividual().asOWLNamedIndividual();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createClassExpressionBuiltInArgument(candidateValue1));
            }
            if (!outputMultiValueArguments.containsKey(1)) continue;
            outputMultiValueArguments.get(1).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue2));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean sia(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.SAME_INDIVIDUAL, Imports.INCLUDED).stream().flatMap(a -> a.asPairwiseAxioms().stream()).collect(Collectors.toSet());
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLSameIndividualAxiom axiom : axioms) {
            OWLNamedIndividual candidateValue1 = ((OWLIndividual)axiom.getIndividualsAsList().get(0)).asOWLNamedIndividual();
            OWLNamedIndividual candidateValue2 = ((OWLIndividual)axiom.getIndividualsAsList().get(1)).asOWLNamedIndividual();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue1));
            }
            if (!outputMultiValueArguments.containsKey(1)) continue;
            outputMultiValueArguments.get(1).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue2));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean dia(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.DIFFERENT_INDIVIDUALS, Imports.INCLUDED).stream().flatMap(a -> a.asPairwiseAxioms().stream()).collect(Collectors.toSet());
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLDifferentIndividualsAxiom axiom : axioms) {
            OWLNamedIndividual candidateValue1 = ((OWLIndividual)axiom.getIndividualsAsList().get(0)).asOWLNamedIndividual();
            OWLNamedIndividual candidateValue2 = ((OWLIndividual)axiom.getIndividualsAsList().get(1)).asOWLNamedIndividual();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue1));
            }
            if (!outputMultiValueArguments.containsKey(1)) continue;
            outputMultiValueArguments.get(1).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue2));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean opaa(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL, SWRLBuiltInArgumentType.OBJECT_PROPERTY_EXPRESSION, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLObjectPropertyAssertionAxiom axiom : axioms) {
            OWLNamedIndividual candidateValue1 = axiom.getSubject().asOWLNamedIndividual();
            OWLObjectPropertyExpression candidateValue2 = (OWLObjectPropertyExpression)axiom.getProperty();
            OWLNamedIndividual candidateValue3 = ((OWLIndividual)axiom.getObject()).asOWLNamedIndividual();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2, candidateValue3})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue1));
            }
            if (outputMultiValueArguments.containsKey(1)) {
                outputMultiValueArguments.get(1).addArgument(this.createObjectPropertyExpressionBuiltInArgument(candidateValue2));
            }
            if (!outputMultiValueArguments.containsKey(2)) continue;
            outputMultiValueArguments.get(2).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue3));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean nopaa(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL, SWRLBuiltInArgumentType.OBJECT_PROPERTY_EXPRESSION, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLNegativeObjectPropertyAssertionAxiom axiom : axioms) {
            OWLNamedIndividual candidateValue1 = axiom.getSubject().asOWLNamedIndividual();
            OWLObjectPropertyExpression candidateValue2 = (OWLObjectPropertyExpression)axiom.getProperty();
            OWLNamedIndividual candidateValue3 = ((OWLIndividual)axiom.getObject()).asOWLNamedIndividual();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2, candidateValue3})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue1));
            }
            if (outputMultiValueArguments.containsKey(1)) {
                outputMultiValueArguments.get(1).addArgument(this.createObjectPropertyExpressionBuiltInArgument(candidateValue2));
            }
            if (!outputMultiValueArguments.containsKey(2)) continue;
            outputMultiValueArguments.get(2).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue3));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean dpaa(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.DATA_PROPERTY_ASSERTION, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL, SWRLBuiltInArgumentType.DATA_PROPERTY_EXPRESSION, SWRLBuiltInArgumentType.LITERAL);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLDataPropertyAssertionAxiom axiom : axioms) {
            OWLNamedIndividual candidateValue1 = axiom.getSubject().asOWLNamedIndividual();
            OWLDataPropertyExpression candidateValue2 = (OWLDataPropertyExpression)axiom.getProperty();
            OWLLiteral candidateValue3 = (OWLLiteral)axiom.getObject();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2, candidateValue3})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue1));
            }
            if (outputMultiValueArguments.containsKey(1)) {
                outputMultiValueArguments.get(1).addArgument(this.createDataPropertyExpressionBuiltInArgument(candidateValue2));
            }
            if (!outputMultiValueArguments.containsKey(2)) continue;
            outputMultiValueArguments.get(2).addArgument(this.createLiteralBuiltInArgument(candidateValue3));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean ndpaa(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.NAMED_INDIVIDUAL, SWRLBuiltInArgumentType.DATA_PROPERTY_EXPRESSION, SWRLBuiltInArgumentType.LITERAL);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLNegativeDataPropertyAssertionAxiom axiom : axioms) {
            OWLNamedIndividual candidateValue1 = axiom.getSubject().asOWLNamedIndividual();
            OWLDataPropertyExpression candidateValue2 = (OWLDataPropertyExpression)axiom.getProperty();
            OWLLiteral candidateValue3 = (OWLLiteral)axiom.getObject();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2, candidateValue3})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createNamedIndividualBuiltInArgument(candidateValue1));
            }
            if (outputMultiValueArguments.containsKey(1)) {
                outputMultiValueArguments.get(1).addArgument(this.createDataPropertyExpressionBuiltInArgument(candidateValue2));
            }
            if (!outputMultiValueArguments.containsKey(2)) continue;
            outputMultiValueArguments.get(2).addArgument(this.createLiteralBuiltInArgument(candidateValue3));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    private boolean noBoundArgumentsMismatch(@NonNull Map<Integer, @NonNull OWLObject> inputArgumentValues, OWLObject ... candidateValues) throws SWRLBuiltInException {
        for (int argumentNumber : inputArgumentValues.keySet()) {
            OWLObject inputArgumentValue = inputArgumentValues.get(argumentNumber);
            if (inputArgumentValue.equals(candidateValues[argumentNumber])) continue;
            return true;
        }
        return false;
    }
}

