/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.arguments;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentType;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyExpressionBuiltInArgument;
import org.swrlapi.exceptions.InvalidSWRLBuiltInArgumentNumberException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;

public interface SWRLBuiltInInputArgumentHandler {
    public boolean hasUnboundArguments(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkThatAllArgumentsAreBound(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkThatArgumentIsBound(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isBoundArgument(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isUnboundArgument(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkForUnboundArguments(@NonNull String var1, @NonNull String var2, @NonNull List<@NonNull SWRLBuiltInArgument> var3) throws SWRLBuiltInException;

    public int getFirstUnboundArgument(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkForUnboundArguments(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkForUnboundArguments(@NonNull List<@NonNull SWRLBuiltInArgument> var1, @NonNull String var2) throws SWRLBuiltInException;

    public void checkThatAllArgumentsAreBoundVariables(@NonNull List<@NonNull SWRLBuiltInArgument> var1, @NonNull String var2) throws SWRLBuiltInException;

    public void checkForUnboundNonFirstArguments(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkNumberOfArgumentsAtLeastOne(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkNumberOfArgumentsEqualTo(int var1, int var2) throws InvalidSWRLBuiltInArgumentNumberException;

    public void checkNumberOfArgumentsAtLeast(int var1, int var2) throws InvalidSWRLBuiltInArgumentNumberException;

    public void checkNumberOfArgumentsAtMost(int var1, int var2) throws InvalidSWRLBuiltInArgumentNumberException;

    public void checkNumberOfArgumentsInRange(int var1, int var2, int var3) throws InvalidSWRLBuiltInArgumentNumberException;

    public void checkArgumentNumber(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull IRI getArgumentAsAnIRI(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAClassPropertyOrNamedIndividual(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAClassPropertyOrNamedIndividual(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull IRI getArgumentAsAClassIRI(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull SWRLClassBuiltInArgument getArgumentAsAClass(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAClass(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAClass(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull SWRLClassExpressionBuiltInArgument getArgumentAsAClassExpression(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAClassExpression(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAClassExpression(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAnOWLNamedIndividual(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsANamedIndividual(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull IRI getArgumentAsANamedIndividualIRI(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull SWRLNamedIndividualBuiltInArgument getArgumentAsANamedIndividual(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull IRI getArgumentAsAPropertyIRI(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAnObjectProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull SWRLObjectPropertyBuiltInArgument getArgumentAsAnObjectProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAnObjectPropertyExpression(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull SWRLObjectPropertyExpressionBuiltInArgument getArgumentAsAnObjectPropertyExpression(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAnObjectProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAnObjectPropertyExpression(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentADataProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentADataPropertyExpression(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull SWRLDataPropertyBuiltInArgument getArgumentAsADataProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull SWRLDataPropertyExpressionBuiltInArgument getArgumentAsADataPropertyExpression(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsADataProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsADataPropertyExpression(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAnAnnotationProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull SWRLAnnotationPropertyBuiltInArgument getArgumentAsAnAnnotationProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAnAnnotationProperty(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentADatatype(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull SWRLDatatypeBuiltInArgument getArgumentAsADatatype(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsADatatype(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatAllArgumentsAreOWLLiterals(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean areAllArgumentLiterals(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkThatArgumentIsALiteral(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentALiteral(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull OWLLiteral getArgumentAsAnOWLLiteral(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull OWLLiteral getArgumentAsAnOWLLiteral(@NonNull SWRLBuiltInArgument var1) throws SWRLBuiltInException;

    public boolean areAllArgumentsBooleans(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkThatArgumentIsABoolean(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentABoolean(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean getArgumentAsABoolean(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatAllArgumentsAreStrings(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isArgumentAString(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull String getArgumentAsAString(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull String getLiteralArgumentAsAString(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull String representArgumentAsAString(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean areAllArgumentsStrings(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkThatArgumentIsAString(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsOfAnOrderedType(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentOfAnOrderedType(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean areAllArgumentsOfAnOrderedType(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isArgumentNumeric(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentNonNumeric(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatAllArgumentsAreOfAnOrderedType(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkThatArgumentIsNumeric(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatAllArgumentsAreNumeric(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean areAllArgumentsNumeric(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkThatArgumentIsNonNumeric(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean areAllArgumentsBytes(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isWidestNumericArgumentAByte(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isArgumentConvertibleToByte(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAByte(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public short getArgumentAsAByte(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAByte(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean areAllArgumentsShorts(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isWidestNumericArgumentAShort(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isArgumentConvertibleToShort(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAShort(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public short getArgumentAsAShort(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAShort(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isWidestNumericArgumentAnInt(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkThatAllArgumentsAreInts(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean areAllArgumentsInts(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isArgumentConvertibleToInt(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAnInt(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAnInt(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public int getArgumentAsAnInt(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public int getArgumentAsAPositiveInt(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isWidestNumericArgumentALong(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean areAllArgumentsLongs(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isArgumentConvertibleToLong(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentALong(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public long getArgumentAsALong(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public long getArgumentAsAPositiveLong(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsALong(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isWidestNumericArgumentAFloat(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public void checkThatAllArgumentsAreFloats(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean areAllArgumentsFloats(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isArgumentConvertibleToFloat(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsAFloat(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAFloat(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public float getArgumentAsAFloat(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public float getArgumentAsAFloat(@NonNull SWRLBuiltInArgument var1) throws SWRLBuiltInException;

    public boolean isWidestNumericArgumentADouble(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean areAllArgumentsDoubles(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isArgumentConvertibleToDouble(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsADouble(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentADouble(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public double getArgumentAsADouble(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public double getArgumentAsADouble(SWRLBuiltInArgument var1) throws SWRLBuiltInException;

    public boolean areAllArgumentsDecimals(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public boolean isWidestNumericArgumentAnInteger(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public @NonNull BigInteger getArgumentAsAPositiveInteger(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean areAllArgumentsIntegers(@NonNull List<@NonNull SWRLBuiltInArgument> var1) throws SWRLBuiltInException;

    public @NonNull BigDecimal getArgumentAsADecimal(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentADecimal(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull BigDecimal getArgumentAsADecimal(SWRLBuiltInArgument var1) throws SWRLBuiltInException;

    public @NonNull BigInteger getArgumentAsAnInteger(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentAnInteger(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull BigInteger getArgumentAsAnInteger(SWRLBuiltInArgument var1) throws SWRLBuiltInException;

    public void checkThatArgumentIsATime(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentATime(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull XSDTime getArgumentAsATime(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsADate(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentADate(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull XSDDate getArgumentAsADate(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsADateTime(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentADateTime(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull XSDDateTime getArgumentAsADateTime(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public void checkThatArgumentIsADuration(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public boolean isArgumentADuration(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull XSDDuration getArgumentAsADuration(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull List<@NonNull SWRLBuiltInArgument> cloneArguments(List<@NonNull SWRLBuiltInArgument> var1);

    public @NonNull Object getArgumentAsAPropertyValue(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull String getVariableName(int var1, @NonNull List<@NonNull SWRLBuiltInArgument> var2) throws SWRLBuiltInException;

    public @NonNull Map<@NonNull Integer, @NonNull OWLObject> getInputArgumentValues(@NonNull List<@NonNull SWRLBuiltInArgument> var1, SWRLBuiltInArgumentType<?> ... var2) throws SWRLBuiltInException;

    public @NonNull String makeInvalidArgumentTypeMessage(@NonNull SWRLBuiltInArgument var1, @NonNull String var2) throws SWRLBuiltInException;
}

