/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.sqwrl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.swrlapi.builtins.AbstractSWRLBuiltInLibrary;
import org.swrlapi.builtins.arguments.SQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.exceptions.InvalidSWRLBuiltInArgumentException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.sqwrl.SQWRLResultGenerator;
import org.swrlapi.sqwrl.values.SQWRLAnnotationPropertyResultValue;
import org.swrlapi.sqwrl.values.SQWRLClassExpressionResultValue;
import org.swrlapi.sqwrl.values.SQWRLClassResultValue;
import org.swrlapi.sqwrl.values.SQWRLDataPropertyResultValue;
import org.swrlapi.sqwrl.values.SQWRLLiteralResultValue;
import org.swrlapi.sqwrl.values.SQWRLNamedIndividualResultValue;
import org.swrlapi.sqwrl.values.SQWRLObjectPropertyResultValue;

public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static final String PREFIX = "sqwrl";
    private static final String NAMESPACE = "http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#";
    private static final String[] BUILT_IN_NAMES = new String[]{"selectDistinct", "select", "count", "columnNames", "orderBy", "orderByDescending", "limit", "min", "max", "avg", "sum", "median", "makeSet", "makeBag", "groupBy", "size", "isEmpty", "notEmpty", "element", "notElement", "intersects", "notIntersects", "equal", "notEqual", "contains", "notContains", "difference", "union", "intersection", "append", "last", "notLast", "lastN", "notLastN", "first", "notFirst", "firstN", "notFirstN", "nth", "notNth", "nthLast", "notNthLast", "nthSlice", "notNthSlice", "nthLastSlice", "notNthLastSlice", "greatest", "notGreatest", "greatestN", "notGreatestN", "least", "notLeast", "leastN", "notLeastN", "nthGreatest", "notNthGreatest", "nthGreatestSlice", "notNthGreatestSlice"};
    private final @NonNull Map<@NonNull String, @NonNull Map<@NonNull String, @NonNull Collection<@NonNull SWRLBuiltInArgument>>> collectionsMap = new HashMap<String, Map<String, Collection<SWRLBuiltInArgument>>>();
    private final @NonNull Map<@NonNull String, @NonNull Integer> collectionGroupElementNumbersMap = new HashMap<String, Integer>();
    private final @NonNull Set<@NonNull String> setKeys = new HashSet<String>();
    private final @NonNull Set<@NonNull String> bagKeys = new HashSet<String>();

    public SWRLBuiltInLibraryImpl() {
        super(PREFIX, NAMESPACE, new HashSet<String>(Arrays.asList(BUILT_IN_NAMES)));
    }

    @Override
    public void reset() {
        this.collectionsMap.clear();
        this.collectionGroupElementNumbersMap.clear();
        this.setKeys.clear();
        this.bagKeys.clear();
    }

    public boolean select(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInConsequent();
        this.checkForUnboundArguments(arguments);
        this.checkNumberOfArgumentsAtLeastOne(arguments);
        SQWRLResultGenerator resultGenerator = this.getSQWRLResultGenerator(this.getInvokingRuleName());
        if (!resultGenerator.isRowOpen()) {
            resultGenerator.openRow();
        }
        int argumentIndex = 0;
        for (SWRLBuiltInArgument argument : arguments) {
            if (argument instanceof SWRLLiteralBuiltInArgument) {
                SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)argument;
                SQWRLLiteralResultValue literal = this.getSQWRLResultValueFactory().getLiteralValue(literalArgument.getLiteral());
                resultGenerator.addCell(literal);
            } else if (argument instanceof SWRLNamedIndividualBuiltInArgument) {
                SWRLNamedIndividualBuiltInArgument individualArgument = (SWRLNamedIndividualBuiltInArgument)argument;
                SQWRLNamedIndividualResultValue individualValue = this.getSQWRLResultValueFactory().getNamedIndividualValue(individualArgument);
                resultGenerator.addCell(individualValue);
            } else if (argument instanceof SWRLClassBuiltInArgument) {
                SWRLClassBuiltInArgument classArgument = (SWRLClassBuiltInArgument)argument;
                SQWRLClassResultValue classValue = this.getSQWRLResultValueFactory().getClassValue(classArgument);
                resultGenerator.addCell(classValue);
            } else if (argument instanceof SWRLObjectPropertyBuiltInArgument) {
                SWRLObjectPropertyBuiltInArgument objectPropertyArgument = (SWRLObjectPropertyBuiltInArgument)argument;
                SQWRLObjectPropertyResultValue objectPropertyValue = this.getSQWRLResultValueFactory().getObjectPropertyValue(objectPropertyArgument);
                resultGenerator.addCell(objectPropertyValue);
            } else if (argument instanceof SWRLDataPropertyBuiltInArgument) {
                SWRLDataPropertyBuiltInArgument dataPropertyArgument = (SWRLDataPropertyBuiltInArgument)argument;
                SQWRLDataPropertyResultValue dataPropertyValue = this.getSQWRLResultValueFactory().getDataPropertyValue(dataPropertyArgument);
                resultGenerator.addCell(dataPropertyValue);
            } else if (argument instanceof SWRLAnnotationPropertyBuiltInArgument) {
                SWRLAnnotationPropertyBuiltInArgument annotationPropertyArgument = (SWRLAnnotationPropertyBuiltInArgument)argument;
                SQWRLAnnotationPropertyResultValue annotationPropertyValue = this.getSQWRLResultValueFactory().getAnnotationPropertyValue(annotationPropertyArgument);
                resultGenerator.addCell(annotationPropertyValue);
            } else if (argument instanceof SWRLClassExpressionBuiltInArgument) {
                SWRLClassExpressionBuiltInArgument classExpressionArgument = (SWRLClassExpressionBuiltInArgument)argument;
                SQWRLClassExpressionResultValue classExpressionValue = this.getSQWRLResultValueFactory().getClassExpressionValue(classExpressionArgument);
                resultGenerator.addCell(classExpressionValue);
            } else {
                if (argument instanceof SQWRLCollectionVariableBuiltInArgument) {
                    throw new InvalidSWRLBuiltInArgumentException(argumentIndex, "collections cannot be selected");
                }
                throw new InvalidSWRLBuiltInArgumentException(argumentIndex, "unknown type " + argument.getClass().getCanonicalName());
            }
            ++argumentIndex;
        }
        return false;
    }

    public boolean selectDistinct(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInConsequent();
        return this.select(arguments);
    }

    public boolean count(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInConsequent();
        this.checkForUnboundArguments(arguments);
        this.checkNumberOfArgumentsEqualTo(1, arguments.size());
        SQWRLResultGenerator resultGenerator = this.getSQWRLResultGenerator(this.getInvokingRuleName());
        SWRLBuiltInArgument argument = arguments.get(0);
        if (!resultGenerator.isRowOpen()) {
            resultGenerator.openRow();
        }
        if (argument instanceof SWRLLiteralBuiltInArgument) {
            SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)argument;
            SQWRLLiteralResultValue literal = this.getSQWRLResultValueFactory().getLiteralValue(literalArgument.getLiteral());
            resultGenerator.addCell(literal);
        } else if (argument instanceof SWRLNamedIndividualBuiltInArgument) {
            SWRLNamedIndividualBuiltInArgument individualArgument = (SWRLNamedIndividualBuiltInArgument)argument;
            SQWRLNamedIndividualResultValue individualValue = this.getSQWRLResultValueFactory().getNamedIndividualValue(individualArgument);
            resultGenerator.addCell(individualValue);
        } else if (argument instanceof SWRLClassBuiltInArgument) {
            SWRLClassBuiltInArgument classArgument = (SWRLClassBuiltInArgument)argument;
            SQWRLClassResultValue classValue = this.getSQWRLResultValueFactory().getClassValue(classArgument);
            resultGenerator.addCell(classValue);
        } else if (argument instanceof SWRLObjectPropertyBuiltInArgument) {
            SWRLObjectPropertyBuiltInArgument objectPropertyArgument = (SWRLObjectPropertyBuiltInArgument)argument;
            SQWRLObjectPropertyResultValue objectPropertyValue = this.getSQWRLResultValueFactory().getObjectPropertyValue(objectPropertyArgument);
            resultGenerator.addCell(objectPropertyValue);
        } else if (argument instanceof SWRLDataPropertyBuiltInArgument) {
            SWRLDataPropertyBuiltInArgument dataPropertyArgument = (SWRLDataPropertyBuiltInArgument)argument;
            SQWRLDataPropertyResultValue dataPropertyValue = this.getSQWRLResultValueFactory().getDataPropertyValue(dataPropertyArgument);
            resultGenerator.addCell(dataPropertyValue);
        } else if (argument instanceof SWRLAnnotationPropertyBuiltInArgument) {
            SWRLAnnotationPropertyBuiltInArgument annotationPropertyArgument = (SWRLAnnotationPropertyBuiltInArgument)argument;
            SQWRLAnnotationPropertyResultValue annotationPropertyValue = this.getSQWRLResultValueFactory().getAnnotationPropertyValue(annotationPropertyArgument);
            resultGenerator.addCell(annotationPropertyValue);
        } else {
            if (argument instanceof SQWRLCollectionVariableBuiltInArgument) {
                throw new InvalidSWRLBuiltInArgumentException(0, "collections cannot be counted");
            }
            throw new InvalidSWRLBuiltInArgumentException(0, "unknown type " + argument.getClass().getCanonicalName());
        }
        return false;
    }

    public boolean countDistinct(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInConsequent();
        return this.count(arguments);
    }

    public boolean columnNames(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInConsequent();
        return true;
    }

    public boolean orderBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInConsequent();
        return true;
    }

    public boolean orderByDescending(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInConsequent();
        return true;
    }

    public boolean limit(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInConsequent();
        return true;
    }

    public boolean makeSet(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        this.checkForUnboundNonFirstArguments(arguments);
        boolean resultCollectionArgumentNumber = false;
        boolean elementArgumentNumber = true;
        String queryName = this.getInvokingRuleName();
        String collectionName = this.getCollectionName(arguments, 0);
        String collectionGroupKey = this.getCollectionGroupKeyInMake(arguments);
        SWRLBuiltInArgument element = arguments.get(1);
        Collection<SWRLBuiltInArgument> set = this.isCollection(queryName, collectionName, collectionGroupKey) ? this.getCollection(queryName, collectionName, collectionGroupKey) : this.createSet(queryName, collectionName, collectionGroupKey);
        set.add(element);
        if (this.isUnboundArgument(0, arguments)) {
            SWRLVariableBuiltInArgument variableArgument = arguments.get(0).asVariable();
            IRI variableIRI = variableArgument.getIRI();
            SQWRLCollectionVariableBuiltInArgument collectionArgument = this.createSQWRLCollectionVariableBuiltInArgument(variableIRI, queryName, collectionName, collectionGroupKey);
            variableArgument.setBuiltInResult(collectionArgument);
        }
        return true;
    }

    public boolean makeBag(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        this.checkForUnboundNonFirstArguments(arguments);
        boolean resultCollectionArgumentNumber = false;
        boolean elementArgumentNumber = true;
        String queryName = this.getInvokingRuleName();
        String collectionName = this.getCollectionName(arguments, 0);
        String collectionGroupKey = this.getCollectionGroupKeyInMake(arguments);
        SWRLBuiltInArgument element = arguments.get(1);
        Collection<SWRLBuiltInArgument> bag = this.isCollection(queryName, collectionName, collectionGroupKey) ? this.getCollection(queryName, collectionName, collectionGroupKey) : this.createBag(queryName, collectionName, collectionGroupKey);
        bag.add(element);
        if (this.isUnboundArgument(0, arguments)) {
            SWRLVariableBuiltInArgument variableArgument = arguments.get(0).asVariable();
            IRI variableIRI = variableArgument.getIRI();
            SQWRLCollectionVariableBuiltInArgument collectionArgument = this.createSQWRLCollectionVariableBuiltInArgument(variableIRI, queryName, collectionName, collectionGroupKey);
            variableArgument.setBuiltInResult(collectionArgument);
        }
        return true;
    }

    public boolean groupBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        return true;
    }

    public boolean isEmpty(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean sourceCollectionArgumentNumber = false;
        boolean numberOfCoreArguments = true;
        Collection<SWRLBuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(arguments, 0, 1);
        return collection.size() == 0;
    }

    public boolean notEmpty(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        return !this.isEmpty(arguments);
    }

    public boolean size(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean resultArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int numberOfCoreArguments = 2;
        Collection<SWRLBuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(arguments, 1, 2);
        return this.processResultArgument(arguments, 0, BigInteger.valueOf(collection.size()));
    }

    public boolean element(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean resultArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int numberOfCoreArguments = 2;
        Collection<SWRLBuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(arguments, 1, 2);
        return this.processResultArgument(arguments, 0, collection);
    }

    public boolean notElement(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        return !this.element(arguments);
    }

    public boolean min(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultArgumentNumber = false;
        boolean numberOfConsequentArguments = true;
        if (this.getIsInConsequent()) {
            SQWRLLiteralResultValue literal;
            this.checkForUnboundArguments(arguments);
            this.checkNumberOfArgumentsEqualTo(1, arguments.size());
            SQWRLResultGenerator resultGenerator = this.getSQWRLResultGenerator(this.getInvokingRuleName());
            SWRLBuiltInArgument argument = arguments.get(0);
            if (!resultGenerator.isRowOpen()) {
                resultGenerator.openRow();
            }
            if (argument instanceof SWRLLiteralBuiltInArgument) {
                SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)argument;
                literal = this.getSQWRLResultValueFactory().getLiteralValue(literalArgument.getLiteral());
                if (!literal.isNumeric()) {
                    throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got " + argument);
                }
            } else {
                throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got " + argument);
            }
            resultGenerator.addCell(literal);
            return true;
        }
        return this.least(arguments);
    }

    public boolean max(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultArgumentNumber = false;
        boolean numberOfConsequentArguments = true;
        if (this.getIsInConsequent()) {
            SQWRLLiteralResultValue literal;
            this.checkForUnboundArguments(arguments);
            this.checkNumberOfArgumentsEqualTo(1, arguments.size());
            SQWRLResultGenerator resultGenerator = this.getSQWRLResultGenerator(this.getInvokingRuleName());
            SWRLBuiltInArgument argument = arguments.get(0);
            if (!resultGenerator.isRowOpen()) {
                resultGenerator.openRow();
            }
            if (argument instanceof SWRLLiteralBuiltInArgument) {
                SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)argument;
                literal = this.getSQWRLResultValueFactory().getLiteralValue(literalArgument.getLiteral());
                if (!literal.isNumeric()) {
                    throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got: " + argument);
                }
            } else {
                throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got: " + argument);
            }
            resultGenerator.addCell(literal);
            return true;
        }
        return this.greatest(arguments);
    }

    public boolean sum(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int numberOfCoreAntecedentArguments = 2;
        boolean numberOfConsequentArguments = true;
        if (this.getIsInConsequent()) {
            SQWRLLiteralResultValue literal;
            this.checkForUnboundArguments(arguments);
            this.checkNumberOfArgumentsEqualTo(1, arguments.size());
            SQWRLResultGenerator resultGenerator = this.getSQWRLResultGenerator(this.getInvokingRuleName());
            SWRLBuiltInArgument argument = arguments.get(0);
            if (!resultGenerator.isRowOpen()) {
                resultGenerator.openRow();
            }
            if (argument instanceof SWRLLiteralBuiltInArgument) {
                SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)argument;
                literal = this.getSQWRLResultValueFactory().getLiteralValue(literalArgument.getLiteral());
                if (!literal.isNumeric()) {
                    throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got " + argument + " with type " + argument.getClass().getCanonicalName());
                }
            } else {
                throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got " + argument + " with type " + argument.getClass().getCanonicalName());
            }
            resultGenerator.addCell(literal);
            return true;
        }
        Collection<SWRLBuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(arguments, 1, 2);
        if (collection.isEmpty()) {
            return false;
        }
        BigDecimal sumValue = BigDecimal.ZERO;
        for (SWRLBuiltInArgument element : collection) {
            this.checkThatElementIsComparable(element);
            BigDecimal value = this.getArgumentAsADecimal(element);
            sumValue = sumValue.add(value);
        }
        SWRLLiteralBuiltInArgument resultArgument = this.createLeastNarrowNumericLiteralBuiltInArgument(sumValue, new ArrayList<SWRLBuiltInArgument>(collection));
        return this.processResultArgument(arguments, 0, (SWRLBuiltInArgument)resultArgument);
    }

    public boolean avg(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int numberOfCoreAntecedentArguments = 2;
        boolean numberOfConsequentArguments = true;
        if (this.getIsInConsequent()) {
            this.checkForUnboundArguments(arguments);
            this.checkNumberOfArgumentsEqualTo(1, arguments.size());
            SQWRLResultGenerator resultGenerator = this.getSQWRLResultGenerator(this.getInvokingRuleName());
            SWRLArgument argument = (SWRLArgument)arguments.get(0);
            if (!resultGenerator.isRowOpen()) {
                resultGenerator.openRow();
            }
            if (argument instanceof SWRLLiteralBuiltInArgument) {
                SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)argument;
                SQWRLLiteralResultValue literal = this.getSQWRLResultValueFactory().getLiteralValue(literalArgument.getLiteral());
                if (!literal.isNumeric()) {
                    throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got " + argument + " with type " + argument.getClass().getCanonicalName());
                }
                resultGenerator.addCell(literal);
                return false;
            }
            throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got " + argument + " with type " + argument.getClass().getCanonicalName());
        }
        Collection<SWRLBuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(arguments, 1, 2);
        if (collection.isEmpty()) {
            return false;
        }
        BigDecimal sumValue = BigDecimal.ZERO;
        for (SWRLBuiltInArgument element : collection) {
            this.checkThatElementIsComparable(element);
            BigDecimal value = this.getArgumentAsADecimal(element);
            sumValue = sumValue.add(value);
        }
        BigDecimal avgValue = sumValue.divide(BigDecimal.valueOf(collection.size()));
        SWRLLiteralBuiltInArgument resultArgument = this.createLeastNarrowNumericLiteralBuiltInArgument(avgValue, new ArrayList<SWRLBuiltInArgument>(collection));
        return this.processResultArgument(arguments, 0, (SWRLBuiltInArgument)resultArgument);
    }

    public boolean median(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int numberOfCoreAntecedentArguments = 2;
        boolean numberOfConsequentArguments = true;
        if (this.getIsInConsequent()) {
            this.checkForUnboundArguments(arguments);
            this.checkNumberOfArgumentsEqualTo(1, arguments.size());
            SQWRLResultGenerator resultGenerator = this.getSQWRLResultGenerator(this.getInvokingRuleName());
            SWRLArgument argument = (SWRLArgument)arguments.get(0);
            if (!resultGenerator.isRowOpen()) {
                resultGenerator.openRow();
            }
            if (argument instanceof SWRLLiteralBuiltInArgument) {
                SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)argument;
                SQWRLLiteralResultValue literal = this.getSQWRLResultValueFactory().getLiteralValue(literalArgument.getLiteral());
                if (!literal.isNumeric()) {
                    throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got " + argument + " with type " + argument.getClass().getCanonicalName());
                }
                resultGenerator.addCell(literal);
                return false;
            }
            throw new InvalidSWRLBuiltInArgumentException(0, "expecting numeric literal, got " + argument + " with type " + argument.getClass().getCanonicalName());
        }
        Collection<SWRLBuiltInArgument> collection = this.getCollectionInSingleCollectionOperation(arguments, 1, 2);
        if (collection.isEmpty()) {
            return false;
        }
        Object[] valueArray = new BigDecimal[collection.size()];
        int count = 0;
        int middle = collection.size() / 2;
        for (SWRLBuiltInArgument element : collection) {
            this.checkThatElementIsComparable(element);
            BigDecimal value = this.getArgumentAsADecimal(element);
            valueArray[count++] = value;
        }
        Arrays.sort(valueArray);
        Object medianValue = collection.size() % 2 == 1 ? valueArray[middle] : ((BigDecimal)valueArray[middle - 1]).add((BigDecimal)valueArray[middle]).divide(BigDecimal.valueOf(2L));
        SWRLLiteralBuiltInArgument resultArgument = this.createLeastNarrowNumericLiteralBuiltInArgument((BigDecimal)medianValue, new ArrayList<SWRLBuiltInArgument>(collection));
        return this.processResultArgument(arguments, 0, (SWRLBuiltInArgument)resultArgument);
    }

    public boolean nth(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 3);
        int n = this.convertArgumentToPositiveInt(2, arguments) - 1;
        if (!sortedList.isEmpty()) {
            if (n >= 0 && n < sortedList.size()) {
                SWRLBuiltInArgument nth = sortedList.get(n);
                return this.processResultArgument(arguments, 0, nth);
            }
            return false;
        }
        return false;
    }

    public boolean greatest(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int numberOfCoreArguments = 2;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 2);
        if (!sortedList.isEmpty()) {
            SWRLBuiltInArgument greatest = sortedList.get(sortedList.size() - 1);
            return this.processResultArgument(arguments, 0, greatest);
        }
        return false;
    }

    public boolean nthGreatest(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 3);
        int n = this.convertArgumentToPositiveInt(2, arguments);
        if (!sortedList.isEmpty() && n > 0 && n <= sortedList.size()) {
            SWRLBuiltInArgument nthGreatest = sortedList.get(sortedList.size() - n);
            return this.processResultArgument(arguments, 0, nthGreatest);
        }
        return false;
    }

    public boolean least(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean resultArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int numberOfCoreArguments = 2;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 2);
        if (!sortedList.isEmpty()) {
            SWRLBuiltInArgument least = sortedList.get(0);
            return this.processResultArgument(arguments, 0, least);
        }
        return false;
    }

    public boolean notNthGreatest(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 3);
        int n = this.convertArgumentToPositiveInt(2, arguments);
        if (!sortedList.isEmpty() && n > 0 && n <= sortedList.size()) {
            sortedList.remove(sortedList.size() - n);
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 3, sortedList);
    }

    public boolean nthSlice(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int sliceSizeArgumentNumber = 3;
        int numberOfCoreArguments = 4;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 4);
        int n = this.convertArgumentToPositiveInt(2, arguments) - 1;
        int sliceSize = this.convertArgumentToPositiveInt(3, arguments);
        ArrayList<@NonNull SWRLBuiltInArgument> slice = new ArrayList<SWRLBuiltInArgument>();
        if (!sortedList.isEmpty() && n >= 0) {
            int startIndex = n;
            int finishIndex = n + sliceSize - 1;
            for (int index = startIndex; index <= finishIndex && index < sortedList.size(); ++index) {
                slice.add(sortedList.get(index));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 4, slice);
    }

    public boolean notNthSlice(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int sliceSizeArgumentNumber = 3;
        int numberOfCoreArguments = 4;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 4);
        int n = this.convertArgumentToPositiveInt(2, arguments) - 1;
        int sliceSize = this.convertArgumentToPositiveInt(3, arguments);
        ArrayList<@NonNull SWRLBuiltInArgument> notSlice = new ArrayList<SWRLBuiltInArgument>();
        if (!sortedList.isEmpty() && n >= 0 && n < sortedList.size()) {
            int startIndex = n;
            int finishIndex = n + sliceSize - 1;
            for (int index = 0; index < sortedList.size(); ++index) {
                if (index >= startIndex && index <= finishIndex) continue;
                notSlice.add(sortedList.get(index));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 4, notSlice);
    }

    public boolean nthGreatestSlice(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int sliceSizeArgumentNumber = 3;
        int numberOfCoreArguments = 4;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 4);
        int n = this.convertArgumentToPositiveInt(2, arguments);
        ArrayList<@NonNull SWRLBuiltInArgument> slice = new ArrayList<SWRLBuiltInArgument>();
        int sliceSize = this.convertArgumentToPositiveInt(3, arguments);
        if (!sortedList.isEmpty() && n > 0) {
            int startIndex = sortedList.size() - n;
            int finishIndex = startIndex + sliceSize - 1;
            if (startIndex < 0) {
                startIndex = 0;
            }
            for (int index = startIndex; index <= finishIndex && index < sortedList.size(); ++index) {
                slice.add(sortedList.get(index));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 4, slice);
    }

    public boolean notNthGreatestSlice(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int sliceSizeArgumentNumber = 3;
        int numberOfCoreArguments = 4;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 4);
        int n = this.convertArgumentToPositiveInt(2, arguments);
        int sliceSize = this.convertArgumentToPositiveInt(3, arguments);
        ArrayList<@NonNull SWRLBuiltInArgument> slice = new ArrayList<SWRLBuiltInArgument>();
        if (!sortedList.isEmpty() && n > 0 && n <= sortedList.size()) {
            int startIndex = sortedList.size() - n;
            int finishIndex = startIndex + sliceSize - 1;
            for (int index = 0; index < sortedList.size(); ++index) {
                if (index >= startIndex && index <= finishIndex) continue;
                slice.add(sortedList.get(index));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 4, slice);
    }

    public boolean notNth(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 3);
        int n = this.convertArgumentToPositiveInt(2, arguments) - 1;
        if (!sortedList.isEmpty() && n >= 0 && n < sortedList.size()) {
            sortedList.remove(n);
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 3, sortedList);
    }

    public boolean notGreatest(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int numberOfCoreArguments = 2;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 2);
        if (!sortedList.isEmpty()) {
            sortedList.remove(sortedList.size() - 1);
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 2, sortedList);
    }

    public boolean greatestN(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 3);
        int n = this.convertArgumentToPositiveInt(2, arguments);
        ArrayList<@NonNull SWRLBuiltInArgument> greatestN = new ArrayList<SWRLBuiltInArgument>();
        if (!sortedList.isEmpty() && n > 0) {
            int startIndex = sortedList.size() - n;
            if (startIndex < 0) {
                startIndex = 0;
            }
            for (int i = startIndex; i < sortedList.size(); ++i) {
                greatestN.add(sortedList.get(i));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 3, greatestN);
    }

    public boolean notGreatestN(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 3);
        int n = this.convertArgumentToPositiveInt(2, arguments);
        ArrayList<@NonNull SWRLBuiltInArgument> notGreatestN = new ArrayList<SWRLBuiltInArgument>();
        if (!sortedList.isEmpty() && n > 0) {
            int startIndex = sortedList.size() - n;
            if (startIndex < 0) {
                startIndex = 0;
            }
            for (int i = 0; i < startIndex; ++i) {
                notGreatestN.add(sortedList.get(i));
            }
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 3, notGreatestN);
    }

    public boolean notLeast(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int numberOfCoreArguments = 2;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 2);
        if (!sortedList.isEmpty()) {
            sortedList.remove(0);
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 2, sortedList);
    }

    public boolean leastN(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 3);
        int n = this.convertArgumentToPositiveInt(2, arguments) - 1;
        ArrayList<@NonNull SWRLBuiltInArgument> leastN = new ArrayList<SWRLBuiltInArgument>();
        for (int i = 0; i <= n && i < sortedList.size(); ++i) {
            leastN.add(sortedList.get(i));
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 3, leastN);
    }

    public boolean notLeastN(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean resultCollectionArgumentNumber = false;
        boolean sourceCollectionArgumentNumber = true;
        int nArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        if (this.getIsInConsequent()) {
            return true;
        }
        List<@NonNull SWRLBuiltInArgument> sortedList = this.getSortedListInSingleOperandCollectionOperation(arguments, 1, 3);
        int n = this.convertArgumentToPositiveInt(2, arguments);
        ArrayList<@NonNull SWRLBuiltInArgument> notLeastN = new ArrayList<SWRLBuiltInArgument>();
        for (int i = n; i >= 0 && i < sortedList.size(); ++i) {
            notLeastN.add(sortedList.get(i));
        }
        return this.processSingleOperandCollectionOperationListResult(arguments, 0, 1, 3, notLeastN);
    }

    public boolean intersects(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean collection1ArgumentNumber = false;
        boolean collection2ArgumentNumber = true;
        int numberOfCoreArguments = 2;
        String queryName = this.getInvokingRuleName();
        String collection1Name = this.getCollectionName(arguments, 0);
        String collection2Name = this.getCollectionName(arguments, 1);
        int collection1NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection1Name);
        int collection2NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection2Name);
        String collection1GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 0, 2, 0, collection1NumberOfGroupElements);
        String collection2GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 1, 2, collection1NumberOfGroupElements, collection2NumberOfGroupElements);
        Collection<SWRLBuiltInArgument> collection1 = this.getCollection(queryName, collection1Name, collection1GroupKey);
        Collection<SWRLBuiltInArgument> collection2 = this.getCollection(queryName, collection2Name, collection2GroupKey);
        return !Collections.disjoint(collection1, collection2);
    }

    public boolean notIntersects(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        return !this.intersects(arguments);
    }

    public boolean contains(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean collection1ArgumentNumber = false;
        boolean collection2ArgumentNumber = true;
        int numberOfCoreArguments = 2;
        String queryName = this.getInvokingRuleName();
        String collection1Name = this.getCollectionName(arguments, 0);
        String collection2Name = this.getCollectionName(arguments, 1);
        int collection1NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection1Name);
        int collection2NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection2Name);
        String collection1GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 0, 2, 0, collection1NumberOfGroupElements);
        String collection2GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 1, 2, collection1NumberOfGroupElements, collection2NumberOfGroupElements);
        Collection<SWRLBuiltInArgument> collection1 = this.getCollection(queryName, collection1Name, collection1GroupKey);
        Collection<SWRLBuiltInArgument> collection2 = this.getCollection(queryName, collection2Name, collection2GroupKey);
        return collection1.containsAll(collection2);
    }

    public boolean notContains(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        return !this.contains(arguments);
    }

    public boolean equal(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean collection1ArgumentNumber = false;
        boolean collection2ArgumentNumber = true;
        int numberOfCoreArguments = 2;
        String queryName = this.getInvokingRuleName();
        String collection1Name = this.getCollectionName(arguments, 0);
        String collection2Name = this.getCollectionName(arguments, 1);
        int collection1NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection1Name);
        int collection2NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection2Name);
        String collection1GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 0, 2, 0, collection1NumberOfGroupElements);
        String collection2GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 1, 2, collection1NumberOfGroupElements, collection2NumberOfGroupElements);
        if (collection1GroupKey.equals(collection2GroupKey)) {
            return true;
        }
        Collection<SWRLBuiltInArgument> collection1 = this.getCollection(queryName, collection1Name, collection1GroupKey);
        Collection<SWRLBuiltInArgument> collection2 = this.getCollection(queryName, collection2Name, collection2GroupKey);
        return collection1.equals(collection2);
    }

    public boolean notEqual(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        return !this.equal(arguments);
    }

    public boolean intersection(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean resultCollectionArgumentNumber = false;
        boolean collection1ArgumentNumber = true;
        int collection2ArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        String queryName = this.getInvokingRuleName();
        String resultCollectionName = this.getCollectionName(arguments, 0);
        String collection1Name = this.getCollectionName(arguments, 1);
        String collection2Name = this.getCollectionName(arguments, 2);
        int collection1NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection1Name);
        int collection2NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection2Name);
        int collectionResultNumberOfGroupElements = collection1NumberOfGroupElements + collection2NumberOfGroupElements;
        String resultCollectionGroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 0, 3, 0, collectionResultNumberOfGroupElements);
        String collection1GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 1, 3, 0, collection1NumberOfGroupElements);
        String collection2GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 2, 3, collection1NumberOfGroupElements, collection2NumberOfGroupElements);
        Collection<SWRLBuiltInArgument> collection1 = this.getCollection(queryName, collection1Name, collection1GroupKey);
        Collection<SWRLBuiltInArgument> collection2 = this.getCollection(queryName, collection2Name, collection2GroupKey);
        HashSet<SWRLBuiltInArgument> intersection = new HashSet<SWRLBuiltInArgument>(collection1);
        intersection.retainAll(collection2);
        if (!this.isCollection(queryName, resultCollectionName, resultCollectionGroupKey)) {
            this.recordCollection(queryName, resultCollectionName, resultCollectionGroupKey, intersection);
        }
        if (this.isUnboundArgument(0, arguments)) {
            SWRLVariableBuiltInArgument variableArgument = arguments.get(0).asVariable();
            IRI variableIRI = variableArgument.getIRI();
            SQWRLCollectionVariableBuiltInArgument collectionArgument = this.createSQWRLCollectionVariableBuiltInArgument(variableIRI, queryName, resultCollectionName, resultCollectionGroupKey);
            variableArgument.setBuiltInResult(collectionArgument);
        }
        return true;
    }

    public boolean append(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean resultCollectionArgumentNumber = false;
        boolean collection1ArgumentNumber = true;
        int collection2ArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        String queryName = this.getInvokingRuleName();
        String resultCollectionName = this.getCollectionName(arguments, 0);
        String collection1Name = this.getCollectionName(arguments, 1);
        String collection2Name = this.getCollectionName(arguments, 2);
        int collection1NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection1Name);
        int collection2NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection2Name);
        int resultCollectionNumberOfGroupElements = collection1NumberOfGroupElements + collection2NumberOfGroupElements;
        String collection1GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 1, 3, 0, collection1NumberOfGroupElements);
        String collection2GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 2, 3, collection1NumberOfGroupElements, collection2NumberOfGroupElements);
        String resultCollectionGroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 0, 3, 0, resultCollectionNumberOfGroupElements);
        Collection<SWRLBuiltInArgument> collection1 = this.getCollection(queryName, collection1Name, collection1GroupKey);
        Collection<SWRLBuiltInArgument> collection2 = this.getCollection(queryName, collection2Name, collection2GroupKey);
        ArrayList<@NonNull SWRLBuiltInArgument> resultCollection = new ArrayList<SWRLBuiltInArgument>(collection1);
        resultCollection.addAll(collection2);
        if (!this.isCollectionRecorded(resultCollectionName, resultCollectionGroupKey)) {
            this.recordCollection(queryName, resultCollectionName, resultCollectionGroupKey, resultCollection);
        }
        if (this.isUnboundArgument(0, arguments)) {
            SWRLVariableBuiltInArgument variableArgument = arguments.get(0).asVariable();
            IRI variableIRI = variableArgument.getIRI();
            SQWRLCollectionVariableBuiltInArgument collectionArgument = this.createSQWRLCollectionVariableBuiltInArgument(variableIRI, queryName, resultCollectionName, resultCollectionGroupKey);
            variableArgument.setBuiltInResult(collectionArgument);
        }
        return true;
    }

    public boolean union(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean resultCollectionArgumentNumber = false;
        boolean collection1ArgumentNumber = true;
        int collection2ArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        String queryName = this.getInvokingRuleName();
        String resultCollectionName = this.getCollectionName(arguments, 0);
        String collection1Name = this.getCollectionName(arguments, 1);
        String collection2Name = this.getCollectionName(arguments, 2);
        int collection1NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection1Name);
        int collection2NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection2Name);
        int resultCollectionNumberOfGroupElements = collection1NumberOfGroupElements + collection2NumberOfGroupElements;
        String collection1GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 1, 3, 0, collection1NumberOfGroupElements);
        String collection2GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 2, 3, collection1NumberOfGroupElements, collection2NumberOfGroupElements);
        String resultCollectionGroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 0, 3, 0, resultCollectionNumberOfGroupElements);
        Collection<SWRLBuiltInArgument> collection1 = this.getCollection(queryName, collection1Name, collection1GroupKey);
        Collection<SWRLBuiltInArgument> collection2 = this.getCollection(queryName, collection2Name, collection2GroupKey);
        HashSet<@NonNull SWRLBuiltInArgument> union = new HashSet<SWRLBuiltInArgument>(collection1);
        union.addAll(collection2);
        if (!this.isCollection(queryName, resultCollectionName, resultCollectionGroupKey)) {
            this.recordCollection(queryName, resultCollectionName, resultCollectionGroupKey, union);
        }
        if (this.isUnboundArgument(0, arguments)) {
            SWRLVariableBuiltInArgument variableArgument = arguments.get(0).asVariable();
            IRI variableIRI = variableArgument.getIRI();
            SQWRLCollectionVariableBuiltInArgument collectionArgument = this.createSQWRLCollectionVariableBuiltInArgument(variableIRI, queryName, resultCollectionName, resultCollectionGroupKey);
            variableArgument.setBuiltInResult(collectionArgument);
        }
        return true;
    }

    public boolean difference(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkThatInAntecedent();
        boolean resultCollectionArgumentNumber = false;
        boolean collection1ArgumentNumber = true;
        int collection2ArgumentNumber = 2;
        int numberOfCoreArguments = 3;
        String queryName = this.getInvokingRuleName();
        String resultCollectionName = this.getCollectionName(arguments, 0);
        String collection1Name = this.getCollectionName(arguments, 1);
        String collection2Name = this.getCollectionName(arguments, 2);
        int collection1NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection1Name);
        int collection2NumberOfGroupElements = this.getNumberOfGroupElements(queryName, collection2Name);
        int collectionResultNumberOfGroupElements = collection1NumberOfGroupElements + collection2NumberOfGroupElements;
        String resultCollectionGroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 0, 3, 0, collectionResultNumberOfGroupElements);
        String collection1GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 1, 3, 0, collection1NumberOfGroupElements);
        String collection2GroupKey = this.getCollectionGroupKeyInMultiOperandCollectionOperation(arguments, 2, 3, collection1NumberOfGroupElements, collection2NumberOfGroupElements);
        Collection<SWRLBuiltInArgument> collection1 = this.getCollection(queryName, collection1Name, collection1GroupKey);
        Collection<SWRLBuiltInArgument> collection2 = this.getCollection(queryName, collection2Name, collection2GroupKey);
        HashSet<SWRLBuiltInArgument> difference = new HashSet<SWRLBuiltInArgument>(collection1);
        difference.removeAll(collection2);
        if (!this.isCollection(queryName, resultCollectionName, resultCollectionGroupKey)) {
            this.recordCollection(queryName, resultCollectionName, resultCollectionGroupKey, difference);
        }
        if (this.isUnboundArgument(0, arguments)) {
            SWRLVariableBuiltInArgument variableArgument = arguments.get(0).asVariable();
            IRI variableIRI = variableArgument.getIRI();
            SQWRLCollectionVariableBuiltInArgument collectionArgument = this.createSQWRLCollectionVariableBuiltInArgument(variableIRI, queryName, resultCollectionName, resultCollectionGroupKey);
            variableArgument.setBuiltInResult(collectionArgument);
        }
        return true;
    }

    public boolean nthLast(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.nthGreatest(arguments);
    }

    public boolean notNthLast(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.notNthGreatest(arguments);
    }

    public boolean nthLastSlice(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.nthGreatestSlice(arguments);
    }

    public boolean notNthLastSlice(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.notNthGreatestSlice(arguments);
    }

    public boolean last(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.greatest(arguments);
    }

    public boolean notLast(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.notGreatest(arguments);
    }

    public boolean lastN(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.greatestN(arguments);
    }

    public boolean notLastN(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.notGreatestN(arguments);
    }

    public boolean first(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.least(arguments);
    }

    public boolean notFirst(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.notLeast(arguments);
    }

    public boolean firstN(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.leastN(arguments);
    }

    public boolean notFirstN(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.notLeastN(arguments);
    }

    private @NonNull String getCollectionGroupKeyInMake(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        String groupPattern;
        boolean collectionArgumentNumber = false;
        int numberOfCoreArguments = 2;
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        String queryName = this.getInvokingRuleName();
        String collectionName = this.getCollectionName(arguments, 0);
        String collectionKey = this.createCollectionKey(queryName, collectionName);
        int numberOfGroupArguments = arguments.size() - 2;
        boolean hasGroupPattern = numberOfGroupArguments != 0;
        String string = groupPattern = !hasGroupPattern ? "" : this.createInvocationPattern(this.getBuiltInBridge(), queryName, 0, false, arguments.subList(2, arguments.size()));
        if (this.isBoundArgument(0, arguments) && !this.collectionGroupElementNumbersMap.containsKey(collectionKey)) {
            throw new SWRLBuiltInException("collection variable ?" + arguments.get(0).asVariable().getVariableName() + " already used in non collection context in query " + queryName);
        }
        if (hasGroupPattern) {
            if (!this.collectionGroupElementNumbersMap.containsKey(collectionKey)) {
                this.collectionGroupElementNumbersMap.put(collectionKey, numberOfGroupArguments);
            } else if (this.collectionGroupElementNumbersMap.get(collectionKey) != numberOfGroupArguments) {
                throw new SWRLBuiltInException("internal error: inconsistent number of group elements for collection " + collectionName + " in query " + queryName);
            }
            return groupPattern;
        }
        if (this.collectionGroupElementNumbersMap.containsKey(collectionKey)) {
            if (this.collectionGroupElementNumbersMap.get(collectionKey) != 0) {
                throw new SWRLBuiltInException("internal error: inconsistent number of group elements for collection " + collectionName + " in query " + queryName);
            }
        } else {
            this.collectionGroupElementNumbersMap.put(collectionKey, 0);
        }
        return "";
    }

    private String getCollectionGroupKeyInSingleCollectionOperation(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int coreNumberOfArguments) throws SWRLBuiltInException {
        String queryName = this.getInvokingRuleName();
        this.checkThatInAntecedent();
        if (arguments.size() > coreNumberOfArguments) {
            return this.createInvocationPattern(this.getBuiltInBridge(), queryName, 0, false, arguments.subList(coreNumberOfArguments, arguments.size()));
        }
        return "";
    }

    private String getCollectionGroupKeyInMultiOperandCollectionOperation(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int collectionArgumentNumber, int coreNumberOfArguments, int groupArgumentOffset, int numberOfRelevantGroupArguments) throws SWRLBuiltInException {
        String queryName = this.getInvokingRuleName();
        String collectionName = this.getCollectionName(arguments, collectionArgumentNumber);
        String collectionKey = this.createCollectionKey(queryName, collectionName);
        this.checkThatInAntecedent();
        if (!this.collectionGroupElementNumbersMap.containsKey(collectionKey)) {
            this.collectionGroupElementNumbersMap.put(collectionKey, numberOfRelevantGroupArguments);
        }
        if (numberOfRelevantGroupArguments != 0) {
            return this.createInvocationPattern(this.getBuiltInBridge(), queryName, 0, false, arguments.subList(coreNumberOfArguments + groupArgumentOffset, coreNumberOfArguments + groupArgumentOffset + numberOfRelevantGroupArguments));
        }
        return "";
    }

    private boolean processSingleOperandCollectionOperationListResult(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultCollectionArgumentNumber, int sourceCollectionArgumentNumber, int numberOfCoreArguments, Collection<SWRLBuiltInArgument> resultList) throws SWRLBuiltInException {
        String queryName = this.getInvokingRuleName();
        String sourceCollectionName = this.getCollectionName(arguments, sourceCollectionArgumentNumber);
        String resultCollectionName = this.getCollectionName(arguments, resultCollectionArgumentNumber);
        String resultCollectionGroupKey = this.getCollectionGroupKeyInSingleCollectionOperation(arguments, numberOfCoreArguments);
        String resultCollectionKey = this.createCollectionKey(queryName, resultCollectionName);
        if (!this.isCollection(queryName, resultCollectionName, resultCollectionGroupKey)) {
            this.recordCollection(queryName, resultCollectionName, resultCollectionGroupKey, resultList);
        }
        if (!this.collectionGroupElementNumbersMap.containsKey(resultCollectionKey)) {
            this.collectionGroupElementNumbersMap.put(resultCollectionKey, this.getNumberOfGroupElements(queryName, sourceCollectionName));
        }
        return this.processListResultArgument(arguments, resultCollectionArgumentNumber, resultCollectionName, resultCollectionGroupKey, resultList);
    }

    private boolean processListResultArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int resultArgumentNumber, @NonNull String resultListName, @NonNull String resultListID, @NonNull Collection<SWRLBuiltInArgument> resultList) throws SWRLBuiltInException {
        this.checkArgumentNumber(resultArgumentNumber, arguments);
        String queryName = this.getInvokingRuleName();
        if (this.isUnboundArgument(resultArgumentNumber, arguments)) {
            SWRLVariableBuiltInArgument variableArgument = arguments.get(resultArgumentNumber).asVariable();
            IRI variableIRI = variableArgument.getIRI();
            SQWRLCollectionVariableBuiltInArgument collectionArgument = this.createSQWRLCollectionVariableBuiltInArgument(variableIRI, queryName, resultListName, resultListID);
            variableArgument.setBuiltInResult(collectionArgument);
            return true;
        }
        Collection<SWRLBuiltInArgument> collection = this.getCollection(queryName, resultListName, resultListID);
        return collection.equals(resultList);
    }

    private SQWRLResultGenerator getSQWRLResultGenerator(@NonNull String queryName) throws SWRLBuiltInException {
        return this.getBuiltInBridge().getSQWRLResultGenerator(queryName);
    }

    private void checkThatElementIsComparable(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        if (argument instanceof SWRLLiteralBuiltInArgument) {
            SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)argument;
            SQWRLLiteralResultValue literal = this.getSQWRLResultValueFactory().getLiteralValue(literalArgument.getLiteral());
            if (!literal.isComparable()) {
                throw new SWRLBuiltInException("may only be applied to collections with comparable elements");
            }
        } else {
            throw new SWRLBuiltInException("may only be applied to collections with comparable elements");
        }
    }

    private Collection<SWRLBuiltInArgument> getCollectionInSingleCollectionOperation(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int sourceCollectionArgumentNumber, int coreNumberOfArguments) throws SWRLBuiltInException {
        String queryName = this.getInvokingRuleName();
        String collectionName = this.getCollectionName(arguments, sourceCollectionArgumentNumber);
        String collectionGroupKey = this.getCollectionGroupKeyInSingleCollectionOperation(arguments, coreNumberOfArguments);
        return this.getCollection(queryName, collectionName, collectionGroupKey);
    }

    private @NonNull List<@NonNull SWRLBuiltInArgument> getSortedListInSingleOperandCollectionOperation(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int sourceCollectionArgumentNumber, int coreNumberOfArguments) throws SWRLBuiltInException {
        String queryName = this.getInvokingRuleName();
        String collectionName = this.getCollectionName(arguments, sourceCollectionArgumentNumber);
        String collectionGroupKey = this.getCollectionGroupKeyInSingleCollectionOperation(arguments, coreNumberOfArguments);
        return this.getSortedList(queryName, collectionName, collectionGroupKey);
    }

    private @NonNull List<@NonNull SWRLBuiltInArgument> getSortedList(@NonNull String queryName, @NonNull String collectionName, @NonNull String collectionGroupKey) throws SWRLBuiltInException {
        Collection<SWRLBuiltInArgument> collection = this.getCollection(queryName, collectionName, collectionGroupKey);
        ArrayList<@NonNull SWRLBuiltInArgument> result = new ArrayList<SWRLBuiltInArgument>(collection);
        Collections.sort(result);
        return result;
    }

    private @NonNull List<@NonNull SWRLBuiltInArgument> createBag(@NonNull String queryName, @NonNull String collectionName, @NonNull String collectionGroupKey) throws SWRLBuiltInException {
        ArrayList<@NonNull SWRLBuiltInArgument> bag = new ArrayList<SWRLBuiltInArgument>();
        this.recordCollection(queryName, collectionName, collectionGroupKey, bag);
        return bag;
    }

    private @NonNull Set<@NonNull SWRLBuiltInArgument> createSet(@NonNull String queryName, @NonNull String collectionName, @NonNull String collectionGroupKey) throws SWRLBuiltInException {
        HashSet<@NonNull SWRLBuiltInArgument> set = new HashSet<SWRLBuiltInArgument>();
        this.recordCollection(queryName, collectionName, collectionGroupKey, set);
        return set;
    }

    private @NonNull String getCollectionName(@NonNull List<@NonNull SWRLBuiltInArgument> arguments, int collectionArgumentNumber) throws SWRLBuiltInException {
        return this.getVariableName(collectionArgumentNumber, arguments);
    }

    private int getNumberOfGroupElements(@NonNull String queryName, @NonNull String collectionName) throws SWRLBuiltInException {
        String collectionKey = this.createCollectionKey(queryName, collectionName);
        if (!this.collectionGroupElementNumbersMap.containsKey(collectionKey)) {
            throw new SWRLBuiltInException("internal error: invalid collection name " + collectionName + " in query " + queryName + "; no group element number found");
        }
        return this.collectionGroupElementNumbersMap.get(collectionKey);
    }

    private void recordCollection(@NonNull String queryName, @NonNull String collectionName, @NonNull String collectionGroupKey, @NonNull Collection<SWRLBuiltInArgument> collection) throws SWRLBuiltInException {
        String collectionKey = this.createCollectionKey(queryName, collectionName);
        if (!this.isCollectionRecorded(queryName, collectionName)) {
            if (this.isBag(collection)) {
                this.bagKeys.add(collectionKey);
            } else if (this.isSet(collection)) {
                this.setKeys.add(collectionKey);
            } else {
                throw new SWRLBuiltInException("internal error: collection " + collectionName + " in query " + queryName + " with group key " + collectionGroupKey + " is neither a bag or a set");
            }
            this.collectionsMap.put(collectionKey, new HashMap());
        }
        if (!this.isCollection(queryName, collectionName, collectionGroupKey)) {
            if (this.isBag(queryName, collectionName) && !this.isBag(collection)) {
                throw new SWRLBuiltInException("attempt to add non bag elements to bag " + collectionName + " in query " + queryName + "; group key=" + collectionGroupKey);
            }
            if (this.isSet(queryName, collectionName) && !this.isSet(collection)) {
                throw new SWRLBuiltInException("attempt to add non set elements to set " + collectionName + " in query " + queryName + "; group key=" + collectionGroupKey);
            }
            if (this.collectionsMap.containsKey(collectionKey)) {
                this.collectionsMap.get(collectionKey).put(collectionGroupKey, collection);
            } else {
                throw new SWRLBuiltInException("internal error attempting to add non set elements to set " + collectionName + " in query " + queryName + "; group key=" + collectionGroupKey);
            }
        }
    }

    private @NonNull Collection<@NonNull SWRLBuiltInArgument> getCollection(@NonNull String queryName, @NonNull String collectionName, @NonNull String collectionGroupKey) throws SWRLBuiltInException {
        String collectionKey = queryName + ":" + collectionName;
        if (!this.isCollection(queryName, collectionName, collectionGroupKey)) {
            throw new SWRLBuiltInException("collection argument in query " + queryName + " with name " + collectionName + " and group key " + collectionGroupKey + " does not refer to a collection");
        }
        if (this.collectionsMap.get(collectionKey) != null && this.collectionsMap.get(collectionKey).get(collectionGroupKey) != null) {
            return this.collectionsMap.get(collectionKey).get(collectionGroupKey);
        }
        throw new SWRLBuiltInException("internal error processing collection argument in query " + queryName + " with name " + collectionName + " and group key " + collectionGroupKey);
    }

    private boolean isCollection(@NonNull String queryName, @NonNull String collectionName, @NonNull String collectionGroupKey) {
        String collectionKey = this.createCollectionKey(queryName, collectionName);
        return this.collectionsMap.get(collectionKey) != null && this.collectionsMap.get(collectionKey).containsKey(collectionGroupKey);
    }

    private boolean isSet(@NonNull String queryName, @NonNull String collectionName) {
        String setKey = this.createCollectionKey(queryName, collectionName);
        return this.setKeys.contains(setKey);
    }

    private boolean isBag(@NonNull String queryName, @NonNull String collectionName) {
        String bagKey = this.createCollectionKey(queryName, collectionName);
        return this.bagKeys.contains(bagKey);
    }

    private boolean isCollectionRecorded(@NonNull String queryName, @NonNull String collectionName) {
        String collectionKey = this.createCollectionKey(queryName, collectionName);
        return this.collectionsMap.containsKey(collectionKey);
    }

    private boolean isBag(Collection<@NonNull SWRLBuiltInArgument> collection) {
        return collection instanceof List;
    }

    private boolean isSet(Collection<@NonNull SWRLBuiltInArgument> collection) {
        return collection instanceof Set;
    }

    private @NonNull String createCollectionKey(@NonNull String queryName, @NonNull String collectionName) {
        return queryName + ":" + collectionName;
    }

    private @NonNull Collection<@NonNull SWRLBuiltInArgument> ungroupCollection(@NonNull String queryName, @NonNull String collectionName) throws SWRLBuiltInException {
        if (!this.isCollectionRecorded(queryName, collectionName)) {
            throw new SWRLBuiltInException(collectionName + " in query " + queryName + " is not a collection");
        }
        HashSet<@NonNull SWRLBuiltInArgument> ungroupedCollection = this.isSet(queryName, collectionName) ? new HashSet() : new ArrayList();
        String collectionKey = this.createCollectionKey(queryName, collectionName);
        if (this.collectionsMap.get(collectionKey) != null) {
            for (String collectionGroupKey : this.collectionsMap.get(collectionKey).keySet()) {
                if (this.collectionsMap.get(collectionKey).get(collectionGroupKey) == null) continue;
                ungroupedCollection.addAll(this.collectionsMap.get(collectionKey).get(collectionGroupKey));
            }
        }
        return ungroupedCollection;
    }

    private int convertArgumentToPositiveInt(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        BigInteger integerValue = this.getArgumentAsAnInteger(argumentNumber, arguments);
        if (integerValue.compareTo(BigInteger.ZERO) < 0) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "expecting positive xsd:integer"));
        }
        if (integerValue.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "value converted to xsd:int cannot be larger than 2147483647"));
        }
        return integerValue.intValue();
    }
}

