/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.swrlb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.axis.types.Duration;
import org.apache.axis.types.Time;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.swrlapi.builtins.AbstractSWRLBuiltInLibrary;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.exceptions.InvalidSWRLBuiltInArgumentException;
import org.swrlapi.exceptions.InvalidSWRLBuiltInNameException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLBuiltInNotImplementedException;
import org.swrlapi.literal.OWLLiteralComparator;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;
import org.swrlapi.literal.XSDTimeUtil;

public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static final String PREFIX = "swrlb";
    private static final String NAMESPACE = "http://www.w3.org/2003/11/swrlb#";
    private static final String[] BUILT_IN_NAMES = new String[]{"equal", "notEqual", "lessThan", "lessThanOrEqual", "greaterThan", "greaterThanOrEqual", "add", "subtract", "multiply", "divide", "integerDivide", "mod", "pow", "unaryPlus", "unaryMinus", "abs", "ceiling", "floor", "round", "roundHalfToEven", "sin", "cos", "tan", "booleanNot", "stringEqualIgnoreCase", "stringConcat", "substring", "stringLength", "normalizeSpace", "upperCase", "lowerCase", "translate", "contains", "containsIgnoreCase", "startsWith", "endsWith", "substringBefore", "substringAfter", "matches", "replace", "tokenize", "yearMonthDuration", "dayTimeDuration", "dateTime", "date", "time", "addYearMonthDurations", "subtractYearMonthDurations", "multiplyYearMonthDuration", "divideYearMonthDuration", "addDayTimeDurations", "subtractDayTimeDurations", "multiplyDayTimeDuration", "divideDayTimeDuration", "subtractDates", "subtractTimes", "addYearMonthDurationToDateTime", "addDayTimeDurationToDateTime", "subtractYearMonthDurationFromDateTime", "subtractDayTimeDurationFromDateTime", "addYearMonthDurationToDate", "addDayTimeDurationToDate", "subtractYearMonthDurationFromDate", "subtractDayTimeDurationFromDate", "addDayTimeDurationToTime", "subtractDayTimeDurationFromTime", "subtractDateTimesYieldingYearMonthDuration", "subtractDateTimesYieldingYearMonthDuration", "resolveURI", "anyURU", "listConcat", "listIntersection", "listSubtraction", "member", "length", "first", "rest", "sublist", "empty"};
    private static final String SWRLBPrefix = "swrlb:";
    private static final String SWRLB_ADD = "swrlb:add";
    private static final String SWRLB_SUBTRACT = "swrlb:subtract";
    private static final String SWRLB_MULTIPLY = "swrlb:multiply";
    private static final String SWRLB_DIVIDE = "swrlb:divide";
    private static final String SWRLB_INTEGER_DIVIDE = "swrlb:integerDivide";
    private static final String SWRLB_MOD = "swrlb:mod";
    private static final String SWRLB_POW = "swrlb:pow";
    private static final String SWRLB_UNARY_PLUS = "swrlb:unaryPlus";
    private static final String SWRLB_UNARY_MINUS = "swrlb:unaryMinus";
    private static final String SWRLB_ABS = "swrlb:abs";
    private static final String SWRLB_CEILING = "swrlb:ceiling";
    private static final String SWRLB_FLOOR = "swrlb:floor";
    private static final String SWRLB_ROUND = "swrlb:round";
    private static final String SWRLB_ROUND_HALF_TO_EVEN = "swrlb:roundHalfToEven";
    private static final String SWRLB_SIN = "swrlb:sin";
    private static final String SWRLB_COS = "swrlb:cos";
    private static final String SWRLB_TAN = "swrlb:tan";

    public SWRLBuiltInLibraryImpl() {
        super(PREFIX, NAMESPACE, new HashSet<String>(Arrays.asList(BUILT_IN_NAMES)));
    }

    @Override
    public void reset() {
    }

    public boolean greaterThan(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        if (this.isArgumentAString(0, arguments)) {
            String s1 = this.getArgumentAsAString(0, arguments);
            if (this.isArgumentAString(1, arguments)) {
                String s2 = this.getArgumentAsAString(1, arguments);
                return s1.compareTo(s2) > 0;
            }
            throw new InvalidSWRLBuiltInArgumentException(1, "expecting string argument for comparison, got " + this.representArgumentAsAString(1, arguments));
        }
        if (this.isArgumentNumeric(0, arguments)) {
            if (this.isArgumentNumeric(1, arguments)) {
                return this.compareTwoNumericArguments(arguments) > 0;
            }
            throw new InvalidSWRLBuiltInArgumentException(1, "expecting numeric argument for comparison, got " + this.representArgumentAsAString(1, arguments));
        }
        throw new InvalidSWRLBuiltInArgumentException(0, "expecting string or numeric argument for comparison, got " + this.representArgumentAsAString(0, arguments));
    }

    public boolean lessThan(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        if (this.isArgumentAString(0, arguments)) {
            String s1 = this.getArgumentAsAString(0, arguments);
            if (this.isArgumentAString(1, arguments)) {
                String s2 = this.getArgumentAsAString(1, arguments);
                return s1.compareTo(s2) < 0;
            }
            throw new InvalidSWRLBuiltInArgumentException(1, "expecting string argument for comparison, got " + this.representArgumentAsAString(1, arguments));
        }
        if (this.isArgumentNumeric(0, arguments)) {
            if (this.isArgumentNumeric(1, arguments)) {
                return this.compareTwoNumericArguments(arguments) < 0;
            }
            throw new InvalidSWRLBuiltInArgumentException(1, "expecting numeric argument for comparison, got " + this.representArgumentAsAString(1, arguments));
        }
        throw new InvalidSWRLBuiltInArgumentException(0, "expecting string or numeric argument for comparison, got " + this.representArgumentAsAString(0, arguments));
    }

    public boolean equal(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        if (this.hasUnboundArguments(arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(0, "comparison built-ins do not support argument binding");
        }
        if (this.isArgumentABoolean(0, arguments)) {
            boolean b1 = this.getArgumentAsABoolean(0, arguments);
            if (this.isArgumentABoolean(1, arguments)) {
                boolean b2 = this.getArgumentAsABoolean(1, arguments);
                return b1 == b2;
            }
            return false;
        }
        if (this.isArgumentAString(0, arguments)) {
            String s1 = this.getArgumentAsAString(0, arguments);
            if (this.isArgumentAString(1, arguments)) {
                String s2 = this.getArgumentAsAString(1, arguments);
                return s1.compareTo(s2) == 0;
            }
            return false;
        }
        if (this.isArgumentADateTime(0, arguments)) {
            XSDDateTime dt1 = this.getArgumentAsADateTime(0, arguments);
            if (this.isArgumentADateTime(1, arguments)) {
                XSDDateTime dt2 = this.getArgumentAsADateTime(1, arguments);
                return dt1.compareTo(dt2) == 0;
            }
            return false;
        }
        if (this.isArgumentADate(0, arguments)) {
            XSDDate d1 = this.getArgumentAsADate(0, arguments);
            if (this.isArgumentADate(1, arguments)) {
                XSDDate d2 = this.getArgumentAsADate(1, arguments);
                return d1.compareTo(d2) == 0;
            }
            return false;
        }
        if (this.isArgumentATime(0, arguments)) {
            XSDTime t1 = this.getArgumentAsATime(0, arguments);
            if (this.isArgumentATime(1, arguments)) {
                XSDTime t2 = this.getArgumentAsATime(1, arguments);
                return t1.compareTo(t2) == 0;
            }
            return false;
        }
        if (this.isArgumentADuration(0, arguments)) {
            XSDDuration d1 = this.getArgumentAsADuration(0, arguments);
            if (this.isArgumentADuration(1, arguments)) {
                XSDDuration d2 = this.getArgumentAsADuration(1, arguments);
                return d1.compareTo(d2) == 0;
            }
            return false;
        }
        if (this.isArgumentNumeric(0, arguments)) {
            if (this.isArgumentNumeric(1, arguments)) {
                return this.compareTwoNumericArguments(arguments) == 0;
            }
            throw new InvalidSWRLBuiltInArgumentException(1, "expecting numeric argument for comparison, got " + this.representArgumentAsAString(1, arguments));
        }
        throw new InvalidSWRLBuiltInArgumentException(0, "unsupported argument type: expecting boolean, numeric, string, xsd:date, xsd:dateTime, xsd:time, or xsd:duration argument for comparison, got " + this.representArgumentAsAString(0, arguments));
    }

    public boolean notEqual(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.equal(arguments);
    }

    public boolean lessThanOrEqual(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.equal(arguments) || this.lessThan(arguments);
    }

    public boolean greaterThanOrEqual(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.equal(arguments) || this.greaterThan(arguments);
    }

    public boolean add(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        return this.mathOperation(SWRLB_ADD, arguments);
    }

    public boolean subtract(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        return this.mathOperation(SWRLB_SUBTRACT, arguments);
    }

    public boolean multiply(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        return this.mathOperation(SWRLB_MULTIPLY, arguments);
    }

    public boolean divide(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        return this.mathOperation(SWRLB_DIVIDE, arguments);
    }

    public boolean integerDivide(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        return this.mathOperation(SWRLB_INTEGER_DIVIDE, arguments);
    }

    public boolean mod(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        return this.mathOperation(SWRLB_MOD, arguments);
    }

    public boolean pow(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        return this.mathOperation(SWRLB_POW, arguments);
    }

    public boolean unaryPlus(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_UNARY_PLUS, arguments);
    }

    public boolean unaryMinus(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_UNARY_MINUS, arguments);
    }

    public boolean abs(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_ABS, arguments);
    }

    public boolean ceiling(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_CEILING, arguments);
    }

    public boolean floor(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_FLOOR, arguments);
    }

    public boolean round(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_ROUND, arguments);
    }

    public boolean roundHalfToEven(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_ROUND_HALF_TO_EVEN, arguments);
    }

    public boolean sin(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_SIN, arguments);
    }

    public boolean cos(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_COS, arguments);
    }

    public boolean tan(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        return this.mathOperation(SWRLB_TAN, arguments);
    }

    public boolean booleanNot(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        this.checkForUnboundNonFirstArguments(arguments);
        if (this.isUnboundArgument(0, arguments)) {
            if (!this.areAllArgumentsBooleans(arguments.subList(1, arguments.size()))) {
                throw new InvalidSWRLBuiltInArgumentException(1, "expecting a Boolean");
            }
            boolean operationResult = !this.getArgumentAsABoolean(1, arguments);
            SWRLLiteralBuiltInArgument resultArgument = this.createLiteralBuiltInArgument(operationResult);
            arguments.get(0).asVariable().setBuiltInResult(resultArgument);
            return true;
        }
        if (!this.areAllArgumentsBooleans(arguments)) {
            throw new InvalidSWRLBuiltInArgumentException("expecting all Boolean arguments");
        }
        return !this.equal(arguments);
    }

    public boolean stringEqualIgnoreCase(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        this.checkForUnboundArguments(arguments);
        String argument1 = this.getArgumentAsAString(0, arguments);
        String argument2 = this.getArgumentAsAString(1, arguments);
        return argument1.equalsIgnoreCase(argument2);
    }

    public boolean stringConcat(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        String operationResult = "";
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        for (int argumentNumber = 1; argumentNumber < arguments.size(); ++argumentNumber) {
            operationResult = operationResult.concat(this.getArgumentAsAnOWLLiteral(argumentNumber, arguments).getLiteral());
        }
        return this.processResultArgument(arguments, 0, operationResult);
    }

    public boolean substring(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        String operationResult;
        this.checkNumberOfArgumentsAtLeast(3, arguments.size());
        this.checkNumberOfArgumentsAtMost(4, arguments.size());
        String argument2 = this.getArgumentAsAString(1, arguments);
        int startIndex = this.convertArgumentToAnInt(2, arguments);
        if (arguments.size() == 4) {
            int length = this.convertArgumentToAnInt(3, arguments);
            operationResult = argument2.substring(startIndex, length);
        } else {
            operationResult = argument2.substring(startIndex);
        }
        return this.processResultArgument(arguments, 0, operationResult);
    }

    public boolean stringLength(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        String argument2 = this.getArgumentAsAString(1, arguments);
        BigInteger operationResult = BigInteger.valueOf(argument2.length());
        return this.processResultArgument(arguments, 0, operationResult);
    }

    public boolean upperCase(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        String argument2 = this.getArgumentAsAString(1, arguments);
        String operationResult = argument2.toUpperCase();
        return this.processResultArgument(arguments, 0, operationResult);
    }

    public boolean lowerCase(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        String argument2 = this.getArgumentAsAString(1, arguments);
        String operationResult = argument2.toLowerCase();
        return this.processResultArgument(arguments, 0, operationResult);
    }

    public boolean contains(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        String argument1 = this.getArgumentAsAString(0, arguments);
        String argument2 = this.getArgumentAsAString(1, arguments);
        return argument1.lastIndexOf(argument2) != -1;
    }

    public boolean containsIgnoreCase(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        String argument1 = this.getArgumentAsAString(0, arguments);
        String argument2 = this.getArgumentAsAString(1, arguments);
        return argument1.toLowerCase().lastIndexOf(argument2.toLowerCase()) != -1;
    }

    public boolean startsWith(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        String argument1 = this.getArgumentAsAString(0, arguments);
        String argument2 = this.getArgumentAsAString(1, arguments);
        return argument1.startsWith(argument2);
    }

    public boolean endsWith(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        String argument1 = this.getArgumentAsAString(0, arguments);
        String argument2 = this.getArgumentAsAString(1, arguments);
        return argument1.endsWith(argument2);
    }

    public boolean translate(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(4, arguments.size());
        String argument2 = this.getArgumentAsAString(1, arguments);
        String argument3 = this.getArgumentAsAString(2, arguments);
        String argument4 = this.getArgumentAsAString(3, arguments);
        @Nullable String operationResult = argument2.replace(argument3, argument4);
        if (operationResult != null) {
            return this.processResultArgument(arguments, 0, operationResult);
        }
        return false;
    }

    public boolean substringAfter(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        String argument2 = this.getArgumentAsAString(1, arguments);
        String argument3 = this.getArgumentAsAString(2, arguments);
        @Nullable String operationResult = this.substringAfter(argument2, argument3);
        if (operationResult != null) {
            return this.processResultArgument(arguments, 0, operationResult);
        }
        return false;
    }

    public boolean substringBefore(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        String argument2 = this.getArgumentAsAString(1, arguments);
        String argument3 = this.getArgumentAsAString(2, arguments);
        @Nullable String operationResult = this.substringBefore(argument2, argument3);
        if (operationResult != null) {
            return this.processResultArgument(arguments, 0, operationResult);
        }
        return false;
    }

    public boolean matches(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        String argument1 = this.getArgumentAsAString(0, arguments);
        String argument2 = this.getArgumentAsAString(1, arguments);
        try {
            return Pattern.matches(argument2, argument1);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidSWRLBuiltInArgumentException(1, "invalid regular expression '" + argument2 + "': " + e.getMessage(), e);
        }
    }

    public boolean replace(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(4, arguments.size());
        String input = this.getArgumentAsAString(1, arguments);
        String regex = this.getArgumentAsAString(2, arguments);
        String replacement = this.getArgumentAsAString(3, arguments);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        String operationResult = m.replaceAll(replacement);
        return this.processResultArgument(arguments, 0, operationResult);
    }

    public boolean normalizeSpace(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        String input = this.getArgumentAsAString(1, arguments);
        Pattern p = Pattern.compile("\\s+");
        Matcher m = p.matcher(input);
        String operationResult = m.replaceAll(" ").trim();
        return this.processResultArgument(arguments, 0, operationResult);
    }

    public boolean tokenize(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (!this.isUnboundArgument(0, arguments)) {
            throw new InvalidSWRLBuiltInArgumentException(0, "unexpected bound argument found");
        }
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        this.checkForUnboundNonFirstArguments(arguments);
        String inputString = this.getArgumentAsAString(1, arguments);
        String delimeters = this.getArgumentAsAString(2, arguments);
        StringTokenizer tokenizer = new StringTokenizer(inputString.trim(), delimeters);
        IRI variableIRI = arguments.get(0).asVariable().getIRI();
        SWRLMultiValueVariableBuiltInArgument multiValueBuiltInArgument = this.createSWRLMultiValueVariableBuiltInArgument(variableIRI);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            multiValueBuiltInArgument.addArgument(this.createLiteralBuiltInArgument(token));
        }
        arguments.get(0).asVariable().setBuiltInResult(multiValueBuiltInArgument);
        return !multiValueBuiltInArgument.hasNoArguments();
    }

    public boolean yearMonthDuration(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        int year = this.convertArgumentToAnInt(1, arguments);
        int month = this.convertArgumentToAnInt(2, arguments);
        Duration duration = new Duration();
        duration.setYears(year);
        duration.setMonths(month);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(duration));
    }

    public boolean dayTimeDuration(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(5, arguments.size());
        int days = this.convertArgumentToAnInt(1, arguments);
        int hours = this.convertArgumentToAnInt(2, arguments);
        int minutes = this.convertArgumentToAnInt(3, arguments);
        int seconds = this.convertArgumentToAnInt(4, arguments);
        Duration duration = new Duration();
        duration.setDays(days);
        duration.setHours(hours);
        duration.setMinutes(minutes);
        duration.setSeconds(seconds);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(duration));
    }

    public boolean dateTime(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(8, arguments.size());
        int year = this.convertArgumentToAnInt(1, arguments);
        int month = this.convertArgumentToAnInt(2, arguments);
        int days = this.convertArgumentToAnInt(3, arguments);
        int hours = this.convertArgumentToAnInt(4, arguments);
        int minutes = this.convertArgumentToAnInt(5, arguments);
        int seconds = this.convertArgumentToAnInt(6, arguments);
        String timeZone = this.getArgumentAsAString(7, arguments);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(year, month, days, hours, minutes, seconds);
        ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone(timeZone));
        String operationResult = "" + calendar.get(1) + "-" + calendar.get(2) + "-" + calendar.get(5) + "T" + calendar.get(10) + ":" + calendar.get(12) + ":" + calendar.get(13) + ((Calendar)calendar).getTimeZone().getID();
        return this.processResultArgument(arguments, 0, this.dateTimeString2XSDDateTime(operationResult));
    }

    public boolean date(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(5, arguments.size());
        int year = this.convertArgumentToAnInt(1, arguments);
        int month = this.convertArgumentToAnInt(2, arguments);
        int days = this.convertArgumentToAnInt(3, arguments);
        String timeZone = this.getArgumentAsAString(4, arguments);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(year, month, days);
        ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone(timeZone));
        String operationResult = "" + calendar.get(1) + "-" + calendar.get(2) + "-" + calendar.get(5) + ((Calendar)calendar).getTimeZone().getID();
        return this.processResultArgument(arguments, 0, this.dateString2XSDDate(operationResult));
    }

    public boolean time(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(5, arguments.size());
        int hours = this.convertArgumentToAnInt(1, arguments);
        int minutes = this.convertArgumentToAnInt(2, arguments);
        int seconds = this.convertArgumentToAnInt(3, arguments);
        String timeZone = this.getArgumentAsAString(4, arguments);
        String operationResult = "" + hours + ":" + minutes + ":" + seconds + timeZone;
        return this.processResultArgument(arguments, 0, this.timeString2XSDTime(operationResult));
    }

    public boolean addYearMonthDurations(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsAtLeast(3, arguments.size());
        Duration operationDuration = new Duration();
        for (int i = 1; i < arguments.size(); ++i) {
            Duration duration = this.getArgumentAsAnAxisDuration(i, arguments);
            operationDuration = XSDTimeUtil.addYearMonthDurations(operationDuration, duration);
        }
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean subtractYearMonthDurations(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Duration duration2 = this.getArgumentAsAnAxisDuration(1, arguments);
        Duration duration3 = this.getArgumentAsAnAxisDuration(2, arguments);
        Duration operationDuration = XSDTimeUtil.subtractYearMonthDurations(duration2, duration3);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean multiplyYearMonthDuration(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Duration duration2 = this.getArgumentAsAnAxisDuration(1, arguments);
        Duration duration3 = this.getArgumentAsAnAxisDuration(2, arguments);
        Duration operationDuration = XSDTimeUtil.multiplyYearMonthDurations(duration2, duration3);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean divideYearMonthDuration(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Duration duration2 = this.getArgumentAsAnAxisDuration(1, arguments);
        Duration duration3 = this.getArgumentAsAnAxisDuration(2, arguments);
        Duration operationDuration = XSDTimeUtil.divideYearMonthDurations(duration2, duration3);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean addDayTimeDurations(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        Duration operationDuration = new Duration();
        this.checkNumberOfArgumentsAtLeast(3, arguments.size());
        for (int i = 1; i < arguments.size(); ++i) {
            Duration duration = this.getArgumentAsAnAxisDuration(i, arguments);
            operationDuration = XSDTimeUtil.addDayTimeDurations(operationDuration, duration);
        }
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean subtractDayTimeDurations(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Duration duration2 = this.getArgumentAsAnAxisDuration(1, arguments);
        Duration duration3 = this.getArgumentAsAnAxisDuration(2, arguments);
        Duration operationDuration = XSDTimeUtil.subtractDayTimeDurations(duration2, duration3);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean multiplyDayTimeDuration(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Duration duration2 = this.getArgumentAsAnAxisDuration(1, arguments);
        Duration duration3 = this.getArgumentAsAnAxisDuration(2, arguments);
        Duration operationDuration = XSDTimeUtil.multiplyDayTimeDurations(duration2, duration3);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean divideDayTimeDuration(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Duration duration2 = this.getArgumentAsAnAxisDuration(1, arguments);
        Duration duration3 = this.getArgumentAsAnAxisDuration(2, arguments);
        Duration operationDuration = XSDTimeUtil.divideDayTimeDurations(duration2, duration3);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean subtractDates(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Date date2 = this.getXSDDateArgumentAsAUtilDate(1, arguments);
        Date date3 = this.getXSDDateArgumentAsAUtilDate(2, arguments);
        Duration operationDuration = XSDTimeUtil.subtractDates(date2, date3);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean subtractTimes(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Time time2 = this.getArgumentAsAnAxisTime(1, arguments);
        Time time3 = this.getArgumentAsAnAxisTime(2, arguments);
        Duration operationDuration = XSDTimeUtil.subtractTimes(time2, time3);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean addYearMonthDurationToDateTime(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Date date = this.getXSDDateTimeArgumentAsAUtilDate(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Date operationUtilDate = XSDTimeUtil.addYearMonthDurationToUtilDate(date, duration);
        return this.processResultArgument(arguments, 0, this.utilDate2XSDDateTime(operationUtilDate));
    }

    public boolean subtractYearMonthDurationFromDateTime(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Date date = this.getXSDDateTimeArgumentAsAUtilDate(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Date operationUtilDate = XSDTimeUtil.subtractYearMonthDurationFromUtilDate(date, duration);
        return this.processResultArgument(arguments, 0, this.utilDate2XSDDateTime(operationUtilDate));
    }

    public boolean addDayTimeDurationToDateTime(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Date date = this.getXSDDateTimeArgumentAsAUtilDate(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Date operationUtilDate = XSDTimeUtil.addDayTimeDurationToUtilDate(date, duration);
        return this.processResultArgument(arguments, 0, this.utilDate2XSDDateTime(operationUtilDate));
    }

    public boolean subtractDayTimeDurationFromDateTime(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Date date = this.getXSDDateTimeArgumentAsAUtilDate(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Date operationUtilDate = XSDTimeUtil.subtractDayTimeDurationFromUtilDate(date, duration);
        return this.processResultArgument(arguments, 0, this.utilDate2XSDDateTime(operationUtilDate));
    }

    public boolean addYearMonthDurationToDate(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Date date = this.getXSDDateArgumentAsAUtilDate(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Date operationUtilDate = XSDTimeUtil.addYearMonthDurationToUtilDate(date, duration);
        return this.processResultArgument(arguments, 0, this.utilDate2XSDDate(operationUtilDate));
    }

    public boolean subtractYearMonthDurationFromDate(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Date date = this.getXSDDateArgumentAsAUtilDate(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Date operationUtilDate = XSDTimeUtil.subtractYearMonthDurationFromUtilDate(date, duration);
        return this.processResultArgument(arguments, 0, this.utilDate2XSDDate(operationUtilDate));
    }

    public boolean addDayTimeDurationToDate(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Date date = this.getXSDDateArgumentAsAUtilDate(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Date operationUtilDate = XSDTimeUtil.addDayTimeDurationToUtilDate(date, duration);
        return this.processResultArgument(arguments, 0, this.utilDate2XSDDate(operationUtilDate));
    }

    public boolean subtractDayTimeDurationFromDate(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Date date = this.getXSDDateArgumentAsAUtilDate(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Date operationUtilDate = XSDTimeUtil.subtractDayTimeDurationFromUtilDate(date, duration);
        return this.processResultArgument(arguments, 0, this.utilDate2XSDDate(operationUtilDate));
    }

    public boolean addDayTimeDurationToTime(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Time time = this.getArgumentAsAnAxisTime(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Time operationTime = XSDTimeUtil.addDayTimeDurationToTime(time, duration);
        return this.processResultArgument(arguments, 0, this.axisTime2XSDTime(operationTime));
    }

    public boolean subtractDayTimeDurationFromTime(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(3, arguments.size());
        Time time = this.getArgumentAsAnAxisTime(1, arguments);
        Duration duration = this.getArgumentAsAnAxisDuration(2, arguments);
        Time operationTime = XSDTimeUtil.subtractDayTimeDurationFromTime(time, duration);
        return this.processResultArgument(arguments, 0, this.axisTime2XSDTime(operationTime));
    }

    public boolean subtractDateTimesYieldingYearMonthDuration(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        Date date1 = this.getXSDDateTimeArgumentAsAUtilDate(1, arguments);
        Date date2 = this.getXSDDateTimeArgumentAsAUtilDate(2, arguments);
        Duration operationDuration = XSDTimeUtil.subtractUtilDatesYieldingYearMonthDuration(date1, date2);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean subtractDateTimesYieldingDayTimeDuration(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        Date date1 = this.getXSDDateTimeArgumentAsAUtilDate(1, arguments);
        Date date2 = this.getXSDDateTimeArgumentAsAUtilDate(2, arguments);
        Duration operationDuration = XSDTimeUtil.subtractUtilDatesYieldingDayTimeDuration(date1, date2);
        return this.processResultArgument(arguments, 0, this.axisDuration2XSDDuration(operationDuration));
    }

    public boolean resolveURI(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean anyURI(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean listConcat(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean listIntersection(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean listSubtraction(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean member(List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean length(List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean first(List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean rest(List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean sublist(List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    public boolean empty(List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException();
    }

    private int compareTwoNumericArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        boolean argument1Index = false;
        boolean argument2Index = true;
        this.checkThatAllArgumentsAreNumeric(arguments);
        OWLLiteral literal1 = this.getArgumentAsAnOWLLiteral(0, arguments);
        OWLLiteral literal2 = this.getArgumentAsAnOWLLiteral(1, arguments);
        return OWLLiteralComparator.COMPARATOR.compare(literal1, literal2);
    }

    private boolean mathOperation(@NonNull String builtInName, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        Number argument3;
        BigDecimal operationResult;
        BigDecimal argument1 = BigDecimal.ZERO;
        boolean hasUnbound1stArgument = false;
        this.checkForUnboundNonFirstArguments(arguments);
        if (this.isUnboundArgument(0, arguments)) {
            hasUnbound1stArgument = true;
        }
        if (!hasUnbound1stArgument) {
            argument1 = this.getArgumentAsADecimal(0, arguments);
        }
        if (builtInName.equalsIgnoreCase(SWRLB_ADD)) {
            operationResult = BigDecimal.ZERO;
            for (int argumentNumber = 1; argumentNumber < arguments.size(); ++argumentNumber) {
                operationResult = operationResult.add(this.getArgumentAsADecimal(argumentNumber, arguments));
            }
        } else if (builtInName.equalsIgnoreCase(SWRLB_MULTIPLY)) {
            operationResult = BigDecimal.ONE;
            for (int argumentNumber = 1; argumentNumber < arguments.size(); ++argumentNumber) {
                operationResult = operationResult.multiply(this.getArgumentAsADecimal(argumentNumber, arguments));
            }
        } else if (builtInName.equalsIgnoreCase(SWRLB_SUBTRACT)) {
            BigDecimal argument2 = this.getArgumentAsADecimal(1, arguments);
            argument3 = this.getArgumentAsADecimal(2, arguments);
            operationResult = argument2.subtract((BigDecimal)argument3);
        } else if (builtInName.equalsIgnoreCase(SWRLB_DIVIDE)) {
            BigDecimal argument2 = this.getArgumentAsADecimal(1, arguments);
            argument3 = this.getArgumentAsADecimal(2, arguments);
            operationResult = argument2.divide((BigDecimal)argument3, RoundingMode.HALF_UP);
        } else if (builtInName.equalsIgnoreCase(SWRLB_INTEGER_DIVIDE)) {
            BigInteger argument2 = this.getArgumentAsAnInteger(1, arguments);
            argument3 = this.getArgumentAsAnInteger(2, arguments);
            if (((BigInteger)argument3).equals(BigDecimal.ZERO)) {
                throw new InvalidSWRLBuiltInArgumentException(2, "zero passed as divisor");
            }
            operationResult = ((BigInteger)argument3).compareTo(BigInteger.ZERO) >= 0 ? new BigDecimal(argument2.add((BigInteger)argument3).add(BigInteger.ONE.divide((BigInteger)argument3))) : new BigDecimal(argument2.divide((BigInteger)argument3));
        } else if (builtInName.equalsIgnoreCase(SWRLB_MOD)) {
            BigInteger argument2 = this.getArgumentAsAnInteger(1, arguments);
            argument3 = this.getArgumentAsAnInteger(2, arguments);
            operationResult = new BigDecimal(argument2.remainder((BigInteger)argument3));
        } else if (builtInName.equalsIgnoreCase(SWRLB_POW)) {
            int argument32 = this.convertArgumentToAnInt(2, arguments);
            BigDecimal argument2 = this.getArgumentAsADecimal(1, arguments);
            operationResult = argument2.pow(argument32);
        } else if (builtInName.equalsIgnoreCase(SWRLB_UNARY_PLUS)) {
            BigDecimal argument2;
            operationResult = argument2 = this.getArgumentAsADecimal(1, arguments);
        } else if (builtInName.equalsIgnoreCase(SWRLB_UNARY_MINUS)) {
            BigDecimal argument2 = this.getArgumentAsADecimal(1, arguments);
            operationResult = argument2.negate();
        } else if (builtInName.equalsIgnoreCase(SWRLB_ABS)) {
            BigDecimal argument2 = this.getArgumentAsADecimal(1, arguments);
            operationResult = argument2.abs();
        } else if (builtInName.equalsIgnoreCase(SWRLB_CEILING)) {
            BigDecimal argument2 = this.getArgumentAsADecimal(1, arguments);
            operationResult = argument2.setScale(0, RoundingMode.CEILING);
        } else if (builtInName.equalsIgnoreCase(SWRLB_FLOOR)) {
            BigDecimal argument2 = this.getArgumentAsADecimal(1, arguments);
            operationResult = argument2.setScale(0, RoundingMode.FLOOR);
        } else if (builtInName.equalsIgnoreCase(SWRLB_ROUND)) {
            BigDecimal argument2 = this.getArgumentAsADecimal(1, arguments);
            operationResult = argument2.setScale(0);
        } else if (builtInName.equalsIgnoreCase(SWRLB_ROUND_HALF_TO_EVEN)) {
            BigDecimal argument2 = this.getArgumentAsADecimal(1, arguments);
            operationResult = argument2.setScale(0, RoundingMode.HALF_EVEN);
        } else if (builtInName.equalsIgnoreCase(SWRLB_SIN)) {
            double argument2 = this.getArgumentAsADouble(1, arguments);
            operationResult = new BigDecimal(Math.sin(argument2));
        } else if (builtInName.equalsIgnoreCase(SWRLB_COS)) {
            double argument2 = this.getArgumentAsADouble(1, arguments);
            operationResult = new BigDecimal(Math.cos(argument2));
        } else if (builtInName.equalsIgnoreCase(SWRLB_TAN)) {
            double argument2 = this.getArgumentAsADouble(1, arguments);
            operationResult = new BigDecimal(Math.tan(argument2));
        } else {
            throw new InvalidSWRLBuiltInNameException(builtInName);
        }
        if (hasUnbound1stArgument) {
            List<@NonNull SWRLBuiltInArgument> boundInputArguments = arguments.subList(1, arguments.size());
            if (builtInName.equalsIgnoreCase(SWRLB_SIN) || builtInName.equalsIgnoreCase(SWRLB_COS) || builtInName.equalsIgnoreCase(SWRLB_TAN)) {
                arguments.get(0).asVariable().setBuiltInResult(this.createLiteralBuiltInArgument(operationResult.doubleValue()));
            } else {
                SWRLLiteralBuiltInArgument resultArgument = this.createLeastNarrowNumericLiteralBuiltInArgument(operationResult, boundInputArguments);
                arguments.get(0).asVariable().setBuiltInResult(resultArgument);
            }
            return true;
        }
        return argument1.equals(operationResult);
    }

    private Duration getArgumentAsAnAxisDuration(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        try {
            XSDDuration duration = this.getArgumentAsADuration(argumentNumber, arguments);
            return XSDTimeUtil.xsdDuration2AxisDuration(duration);
        }
        catch (IllegalArgumentException e) {
            throw new SWRLBuiltInException("invalid xsd:duration " + arguments.get(argumentNumber) + ": " + e.getMessage(), e);
        }
    }

    private Date getXSDDateArgumentAsAUtilDate(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        try {
            XSDDate date = this.getArgumentAsADate(argumentNumber, arguments);
            return XSDTimeUtil.xsdDate2UtilDate(date);
        }
        catch (IllegalArgumentException e) {
            throw new SWRLBuiltInException("invalid xsd:date " + arguments.get(argumentNumber) + ": " + e.getMessage(), e);
        }
    }

    private Date getXSDDateTimeArgumentAsAUtilDate(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        try {
            XSDDateTime dateTime = this.getArgumentAsADateTime(argumentNumber, arguments);
            return XSDTimeUtil.xsdDateTime2UtilDate(dateTime);
        }
        catch (IllegalArgumentException e) {
            throw new SWRLBuiltInException("invalid xsd:dateTime " + arguments.get(argumentNumber) + ": " + e.getMessage(), e);
        }
    }

    private Time getArgumentAsAnAxisTime(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        String time = this.getArgumentAsAString(argumentNumber, arguments);
        try {
            return XSDTimeUtil.xsdTimeString2AxisTime(time);
        }
        catch (NumberFormatException e) {
            throw new SWRLBuiltInException("invalid xsd:time " + time + ": " + e.getMessage(), e);
        }
    }

    private @NonNull XSDDate utilDate2XSDDate(Date utilDate) {
        return new XSDDate(XSDTimeUtil.utilDate2XSDDateString(utilDate));
    }

    private @NonNull XSDDate dateString2XSDDate(@NonNull String date) {
        return new XSDDate(date);
    }

    private @NonNull XSDDateTime utilDate2XSDDateTime(@NonNull Date utilDate) {
        return new XSDDateTime(XSDTimeUtil.utilDate2XSDDateTimeString(utilDate));
    }

    private @NonNull XSDDateTime dateTimeString2XSDDateTime(@NonNull String dateTime) {
        return new XSDDateTime(dateTime);
    }

    private @NonNull XSDDuration axisDuration2XSDDuration(@NonNull Duration duration) {
        return new XSDDuration(duration.toString());
    }

    private @NonNull XSDTime axisTime2XSDTime(@NonNull Time time) {
        return new XSDTime(time.toString());
    }

    private @NonNull XSDTime timeString2XSDTime(@NonNull String time) {
        return new XSDTime(time);
    }

    private @Nullable String substringAfter(@Nullable String str, @Nullable String separator) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    private @Nullable String substringBefore(@Nullable String str, @Nullable String separator) {
        if (str == null || str.length() == 0 || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private int convertArgumentToAnInt(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        BigInteger integerValue = this.getArgumentAsAnInteger(argumentNumber, arguments);
        if (integerValue.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || integerValue.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "value converted to xsd:int cannot be larger than 2147483647"));
        }
        return integerValue.intValue();
    }
}

