/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.swrlm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.nfunk.jep.JEP;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.builtins.AbstractSWRLBuiltInLibrary;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.exceptions.SWRLBuiltInException;

public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static final String PREFIX = "swrlm";
    private static final String NAMESPACE = "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlm.owl#";
    private static final String[] BUILT_IN_NAMES = new String[]{"sqrt", "eval", "log"};
    private @Nullable JEP jep = null;

    public SWRLBuiltInLibraryImpl() {
        super(PREFIX, NAMESPACE, new HashSet<String>(Arrays.asList(BUILT_IN_NAMES)));
    }

    @Override
    public void reset() {
        this.jep = null;
    }

    public boolean sqrt(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        double argument2 = this.getArgumentAsADouble(1, arguments);
        if (this.isUnboundArgument(0, arguments)) {
            arguments.get(0).asVariable().setBuiltInResult(this.createLiteralBuiltInArgument(Math.sqrt(argument2)));
            return true;
        }
        double argument1 = this.getArgumentAsADouble(0, arguments);
        return argument1 == Math.sqrt(argument2);
    }

    public boolean log(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        double argument2 = this.getArgumentAsADouble(1, arguments);
        if (this.isUnboundArgument(0, arguments)) {
            arguments.get(0).asVariable().setBuiltInResult(this.createLiteralBuiltInArgument(Math.log(argument2)));
            return true;
        }
        double argument1 = this.getArgumentAsADouble(0, arguments);
        return argument1 == Math.log(argument2);
    }

    public boolean eval(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        int minimumNumberoOfArguments = 2;
        boolean expressionArgumentIndex = true;
        boolean resultArgumentIndex = false;
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        String expression = this.getArgumentAsAString(1, arguments);
        if (arguments.size() > 2) {
            List<@NonNull SWRLBuiltInArgument> variableArguments = arguments.subList(2, arguments.size());
            this.checkForUnboundArguments(variableArguments, "2nd and subsequent arguments cannot be unbound");
            this.checkThatAllArgumentsAreBoundVariables(variableArguments, "2nd and subsequent arguments should be variables");
            int currentVariableArgumentIndex = 2;
            for (SWRLBuiltInArgument variableArgument : variableArguments) {
                Optional<String> variableName = variableArgument.getBoundVariableName();
                if (!variableName.isPresent()) continue;
                if (!this.isArgumentConvertibleToDouble(currentVariableArgumentIndex, arguments)) {
                    String message = "exception processing expression '" + expression + "': variable ?" + variableName.get() + " with type " + this.getLiteralArgumentDatatypeName(currentVariableArgumentIndex, arguments) + " cannot be converted to " + XSDVocabulary.DOUBLE.getPrefixedName();
                    throw new SWRLBuiltInException(message);
                }
                double variableValue = this.getArgumentAsADouble(variableArgument);
                this.getJEP().addVariable(variableName.get(), variableValue);
                ++currentVariableArgumentIndex;
            }
        }
        this.getJEP().parseExpression(expression);
        if (this.getJEP().hasError()) {
            throw new SWRLBuiltInException("exception parsing expression '" + expression + "': " + this.getJEP().getErrorInfo());
        }
        double value = this.getJEP().getValue();
        if (this.getJEP().hasError()) {
            throw new SWRLBuiltInException("exception parsing expression '" + expression + "': " + this.getJEP().getErrorInfo());
        }
        if (this.isUnboundArgument(0, arguments)) {
            arguments.get(0).asVariable().setBuiltInResult(this.createLiteralBuiltInArgument(value));
            return true;
        }
        if (this.isArgumentConvertibleToDouble(0, arguments)) {
            return value == this.getArgumentAsADouble(0, arguments);
        }
        throw new SWRLBuiltInException("exception processing expression '" + expression + "': result argument with type " + this.getLiteralArgumentDatatypeName(0, arguments) + " cannot be converted to " + XSDVocabulary.DOUBLE.getPrefixedName());
    }

    private @NonNull JEP getJEP() {
        if (this.jep == null) {
            this.jep = new JEP();
            this.jep.addStandardFunctions();
            this.jep.addStandardConstants();
            this.jep.setImplicitMul(true);
        }
        return this.jep;
    }
}

