/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.swrlx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.swrlapi.builtins.AbstractSWRLBuiltInLibrary;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.exceptions.SWRLBuiltInException;

public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static final String PREFIX = "swrlx";
    private static final String NAMESPACE = "http://swrl.stanford.edu/ontologies/built-ins/3.3/swrlx.owl#";
    private static final String[] BUILT_IN_NAMES = new String[]{"makeOWLClass", "makeOWLIndividual", "makeOWLThing", "createOWLThing", "invokeSWRLBuiltIn"};
    private final @NonNull Map<@NonNull String, @NonNull OWLClass> classInvocationMap = new HashMap<String, OWLClass>();
    private final @NonNull Map<@NonNull String, @NonNull OWLNamedIndividual> individualInvocationMap = new HashMap<String, OWLNamedIndividual>();

    public SWRLBuiltInLibraryImpl() {
        super(PREFIX, NAMESPACE, new HashSet<String>(Arrays.asList(BUILT_IN_NAMES)));
    }

    @Override
    public void reset() {
        this.classInvocationMap.clear();
        this.individualInvocationMap.clear();
    }

    public boolean makeOWLClass(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        if (this.isUnboundArgument(0, arguments)) {
            OWLClass cls;
            String createInvocationPattern = this.createInvocationPattern(this.getBuiltInBridge(), this.getInvokingRuleName(), this.getInvokingBuiltInIndex(), this.getIsInConsequent(), arguments.subList(1, arguments.size()));
            if (this.classInvocationMap.containsKey(createInvocationPattern)) {
                cls = this.classInvocationMap.get(createInvocationPattern);
            } else {
                cls = this.getSWRLAPIOWLDataFactory().getInjectedOWLClass();
                OWLDeclarationAxiom declarationAxiom = this.getSWRLAPIOWLDataFactory().getOWLClassDeclarationAxiom(cls);
                this.getBuiltInBridge().injectOWLAxiom((OWLAxiom)declarationAxiom);
                this.classInvocationMap.put(createInvocationPattern, cls);
            }
            arguments.get(0).asVariable().setBuiltInResult(this.createClassBuiltInArgument(cls));
        }
        return true;
    }

    private boolean makeOWLIndividual(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        if (this.isUnboundArgument(0, arguments)) {
            OWLNamedIndividual individual;
            String createInvocationPattern = this.createInvocationPattern(this.getBuiltInBridge(), this.getInvokingRuleName(), this.getInvokingBuiltInIndex(), this.getIsInConsequent(), arguments.subList(1, arguments.size()));
            if (this.individualInvocationMap.containsKey(createInvocationPattern)) {
                individual = this.individualInvocationMap.get(createInvocationPattern);
            } else {
                individual = this.getSWRLAPIOWLDataFactory().getInjectedOWLNamedIndividual();
                OWLDeclarationAxiom declarationAxiom = this.getSWRLAPIOWLDataFactory().getOWLIndividualDeclarationAxiom(individual);
                this.getBuiltInBridge().injectOWLAxiom((OWLAxiom)declarationAxiom);
                this.individualInvocationMap.put(createInvocationPattern, individual);
            }
            arguments.get(0).asVariable().setBuiltInResult(this.createNamedIndividualBuiltInArgument(individual));
        }
        return true;
    }

    public boolean makeOWLThing(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.makeOWLIndividual(arguments);
    }

    public boolean createOWLThing(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.makeOWLIndividual(arguments);
    }

    public boolean invokeSWRLBuiltIn(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsAtLeast(2, arguments.size());
        String builtInName = this.getArgumentAsAString(0, arguments);
        List<@NonNull List<@NonNull SWRLBuiltInArgument>> argumentPatterns = this.getBuiltInBridge().invokeSWRLBuiltIn(this.getInvokingRuleName(), builtInName, this.getInvokingBuiltInIndex(), this.getIsInConsequent(), arguments.subList(1, arguments.size()));
        return !argumentPatterns.isEmpty();
    }
}

