/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.tbox;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.swrlapi.builtins.AbstractSWRLBuiltInLibrary;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentType;
import org.swrlapi.builtins.arguments.SWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLBuiltInNotImplementedException;

public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static final String PREFIX = "tbox";
    private static final String NAMESPACE = "http://swrl.stanford.edu/ontologies/built-ins/5.0.0/tbox.owl#";
    private static final String[] BUILT_IN_NAMES = new String[]{"cd", "opd", "dpd", "apd", "dd", "sca", "eca", "dca", "fopa", "ifopa", "fdpa", "opda", "opra", "dpda", "dpra", "dda", "dua", "hka"};

    public SWRLBuiltInLibraryImpl() {
        super(PREFIX, NAMESPACE, new HashSet<String>(Arrays.asList(BUILT_IN_NAMES)));
    }

    @Override
    public void reset() {
    }

    public boolean cd(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(a -> a.getEntity().isOWLClass()).collect(Collectors.toSet());
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.CLASS);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLDeclarationAxiom axiom : axioms) {
            OWLClass candidateValue1 = axiom.getEntity().asOWLClass();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (!outputMultiValueArguments.containsKey(0)) continue;
            outputMultiValueArguments.get(0).addArgument(this.createClassBuiltInArgument(candidateValue1));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean opd(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(a -> a.getEntity().isOWLObjectProperty()).collect(Collectors.toSet());
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.OBJECT_PROPERTY);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLDeclarationAxiom axiom : axioms) {
            OWLObjectProperty candidateValue1 = axiom.getEntity().asOWLObjectProperty();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (!outputMultiValueArguments.containsKey(0)) continue;
            outputMultiValueArguments.get(0).addArgument(this.createObjectPropertyBuiltInArgument(candidateValue1));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean dpd(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(a -> a.getEntity().isOWLDataProperty()).collect(Collectors.toSet());
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.DATA_PROPERTY);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLDeclarationAxiom axiom : axioms) {
            OWLDataProperty candidateValue1 = axiom.getEntity().asOWLDataProperty();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (!outputMultiValueArguments.containsKey(0)) continue;
            outputMultiValueArguments.get(0).addArgument(this.createDataPropertyBuiltInArgument(candidateValue1));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean apd(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(a -> a.getEntity().isOWLAnnotationProperty()).collect(Collectors.toSet());
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.ANNOTATION_PROPERTY);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLDeclarationAxiom axiom : axioms) {
            OWLAnnotationProperty candidateValue1 = axiom.getEntity().asOWLAnnotationProperty();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (!outputMultiValueArguments.containsKey(0)) continue;
            outputMultiValueArguments.get(0).addArgument(this.createAnnotationPropertyBuiltInArgument(candidateValue1));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean dd(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(a -> a.getEntity().isOWLDatatype()).collect(Collectors.toSet());
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.DATATYPE);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLDeclarationAxiom axiom : axioms) {
            OWLDatatype candidateValue1 = axiom.getEntity().asOWLDatatype();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (!outputMultiValueArguments.containsKey(0)) continue;
            outputMultiValueArguments.get(0).addArgument(this.createDatatypeBuiltInArgument(candidateValue1));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean sca(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.SUBCLASS_OF, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.CLASS_EXPRESSION, SWRLBuiltInArgumentType.CLASS_EXPRESSION);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLSubClassOfAxiom axiom : axioms) {
            OWLClassExpression candidateValue1 = axiom.getSubClass();
            OWLClassExpression candidateValue2 = axiom.getSuperClass();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createClassExpressionBuiltInArgument(candidateValue1));
            }
            if (!outputMultiValueArguments.containsKey(1)) continue;
            outputMultiValueArguments.get(1).addArgument(this.createClassExpressionBuiltInArgument(candidateValue2));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean eca(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.EQUIVALENT_CLASSES, Imports.INCLUDED).stream().flatMap(a -> a.asPairwiseAxioms().stream()).collect(Collectors.toSet());
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.CLASS_EXPRESSION, SWRLBuiltInArgumentType.CLASS_EXPRESSION);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLEquivalentClassesAxiom axiom : axioms) {
            OWLClassExpression candidateValue1 = (OWLClassExpression)axiom.getClassExpressionsAsList().get(0);
            OWLClassExpression candidateValue2 = (OWLClassExpression)axiom.getClassExpressionsAsList().get(1);
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createClassExpressionBuiltInArgument(candidateValue1));
            }
            if (!outputMultiValueArguments.containsKey(1)) continue;
            outputMultiValueArguments.get(1).addArgument(this.createClassExpressionBuiltInArgument(candidateValue2));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean dca(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.DISJOINT_CLASSES, Imports.INCLUDED).stream().flatMap(a -> a.asPairwiseAxioms().stream()).collect(Collectors.toSet());
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.CLASS_EXPRESSION, SWRLBuiltInArgumentType.CLASS_EXPRESSION);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLDisjointClassesAxiom axiom : axioms) {
            OWLClassExpression candidateValue1 = (OWLClassExpression)axiom.getClassExpressionsAsList().get(0);
            OWLClassExpression candidateValue2 = (OWLClassExpression)axiom.getClassExpressionsAsList().get(1);
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createClassExpressionBuiltInArgument(candidateValue1));
            }
            if (!outputMultiValueArguments.containsKey(1)) continue;
            outputMultiValueArguments.get(1).addArgument(this.createClassExpressionBuiltInArgument(candidateValue2));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean fopa(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.OBJECT_PROPERTY_EXPRESSION);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLFunctionalObjectPropertyAxiom axiom : axioms) {
            OWLObjectPropertyExpression candidateValue1 = (OWLObjectPropertyExpression)axiom.getProperty();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (!outputMultiValueArguments.containsKey(0)) continue;
            outputMultiValueArguments.get(0).addArgument(this.createObjectPropertyExpressionBuiltInArgument(candidateValue1));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean ifopa(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.OBJECT_PROPERTY_EXPRESSION);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLInverseFunctionalObjectPropertyAxiom axiom : axioms) {
            OWLObjectPropertyExpression candidateValue1 = (OWLObjectPropertyExpression)axiom.getProperty();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (!outputMultiValueArguments.containsKey(0)) continue;
            outputMultiValueArguments.get(0).addArgument(this.createObjectPropertyExpressionBuiltInArgument(candidateValue1));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean fdpa(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(1, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.FUNCTIONAL_DATA_PROPERTY, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.DATA_PROPERTY_EXPRESSION);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLFunctionalDataPropertyAxiom axiom : axioms) {
            OWLDataPropertyExpression candidateValue1 = (OWLDataPropertyExpression)axiom.getProperty();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (!outputMultiValueArguments.containsKey(0)) continue;
            outputMultiValueArguments.get(0).addArgument(this.createDataPropertyExpressionBuiltInArgument(candidateValue1));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean opda(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.OBJECT_PROPERTY_DOMAIN, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.OBJECT_PROPERTY_EXPRESSION, SWRLBuiltInArgumentType.CLASS_EXPRESSION);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLObjectPropertyDomainAxiom axiom : axioms) {
            OWLObjectPropertyExpression candidateValue1 = (OWLObjectPropertyExpression)axiom.getProperty();
            OWLClassExpression candidateValue2 = axiom.getDomain();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createObjectPropertyExpressionBuiltInArgument(candidateValue1));
            }
            if (!outputMultiValueArguments.containsKey(1)) continue;
            outputMultiValueArguments.get(1).addArgument(this.createClassExpressionBuiltInArgument(candidateValue2));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean opra(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.OBJECT_PROPERTY_RANGE, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.OBJECT_PROPERTY_EXPRESSION, SWRLBuiltInArgumentType.CLASS_EXPRESSION);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLObjectPropertyRangeAxiom axiom : axioms) {
            OWLObjectPropertyExpression candidateValue1 = (OWLObjectPropertyExpression)axiom.getProperty();
            OWLClassExpression candidateValue2 = (OWLClassExpression)axiom.getRange();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createObjectPropertyExpressionBuiltInArgument(candidateValue1));
            }
            if (!outputMultiValueArguments.containsKey(1)) continue;
            outputMultiValueArguments.get(1).addArgument(this.createClassExpressionBuiltInArgument(candidateValue2));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean dpda(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(2, arguments.size());
        Set axioms = this.getBuiltInBridge().getOWLOntology().getAxioms(AxiomType.DATA_PROPERTY_DOMAIN, Imports.INCLUDED);
        if (axioms.isEmpty()) {
            return false;
        }
        Map<@NonNull Integer, @NonNull OWLObject> inputArgumentValues = this.getInputArgumentValues(arguments, SWRLBuiltInArgumentType.DATA_PROPERTY_EXPRESSION, SWRLBuiltInArgumentType.CLASS_EXPRESSION);
        Map<@NonNull Integer, @NonNull SWRLMultiValueVariableBuiltInArgument> outputMultiValueArguments = this.createOutputMultiValueArguments(arguments);
        for (OWLDataPropertyDomainAxiom axiom : axioms) {
            OWLDataPropertyExpression candidateValue1 = (OWLDataPropertyExpression)axiom.getProperty();
            OWLClassExpression candidateValue2 = axiom.getDomain();
            if (this.noBoundArgumentsMismatch(inputArgumentValues, new OWLObject[]{candidateValue1, candidateValue2})) continue;
            if (outputMultiValueArguments.isEmpty()) {
                return true;
            }
            if (outputMultiValueArguments.containsKey(0)) {
                outputMultiValueArguments.get(0).addArgument(this.createDataPropertyExpressionBuiltInArgument(candidateValue1));
            }
            if (!outputMultiValueArguments.containsKey(1)) continue;
            outputMultiValueArguments.get(1).addArgument(this.createClassExpressionBuiltInArgument(candidateValue2));
        }
        return this.processResultMultiValueArguments(arguments, outputMultiValueArguments);
    }

    public boolean dpra(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException("tbox:dpra built-in not implemented");
    }

    public boolean dua(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException("tbox:dua built-in not implemented");
    }

    public boolean dda(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException("tbox:dda built-in not implemented");
    }

    public boolean hka(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        throw new SWRLBuiltInNotImplementedException("tbox:hka axiom not implemented");
    }

    private boolean noBoundArgumentsMismatch(@NonNull Map<Integer, @NonNull OWLObject> inputArgumentValues, OWLObject ... candidateValues) throws SWRLBuiltInException {
        for (int argumentNumber : inputArgumentValues.keySet()) {
            OWLObject inputArgumentValue = inputArgumentValues.get(argumentNumber);
            if (inputArgumentValue.equals(candidateValues[argumentNumber])) continue;
            return true;
        }
        return false;
    }
}

