/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.temporal;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.builtins.temporal.Temporal;
import org.swrlapi.builtins.temporal.TemporalException;

abstract class DatetimeStringProcessor {
    private final @NonNull SimpleDateFormat dateFormat;
    private final @NonNull String delimiters;
    private final @NonNull int[] gTokenIndex;
    private final @NonNull String[] datetimeRoundDownPadding;
    private final @NonNull String[] datetimeRoundUpPadding;

    DatetimeStringProcessor(@NonNull SimpleDateFormat dateFormat, @NonNull String delimiters, @NonNull int[] gTokenIndex, @NonNull String[] datetimeRoundDownPadding, @NonNull String[] datetimeRoundUpPadding) {
        this.dateFormat = dateFormat;
        this.delimiters = delimiters;
        this.gTokenIndex = (int[])gTokenIndex.clone();
        this.datetimeRoundUpPadding = (String[])datetimeRoundUpPadding.clone();
        this.datetimeRoundDownPadding = (String[])datetimeRoundDownPadding.clone();
    }

    protected abstract @NonNull String constructDatetimeStringFromMillisecondsFrom1970Count(long var1);

    public @NonNull String granuleCount2DatetimeString(long granuleCount, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        long granuleCountInMilliSeconds = Temporal.convertGranuleCount(granuleCount, granularity, 6);
        return this.constructDatetimeStringFromMillisecondsFrom1970Count(granuleCountInMilliSeconds - 62167392000000L);
    }

    public @NonNull String expressDatetimeStringAtGranularity(@NonNull String datetimeString, int granularity, boolean roundUp) throws TemporalException {
        String localDatetimeString = this.stripDatetimeString(datetimeString, granularity);
        return this.padDatetimeString(localDatetimeString, roundUp);
    }

    public @NonNull String expressDatetimeStringAtGranularity(@NonNull String datetimeString, int granularity) throws TemporalException {
        return this.expressDatetimeStringAtGranularity(datetimeString, granularity, false);
    }

    private void checkDatetimeString(@NonNull String datetimeString) throws TemporalException {
        String localDatetimeString = datetimeString.trim();
        Date date = this.dateFormat.parse(localDatetimeString, new ParsePosition(0));
        if (date == null) {
            Temporal.throwInvalidDatetimeStringException(datetimeString);
        }
    }

    public @NonNull String normalizeDatetimeString(@NonNull String datetimeString, int granularity, boolean roundUp) throws TemporalException {
        String localDatetimeString = this.stripDatetimeString(datetimeString.trim(), granularity);
        String normalizedDatetimeString = this.padDatetimeString(localDatetimeString, roundUp);
        this.checkDatetimeString(normalizedDatetimeString);
        return normalizedDatetimeString;
    }

    public @NonNull String normalizeDatetimeString(@NonNull String datetime, int granularity) throws TemporalException {
        return this.normalizeDatetimeString(datetime, granularity, false);
    }

    public @NonNull String normalizeDatetimeString(@NonNull String datetime) throws TemporalException {
        return this.normalizeDatetimeString(datetime, 6, false);
    }

    private @NonNull String padDatetimeString(@NonNull String datetimeString, boolean roundUp) throws TemporalException {
        StringTokenizer tokenizer = new StringTokenizer(datetimeString.trim(), this.delimiters);
        int numberOfTokens = tokenizer.countTokens();
        if (numberOfTokens == 0) {
            Temporal.throwInvalidDatetimeStringException(datetimeString);
        }
        int granularity = numberOfTokens - 1;
        String token = tokenizer.nextToken().trim();
        long yearCount = Long.parseLong(token);
        if (roundUp) {
            if (granularity != 1) {
                return datetimeString.trim() + this.datetimeRoundUpPadding[granularity];
            }
            token = tokenizer.nextToken().trim();
            long monthCount = Long.parseLong(token);
            Temporal.checkMonthCount(monthCount);
            long daysInMonth = Temporal.getDaysInMonth(monthCount);
            if (Temporal.isLeapYear(yearCount) && monthCount == 2L) {
                ++daysInMonth;
            }
            return datetimeString.trim() + "-" + daysInMonth + this.datetimeRoundUpPadding[2];
        }
        return datetimeString.trim() + this.datetimeRoundDownPadding[granularity];
    }

    public @NonNull String stripDatetimeString(@NonNull String datetimeString, int granularity) throws TemporalException {
        String strippedDatetimeString = "";
        Temporal.checkGranularity(granularity);
        StringTokenizer tokenizer = new StringTokenizer(datetimeString, this.delimiters, true);
        int numberOfTokens = tokenizer.countTokens();
        if (numberOfTokens == 0) {
            Temporal.throwInvalidDatetimeStringException(datetimeString);
        }
        if (numberOfTokens <= this.gTokenIndex[granularity]) {
            strippedDatetimeString = datetimeString;
        } else {
            try {
                for (int i = 0; i < this.gTokenIndex[granularity] && tokenizer.hasMoreTokens(); ++i) {
                    strippedDatetimeString = strippedDatetimeString + tokenizer.nextToken();
                }
            }
            catch (Exception e) {
                Temporal.throwInvalidDatetimeStringException(datetimeString);
            }
        }
        return strippedDatetimeString;
    }

    public int getFinestSpecifiedGranularity(@NonNull String datetimeString) throws TemporalException {
        StringTokenizer tokenizer = new StringTokenizer(datetimeString, this.delimiters, true);
        int numberOfTokens = tokenizer.countTokens();
        int granularity = -1;
        for (int i = 0; i < this.gTokenIndex.length; ++i) {
            if (numberOfTokens != this.gTokenIndex[i]) continue;
            granularity = i;
            break;
        }
        if (granularity == -1) {
            Temporal.throwInvalidDatetimeStringException(datetimeString);
        }
        return granularity;
    }

    public int getYears(@NonNull String datetimeString) throws TemporalException {
        return this.getTimeComponent(datetimeString, 0);
    }

    public int getMonths(@NonNull String datetimeString) throws TemporalException {
        return this.getTimeComponent(datetimeString, 1);
    }

    public int getDays(@NonNull String datetimeString) throws TemporalException {
        return this.getTimeComponent(datetimeString, 2);
    }

    public int getHours(@NonNull String datetimeString) throws TemporalException {
        return this.getTimeComponent(datetimeString, 3);
    }

    public int getMinutes(@NonNull String datetimeString) throws TemporalException {
        return this.getTimeComponent(datetimeString, 4);
    }

    public int getSeconds(@NonNull String datetimeString) throws TemporalException {
        return this.getTimeComponent(datetimeString, 5);
    }

    public int getMilliseconds(@NonNull String datetimeString) throws TemporalException {
        return this.getTimeComponent(datetimeString, 6);
    }

    private int getTimeComponent(@NonNull String datetimeString, int granularity) throws TemporalException {
        int result = -1;
        Temporal.checkGranularity(granularity);
        StringTokenizer tokenizer = new StringTokenizer(datetimeString, this.delimiters, true);
        int numberOfTokens = tokenizer.countTokens();
        if (numberOfTokens == 0) {
            Temporal.throwInvalidDatetimeStringException(datetimeString);
        }
        if (numberOfTokens < this.gTokenIndex[granularity]) {
            throw new TemporalException("cannot extract " + Temporal.getStringGranularityRepresentation(granularity) + " from incomplete datetime " + datetimeString);
        }
        try {
            int i = 1;
            while (i++ < this.gTokenIndex[granularity]) {
                tokenizer.nextToken();
            }
            return Integer.valueOf(tokenizer.nextToken());
        }
        catch (Exception e) {
            Temporal.throwInvalidDatetimeStringException(datetimeString);
            return result;
        }
    }
}

