/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.temporal;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.swrlapi.builtins.temporal.Temporal;
import org.swrlapi.builtins.temporal.TemporalException;

class Instant {
    private final @NonNull Temporal temporal;
    private long granuleCount;
    private int granularity;
    private final long[] granuleCountArray = new long[7];

    public Instant(@NonNull Temporal temporal, long granuleCount, int granularity) {
        this.temporal = temporal;
        this.granuleCount = granuleCount;
        this.granularity = granularity;
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }

    public Instant(@NonNull Temporal temporal, @NonNull Timestamp timestamp) throws TemporalException {
        this(temporal, timestamp, 6);
    }

    public Instant(@NonNull Temporal temporal, @NonNull Timestamp timestamp, int granularity) throws TemporalException {
        this.temporal = temporal;
        this.granuleCount = temporal.sqlTimestamp2GranuleCount(timestamp, granularity);
        this.granularity = granularity;
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }

    public Instant(@NonNull Temporal temporal, @NonNull Date date) throws TemporalException {
        this(temporal, date, 6);
    }

    public Instant(@NonNull Temporal temporal, @NonNull Date date, int granularity) throws TemporalException {
        this.temporal = temporal;
        this.granuleCount = Temporal.utilDate2GranuleCount(date, granularity);
        this.granularity = granularity;
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }

    public Instant(@NonNull Temporal temporal, @NonNull java.sql.Date date) throws TemporalException {
        this(temporal, date, 6);
    }

    public Instant(@NonNull Temporal temporal, @NonNull java.sql.Date date, int granularity) throws TemporalException {
        this.temporal = temporal;
        this.granuleCount = Temporal.sqlDate2GranuleCount(date, granularity);
        this.granularity = granularity;
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }

    public Instant(@NonNull Temporal t, @NonNull String datetimeString, int g, boolean roundUp) throws TemporalException {
        String localDatetimeString = datetimeString.equals("now") ? t.getNowDatetimeString() : datetimeString.trim();
        localDatetimeString = t.normalizeDatetimeString(localDatetimeString, g, roundUp);
        localDatetimeString = t.expressDatetimeStringAtGranularity(localDatetimeString, g);
        this.temporal = t;
        this.granularity = g;
        this.granuleCount = t.datetimeString2GranuleCount(localDatetimeString, g);
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }

    public Instant(@NonNull Temporal temporal, @NonNull String datetimeString, int granularity) throws TemporalException {
        this(temporal, datetimeString, granularity, false);
    }

    public Instant(@NonNull Temporal temporal, @NonNull String datetimeString) throws TemporalException {
        this(temporal, datetimeString, 6, false);
    }

    public Instant(@NonNull Temporal temporal, @NonNull String datetimeString, boolean roundUp) throws TemporalException {
        this(temporal, datetimeString, 6, roundUp);
    }

    public Instant(@NonNull Temporal temporal, @NonNull Instant instant) throws TemporalException {
        this(temporal, instant.getGranuleCount(instant.getGranularity()), instant.getGranularity());
    }

    public int getGranularity() {
        return this.granularity;
    }

    public void setGranularity(int granularity) throws TemporalException {
        if (this.granularity == granularity) {
            return;
        }
        this.granuleCount = Temporal.convertGranuleCount(this.granuleCount, this.granularity, granularity);
        this.granularity = granularity;
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }

    public void setGranuleCount(long granuleCount, int granularity) {
        this.granuleCount = granuleCount;
        this.granularity = granularity;
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }

    public long getGranuleCount() {
        return this.granuleCount;
    }

    public long getGranuleCount(int g) throws TemporalException {
        long resultGranuleCount;
        if (this.getGranularity() != g) {
            if (this.granuleCountArray[g] == -1L) {
                this.granuleCountArray[g] = resultGranuleCount = Temporal.convertGranuleCount(this.granuleCount, this.getGranularity(), g);
            } else {
                resultGranuleCount = this.granuleCountArray[g];
            }
        } else {
            resultGranuleCount = this.getGranuleCount();
        }
        return resultGranuleCount;
    }

    public @NonNull String getDatetimeString() throws TemporalException {
        return this.getDatetimeString(6);
    }

    public @NonNull String getDatetimeString(int g) throws TemporalException {
        long localGranuleCount = this.getGranuleCount(g);
        return this.temporal.stripDatetimeString(this.temporal.granuleCount2DatetimeString(localGranuleCount, g), g);
    }

    public Date getUtilDate() throws TemporalException {
        return this.getUtilDate(this.granularity);
    }

    public Date getUtilDate(int g) throws TemporalException {
        long localGranuleCount = this.granuleCount;
        return Temporal.granuleCount2UtilDate(localGranuleCount, g);
    }

    public java.sql.Date getSQLDate() throws TemporalException {
        return this.getSQLDate(this.granularity);
    }

    public java.sql.Date getSQLDate(int g) throws TemporalException {
        long localGranuleCount = this.granuleCount;
        return Temporal.granuleCount2SQLDate(localGranuleCount, g);
    }

    public boolean isStartOfTime() {
        return this.granuleCount == 0L;
    }

    @SideEffectFree
    public @NonNull String toString(int g) throws TemporalException {
        return this.getDatetimeString(g);
    }

    @SideEffectFree
    public @NonNull String toString() {
        try {
            return this.toString(6);
        }
        catch (TemporalException e) {
            return "<INVALID_INSTANT: " + e.toString() + ">";
        }
    }

    public void addGranuleCount(long gc, int g) throws TemporalException {
        long plusGranuleCount = Temporal.convertGranuleCount(gc, g, this.granularity);
        this.granuleCount = this.getGranuleCount() + plusGranuleCount;
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }

    public void subtractGranuleCount(long gc, int g) throws TemporalException {
        long subtractGranuleCount = Temporal.convertGranuleCount(gc, g, this.granularity);
        this.granuleCount -= subtractGranuleCount;
        for (int i = 0; i < 7; ++i) {
            this.granuleCountArray[i] = -1L;
        }
    }

    public long duration(@NonNull Instant i2, int g) throws TemporalException {
        return Math.abs(this.getGranuleCount(g) - i2.getGranuleCount(g));
    }

    public boolean before(@NonNull Instant i2, int g) throws TemporalException {
        return this.getGranuleCount(g) < i2.getGranuleCount(g);
    }

    public boolean after(@NonNull Instant i2, int g) throws TemporalException {
        return this.getGranuleCount(g) > i2.getGranuleCount(g);
    }

    public boolean equals(@NonNull Instant i2, int g) throws TemporalException {
        return this.getGranuleCount(g) == i2.getGranuleCount(g);
    }

    public boolean meets(@NonNull Instant i2, int g) throws TemporalException {
        return this.getGranuleCount(g) + 1L == i2.getGranuleCount(g) || this.getGranuleCount(g) == i2.getGranuleCount(g);
    }

    public boolean met_by(@NonNull Instant i2, int g) throws TemporalException {
        return i2.meets(this, g);
    }

    public boolean adjacent(@NonNull Instant i2, int g) throws TemporalException {
        return this.meets(i2, g) || this.met_by(i2, g);
    }

    public boolean overlaps(Instant i2, int g) throws TemporalException {
        Temporal.checkGranularity(g);
        return false;
    }

    public boolean overlapped_by(@NonNull Instant i2, int g) throws TemporalException {
        return i2.overlaps(this, g);
    }

    public boolean contains(Instant i2, int g) throws TemporalException {
        Temporal.checkGranularity(g);
        return false;
    }

    public boolean during(Instant i2, int g) throws TemporalException {
        Temporal.checkGranularity(g);
        return false;
    }

    public boolean starts(Instant i2, int g) throws TemporalException {
        Temporal.checkGranularity(g);
        return false;
    }

    public boolean started_by(@NonNull Instant i2, int g) throws TemporalException {
        return i2.starts(this, g);
    }

    public boolean finishes(Instant i2, int g) throws TemporalException {
        Temporal.checkGranularity(g);
        return false;
    }

    public boolean finished_by(@NonNull Instant i2, int g) throws TemporalException {
        return i2.finishes(this, g);
    }

    public @NonNull List<@NonNull Instant> coalesce(@NonNull List<@NonNull Instant> instants, int g) throws TemporalException {
        ArrayList<@NonNull Instant> resultList = new ArrayList<Instant>();
        while (!instants.isEmpty()) {
            Instant i1 = instants.get(0);
            instants.remove(0);
            Iterator<@NonNull Instant> iterator = instants.iterator();
            while (iterator.hasNext()) {
                Instant i2 = iterator.next();
                if (!i1.equals(i2, g)) continue;
                iterator.remove();
            }
            resultList.add(i1);
        }
        return resultList;
    }
}

