/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.temporal;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.swrlapi.builtins.temporal.Instant;
import org.swrlapi.builtins.temporal.Temporal;
import org.swrlapi.builtins.temporal.TemporalException;

public class Period {
    private @NonNull Instant startInstant;
    private @NonNull Instant finishInstant;
    private final @NonNull Temporal temporal;

    public Period(@NonNull Temporal temporal, long startGranuleCount, long finishGranuleCount, int granularity) throws TemporalException {
        this.temporal = temporal;
        this.startInstant = new Instant(temporal, startGranuleCount, granularity);
        this.finishInstant = new Instant(temporal, finishGranuleCount, granularity);
        Period.orderCheck(this.startInstant, this.finishInstant);
    }

    public Period(@NonNull Temporal temporal, @NonNull String startDatetime, @NonNull String finishDatetime, int granularity) throws TemporalException {
        this.temporal = temporal;
        Period.semanticCheck(startDatetime, finishDatetime);
        this.startInstant = new Instant(temporal, startDatetime, granularity, false);
        this.finishInstant = new Instant(temporal, finishDatetime, granularity, false);
        Period.orderCheck(this.startInstant, this.finishInstant);
    }

    public Period(@NonNull Temporal temporal, @NonNull String startDatetime, @NonNull String finishDatetime) throws TemporalException {
        this(temporal, startDatetime, finishDatetime, 6);
    }

    public Period(@NonNull Temporal temporal, @NonNull Period period) throws TemporalException {
        this(temporal, period.getStartGranuleCount(period.getGranularity()), period.getFinishGranuleCount(period.getGranularity()), period.getGranularity());
    }

    public Period(@NonNull Temporal temporal, @NonNull Instant instant, int granularity) throws TemporalException {
        this(temporal, instant, instant, granularity);
    }

    public Period(@NonNull Temporal temporal, @NonNull Instant instant) throws TemporalException {
        this(temporal, instant, instant, instant.getGranularity());
    }

    public Period(@NonNull Temporal temporal, @NonNull Instant startInstant, @NonNull Instant finishInstant, int granularity) throws TemporalException {
        this.temporal = temporal;
        this.startInstant = new Instant(temporal, startInstant);
        this.finishInstant = new Instant(temporal, finishInstant);
        this.startInstant.setGranularity(granularity);
        this.finishInstant.setGranularity(granularity);
        Period.orderCheck(this.startInstant, this.finishInstant);
    }

    public Period(@NonNull Temporal temporal, @NonNull Instant startInstant, @NonNull Instant finishInstant) throws TemporalException {
        this.temporal = temporal;
        this.startInstant = new Instant(temporal, startInstant);
        this.finishInstant = new Instant(temporal, finishInstant);
        int granularity = startInstant.getGranularity() > finishInstant.getGranularity() ? startInstant.getGranularity() : finishInstant.getGranularity();
        this.startInstant.setGranularity(granularity);
        this.finishInstant.setGranularity(granularity);
        Period.orderCheck(this.startInstant, this.finishInstant);
    }

    public Period(@NonNull Temporal temporal, @NonNull Timestamp startTimestamp, @NonNull Timestamp finishTimestamp, int granularity) throws TemporalException {
        this.temporal = temporal;
        this.startInstant = new Instant(temporal, startTimestamp, granularity);
        this.finishInstant = new Instant(temporal, finishTimestamp, granularity);
        Period.orderCheck(this.startInstant, this.finishInstant);
    }

    public Period(@NonNull Temporal temporal, @NonNull Timestamp startTimestamp, @NonNull Timestamp finishTimestamp) throws TemporalException {
        this(temporal, startTimestamp, finishTimestamp, 6);
    }

    public Period(@NonNull Temporal temporal, @NonNull Date startDate, @NonNull Date finishDate, int granularity) throws TemporalException {
        this.temporal = temporal;
        this.startInstant = new Instant(temporal, startDate, granularity);
        this.finishInstant = new Instant(temporal, finishDate, granularity);
        Period.orderCheck(this.startInstant, this.finishInstant);
    }

    public Period(@NonNull Temporal temporal, @NonNull Date startDate, @NonNull Date finishDate) throws TemporalException {
        this(temporal, startDate, finishDate, 6);
    }

    public Period(@NonNull Temporal temporal, @NonNull java.sql.Date startDate, @NonNull java.sql.Date finishDate, int granularity) throws TemporalException {
        this.temporal = temporal;
        this.startInstant = new Instant(temporal, startDate, granularity);
        this.finishInstant = new Instant(temporal, finishDate, granularity);
        Period.orderCheck(this.startInstant, this.finishInstant);
    }

    public Period(@NonNull Temporal temporal, @NonNull java.sql.Date startDate, @NonNull java.sql.Date finishDate) throws TemporalException {
        this(temporal, startDate, finishDate, 6);
    }

    public boolean before(@NonNull Period p2, int granularity) throws TemporalException {
        return this.getFinishGranuleCount(granularity) < p2.getStartGranuleCount(granularity);
    }

    public boolean before(@NonNull Period p2) throws TemporalException {
        return this.getFinishGranuleCount(6) < p2.getStartGranuleCount(6);
    }

    public boolean starts_before(@NonNull Period p2, int granularity) throws TemporalException {
        return this.getStartGranuleCount(granularity) < p2.getStartGranuleCount(granularity);
    }

    public boolean starts_after(@NonNull Period p2, int granularity) throws TemporalException {
        return this.getStartGranuleCount(granularity) > p2.getFinishGranuleCount(granularity);
    }

    public boolean starts_after(@NonNull Period p2) throws TemporalException {
        return this.getStartGranuleCount(6) > p2.getFinishGranuleCount(6);
    }

    public boolean after(@NonNull Period p2, int granularity) throws TemporalException {
        return this.getStartGranuleCount(granularity) > p2.getFinishGranuleCount(granularity);
    }

    public boolean equals(@NonNull Period p2, int granularity) throws TemporalException {
        return this.getStartGranuleCount(granularity) == p2.getStartGranuleCount(granularity) && this.getFinishGranuleCount(granularity) == p2.getFinishGranuleCount(granularity);
    }

    public boolean meets(@NonNull Period p2) throws TemporalException {
        return this.meets(p2, 6);
    }

    public boolean meets(@NonNull Period p2, int granularity) throws TemporalException {
        return this.getFinishGranuleCount(granularity) + 1L == p2.getStartGranuleCount(granularity);
    }

    public boolean met_by(@NonNull Period p2) throws TemporalException {
        return this.met_by(p2, 6);
    }

    public boolean met_by(@NonNull Period p2, int granularity) throws TemporalException {
        return p2.meets(this, granularity);
    }

    public boolean overlaps(@NonNull Period p2) throws TemporalException {
        return this.overlaps(p2, 6);
    }

    public boolean overlaps(@NonNull Period p2, int granularity) throws TemporalException {
        return this.getStartGranuleCount(granularity) <= p2.getStartGranuleCount(granularity) && this.getFinishGranuleCount(granularity) <= p2.getFinishGranuleCount(granularity) && this.getFinishGranuleCount(granularity) >= p2.getStartGranuleCount(granularity);
    }

    public boolean overlapped_by(@NonNull Period p2) throws TemporalException {
        return this.overlapped_by(p2, 6);
    }

    public boolean overlapped_by(@NonNull Period p2, int granularity) throws TemporalException {
        return p2.overlaps(this, granularity);
    }

    public boolean during(@NonNull Period p2) throws TemporalException {
        return this.during(p2, 6);
    }

    public boolean during(@NonNull Period p2, int granularity) throws TemporalException {
        return p2.contains(this, granularity) && !p2.equals(this, granularity);
    }

    public boolean contains(@NonNull Period p2) throws TemporalException {
        return this.contains(p2, 6);
    }

    public boolean contains(@NonNull Period p2, int granularity) throws TemporalException {
        return !(p2.getStartGranuleCount(granularity) <= this.getStartGranuleCount(granularity) && p2.getStartGranuleCount(granularity) != this.getStartGranuleCount(granularity) || p2.getFinishGranuleCount(granularity) >= this.getFinishGranuleCount(granularity) && p2.getFinishGranuleCount(granularity) != this.getFinishGranuleCount(granularity));
    }

    public boolean starts(@NonNull Period p2) throws TemporalException {
        return this.starts(p2, 6);
    }

    public boolean starts(@NonNull Period p2, int granularity) throws TemporalException {
        return this.getStartGranuleCount(granularity) == p2.getStartGranuleCount(granularity) && this.getFinishGranuleCount(granularity) < p2.getFinishGranuleCount(granularity);
    }

    public boolean started_by(@NonNull Period p2) throws TemporalException {
        return this.started_by(p2, 6);
    }

    public boolean started_by(@NonNull Period p2, int granularity) throws TemporalException {
        return p2.starts(this, granularity);
    }

    public boolean finishes(@NonNull Period p2) throws TemporalException {
        return this.finishes(p2, 6);
    }

    public boolean finishes(@NonNull Period p2, int granularity) throws TemporalException {
        return this.getStartGranuleCount(granularity) < p2.getStartGranuleCount(granularity) && this.getFinishGranuleCount(granularity) == p2.getFinishGranuleCount(granularity);
    }

    public boolean finished_by(@NonNull Period p2) throws TemporalException {
        return this.finished_by(p2, 6);
    }

    public boolean finished_by(@NonNull Period p2, int granularity) throws TemporalException {
        return p2.finishes(this, granularity);
    }

    public boolean adjacent(@NonNull Period p2) throws TemporalException {
        return this.adjacent(p2, 6);
    }

    public boolean adjacent(@NonNull Period p2, int granularity) throws TemporalException {
        return this.meets(p2, granularity) || this.met_by(p2, granularity);
    }

    public boolean intersects(@NonNull Period p2) throws TemporalException {
        return this.intersects(p2, 6);
    }

    public boolean intersects(@NonNull Period p2, int granularity) throws TemporalException {
        return this.intersection(p2, granularity) != null;
    }

    public @Nullable Period intersection(@NonNull Period p2) throws TemporalException {
        return this.intersection(p2, 6);
    }

    public @Nullable Period intersection(@NonNull Period p2, int granularity) throws TemporalException {
        Period result = this.startInstant.equals(p2.getStartInstant(), granularity) ? (this.finishInstant.after(p2.getFinishInstant(), granularity) ? new Period(this.temporal, this.startInstant, p2.getFinishInstant(), granularity) : new Period(this.temporal, this.startInstant, this.finishInstant, granularity)) : (this.startInstant.before(p2.getStartInstant(), granularity) ? (this.finishInstant.after(p2.getStartInstant(), granularity) ? (this.finishInstant.before(p2.getFinishInstant(), granularity) ? new Period(this.temporal, p2.getStartInstant(), this.finishInstant, granularity) : new Period(this.temporal, p2.getStartInstant(), p2.getFinishInstant(), granularity)) : null) : (p2.getFinishInstant().after(this.startInstant, granularity) ? (this.finishInstant.before(p2.getFinishInstant(), granularity) ? new Period(this.temporal, this.startInstant, this.finishInstant, granularity) : new Period(this.temporal, this.startInstant, p2.getFinishInstant(), granularity)) : null));
        return result;
    }

    public @NonNull Period merge(@NonNull Period p2) throws TemporalException {
        return this.merge(p2, 6);
    }

    public @NonNull Period merge(@NonNull Period p2, int granularity) throws TemporalException {
        if (this.intersection(p2, granularity) == null && !this.adjacent(p2, granularity)) {
            throw new TemporalException("start must be before or equal to the finish in a period: ('" + this.toString(granularity) + "'), ('" + p2.toString(granularity) + "')");
        }
        Instant resultStartInstant = this.startInstant.before(p2.getStartInstant(), granularity) ? this.startInstant : p2.getStartInstant();
        Instant resultFinishInstant = this.getFinishInstant().before(p2.getFinishInstant(), granularity) ? p2.getFinishInstant() : this.finishInstant;
        Period result = new Period(this.temporal, resultStartInstant, resultFinishInstant, granularity);
        return result;
    }

    private static void orderCheck(@NonNull Instant startInstant, @NonNull Instant finishInstant) throws TemporalException {
        if (startInstant.after(finishInstant, 6)) {
            throw new TemporalException("start must be before or equal to finish in a period: (" + startInstant.toString(6) + ", " + finishInstant.toString(6) + ")");
        }
    }

    public long duration(int granularity) throws TemporalException {
        return this.startInstant.duration(this.finishInstant, granularity);
    }

    public @NonNull List<@NonNull Period> coalesce(@NonNull List<@NonNull Period> periods, int granularity) throws TemporalException {
        ArrayList<@NonNull Period> resultList = new ArrayList<Period>();
        while (!periods.isEmpty()) {
            boolean periodMerged;
            Period p1 = periods.get(0);
            periods.remove(0);
            do {
                periodMerged = false;
                Iterator<Period> iterator = periods.iterator();
                while (!periodMerged && iterator.hasNext()) {
                    Period p2 = iterator.next();
                    if (!p1.intersects(p2, granularity) && !p1.adjacent(p2, granularity)) continue;
                    p1 = p1.merge(p2, granularity);
                    iterator.remove();
                    periodMerged = true;
                }
            } while (periodMerged);
            resultList.add(p1);
        }
        return resultList;
    }

    public void addGranuleCount(long granuleCount, int granularity) throws TemporalException {
        this.startInstant.addGranuleCount(granuleCount, granularity);
        this.finishInstant.addGranuleCount(granuleCount, granularity);
    }

    public void subtractGranuleCount(long granuleCount, int granularity) throws TemporalException {
        this.startInstant.subtractGranuleCount(granuleCount, granularity);
        this.finishInstant.subtractGranuleCount(granuleCount, granularity);
    }

    public void addStartGranuleCount(long granuleCount, int granularity) throws TemporalException {
        this.startInstant.addGranuleCount(granuleCount, granularity);
    }

    public void addFinishGranuleCount(long granuleCount, int granularity) throws TemporalException {
        this.finishInstant.addGranuleCount(granuleCount, granularity);
    }

    public void subtractStartGranuleCount(long granuleCount, int granularity) throws TemporalException {
        this.startInstant.subtractGranuleCount(granuleCount, granularity);
    }

    public void subtractFinishGranuleCount(long granuleCount, int granularity) throws TemporalException {
        this.finishInstant.subtractGranuleCount(granuleCount, granularity);
    }

    public @Nullable Period coalesce(@NonNull Period p2, int granularity) throws TemporalException {
        Period result = null;
        if (this.intersects(p2, granularity) || this.adjacent(p2, granularity)) {
            result = this.merge(p2, granularity);
        }
        return result;
    }

    public void setStartInstant(@NonNull Instant instant) throws TemporalException {
        this.startInstant = new Instant(this.temporal, instant);
        this.finishInstant.setGranularity(instant.getGranularity());
    }

    public void setFinishInstant(@NonNull Instant instant) throws TemporalException {
        this.finishInstant = new Instant(this.temporal, instant);
        this.startInstant.setGranularity(instant.getGranularity());
    }

    public String getStartDatetimeString() throws TemporalException {
        return this.startInstant.getDatetimeString();
    }

    public Date getStartDate() throws TemporalException {
        return this.startInstant.getUtilDate();
    }

    public Instant getStartInstant() {
        return this.startInstant;
    }

    public String getStartDatetimeString(int granularity) throws TemporalException {
        return this.startInstant.getDatetimeString(granularity);
    }

    public Date getStartDate(int granularity) throws TemporalException {
        return this.startInstant.getUtilDate(granularity);
    }

    public String getFinishDatetime() throws TemporalException {
        return this.finishInstant.getDatetimeString();
    }

    public Date getFinishDate() throws TemporalException {
        return this.finishInstant.getUtilDate();
    }

    public Instant getFinishInstant() {
        return this.finishInstant;
    }

    public String getFinishDatetime(int granularity) throws TemporalException {
        return this.finishInstant.getDatetimeString(granularity);
    }

    public Date getFinishDate(int granularity) throws TemporalException {
        return this.finishInstant.getUtilDate(granularity);
    }

    public long getStartGranuleCount(int granularity) throws TemporalException {
        return this.startInstant.getGranuleCount(granularity);
    }

    public long getFinishGranuleCount(int granularity) throws TemporalException {
        return this.finishInstant.getGranuleCount(granularity);
    }

    public boolean couldBeInstant() throws TemporalException {
        return this.startInstant.equals(this.finishInstant, 6);
    }

    @SideEffectFree
    public @NonNull String toString(int granularity) throws TemporalException {
        return "(" + this.startInstant.toString(granularity) + ", " + this.finishInstant.toString(granularity) + ")";
    }

    @SideEffectFree
    public @NonNull String toString() {
        try {
            return this.toString(6);
        }
        catch (TemporalException e) {
            return "";
        }
    }

    public int getGranularity() {
        return this.startInstant.getGranularity();
    }

    private static void semanticCheck(@NonNull String startDatetime, @NonNull String finishDatetime) throws TemporalException {
        if (startDatetime.equals("+")) {
            throw new TemporalException("'+' cannot be used at the start of a period");
        }
        if (finishDatetime.equals("-")) {
            throw new TemporalException("'-' cannot be used at the end of a period");
        }
    }
}

