/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.temporal;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.swrlapi.builtins.AbstractSWRLBuiltInLibrary;
import org.swrlapi.builtins.SWRLBuiltInBridge;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.temporal.Instant;
import org.swrlapi.builtins.temporal.Period;
import org.swrlapi.builtins.temporal.Temporal;
import org.swrlapi.builtins.temporal.TemporalException;
import org.swrlapi.builtins.temporal.XSDDateTimeStringProcessor;
import org.swrlapi.exceptions.InvalidSWRLBuiltInArgumentException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLBuiltInLibraryException;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;

public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static final String PREFIX = "temporal";
    private static final String NAMESPACE = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#";
    private static final String[] BUILT_IN_NAMES = new String[]{"notEquals", "notIntersects", "notStarts", "overlappedBy", "contains", "equals", "intersects", "finishedBy", "notDurationLessThanOrEqualTo", "notStartedBy", "notFinishedBy", "starts", "notContains", "notOverlaps", "durationLessThanOrEqualTo", "duration", "notFinishes", "metBy", "notDurationEqualTo", "before", "startedBy", "notMeets", "durationGreaterThanOrEqualTo", "notDuring", "notOverlappedBy", "during", "notDurationLessThan", "notBefore", "meets", "notDurationGreaterThan", "notDurationGreaterThanOrEqualTo", "add", "finishes", "notAfter", "durationEqualTo", "overlaps", "durationGreaterThan", "durationLessThan", "after", "notMetBy"};
    private static final String TemporalEquals = "temporal:equals";
    private static final String TemporalAfter = "temporal:after";
    private static final String TemporalBefore = "temporal:before";
    private static final String TemporalMeets = "temporal:meets";
    private static final String TemporalMetBy = "temporal:metBy";
    private static final String TemporalOverlaps = "temporal:overlaps";
    private static final String TemporalOverlappedBy = "temporal:overlappedBy";
    private static final String TemporalContains = "temporal:contains";
    private static final String TemporalDuring = "temporal:during";
    private static final String TemporalStarts = "temporal:starts";
    private static final String TemporalStartedBy = "temporal:startedBy";
    private static final String TemporalFinishes = "temporal:finishes";
    private static final String TemporalFinishedBy = "temporal:finishedBy";
    private static final String TemporalIntersects = "temporal:intersects";
    private static final String ExtendedPropositionClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ExtendedProposition";
    private static final String ValidInstantClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ValidInstant";
    private static final String ValidPeriodClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ValidPeriod";
    private static final String GranularityClassName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#Granularity";
    private static final String HasValidTimePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#hasValidTime";
    private static final String HasTimePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#hasTime";
    private static final String HasStartTimePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#hasStartTime";
    private static final String HasFinishTimePropertyName = "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#hasFinishTime";
    private final @NonNull Temporal temporal = new Temporal(new XSDDateTimeStringProcessor());

    public SWRLBuiltInLibraryImpl() {
        super(PREFIX, NAMESPACE, new HashSet<String>(Arrays.asList(BUILT_IN_NAMES)));
        this.temporal.setNow();
    }

    @Override
    public void reset() throws SWRLBuiltInLibraryException {
        this.temporal.setNow();
    }

    public boolean equals(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalEquals, arguments);
    }

    public boolean before(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalBefore, arguments);
    }

    public boolean after(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalAfter, arguments);
    }

    public boolean meets(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalMeets, arguments);
    }

    public boolean metBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalMetBy, arguments);
    }

    public boolean overlaps(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalOverlaps, arguments);
    }

    public boolean overlappedBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalOverlappedBy, arguments);
    }

    public boolean contains(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalContains, arguments);
    }

    public boolean during(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalDuring, arguments);
    }

    public boolean starts(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalStarts, arguments);
    }

    public boolean startedBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalStartedBy, arguments);
    }

    public boolean finishes(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalFinishes, arguments);
    }

    public boolean finishedBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalFinishedBy, arguments);
    }

    public boolean intersects(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.temporalOperation(TemporalIntersects, arguments);
    }

    public boolean notIntersects(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalIntersects, arguments);
    }

    public boolean notEquals(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalEquals, arguments);
    }

    public boolean notBefore(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalBefore, arguments);
    }

    public boolean notAfter(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalAfter, arguments);
    }

    public boolean notMeets(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalMeets, arguments);
    }

    public boolean notMetBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalMetBy, arguments);
    }

    public boolean notOverlaps(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalOverlaps, arguments);
    }

    public boolean notOverlappedBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalOverlappedBy, arguments);
    }

    public boolean notContains(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalContains, arguments);
    }

    public boolean notDuring(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalDuring, arguments);
    }

    public boolean notStarts(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalStarts, arguments);
    }

    public boolean notStartedBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalStartedBy, arguments);
    }

    public boolean notFinishes(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalFinishes, arguments);
    }

    public boolean notFinishedBy(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.temporalOperation(TemporalFinishedBy, arguments);
    }

    public boolean notDurationLessThan(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.durationLessThan(arguments);
    }

    public boolean notDurationLessThanOrEqualTo(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.durationLessThanOrEqualTo(arguments);
    }

    public boolean notDurationEqualTo(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.durationEqualTo(arguments);
    }

    public boolean notDurationGreaterThan(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.durationGreaterThan(arguments);
    }

    public boolean notDurationGreaterThanOrEqualTo(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return !this.durationGreaterThanOrEqualTo(arguments);
    }

    public boolean duration(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        long operationResult;
        this.checkNumberOfArgumentsInRange(3, 4, arguments.size());
        this.checkForUnboundNonFirstArguments(arguments);
        try {
            int numberOfArguments = arguments.size();
            if (numberOfArguments == 3) {
                int granularity = this.getBuiltInArgumentAsAGranularity(2, arguments);
                Period period = this.getArgumentAsAPeriod(1, arguments, granularity);
                operationResult = period.duration(granularity);
            } else {
                int granularity = this.getBuiltInArgumentAsAGranularity(3, arguments);
                Instant i1 = this.getArgumentAsAnInstant(1, arguments, granularity);
                Instant i2 = this.getArgumentAsAnInstant(2, arguments, granularity);
                operationResult = i1.duration(i2, granularity);
            }
        }
        catch (TemporalException e) {
            throw new SWRLBuiltInException(e.getMessage() == null ? "" : e.getMessage(), e);
        }
        if (this.isUnboundArgument(0, arguments)) {
            SWRLLiteralBuiltInArgument resultArgument = this.createLiteralBuiltInArgument(operationResult);
            arguments.get(0).asVariable().setBuiltInResult(resultArgument);
            return true;
        }
        long argument1 = this.convertArgumentToAPositiveLong(0, arguments);
        return argument1 == operationResult;
    }

    public boolean durationLessThan(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, arguments.size());
        this.checkForUnboundArguments(arguments);
        List<@NonNull SWRLBuiltInArgument> newArguments = this.cloneArguments(arguments);
        long argument1 = this.convertArgumentToALong(0, arguments);
        if (newArguments.get(0).isVariable()) {
            newArguments.get(0).asVariable().setUnbound();
        }
        this.duration(newArguments);
        long operationResult = this.convertArgumentToALong(0, newArguments);
        return argument1 < operationResult;
    }

    public boolean durationLessThanOrEqualTo(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, arguments.size());
        this.checkForUnboundArguments(arguments);
        List<@NonNull SWRLBuiltInArgument> newArguments = this.cloneArguments(arguments);
        long argument1 = this.convertArgumentToALong(0, arguments);
        if (newArguments.get(0).isVariable()) {
            newArguments.get(0).asVariable().setUnbound();
        }
        this.duration(newArguments);
        long operationResult = this.convertArgumentToALong(0, newArguments);
        return argument1 <= operationResult;
    }

    public boolean durationEqualTo(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, arguments.size());
        this.checkForUnboundArguments(arguments);
        List<@NonNull SWRLBuiltInArgument> newArguments = this.cloneArguments(arguments);
        long argument1 = this.convertArgumentToALong(0, arguments);
        if (newArguments.get(0).isVariable()) {
            newArguments.get(0).asVariable().setUnbound();
        }
        this.duration(newArguments);
        long operationResult = this.convertArgumentToALong(0, newArguments);
        return argument1 == operationResult;
    }

    public boolean durationGreaterThan(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, arguments.size());
        this.checkForUnboundArguments(arguments);
        List<@NonNull SWRLBuiltInArgument> newArguments = this.cloneArguments(arguments);
        long argument1 = this.convertArgumentToALong(0, arguments);
        if (newArguments.get(0).isVariable()) {
            newArguments.get(0).asVariable().setUnbound();
        }
        this.duration(newArguments);
        long operationResult = this.convertArgumentToALong(0, newArguments);
        return argument1 > operationResult;
    }

    public boolean durationGreaterThanOrEqualTo(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsInRange(3, 4, arguments.size());
        this.checkForUnboundArguments(arguments);
        List<@NonNull SWRLBuiltInArgument> newArguments = this.cloneArguments(arguments);
        long argument1 = this.convertArgumentToALong(0, arguments);
        if (newArguments.get(0).isVariable()) {
            newArguments.get(0).asVariable().setUnbound();
        }
        this.duration(newArguments);
        long operationResult = this.convertArgumentToALong(0, newArguments);
        return argument1 >= operationResult;
    }

    public boolean add(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsEqualTo(4, arguments.size());
        this.checkForUnboundNonFirstArguments(arguments);
        try {
            long granuleCount = this.convertArgumentToALong(2, arguments);
            int granularity = this.getBuiltInArgumentAsAGranularity(3, arguments);
            Instant operationResult = this.getArgumentAsAnInstant(1, arguments, 6);
            operationResult.addGranuleCount(granuleCount, granularity);
            if (this.isUnboundArgument(0, arguments)) {
                SWRLLiteralBuiltInArgument resultArgument = this.createLiteralBuiltInArgument(new XSDDateTime(operationResult.toString()));
                arguments.get(0).asVariable().setBuiltInResult(resultArgument);
                return true;
            }
            Instant argument1 = this.getArgumentAsAnInstant(0, arguments, granularity);
            return argument1.equals(operationResult, 6);
        }
        catch (TemporalException e) {
            throw new SWRLBuiltInException(e.getMessage() == null ? "" : e.getMessage(), e);
        }
    }

    private boolean temporalOperation(@NonNull String operation, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        this.checkNumberOfArgumentsInRange(2, 4, arguments.size());
        this.checkForUnboundArguments(arguments);
        try {
            int numberOfArguments = arguments.size();
            boolean hasGranularityArgument = this.isBuiltInArgumentAGranularity(numberOfArguments - 1, arguments);
            boolean has2nd3rdInstantArguments = hasGranularityArgument ? numberOfArguments > 3 : numberOfArguments > 2;
            int granularity = hasGranularityArgument ? this.getBuiltInArgumentAsAGranularity(numberOfArguments - 1, arguments) : 6;
            Period p1 = this.getArgumentAsAPeriod(0, arguments, granularity);
            Period p2 = has2nd3rdInstantArguments ? this.getTwoInstantArgumentsAsAPeriod(1, 2, arguments, granularity) : this.getArgumentAsAPeriod(1, arguments, granularity);
            switch (operation) {
                case "temporal:equals": {
                    return p1.equals(p2, granularity);
                }
                case "temporal:before": {
                    return p1.before(p2, granularity);
                }
                case "temporal:after": {
                    return p1.after(p2, granularity);
                }
                case "temporal:meets": {
                    return p1.meets(p2, granularity);
                }
                case "temporal:metBy": {
                    return p1.met_by(p2, granularity);
                }
                case "temporal:overlaps": {
                    return p1.overlaps(p2, granularity);
                }
                case "temporal:overlappedBy": {
                    return p1.overlapped_by(p2, granularity);
                }
                case "temporal:contains": {
                    return p1.contains(p2, granularity);
                }
                case "temporal:during": {
                    return p1.during(p2, granularity);
                }
                case "temporal:starts": {
                    return p1.starts(p2, granularity);
                }
                case "temporal:startedBy": {
                    return p1.started_by(p2, granularity);
                }
                case "temporal:finishes": {
                    return p1.finishes(p2, granularity);
                }
                case "temporal:finishedBy": {
                    return p1.finished_by(p2, granularity);
                }
                case "temporal:intersects": {
                    return p1.intersects(p2, granularity);
                }
            }
            throw new SWRLBuiltInException("internal error - unknown temporal operator " + operation);
        }
        catch (TemporalException e) {
            throw new SWRLBuiltInException(e.getMessage() == null ? "" : e.getMessage(), e);
        }
    }

    private @NonNull Period getTwoInstantArgumentsAsAPeriod(int firstArgumentNumber, int secondArgumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments, int granularity) throws SWRLBuiltInException, TemporalException {
        if (firstArgumentNumber >= arguments.size()) {
            throw new InvalidSWRLBuiltInArgumentException(firstArgumentNumber, "out of range");
        }
        if (secondArgumentNumber >= arguments.size()) {
            throw new InvalidSWRLBuiltInArgumentException(secondArgumentNumber, "out of range");
        }
        Instant i1 = this.getArgumentAsAnInstant(firstArgumentNumber, arguments, granularity);
        Instant i2 = this.getArgumentAsAnInstant(secondArgumentNumber, arguments, granularity);
        return new Period(this.temporal, i1, i2, granularity);
    }

    private @NonNull Period getArgumentAsAPeriod(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments, int granularity) throws SWRLBuiltInException, TemporalException {
        if (this.isArgumentALiteral(argumentNumber, arguments)) {
            String datetimeString;
            if (this.isArgumentAString(argumentNumber, arguments)) {
                datetimeString = this.getArgumentAsAString(argumentNumber, arguments);
            } else if (this.isArgumentADate(argumentNumber, arguments)) {
                datetimeString = this.getArgumentAsADate(argumentNumber, arguments).getContent();
            } else if (this.isArgumentADateTime(argumentNumber, arguments)) {
                datetimeString = this.getArgumentAsADateTime(argumentNumber, arguments).getContent();
            } else {
                throw new InvalidSWRLBuiltInArgumentException(argumentNumber, "expecting an xsd:date, an xsd:dateTime, or an xsd:string containing a correctly-formatted XSD date or datetime value, got " + arguments.get(argumentNumber));
            }
            return new Period(this.temporal, datetimeString, datetimeString, granularity);
        }
        if (this.isArgumentAnOWLNamedIndividual(argumentNumber, arguments)) {
            IRI individualIRI = this.getArgumentAsANamedIndividualIRI(argumentNumber, arguments);
            if (this.isOWLIndividualOfType(individualIRI, this.createIRI(ValidInstantClassName))) {
                Instant instant = this.validInstantIndividual2Instant(individualIRI, granularity);
                return new Period(this.temporal, instant, granularity);
            }
            if (this.isOWLIndividualOfType(individualIRI, this.createIRI(ValidPeriodClassName))) {
                return this.validPeriodIndividual2Period(individualIRI, granularity);
            }
            if (this.isOWLIndividualOfType(individualIRI, this.createIRI(ExtendedPropositionClassName))) {
                return this.extendedPropositionIndividual2Period(individualIRI, granularity);
            }
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, "individual " + individualIRI + " is not a " + ValidInstantClassName + " or " + ValidPeriodClassName + " or " + ExtendedPropositionClassName);
        }
        throw new InvalidSWRLBuiltInArgumentException(argumentNumber, "expecting xsd:date or xsd:datetime or http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ValidInstant or http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ValidPeriod or http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ExtendedProposition individual, got " + arguments.get(argumentNumber));
    }

    private @NonNull Instant getArgumentAsAnInstant(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments, int granularity) throws SWRLBuiltInException, TemporalException {
        if (this.isArgumentALiteral(argumentNumber, arguments)) {
            String datetimeString;
            if (this.isArgumentAString(argumentNumber, arguments)) {
                datetimeString = this.getArgumentAsAString(argumentNumber, arguments);
            } else if (this.isArgumentADate(argumentNumber, arguments)) {
                datetimeString = this.getArgumentAsADate(argumentNumber, arguments).getContent();
            } else if (this.isArgumentADateTime(argumentNumber, arguments)) {
                datetimeString = this.getArgumentAsADateTime(argumentNumber, arguments).getContent();
            } else {
                throw new InvalidSWRLBuiltInArgumentException(argumentNumber, "expecting an xsd:date, an xsd:dateTime, or an xsd:string containing a correctly-formatted XSD date or datetime value, got " + arguments.get(argumentNumber));
            }
            return new Instant(this.temporal, datetimeString, granularity);
        }
        if (this.isArgumentAnOWLNamedIndividual(argumentNumber, arguments)) {
            IRI individualIRI = this.getArgumentAsANamedIndividualIRI(argumentNumber, arguments);
            if (this.isOWLIndividualOfType(individualIRI, this.createIRI(ValidInstantClassName))) {
                return this.validInstantIndividual2Instant(individualIRI, granularity);
            }
            if (this.isOWLIndividualOfType(individualIRI, this.createIRI(ExtendedPropositionClassName))) {
                return this.extendedPropositionIndividual2Instant(individualIRI, granularity);
            }
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, "individual " + individualIRI + " is not a " + ValidInstantClassName + "or an " + ExtendedPropositionClassName);
        }
        throw new InvalidSWRLBuiltInArgumentException(argumentNumber, "expecting xsd:date or xsd:datetime or http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ValidInstant or http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#ExtendedProposition individual, got " + arguments.get(argumentNumber));
    }

    private int getBuiltInArgumentAsAGranularity(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws TemporalException, SWRLBuiltInException {
        if (this.isArgumentALiteral(argumentNumber, arguments)) {
            String granularityName = this.getArgumentAsAString(argumentNumber, arguments);
            return Temporal.getIntegerGranularityRepresentation(granularityName);
        }
        if (this.isArgumentAnOWLNamedIndividual(argumentNumber, arguments)) {
            SWRLNamedIndividualBuiltInArgument individualArgument = this.getArgumentAsANamedIndividual(argumentNumber, arguments);
            IRI individualIRI = individualArgument.getIRI();
            String fullName = individualIRI.toString();
            if (this.isOWLIndividualOfType(individualIRI, this.createIRI(GranularityClassName))) {
                int hashIndex = fullName.indexOf(35);
                String granularityName = hashIndex == -1 ? fullName : fullName.substring(hashIndex + 1, fullName.length());
                return Temporal.getIntegerGranularityRepresentation(granularityName);
            }
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, "individual " + individualIRI + " is not a " + GranularityClassName);
        }
        throw new InvalidSWRLBuiltInArgumentException(argumentNumber, "expecting a http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#Granularity individual, got " + arguments.get(argumentNumber));
    }

    private boolean isBuiltInArgumentAGranularity(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        if (this.isArgumentAString(argumentNumber, arguments)) {
            String granularityName = this.getArgumentAsAString(argumentNumber, arguments);
            return Temporal.isValidGranularityString(granularityName);
        }
        if (this.isArgumentAnOWLNamedIndividual(argumentNumber, arguments)) {
            IRI individualIRI = this.getArgumentAsANamedIndividualIRI(argumentNumber, arguments);
            return this.isOWLIndividualOfType(individualIRI, this.createIRI(GranularityClassName));
        }
        return false;
    }

    private @NonNull Instant validInstantIndividual2Instant(@NonNull IRI individualIRI, int granularity) throws SWRLBuiltInException, TemporalException {
        String datetimeString = this.getDataPropertyValueAsAString(this.getBuiltInBridge(), individualIRI, this.createIRI(HasTimePropertyName));
        return new Instant(this.temporal, datetimeString, granularity);
    }

    private @NonNull Period validPeriodIndividual2Period(@NonNull IRI individualIRI, int granularity) throws SWRLBuiltInException, TemporalException {
        String startDatetimeString = this.getDataPropertyValueAsAString(this.getBuiltInBridge(), individualIRI, this.createIRI(HasStartTimePropertyName));
        String finishDatetimeString = this.getDataPropertyValueAsAString(this.getBuiltInBridge(), individualIRI, this.createIRI(HasFinishTimePropertyName));
        return new Period(this.temporal, startDatetimeString, finishDatetimeString, granularity);
    }

    private @NonNull Period extendedPropositionIndividual2Period(@NonNull IRI extendedPropositionIRI, int granularity) throws SWRLBuiltInException, TemporalException {
        IRI validTimeIRI = this.getObjectPropertyValueAsIRI(this.getBuiltInBridge(), extendedPropositionIRI, this.createIRI(HasValidTimePropertyName));
        if (this.isOWLIndividualOfType(validTimeIRI, this.createIRI(ValidPeriodClassName))) {
            return this.validPeriodIndividual2Period(validTimeIRI, granularity);
        }
        throw new SWRLBuiltInException("expecting valid period value for extended proposition " + extendedPropositionIRI);
    }

    private @NonNull Instant extendedPropositionIndividual2Instant(@NonNull IRI extendedPropositionIRI, int granularity) throws SWRLBuiltInException, TemporalException {
        IRI validTimeIRI = this.getObjectPropertyValueAsIRI(this.getBuiltInBridge(), extendedPropositionIRI, this.createIRI(HasValidTimePropertyName));
        if (this.isOWLIndividualOfType(validTimeIRI, this.createIRI(ValidInstantClassName))) {
            return this.validInstantIndividual2Instant(validTimeIRI, granularity);
        }
        throw new SWRLBuiltInException("expecting valid instant value for extended proposition " + extendedPropositionIRI);
    }

    private @NonNull IRI getObjectPropertyValueAsIRI(@NonNull SWRLBuiltInBridge bridge, @NonNull IRI individualIRI, @NonNull IRI propertyIRI) {
        HashSet<@NonNull E> axioms = new HashSet();
        OWLObjectPropertyAssertionAxiom axiom = axioms.toArray(new OWLObjectPropertyAssertionAxiom[axioms.size()])[0];
        OWLIndividual subject = (OWLIndividual)axiom.getObject();
        return subject.asOWLNamedIndividual().getIRI();
    }

    private boolean isOWLIndividualOfType(@NonNull IRI individualIRI, @NonNull IRI classIRI) throws SWRLBuiltInLibraryException {
        return true;
    }

    private @NonNull String getDataPropertyValueAsAString(@NonNull SWRLBuiltInBridge bridge, @NonNull IRI individualIRI, @NonNull IRI propertyIRI) {
        HashSet<@NonNull E> axioms = new HashSet();
        OWLDataPropertyAssertionAxiom axiom = axioms.toArray(new OWLDataPropertyAssertionAxiom[axioms.size()])[0];
        OWLLiteral value = (OWLLiteral)axiom.getObject();
        return value.toString();
    }

    private long convertArgumentToALong(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        BigInteger integerValue = this.getArgumentAsAnInteger(argumentNumber, arguments);
        if (integerValue.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || integerValue.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "value converted to xsd:long cannot be larger than 9223372036854775807"));
        }
        return integerValue.longValue();
    }

    private void rewriteStringArgumentAsADateOrDateTime(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        String datetimeString = this.getArgumentAsAString(argumentNumber, arguments);
        XSDDateTimeStringProcessor datetimeProcessor = new XSDDateTimeStringProcessor();
        try {
            if (datetimeProcessor.getFinestSpecifiedGranularity(datetimeString) < 3) {
                XSDDate date = new XSDDate(datetimeProcessor.stripDatetimeString(datetimeString, 2));
                arguments.set(argumentNumber, this.createLiteralBuiltInArgument(date));
            } else {
                XSDDateTime dateTime = new XSDDateTime(datetimeProcessor.normalizeDatetimeString(datetimeString));
                arguments.set(argumentNumber, this.createLiteralBuiltInArgument(dateTime));
            }
        }
        catch (TemporalException e) {
            throw new SWRLBuiltInException("invalid xsd:date or xsd:dateTime string " + datetimeString);
        }
    }

    private long convertArgumentToAPositiveLong(int argumentNumber, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        BigInteger integerValue = this.getArgumentAsAnInteger(argumentNumber, arguments);
        if (integerValue.compareTo(BigInteger.ZERO) < 0) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "expecting positive xsd:integer"));
        }
        if (integerValue.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new InvalidSWRLBuiltInArgumentException(argumentNumber, this.makeInvalidArgumentTypeMessage(arguments.get(argumentNumber), "value converted to xsd:long cannot be larger than 9223372036854775807"));
        }
        return integerValue.longValue();
    }

    private @NonNull IRI createIRI(@NonNull String fullName) throws SWRLBuiltInException {
        try {
            return IRI.create((String)fullName);
        }
        catch (RuntimeException e) {
            throw new SWRLBuiltInException("error creating IRI from full prefix " + fullName + ": " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }
}

