/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.temporal;

import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.builtins.temporal.DatetimeStringProcessor;
import org.swrlapi.builtins.temporal.TemporalException;

class Temporal {
    public static final int MILLISECONDS = 6;
    public static final int SECONDS = 5;
    public static final int MINUTES = 4;
    public static final int HOURS = 3;
    public static final int DAYS = 2;
    public static final int MONTHS = 1;
    public static final int YEARS = 0;
    public static final int FINEST = 6;
    private static final int COARSEST = 0;
    public static final int NUMBER_OF_GRANULARITIES = 7;
    private long nowGranuleCountInMillis = -1L;
    private final DatetimeStringProcessor datetimeStringProcessor;
    public static final long MillisecondsTo1970 = 62167392000000L;
    public static final long MillisecondsToGregorianChangeDate = 12219292800000L;
    public static final long GregorianChangeYear = 1582L;
    public static final long MillisecondsInGregorianDiscontinuity = 864000000L;
    public static final long DaysInGregorianDiscontinuity = 10L;
    private static final long[][] conversion_table = new long[][]{{1L, 12L, 365L, 8760L, 525600L, 31536000L, 31536000000L}, {0L, 1L, 0L, 0L, 0L, 0L, 0L}, {365L, 0L, 1L, 24L, 1440L, 86400L, 86400000L}, {8760L, 0L, 24L, 1L, 60L, 3600L, 3600000L}, {525600L, 0L, 1440L, 60L, 1L, 60L, 60000L}, {31536000L, 0L, 86400L, 3600L, 60L, 1L, 1000L}, {31536000000L, 0L, 86400000L, 3600000L, 60000L, 1000L, 1L}};
    private static final String[] stringGranularityRepresentation = new String[]{"years", "months", "days", "hours", "minutes", "seconds", "milliseconds"};
    private static final long[] days_in_month = new long[]{31L, 28L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
    private static final long[] days_to_month = new long[]{0L, 31L, 59L, 90L, 120L, 151L, 181L, 212L, 243L, 273L, 304L, 334L, 365L};
    private final @NonNull GregorianCalendar gc;

    public Temporal(DatetimeStringProcessor datetimeStringProcessor) {
        this.datetimeStringProcessor = datetimeStringProcessor;
        this.gc = new GregorianCalendar();
    }

    public void setNow(@NonNull String nowDatetimeString) throws TemporalException {
        this.nowGranuleCountInMillis = this.datetimeString2GranuleCount(nowDatetimeString, 6);
    }

    public void setNow() {
        long millisecondsFrom1970 = System.currentTimeMillis();
        this.nowGranuleCountInMillis = millisecondsFrom1970 + 62167392000000L;
    }

    public void checkGranularity(@NonNull String granularity) throws TemporalException {
        Temporal.getIntegerGranularityRepresentation(granularity);
    }

    public static void checkMonthCount(long monthCount) throws TemporalException {
        if (monthCount < 1L || monthCount > 12L) {
            throw new TemporalException("invalid month count #" + monthCount);
        }
    }

    public static int getIntegerGranularityRepresentation(@NonNull String granularity) throws TemporalException {
        if (granularity.length() == 0 || granularity.equalsIgnoreCase("finest")) {
            return 6;
        }
        if (granularity.equalsIgnoreCase("coarsest")) {
            return 0;
        }
        for (int i = 0; i < stringGranularityRepresentation.length; ++i) {
            if (!stringGranularityRepresentation[i].equalsIgnoreCase(granularity)) continue;
            return i;
        }
        throw new TemporalException("invalid granularity '" + granularity + "'");
    }

    public static boolean isValidGranularityString(@NonNull String granularity) {
        boolean found = false;
        for (int i = 0; i < stringGranularityRepresentation.length && !found; ++i) {
            if (!stringGranularityRepresentation[i].equalsIgnoreCase(granularity)) continue;
            found = true;
        }
        return found;
    }

    public static String getStringGranularityRepresentation(int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        return stringGranularityRepresentation[granularity];
    }

    public long sqlTimestamp2GranuleCount(@NonNull Timestamp timestamp, int granularity) throws TemporalException {
        long granuleCountInMillis = timestamp.getTime() + 62167392000000L;
        return Temporal.convertGranuleCount(granuleCountInMillis, 6, granularity);
    }

    public long datetimeString2GranuleCount(@NonNull String datetimeString, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        int years = this.getDatetimeStringProcessor().getYears(datetimeString);
        if (years < 1 || years > 9999) {
            throw new TemporalException("years must be between 1  and 9999 in datetime: " + datetimeString);
        }
        int months = this.getDatetimeStringProcessor().getMonths(datetimeString);
        if (months < 1 | months > 12) {
            throw new TemporalException("months must be between 1 and 12 in datetime: " + datetimeString);
        }
        int days = this.getDatetimeStringProcessor().getDays(datetimeString);
        if (days < 1 || days > 31) {
            throw new TemporalException("days must be between 1 and 31 in datetime: " + datetimeString);
        }
        int hours = this.getDatetimeStringProcessor().getHours(datetimeString);
        if (hours < 0 || hours > 23) {
            throw new TemporalException("hours must bebetween 0 and 23 in datetime: " + datetimeString);
        }
        int minutes = this.getDatetimeStringProcessor().getMinutes(datetimeString);
        if (minutes < 0 || minutes > 59) {
            throw new TemporalException("minutes must be between 0 and 59 in datetime: " + datetimeString);
        }
        int seconds = this.getDatetimeStringProcessor().getSeconds(datetimeString);
        if (seconds < 0) {
            throw new TemporalException("seconds must be 0 or greater in datetime: " + datetimeString);
        }
        int milliseconds = this.getDatetimeStringProcessor().getMilliseconds(datetimeString);
        if (milliseconds < 0) {
            throw new TemporalException("milliseconds must be 0 or greater in datetime: " + datetimeString);
        }
        this.gc.clear();
        this.gc.set(years, months - 1, days, hours, minutes, seconds);
        long granuleCountInMillis = this.gc.getTimeInMillis() + (long)milliseconds + 62167392000000L;
        return Temporal.convertGranuleCount(granuleCountInMillis, 6, granularity);
    }

    public static long utilDate2GranuleCount(Date date, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        long granuleCountInMilliseconds = date.getTime() + 62167392000000L;
        return Temporal.convertGranuleCount(granuleCountInMilliseconds, 6, granularity);
    }

    public java.sql.Date utilDate2SQLDate(Date date) throws TemporalException {
        if (date instanceof java.sql.Date) {
            return (java.sql.Date)date;
        }
        return this.datetimeString2SQLDate(this.utilDate2DatetimeString(date));
    }

    public static long convertGranuleCount(long granuleCount, int from_granularity, int to_granularity) throws TemporalException {
        long leapOffsetGranuleCount;
        Temporal.checkGranularity(from_granularity);
        Temporal.checkGranularity(to_granularity);
        if (from_granularity == to_granularity) {
            return granuleCount;
        }
        long localGranuleCount = granuleCount;
        if (from_granularity >= 2 && to_granularity <= 1) {
            leapOffsetGranuleCount = -Temporal.leapYearsUpToGranuleCount(localGranuleCount, from_granularity) * conversion_table[2][from_granularity];
            localGranuleCount += leapOffsetGranuleCount;
        }
        long result = from_granularity == 1 ? Temporal.convertMonthCount2GranuleCount(localGranuleCount, to_granularity) : (to_granularity == 1 ? Temporal.convertGranuleCount2MonthCount(localGranuleCount, from_granularity) : (from_granularity > to_granularity ? localGranuleCount / conversion_table[from_granularity][to_granularity] : (from_granularity < to_granularity ? localGranuleCount * conversion_table[from_granularity][to_granularity] : localGranuleCount)));
        if (from_granularity <= 1 && to_granularity >= 2) {
            leapOffsetGranuleCount = from_granularity == 0 ? Temporal.leapGranulesUpToYear(granuleCount, to_granularity) : Temporal.leapGranulesUpToMonth(granuleCount, to_granularity);
            result += leapOffsetGranuleCount;
        }
        return result;
    }

    public static long getDaysInMonth(long monthCount) throws TemporalException {
        Temporal.checkMonthCount(monthCount);
        return days_in_month[(int)monthCount - 1];
    }

    public static boolean isLeapYear(long yearCount) {
        GregorianCalendar gc = new GregorianCalendar();
        return gc.isLeapYear((int)yearCount);
    }

    private static long convertGranuleCount2MonthCount(long granuleCount, int from_granularity) {
        long monthCount;
        if (from_granularity == 0) {
            monthCount = granuleCount * conversion_table[0][1];
        } else if (from_granularity == 1) {
            monthCount = granuleCount;
        } else {
            long dayCount = granuleCount / conversion_table[from_granularity][2];
            long yearCount = dayCount / 365L;
            monthCount = yearCount * 12L;
            long dayInYear = dayCount % 365L;
            int i = 1;
            while (days_to_month[i] <= dayInYear) {
                ++monthCount;
                ++i;
            }
        }
        return monthCount;
    }

    private static Date sqlDate2UtilDate(java.sql.Date sqlDate, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        return Temporal.granuleCount2UtilDate(Temporal.sqlDate2GranuleCount(sqlDate, granularity), granularity);
    }

    public static Date sqlDate2UtilDate(java.sql.Date sqlDate) throws TemporalException {
        return Temporal.sqlDate2UtilDate(sqlDate, 6);
    }

    public static long sqlDate2GranuleCount(java.sql.Date date, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        return Temporal.utilDate2GranuleCount(Temporal.sqlDate2UtilDate(date, granularity), granularity);
    }

    public static Date addGranuleCount(Date date, long granuleCount, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        long resultGranuleCount = Temporal.utilDate2GranuleCount(date, granularity) + granuleCount;
        return Temporal.granuleCount2UtilDate(resultGranuleCount, granularity);
    }

    public static Date subtractGranuleCount(Date date, long granuleCount, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        long resultGranuleCount = Temporal.utilDate2GranuleCount(date, granularity) - granuleCount;
        return Temporal.granuleCount2UtilDate(resultGranuleCount, granularity);
    }

    public java.sql.Date getNowSQLDate() throws TemporalException {
        return java.sql.Date.valueOf(this.getNowDatetimeString());
    }

    public Date getNowUtilDate() throws TemporalException {
        return Temporal.granuleCount2UtilDate(this.nowGranuleCountInMillis, 6);
    }

    public long getNowGranuleCount(int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        return Temporal.convertGranuleCount(this.nowGranuleCountInMillis, 6, granularity);
    }

    public static Timestamp granuleCount2Timestamp(long granuleCount, int granularity) throws TemporalException {
        long granuleCountInMilliSeconds = Temporal.convertGranuleCount(granuleCount, granularity, 6);
        return new Timestamp(granuleCountInMilliSeconds -= 62167392000000L);
    }

    public static Date granuleCount2UtilDate(long granuleCount, int granularity) throws TemporalException {
        long granuleCountInMilliseconds = Temporal.convertGranuleCount(granuleCount, granularity, 6);
        return new Date(granuleCountInMilliseconds -= 62167392000000L);
    }

    public static java.sql.Date granuleCount2SQLDate(long granuleCount, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        long granuleCountInMilliseconds = Temporal.convertGranuleCount(granuleCount, granularity, 6);
        return new java.sql.Date(granuleCountInMilliseconds -= 62167392000000L);
    }

    public String sqlDate2DatetimeString(java.sql.Date date, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        return this.granuleCount2DatetimeString(Temporal.sqlDate2GranuleCount(date, granularity), granularity);
    }

    public String sqlDate2DatetimeString(java.sql.Date date) throws TemporalException {
        return this.getDatetimeStringProcessor().granuleCount2DatetimeString(Temporal.sqlDate2GranuleCount(date, 6), 6);
    }

    private String utilDate2DatetimeString(Date date, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        return this.granuleCount2DatetimeString(Temporal.utilDate2GranuleCount(date, granularity), granularity);
    }

    private String utilDate2DatetimeString(Date date) throws TemporalException {
        return this.utilDate2DatetimeString(date, 6);
    }

    private java.sql.Date datetimeString2SQLDate(@NonNull String datetimeString, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        return Temporal.granuleCount2SQLDate(this.datetimeString2GranuleCount(datetimeString, granularity), granularity);
    }

    private java.sql.Date datetimeString2SQLDate(@NonNull String datetimeString) throws TemporalException {
        return this.datetimeString2SQLDate(datetimeString, 6);
    }

    private Date datetimeString2UtilDate(@NonNull String datetimeString, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        return Temporal.granuleCount2UtilDate(this.datetimeString2GranuleCount(datetimeString, granularity), granularity);
    }

    public Date datetimeString2UtilDate(@NonNull String datetimeString) throws TemporalException {
        return this.datetimeString2UtilDate(datetimeString, 6);
    }

    public String getNowDatetimeString() throws TemporalException {
        return this.granuleCount2DatetimeString(this.nowGranuleCountInMillis, 6);
    }

    public @NonNull String normalizeDatetimeString(@NonNull String datetimeString, int granularity, boolean roundUp) throws TemporalException {
        return this.getDatetimeStringProcessor().normalizeDatetimeString(datetimeString, granularity, roundUp);
    }

    public @NonNull String normalizeDatetimeString(@NonNull String datetimeString, int granularity) throws TemporalException {
        return this.normalizeDatetimeString(datetimeString, granularity, false);
    }

    public @NonNull String stripDatetimeString(@NonNull String datetimeString, int granularity) throws TemporalException {
        return this.getDatetimeStringProcessor().stripDatetimeString(datetimeString, granularity);
    }

    private String expressDatetimeStringAtGranularity(@NonNull String datetimeString, int granularity, boolean roundUp) throws TemporalException {
        return this.getDatetimeStringProcessor().expressDatetimeStringAtGranularity(datetimeString, granularity, roundUp);
    }

    public @NonNull String expressDatetimeStringAtGranularity(@NonNull String datetimeString, int granularity) throws TemporalException {
        return this.expressDatetimeStringAtGranularity(datetimeString, granularity, false);
    }

    public String addGranuleCount(@NonNull String datetimeString, long granuleCount, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        long resultGranuleCount = this.datetimeString2GranuleCount(datetimeString, granularity) + granuleCount;
        return this.granuleCount2DatetimeString(resultGranuleCount, granularity);
    }

    public String subtractGranuleCount(@NonNull String datetimeString, long granuleCount, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        long resultGranuleCount = this.datetimeString2GranuleCount(datetimeString, granularity) - granuleCount;
        return this.granuleCount2DatetimeString(resultGranuleCount, granularity);
    }

    public String granuleCount2DatetimeString(long granuleCount, int granularity) throws TemporalException {
        return this.getDatetimeStringProcessor().granuleCount2DatetimeString(granuleCount, granularity);
    }

    public static void checkGranularity(int granularity) throws TemporalException {
        if (granularity < 0 || granularity > 6) {
            throw new TemporalException("invalid granularity '" + granularity + "'");
        }
    }

    public static void throwInvalidDatetimeStringException(@NonNull String datetimeString) throws TemporalException {
        throw new TemporalException("invalid datetime string: '" + datetimeString + "'");
    }

    private static long convertMonthCount2GranuleCount(long monthCount, int to_granularity) throws TemporalException {
        Temporal.checkGranularity(to_granularity);
        if (to_granularity == 1) {
            return monthCount;
        }
        long yearCount = monthCount / 12L;
        long daysUpToAndIncludingMonth = days_to_month[(int)monthCount % 12];
        long dayCount = daysUpToAndIncludingMonth + yearCount * 365L;
        long result = to_granularity > 1 ? dayCount * conversion_table[2][to_granularity] : dayCount / conversion_table[2][to_granularity];
        return result;
    }

    private static long leapGranulesUpToYear(long yearCount, int granularity) throws TemporalException {
        long leapDays = 0L;
        Temporal.checkGranularity(granularity);
        for (long i = 0L; i < yearCount; ++i) {
            if (!Temporal.isLeapYear(i)) continue;
            ++leapDays;
        }
        return leapDays * conversion_table[2][granularity];
    }

    private static long leapGranulesUpToMonth(long monthCount, int granularity) throws TemporalException {
        Temporal.checkGranularity(granularity);
        long yearCount = monthCount / 12L;
        long leapGranules = Temporal.leapGranulesUpToYear(yearCount, granularity);
        if (yearCount != 0L) {
            long month = monthCount % 12L;
            if (Temporal.isLeapYear(yearCount) && month > 1L) {
                leapGranules += conversion_table[2][granularity];
            }
        }
        return leapGranules;
    }

    private static long leapYearsUpToGranuleCount(long granuleCount, int granularity) throws TemporalException {
        long leapYearCount = 0L;
        Temporal.checkGranularity(granularity);
        if (granuleCount == 0L) {
            return 0L;
        }
        if (granularity == 0) {
            leapYearCount = Temporal.leapGranulesUpToYear(granuleCount, 0);
        } else if (granuleCount == 1L) {
            leapYearCount = Temporal.leapGranulesUpToMonth(granuleCount, 0);
        } else {
            long cumulativeGranuleCount = 0L;
            long granulesInYear = conversion_table[0][granularity];
            long granulesInDay = conversion_table[2][granularity];
            long yearCount = 0L;
            do {
                cumulativeGranuleCount += granulesInYear;
                if (!Temporal.isLeapYear(++yearCount)) continue;
                ++leapYearCount;
                cumulativeGranuleCount += granulesInDay;
            } while (cumulativeGranuleCount < granuleCount);
            long granulesInYearToFeb29th = (days_to_month[2] + 1L) * conversion_table[2][granularity];
            if (Temporal.isLeapYear(yearCount) && cumulativeGranuleCount - granuleCount > granulesInYearToFeb29th) {
                ++leapYearCount;
            }
        }
        return leapYearCount;
    }

    private DatetimeStringProcessor getDatetimeStringProcessor() {
        return this.datetimeStringProcessor;
    }
}

