/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.builtins.temporal;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.builtins.temporal.DatetimeStringProcessor;

class XSDDateTimeStringProcessor
extends DatetimeStringProcessor {
    private static final @NonNull SimpleDateFormat _dateFormat = new SimpleDateFormat("y-M-d'T'h:m:s.S");
    private static final @NonNull String _delimiters = "-:.TZ";
    private static final @NonNull int[] _gTokenIndex = new int[]{1, 3, 5, 7, 9, 11, 13};
    private static final @NonNull String[] _datetimeRoundDownPadding = new String[]{"-01-01T00:00:00.000", "-01T00:00:00.000", "T00:00:00.000", ":00:00.000", ":00.000", ".000", ""};
    private static final @NonNull String[] _datetimeRoundUpPadding = new String[]{"-12-31T23:59:59.999", "", "T23:59:59.999", ":59:59.999", ":59.999", ".999", ""};

    public XSDDateTimeStringProcessor() {
        super(_dateFormat, _delimiters, _gTokenIndex, _datetimeRoundDownPadding, _datetimeRoundUpPadding);
    }

    @Override
    protected @NonNull String constructDatetimeStringFromMillisecondsFrom1970Count(long millisecondsFrom1970) {
        Timestamp ts = new Timestamp(millisecondsFrom1970);
        return ts.toString().replace(' ', 'T');
    }
}

