/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.io.File;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.swrlapi.factory.DefaultSQWRLQueryEngineModel;
import org.swrlapi.factory.SWRLAPIFactory;
import org.swrlapi.sqwrl.SQWRLQueryEngine;
import org.swrlapi.ui.model.FileBackedSQWRLQueryEngineModel;

public class DefaultFileBackedSQWRLQueryEngineModel
extends DefaultSQWRLQueryEngineModel
implements FileBackedSQWRLQueryEngineModel {
    private Optional<@NonNull File> file;

    public DefaultFileBackedSQWRLQueryEngineModel(@NonNull SQWRLQueryEngine queryEngine, Optional<@NonNull File> file) {
        super(queryEngine);
        this.file = file;
    }

    @Override
    public void open(@NonNull File file) throws OWLOntologyCreationException {
        OWLOntology ontology = this.createOWLOntology(file);
        SQWRLQueryEngine queryEngine = SWRLAPIFactory.createSQWRLQueryEngine(ontology);
        this.file = Optional.of(file);
        this.resetOntologyChanged();
        this.updateModel(queryEngine);
    }

    @Override
    public void saveAs(@NonNull File file) throws OWLOntologyStorageException {
        this.file = Optional.of(file);
        this.saveOWLOntology(this.file.get());
        this.resetOntologyChanged();
    }

    @Override
    public void close() throws OWLOntologyCreationException {
        OWLOntology ontology = this.createOWLOntology();
        SQWRLQueryEngine queryEngine = SWRLAPIFactory.createSQWRLQueryEngine(ontology);
        this.file = Optional.empty();
        this.resetOntologyChanged();
        this.updateModel(queryEngine);
    }

    @Override
    public void save() throws OWLOntologyStorageException {
        if (this.file.isPresent()) {
            this.saveOWLOntology(this.file.get());
        }
        this.resetOntologyChanged();
    }

    @Override
    public boolean hasBackingFile() {
        return this.file.isPresent();
    }
}

