/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.io.File;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.factory.DefaultSWRLRuleEngineModel;
import org.swrlapi.factory.SWRLAPIFactory;
import org.swrlapi.ui.model.FileBackedSWRLRuleEngineModel;

public class DefaultFileBackedSWRLRuleEngineModel
extends DefaultSWRLRuleEngineModel
implements FileBackedSWRLRuleEngineModel {
    private Optional<@NonNull File> file;

    public DefaultFileBackedSWRLRuleEngineModel(@NonNull SWRLRuleEngine ruleEngine, Optional<File> file) {
        super(ruleEngine);
        this.file = file;
    }

    @Override
    public void open(@NonNull File file) throws OWLOntologyCreationException {
        OWLOntology ontology = this.createOWLOntology(file);
        SWRLRuleEngine ruleEngine = SWRLAPIFactory.createSWRLRuleEngine(ontology);
        this.file = Optional.of(file);
        this.updateModel(ruleEngine);
    }

    @Override
    public void saveAs(@NonNull File file) throws OWLOntologyStorageException {
        this.file = Optional.of(file);
        this.saveOWLOntology(this.file.get());
        this.resetOntologyChanged();
    }

    @Override
    public void close() throws OWLOntologyCreationException {
        OWLOntology ontology = this.createOWLOntology();
        SWRLRuleEngine ruleEngine = SWRLAPIFactory.createSWRLRuleEngine(ontology);
        this.file = Optional.empty();
        this.updateModel(ruleEngine);
    }

    @Override
    public void save() throws OWLOntologyStorageException {
        if (this.file.isPresent()) {
            this.saveOWLOntology(this.file.get());
        }
        this.resetOntologyChanged();
    }

    @Override
    public boolean hasBackingFile() {
        return this.file.isPresent();
    }
}

