/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.SimpleRenderer;
import org.swrlapi.core.IRIResolver;

public class DefaultIRIResolver
implements IRIResolver {
    private static final String GENERATED_IRI_NAMESPACE = "http://swrl.stanford.edu/autogenerated";
    private final @NonNull DefaultPrefixManager prefixManager;
    private final @NonNull OWLObjectRenderer objectRenderer;
    private final @NonNull Map<@NonNull String, @NonNull String> autogenNamespace2Prefix = new HashMap<String, String>();
    private final @NonNull Map<@NonNull String, @NonNull String> autogeneratedPrefix2Namespace = new HashMap<String, String>();
    private final @NonNull Map<@NonNull IRI, @NonNull String> autogenIRI2PrefixedName = new HashMap<IRI, String>();
    private final @NonNull Map<@NonNull String, @NonNull IRI> autogenPrefixedName2IRI = new HashMap<String, IRI>();
    private @Nullable String defaultPrefix;
    private int autogenPrefixNumber = 0;
    private int autogenPrefixedNameNumber = 0;

    public DefaultIRIResolver() {
        this.prefixManager = new DefaultPrefixManager();
        this.objectRenderer = new SimpleRenderer();
    }

    public DefaultIRIResolver(@NonNull String defaultPrefix) {
        this.prefixManager = new DefaultPrefixManager();
        this.prefixManager.setDefaultPrefix(defaultPrefix);
        this.defaultPrefix = defaultPrefix;
        this.objectRenderer = new SimpleRenderer();
    }

    @Override
    public void reset() {
        this.autogenNamespace2Prefix.clear();
        this.autogeneratedPrefix2Namespace.clear();
        this.autogenPrefixedName2IRI.clear();
        this.autogenIRI2PrefixedName.clear();
        this.autogenPrefixedNameNumber = 0;
        this.autogenPrefixNumber = 0;
    }

    @Override
    public @NonNull Optional<@NonNull IRI> variableName2IRI(@NonNull String variableName) {
        String defaultPrefix = this.prefixManager.getDefaultPrefix();
        if (defaultPrefix != null && defaultPrefix.matches(".*[0-9A-Za-z]$")) {
            return Optional.of(IRI.create((String)"", (String)("#" + variableName)));
        }
        return Optional.of(this.prefixManager.getIRI(variableName));
    }

    @Override
    public @NonNull Optional<@NonNull IRI> prefixedName2IRI(@NonNull String prefixedName) {
        if (this.autogenPrefixedName2IRI.containsKey(prefixedName)) {
            return Optional.of(this.autogenPrefixedName2IRI.get(prefixedName));
        }
        String prefix = this.getPrefix(prefixedName);
        String remainder = this.getRemainder(prefixedName);
        if (prefix.isEmpty()) {
            if (remainder.isEmpty()) {
                return Optional.empty();
            }
            IRI iri = this.prefixManager.getIRI(remainder);
            if (iri != null) {
                return Optional.of(iri);
            }
            return Optional.empty();
        }
        IRI iri = this.prefixManager.getIRI(prefixedName);
        if (iri != null) {
            return Optional.of(iri);
        }
        if (this.autogeneratedPrefix2Namespace.containsKey(prefix)) {
            String namespace = this.autogeneratedPrefix2Namespace.get(prefix);
            return Optional.of(IRI.create((String)namespace, (String)remainder));
        }
        return Optional.empty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Optional<@NonNull String> iri2PrefixedName(@NonNull IRI iri) {
        String existingPrefixedName = this.prefixManager.getPrefixIRI(iri);
        if (existingPrefixedName != null) {
            return Optional.of(existingPrefixedName);
        }
        String namespace = iri.getNamespace();
        @NonNull com.google.common.base.Optional remainder = iri.getRemainder();
        if (remainder.isPresent()) {
            if (namespace.isEmpty()) {
                String prefixedName = (String)remainder.get();
                return Optional.of(prefixedName);
            }
            return Optional.of(this.autoGeneratePrefixedName(iri, namespace, (String)remainder.get()));
        }
        return Optional.of(this.autoGeneratePrefixedName(iri));
    }

    @Override
    public @NonNull Optional<@NonNull String> iri2VariableName(@NonNull IRI iri) {
        Optional<String> prefixedName = this.iri2PrefixedName(iri);
        if (prefixedName.isPresent()) {
            String actualPrefixedName = prefixedName.get();
            if (!actualPrefixedName.contains(":")) {
                return Optional.of(actualPrefixedName);
            }
            return Optional.of(actualPrefixedName.substring(actualPrefixedName.indexOf(":") + 1, actualPrefixedName.length()));
        }
        return Optional.empty();
    }

    @Override
    public @NonNull Optional<@NonNull String> iri2ShortForm(@NonNull IRI iri) {
        String shortForm = this.prefixManager.getShortForm(iri);
        if (shortForm == null || shortForm.isEmpty() || shortForm.startsWith("<")) {
            return this.iri2PrefixedName(iri);
        }
        return Optional.of(shortForm);
    }

    @Override
    public void setPrefix(@NonNull String prefix, @NonNull String namespace) {
        this.prefixManager.setPrefix(prefix, namespace);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void updatePrefixes(@NonNull OWLOntology ontology) {
        OWLOntologyManager owlOntologyManager = ontology.getOWLOntologyManager();
        OWLDocumentFormat ontologyFormat = owlOntologyManager.getOntologyFormat(ontology);
        this.prefixManager.clear();
        if (this.defaultPrefix != null) {
            this.prefixManager.setDefaultPrefix(this.defaultPrefix);
        }
        if (ontologyFormat != null && ontologyFormat.isPrefixOWLOntologyFormat()) {
            PrefixDocumentFormat prefixOntologyFormat = ontologyFormat.asPrefixOWLOntologyFormat();
            @NonNull Map map = prefixOntologyFormat.getPrefixName2PrefixMap();
            for (String prefix : map.keySet()) {
                this.prefixManager.setPrefix(prefix, (String)map.get(prefix));
            }
        }
        this.addSWRLAPIPrefixes();
    }

    @Override
    public IRI generateIRI() {
        String defaultPrefix = this.prefixManager.getDefaultPrefix();
        if (defaultPrefix != null) {
            return IRI.create((String)(defaultPrefix + "#" + UUID.randomUUID().toString().replaceAll("-", "_")));
        }
        return IRI.create((String)("http://swrl.stanford.edu/autogenerated#" + UUID.randomUUID().toString().replaceAll("-", "_")));
    }

    @Override
    public @NonNull String render(@Nonnull OWLObject owlObject) {
        return this.objectRenderer.render(owlObject);
    }

    private @NonNull String getPrefix(@NonNull String prefixedName) {
        int separatorIndex = prefixedName.indexOf(":");
        if (separatorIndex > 0) {
            return prefixedName.substring(0, separatorIndex);
        }
        return "";
    }

    private @NonNull String getRemainder(@NonNull String prefixedName) {
        int separatorIndex = prefixedName.indexOf(":");
        if (separatorIndex != -1) {
            return prefixedName.substring(separatorIndex, prefixedName.length());
        }
        return prefixedName;
    }

    private @NonNull String autoGeneratePrefix(@NonNull String namespace) {
        if (this.autogenNamespace2Prefix.containsKey(namespace)) {
            return this.autogenNamespace2Prefix.get(namespace);
        }
        String autogeneratedPrefix = "autogen" + this.autogenPrefixNumber++ + ":";
        this.autogenNamespace2Prefix.put(namespace, autogeneratedPrefix);
        this.autogeneratedPrefix2Namespace.put(autogeneratedPrefix, namespace);
        return autogeneratedPrefix;
    }

    private @NonNull String autoGeneratePrefixedName(@NonNull IRI iri) {
        if (this.autogenIRI2PrefixedName.containsKey(iri)) {
            return this.autogenIRI2PrefixedName.get(iri);
        }
        String autoGeneratedPrefixedName = "autogen:p" + this.autogenPrefixedNameNumber++;
        this.autogenPrefixedName2IRI.put(autoGeneratedPrefixedName, iri);
        this.autogenIRI2PrefixedName.put(iri, autoGeneratedPrefixedName);
        return autoGeneratedPrefixedName;
    }

    private @NonNull String autoGeneratePrefixedName(@NonNull IRI iri, @NonNull String namespace, @NonNull String remainder) {
        String autogenPrefix = this.autoGeneratePrefix(namespace);
        String autogenPrefixedName = autogenPrefix + remainder;
        this.autogenPrefixedName2IRI.put(autogenPrefixedName, iri);
        return autogenPrefixedName;
    }

    private void addSWRLAPIPrefixes() {
        this.prefixManager.setPrefix("owl:", "http://www.w3.org/2002/07/owl#");
        this.prefixManager.setPrefix("swrl:", "http://www.w3.org/2003/11/swrl#");
        this.prefixManager.setPrefix("swrlb:", "http://www.w3.org/2003/11/swrlb#");
        this.prefixManager.setPrefix("sqwrl:", "http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#");
        this.prefixManager.setPrefix("swrlm:", "http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlm.owl#");
        this.prefixManager.setPrefix("temporal:", "http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#");
        this.prefixManager.setPrefix("swrlx:", "http://swrl.stanford.edu/ontologies/built-ins/3.3/swrlx.owl#");
        this.prefixManager.setPrefix("abox:", "http://swrl.stanford.edu/ontologies/built-ins/5.0.0/abox.owl#");
        this.prefixManager.setPrefix("tbox:", "http://swrl.stanford.edu/ontologies/built-ins/5.0.0/tbox.owl#");
        this.prefixManager.setPrefix("rbox:", "http://swrl.stanford.edu/ontologies/built-ins/5.0.0/rbox.owl#");
        this.prefixManager.setPrefix("swrla:", "http://swrl.stanford.edu/ontologies/3.3/swrla.owl#");
    }
}

