/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.exceptions.LiteralException;
import org.swrlapi.literal.Literal;
import org.swrlapi.literal.OWLLiteralComparator;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;

class DefaultLiteral
implements Literal {
    private final @NonNull OWLLiteral literal;

    public DefaultLiteral(@NonNull OWLLiteral literal) {
        this.literal = literal;
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral() {
        return this.literal;
    }

    @Override
    public boolean isNumeric() {
        return OWLLiteralComparator.isNumeric(this.literal);
    }

    @Override
    public boolean isByte() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.BYTE.getIRI());
    }

    @Override
    public boolean isShort() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.SHORT.getIRI());
    }

    @Override
    public boolean isInt() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.INT.getIRI());
    }

    @Override
    public boolean isLong() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.LONG.getIRI());
    }

    @Override
    public boolean isFloat() {
        return this.literal.getDatatype().isFloat();
    }

    @Override
    public boolean isDouble() {
        return this.literal.getDatatype().isDouble();
    }

    @Override
    public boolean isDecimal() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.DECIMAL.getIRI());
    }

    @Override
    public boolean isInteger() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.INTEGER.getIRI());
    }

    @Override
    public boolean isNegativeInteger() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.NEGATIVE_INTEGER.getIRI());
    }

    @Override
    public boolean isPositiveInteger() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.POSITIVE_INTEGER.getIRI());
    }

    @Override
    public boolean isNonNegativeInteger() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.NON_NEGATIVE_INTEGER.getIRI());
    }

    @Override
    public boolean isNonPositiveInteger() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.NON_POSITIVE_INTEGER.getIRI());
    }

    @Override
    public boolean isUnsignedLong() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_LONG.getIRI());
    }

    @Override
    public boolean isUnsignedInt() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_INT.getIRI());
    }

    @Override
    public boolean isUnsignedShort() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_SHORT.getIRI());
    }

    @Override
    public boolean isUnsignedByte() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.UNSIGNED_BYTE.getIRI());
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.literal.getDatatype().getIRI().equals((Object)OWLRDFVocabulary.RDF_PLAIN_LITERAL.getIRI());
    }

    @Override
    public boolean isRDFSLiteral() {
        return this.literal.getDatatype().getIRI().equals((Object)OWLRDFVocabulary.RDFS_LITERAL.getIRI());
    }

    @Override
    public boolean isRDFXMLLiteral() {
        return this.literal.getDatatype().getIRI().equals((Object)OWLRDFVocabulary.RDF_XML_LITERAL.getIRI());
    }

    @Override
    public boolean isString() {
        return this.literal.getDatatype().isString();
    }

    @Override
    public boolean isBoolean() {
        return this.literal.getDatatype().isBoolean();
    }

    @Override
    public boolean isAnyURI() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.ANY_URI.getIRI());
    }

    @Override
    public boolean isTime() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.TIME.getIRI());
    }

    @Override
    public boolean isDate() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.DATE.getIRI());
    }

    @Override
    public boolean isDateTime() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.DATE_TIME.getIRI());
    }

    @Override
    public boolean isDuration() {
        return this.literal.getDatatype().getIRI().equals((Object)XSDVocabulary.DURATION.getIRI());
    }

    @Override
    public boolean isComparable() {
        return this.isNumeric() || this.isString() || this.isTime() || this.isDate() || this.isDateTime() || this.isDuration();
    }

    @Override
    public boolean isQuotableType() {
        return this.isString() || this.isTime() || this.isDate() || this.isDateTime() || this.isDuration();
    }

    @Override
    public @NonNull String getString() throws LiteralException {
        if (!this.isString()) {
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.STRING.getPrefixedName());
        }
        return this.getOWLLiteral().getLiteral();
    }

    @Override
    public @NonNull String getRDFPlainLiteral() throws LiteralException {
        if (!this.isRDFPlainLiteral()) {
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + OWLRDFVocabulary.RDF_PLAIN_LITERAL.getPrefixedName());
        }
        return this.getOWLLiteral().getLiteral();
    }

    @Override
    public @NonNull String getRDFSLiteral() throws LiteralException {
        if (!this.isRDFSLiteral()) {
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + OWLRDFVocabulary.RDFS_LITERAL.getPrefixedName());
        }
        return this.getOWLLiteral().getLiteral();
    }

    @Override
    public @NonNull String getRDFXMLLiteral() throws LiteralException {
        if (!this.isRDFXMLLiteral()) {
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + OWLRDFVocabulary.RDF_XML_LITERAL.getPrefixedName());
        }
        return this.getOWLLiteral().getLiteral();
    }

    @Override
    public boolean getBoolean() throws LiteralException {
        if (!this.isBoolean()) {
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.BOOLEAN.getPrefixedName());
        }
        return Boolean.parseBoolean(this.literal.getLiteral());
    }

    @Override
    public byte getByte() throws LiteralException {
        try {
            if (!this.isByte()) {
                throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.BYTE.getPrefixedName());
            }
            return Byte.parseByte(this.literal.getLiteral());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + XSDVocabulary.BYTE.getPrefixedName());
        }
    }

    @Override
    public short getShort() throws LiteralException {
        try {
            if (this.isShort()) {
                return Short.parseShort(this.literal.getLiteral());
            }
            if (this.isByte()) {
                return Byte.parseByte(this.literal.getLiteral());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.SHORT.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.SHORT.getPrefixedName());
        }
    }

    @Override
    public int getInt() throws LiteralException {
        try {
            if (this.isInt()) {
                return Integer.parseInt(this.literal.getLiteral());
            }
            if (this.isShort()) {
                return Short.parseShort(this.literal.getLiteral());
            }
            if (this.isByte()) {
                return Byte.parseByte(this.literal.getLiteral());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.INT.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.INT.getPrefixedName());
        }
    }

    @Override
    public long getLong() throws LiteralException {
        try {
            if (this.isLong()) {
                return Long.parseLong(this.literal.getLiteral());
            }
            if (this.isInt()) {
                return Integer.parseInt(this.literal.getLiteral());
            }
            if (this.isShort()) {
                return Short.parseShort(this.literal.getLiteral());
            }
            if (this.isByte()) {
                return Byte.parseByte(this.literal.getLiteral());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.LONG.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.LONG.getPrefixedName());
        }
    }

    @Override
    public float getFloat() throws LiteralException {
        try {
            if (this.isFloat()) {
                return Float.parseFloat(this.literal.getLiteral());
            }
            if (this.isDouble()) {
                return Float.parseFloat(this.literal.getLiteral());
            }
            if (this.isInt()) {
                return Integer.parseInt(this.literal.getLiteral());
            }
            if (this.isLong()) {
                return Long.parseLong(this.literal.getLiteral());
            }
            if (this.isShort()) {
                return Short.parseShort(this.literal.getLiteral());
            }
            if (this.isByte()) {
                return Byte.parseByte(this.literal.getLiteral());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.FLOAT.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.FLOAT);
        }
    }

    @Override
    public double getDouble() throws LiteralException {
        try {
            if (this.isDouble()) {
                return Double.parseDouble(this.literal.getLiteral());
            }
            if (this.isFloat()) {
                return Float.parseFloat(this.literal.getLiteral());
            }
            if (this.isInt()) {
                return Integer.parseInt(this.literal.getLiteral());
            }
            if (this.isLong()) {
                return Long.parseLong(this.literal.getLiteral());
            }
            if (this.isShort()) {
                return Short.parseShort(this.literal.getLiteral());
            }
            if (this.isByte()) {
                return Byte.parseByte(this.literal.getLiteral());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.DOUBLE.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.DOUBLE);
        }
    }

    @Override
    public @NonNull BigDecimal getDecimal() throws LiteralException {
        try {
            if (this.isNumeric()) {
                return new BigDecimal(this.literal.getLiteral());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.DECIMAL.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.DECIMAL.getPrefixedName());
        }
    }

    @Override
    public @NonNull BigInteger getInteger() throws LiteralException {
        try {
            if (this.isNumeric()) {
                return new BigInteger(this.literal.getLiteral());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.INTEGER.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.INTEGER.getPrefixedName());
        }
    }

    @Override
    public @NonNull BigInteger getNonNegativeInteger() throws LiteralException {
        try {
            if (this.isNumeric()) {
                BigInteger i = new BigInteger(this.literal.getLiteral());
                if (i.signum() != -1) {
                    return i;
                }
                throw new LiteralException("invalid value " + this.getValue() + " for " + XSDVocabulary.NON_NEGATIVE_INTEGER.getPrefixedName());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.NON_NEGATIVE_INTEGER.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.NON_NEGATIVE_INTEGER.getPrefixedName());
        }
    }

    @Override
    public @NonNull BigInteger getNonPositiveInteger() throws LiteralException {
        try {
            if (this.isNumeric()) {
                BigInteger i = new BigInteger(this.literal.getLiteral());
                if (i.signum() != 1) {
                    return i;
                }
                throw new LiteralException("invalid value " + this.getValue() + " for " + XSDVocabulary.NON_POSITIVE_INTEGER.getPrefixedName());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.NON_POSITIVE_INTEGER.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.NON_POSITIVE_INTEGER.getPrefixedName());
        }
    }

    @Override
    public @NonNull BigInteger getNegativeInteger() throws LiteralException {
        try {
            if (this.isNumeric()) {
                BigInteger i = new BigInteger(this.literal.getLiteral());
                if (i.signum() == -1) {
                    return i;
                }
                throw new LiteralException("invalid value " + this.getValue() + " for " + XSDVocabulary.NEGATIVE_INTEGER.getPrefixedName());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.NEGATIVE_INTEGER.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.NEGATIVE_INTEGER.getPrefixedName());
        }
    }

    @Override
    public @NonNull BigInteger getPositiveInteger() throws LiteralException {
        try {
            if (this.isNumeric()) {
                BigInteger i = new BigInteger(this.literal.getLiteral());
                if (i.signum() == 1) {
                    return i;
                }
                throw new LiteralException("invalid value " + this.getValue() + " for " + XSDVocabulary.POSITIVE_INTEGER.getPrefixedName());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.POSITIVE_INTEGER.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.POSITIVE_INTEGER.getPrefixedName());
        }
    }

    @Override
    public long getUnsignedLong() throws LiteralException {
        try {
            if (this.isNumeric()) {
                long l = Long.parseLong(this.literal.getLiteral());
                if (l >= 0L) {
                    return l;
                }
                throw new LiteralException("negative value " + this.getValue() + " for " + XSDVocabulary.UNSIGNED_LONG.getPrefixedName());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.UNSIGNED_LONG.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.UNSIGNED_LONG.getPrefixedName());
        }
    }

    @Override
    public long getUnsignedInt() throws LiteralException {
        try {
            if (this.isNumeric()) {
                long l = Long.parseLong(this.literal.getLiteral());
                if (l >= 0L) {
                    return l;
                }
                throw new LiteralException("negative value " + this.getValue() + " for " + XSDVocabulary.UNSIGNED_INT.getPrefixedName());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.UNSIGNED_INT.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.UNSIGNED_INT.getPrefixedName());
        }
    }

    @Override
    public int getUnsignedShort() throws LiteralException {
        try {
            if (this.isNumeric()) {
                int i = Integer.parseInt(this.literal.getLiteral());
                if (i >= 0) {
                    return i;
                }
                throw new LiteralException("negative value " + this.getValue() + " for " + XSDVocabulary.UNSIGNED_SHORT.getPrefixedName());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.UNSIGNED_SHORT.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.UNSIGNED_SHORT.getPrefixedName());
        }
    }

    @Override
    public short getUnsignedByte() throws LiteralException {
        try {
            if (this.isNumeric()) {
                short s = Short.parseShort(this.literal.getLiteral());
                if (s >= 0) {
                    return s;
                }
                throw new LiteralException("negative value " + this.getValue() + " for " + XSDVocabulary.UNSIGNED_BYTE.getPrefixedName());
            }
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.UNSIGNED_BYTE.getPrefixedName());
        }
        catch (NumberFormatException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.UNSIGNED_BYTE.getPrefixedName());
        }
    }

    @Override
    public @NonNull URI getAnyURI() throws LiteralException {
        try {
            if (!this.isAnyURI()) {
                throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.ANY_URI.getPrefixedName());
            }
            return URI.create(this.literal.getLiteral());
        }
        catch (IllegalArgumentException e) {
            throw new LiteralException("cannot convert value " + this.literal.getLiteral() + " of type " + this.literal.getDatatype() + " to " + XSDVocabulary.ANY_URI.getPrefixedName());
        }
    }

    @Override
    public @NonNull XSDTime getTime() throws LiteralException {
        if (!this.isTime()) {
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.TIME.getPrefixedName());
        }
        return new XSDTime(this.literal.getLiteral());
    }

    @Override
    public @NonNull XSDDate getDate() throws LiteralException {
        if (!this.isDate()) {
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.DATE.getPrefixedName());
        }
        return new XSDDate(this.literal.getLiteral());
    }

    @Override
    public @NonNull XSDDateTime getDateTime() throws LiteralException {
        if (!this.isDateTime()) {
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.DATE_TIME.getPrefixedName());
        }
        return new XSDDateTime(this.literal.getLiteral());
    }

    @Override
    public @NonNull XSDDuration getDuration() throws LiteralException {
        if (!this.isDuration()) {
            throw new LiteralException("cannot convert value of type " + this.literal.getDatatype() + " to " + XSDVocabulary.DURATION.getPrefixedName());
        }
        return new XSDDuration(this.literal.getLiteral());
    }

    @Override
    public @NonNull String getValue() {
        return this.literal.getLiteral();
    }

    @Override
    public @NonNull OWLDatatype getOWLDatatype() {
        return this.literal.getDatatype();
    }

    @Override
    public @NonNull String getOWLDatatypeName() {
        return this.getOWLDatatype().toString();
    }

    @Override
    @SideEffectFree
    public @NonNull String toString() {
        return this.literal.toString();
    }

    @Override
    public @NonNull String toQuotedString() {
        return "\"" + this.literal.toString().replaceAll("[~\\\\]\"", "\\\\\"") + "\"";
    }

    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultLiteral impl = (DefaultLiteral)obj;
        return this.literal != null && impl.literal != null && this.literal.equals(impl.literal);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int hash = 95;
        return hash += null == this.literal ? 0 : this.literal.hashCode();
    }
}

