/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.swrlapi.owl2rl.OWL2RLNames;
import org.swrlapi.owl2rl.OWL2RLPersistenceLayer;

public class DefaultOWL2RLPersistenceLayer
implements OWL2RLPersistenceLayer {
    private final @NonNull OWLOntology ontology;

    public DefaultOWL2RLPersistenceLayer(@NonNull OWLOntology ontology) {
        this.ontology = ontology;
    }

    @Override
    public @NonNull Set<OWL2RLNames.OWL2RLRule> getEnabledRules() {
        HashSet<OWL2RLNames.OWL2RLRule> enabledRules = new HashSet<OWL2RLNames.OWL2RLRule>();
        for (OWL2RLNames.OWL2RLRule rule : EnumSet.allOf(OWL2RLNames.OWL2RLRule.class)) {
            if (this.isOWL2RLRuleDisabled(rule)) continue;
            enabledRules.add(rule);
        }
        return enabledRules;
    }

    @Override
    public void setEnabledRules(@NonNull Set<OWL2RLNames.OWL2RLRule> rules) {
    }

    @Override
    public void setDisabledRule(OWL2RLNames.OWL2RLRule rule) {
        this.disableRule(rule);
    }

    @Override
    public void setDisabledRules(@NonNull Set<OWL2RLNames.OWL2RLRule> rules) {
        rules.forEach(this::disableRule);
    }

    @Override
    public void disableAll() {
        for (OWL2RLNames.OWL2RLRule rule : EnumSet.allOf(OWL2RLNames.OWL2RLRule.class)) {
            this.disableRule(rule);
        }
    }

    private void disableRule(OWL2RLNames.OWL2RLRule rule) {
        if (!this.isOWL2RLRuleDisabled(rule)) {
            // empty if block
        }
    }

    private boolean isOWL2RLRuleDisabled(OWL2RLNames.OWL2RLRule rule) {
        return false;
    }
}

