/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.factory.OWLDatatypeFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;

class DefaultOWLDatatypeFactory
implements OWLDatatypeFactory {
    DefaultOWLDatatypeFactory() {
    }

    @Override
    public @NonNull OWLDatatype getOWLDatatype(@NonNull IRI iri) {
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getBooleanDatatype() {
        IRI iri = XSDVocabulary.BOOLEAN.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getShortDatatype() {
        IRI iri = XSDVocabulary.SHORT.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getDoubleDatatype() {
        IRI iri = XSDVocabulary.DOUBLE.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getFloatDatatype() {
        IRI iri = XSDVocabulary.FLOAT.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getDecimalDatatype() {
        IRI iri = XSDVocabulary.DECIMAL.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getIntegerDatatype() {
        IRI iri = XSDVocabulary.INTEGER.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getIntDatatype() {
        IRI iri = XSDVocabulary.INT.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getLongDatatype() {
        IRI iri = XSDVocabulary.LONG.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getStringDatatype() {
        IRI iri = XSDVocabulary.STRING.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getByteDatatype() {
        IRI iri = XSDVocabulary.BYTE.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getURIDatatype() {
        IRI iri = XSDVocabulary.ANY_URI.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getDateDatatype() {
        IRI iri = XSDVocabulary.DATE.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getTimeDatatype() {
        IRI iri = XSDVocabulary.TIME.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getDateTimeDatatype() {
        IRI iri = XSDVocabulary.DATE_TIME.getIRI();
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public @NonNull OWLDatatype getDurationDatatype() {
        IRI iri = XSDVocabulary.DURATION.getIRI();
        return new OWLDatatypeImpl(iri);
    }
}

