/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.factory.OWLDatatypeFactory;
import org.swrlapi.factory.OWLLiteralFactory;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.literal.OWLLiteralValidator;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;

class DefaultOWLLiteralFactory
implements OWLLiteralFactory {
    private final @NonNull OWLDatatypeFactory datatypeFactory = SWRLAPIInternalFactory.createOWLDatatypeFactory();

    @Override
    public @NonNull OWLLiteral getOWLLiteral(byte b) {
        return new OWLLiteralImpl("" + b, "", this.getOWLDatatypeFactory().getByteDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(short s) {
        return new OWLLiteralImpl("" + s, "", this.getOWLDatatypeFactory().getShortDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(int i) {
        return new OWLLiteralImpl("" + i, "", this.getOWLDatatypeFactory().getIntDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(long l) {
        return new OWLLiteralImpl("" + l, "", this.getOWLDatatypeFactory().getLongDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(float f) {
        return new OWLLiteralImpl("" + f, "", this.getOWLDatatypeFactory().getFloatDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(double d) {
        return new OWLLiteralImpl("" + d, "", this.getOWLDatatypeFactory().getDoubleDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(@NonNull BigDecimal d) {
        return new OWLLiteralImpl("" + d, "", this.getOWLDatatypeFactory().getDecimalDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(@NonNull BigInteger i) {
        return new OWLLiteralImpl("" + i, "", this.getOWLDatatypeFactory().getIntegerDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(@NonNull String s) {
        return new OWLLiteralImpl(s, "", this.getOWLDatatypeFactory().getStringDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(boolean b) {
        return new OWLLiteralImpl("" + b, "", this.getOWLDatatypeFactory().getBooleanDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(URI uri) {
        return new OWLLiteralImpl("" + uri, "", this.getOWLDatatypeFactory().getURIDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(@NonNull XSDDate date) {
        return new OWLLiteralImpl(date.getContent(), "", this.getOWLDatatypeFactory().getDateDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(@NonNull XSDTime time) {
        return new OWLLiteralImpl(time.getContent(), "", this.getOWLDatatypeFactory().getTimeDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(@NonNull XSDDateTime datetime) {
        return new OWLLiteralImpl(datetime.getContent(), "", this.getOWLDatatypeFactory().getDateTimeDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(@NonNull XSDDuration duration) {
        return new OWLLiteralImpl(duration.getContent(), "", this.getOWLDatatypeFactory().getDurationDatatype());
    }

    @Override
    public @NonNull OWLLiteral getOWLLiteral(@NonNull String literal, @NonNull OWLDatatype datatype) {
        this.validateOWLLiteral(literal, datatype);
        return new OWLLiteralImpl(literal, "", datatype);
    }

    @Override
    public @NonNull OWLLiteral createLeastNarrowNumericOWLLiteral(double value, @NonNull List<@NonNull OWLLiteral> inputLiterals) {
        if (this.isWidestNumericLiteralAByte(inputLiterals)) {
            return this.getOWLLiteral((byte)value);
        }
        if (this.isWidestNumericLiteralAShort(inputLiterals)) {
            return this.getOWLLiteral((short)value);
        }
        if (this.isWidestNumericLiteralAnInt(inputLiterals)) {
            return this.getOWLLiteral((int)value);
        }
        if (this.isWidestNumericLiteralALong(inputLiterals)) {
            return this.getOWLLiteral((long)value);
        }
        if (this.isWidestNumericLiteralAFloat(inputLiterals)) {
            return this.getOWLLiteral((float)value);
        }
        return this.getOWLLiteral(value);
    }

    private boolean isWidestNumericLiteralAByte(@NonNull List<@NonNull OWLLiteral> literals) {
        for (OWLLiteral literal : literals) {
            if (!this.isShort(literal) && !this.isInt(literal) && !this.isLong(literal) && !this.isFloat(literal) && !this.isDouble(literal)) continue;
            return false;
        }
        return true;
    }

    private boolean isWidestNumericLiteralAShort(@NonNull List<@NonNull OWLLiteral> literals) {
        for (OWLLiteral literal : literals) {
            if (!this.isInt(literal) && !this.isLong(literal) && !this.isFloat(literal) && !this.isDouble(literal)) continue;
            return false;
        }
        return true;
    }

    private boolean isWidestNumericLiteralAnInt(@NonNull List<@NonNull OWLLiteral> literals) {
        for (OWLLiteral literal : literals) {
            if (!this.isLong(literal) && !this.isFloat(literal) && !this.isDouble(literal)) continue;
            return false;
        }
        return true;
    }

    private boolean isWidestNumericLiteralALong(@NonNull List<@NonNull OWLLiteral> literals) {
        for (OWLLiteral literal : literals) {
            if (!this.isFloat(literal) && !this.isDouble(literal)) continue;
            return false;
        }
        return true;
    }

    private boolean isWidestNumericLiteralAFloat(@NonNull List<@NonNull OWLLiteral> literals) {
        for (OWLLiteral literal : literals) {
            if (!this.isDouble(literal)) continue;
            return false;
        }
        return true;
    }

    private boolean isShort(@NonNull OWLLiteral literal) {
        return literal.getDatatype().getIRI().equals((Object)XSDVocabulary.SHORT.getIRI());
    }

    private boolean isInt(@NonNull OWLLiteral literal) {
        return literal.getDatatype().getIRI().equals((Object)XSDVocabulary.INT.getIRI());
    }

    private boolean isLong(@NonNull OWLLiteral literal) {
        return literal.getDatatype().getIRI().equals((Object)XSDVocabulary.LONG.getIRI());
    }

    private boolean isFloat(@NonNull OWLLiteral literal) {
        return literal.getDatatype().isFloat();
    }

    private boolean isDouble(@NonNull OWLLiteral literal) {
        return literal.getDatatype().isDouble();
    }

    private void validateOWLLiteral(@NonNull String literal, @NonNull OWLDatatype datatype) {
        if (!OWLLiteralValidator.isValid(literal, datatype)) {
            throw new RuntimeException("literal value '" + literal + "' is not a valid " + datatype.getIRI());
        }
    }

    private @NonNull OWLDatatypeFactory getOWLDatatypeFactory() {
        return this.datatypeFactory;
    }
}

