/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.model.IRI;
import org.swrlapi.builtins.arguments.SQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentType;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentVisitor;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentVisitorEx;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.factory.DefaultSWRLVariableBuiltInArgument;

class DefaultSQWRLCollectionVariableBuiltInArgument
extends DefaultSWRLVariableBuiltInArgument
implements SQWRLCollectionVariableBuiltInArgument {
    private static final long serialVersionUID = 1L;
    private final @NonNull String queryName;
    private final @NonNull String collectionName;
    private final @NonNull String collectionGroupID;

    public DefaultSQWRLCollectionVariableBuiltInArgument(@NonNull IRI variableIRI, @NonNull String queryName, @NonNull String collectionName, @NonNull String collectionGroupID) {
        super(variableIRI);
        this.queryName = queryName;
        this.collectionName = collectionName;
        this.collectionGroupID = collectionGroupID;
    }

    @Override
    public @NonNull SWRLBuiltInArgumentType<?> getSWRLBuiltInArgumentType() {
        return SWRLBuiltInArgumentType.COLLECTION_VARIABLE;
    }

    @Override
    public String getGroupID() {
        return this.collectionGroupID;
    }

    @Override
    public @NonNull String getQueryName() {
        return this.queryName;
    }

    @Override
    public @NonNull String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public @NonNull SQWRLCollectionVariableBuiltInArgument asCollectionVariable() throws SWRLBuiltInException {
        return this;
    }

    @Override
    public <T> @NonNull T accept(@NonNull SWRLBuiltInArgumentVisitorEx<@NonNull T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(@NonNull SWRLBuiltInArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultSQWRLCollectionVariableBuiltInArgument that = (DefaultSQWRLCollectionVariableBuiltInArgument)o;
        if (!Objects.equals(this.queryName, that.queryName)) {
            return false;
        }
        if (!Objects.equals(this.collectionName, that.collectionName)) {
            return false;
        }
        return Objects.equals(this.collectionGroupID, that.collectionGroupID);
    }

    @Override
    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.queryName != null ? this.queryName.hashCode() : 0);
        result = 31 * result + (this.collectionName != null ? this.collectionName.hashCode() : 0);
        result = 31 * result + (this.collectionGroupID != null ? this.collectionGroupID.hashCode() : 0);
        return result;
    }
}

