/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLAPIBuiltInAtom;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.factory.LiteralFactory;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.literal.Literal;
import org.swrlapi.sqwrl.SQWRLNames;
import org.swrlapi.sqwrl.SQWRLQuery;
import org.swrlapi.sqwrl.SQWRLResult;
import org.swrlapi.sqwrl.SQWRLResultGenerator;
import org.swrlapi.sqwrl.SQWRLResultManager;
import org.swrlapi.sqwrl.exceptions.SQWRLException;

class DefaultSQWRLQuery
implements SQWRLQuery {
    private final @NonNull String queryName;
    private final @NonNull List<@NonNull SWRLAtom> bodyAtoms;
    private final @NonNull List<@NonNull SWRLAtom> headAtoms;
    private final @NonNull SQWRLResultManager sqwrlResult;
    private final @NonNull Map<@NonNull String, @NonNull List<@NonNull SWRLBuiltInArgument>> collectionGroupArgumentsMap;
    private final @NonNull IRIResolver iriResolver;
    private final @NonNull LiteralFactory literalFactory;
    private final @NonNull String comment;
    private boolean active;

    public DefaultSQWRLQuery(@NonNull String queryName, @NonNull List<@NonNull SWRLAtom> bodyAtoms, @NonNull List<@NonNull SWRLAtom> headAtoms, boolean active, @NonNull String comment, @NonNull LiteralFactory literalFactory, @NonNull IRIResolver iriResolver) throws SWRLBuiltInException {
        this.queryName = queryName;
        this.bodyAtoms = new ArrayList<SWRLAtom>(bodyAtoms);
        this.headAtoms = new ArrayList<SWRLAtom>(headAtoms);
        this.active = active;
        this.comment = comment;
        this.sqwrlResult = SWRLAPIInternalFactory.createSQWRLResultManager(iriResolver);
        this.collectionGroupArgumentsMap = new HashMap<String, List<SWRLBuiltInArgument>>();
        this.iriResolver = iriResolver;
        this.literalFactory = literalFactory;
        this.processSQWRLBuiltIns();
        this.generateBuiltInAtomVariableDependencies();
    }

    @Override
    public @NonNull String getQueryName() {
        return this.queryName;
    }

    @Override
    public @NonNull List<@NonNull SWRLAtom> getHeadAtoms() {
        return Collections.unmodifiableList(this.headAtoms);
    }

    @Override
    public @NonNull List<@NonNull SWRLAtom> getBodyAtoms() {
        return Collections.unmodifiableList(this.bodyAtoms);
    }

    @Override
    public @NonNull SQWRLResult getSQWRLResult() throws SQWRLException {
        if (!this.sqwrlResult.isPrepared()) {
            this.sqwrlResult.prepared();
        }
        return this.sqwrlResult;
    }

    @Override
    public @NonNull SQWRLResultGenerator getSQWRLResultGenerator() {
        return this.sqwrlResult;
    }

    @Override
    public boolean hasSQWRLCollections() {
        return !this.getBuiltInAtomsFromBody(SQWRLNames.getCollectionMakeBuiltInNames()).isEmpty();
    }

    @Override
    public @NonNull List<@NonNull SWRLAPIBuiltInAtom> getBuiltInAtomsFromBody(@NonNull Set<@NonNull String> builtInNames) {
        return this.getBuiltInAtoms(this.getBodyAtoms(), builtInNames);
    }

    @Override
    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    @Override
    public @NonNull String getComment() {
        return this.comment;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public @NonNull List<@NonNull SWRLAtom> getSQWRLPhase1BodyAtoms() {
        ArrayList<@NonNull SWRLAtom> result = new ArrayList<SWRLAtom>();
        for (SWRLAtom atom : this.getBodyAtoms()) {
            SWRLAPIBuiltInAtom builtInAtom;
            if (atom instanceof SWRLAPIBuiltInAtom && ((builtInAtom = (SWRLAPIBuiltInAtom)atom).usesSQWRLCollectionResults() || this.isSQWRLGroupCollection(builtInAtom))) continue;
            result.add(atom);
        }
        return result;
    }

    @Override
    public @NonNull List<@NonNull SWRLAtom> getSQWRLPhase2BodyAtoms() {
        ArrayList<@NonNull SWRLAtom> result = new ArrayList<SWRLAtom>();
        for (SWRLAtom atom : this.getBodyAtoms()) {
            SWRLAPIBuiltInAtom builtInAtom;
            if (atom instanceof SWRLAPIBuiltInAtom && (this.isSQWRLMakeCollection(builtInAtom = (SWRLAPIBuiltInAtom)atom) || this.isSQWRLGroupCollection(builtInAtom))) continue;
            result.add(atom);
        }
        return result;
    }

    private List<@NonNull SWRLAPIBuiltInAtom> getBuiltInAtomsFromBody() {
        return this.getBuiltInAtoms(this.getBodyAtoms());
    }

    private boolean isSQWRLMakeCollection(@NonNull SWRLAPIBuiltInAtom builtInAtom) {
        return SQWRLNames.isSQWRLCollectionMakeBuiltIn(builtInAtom.getBuiltInPrefixedName());
    }

    private boolean isSQWRLGroupCollection(@NonNull SWRLAPIBuiltInAtom builtInAtom) {
        return SQWRLNames.isSQWRLCollectionGroupByBuiltIn(builtInAtom.getBuiltInPrefixedName());
    }

    private List<@NonNull SWRLAPIBuiltInAtom> getBuiltInAtomsFromHead() {
        return this.getBuiltInAtoms(this.getHeadAtoms());
    }

    private @NonNull List<@NonNull SWRLAPIBuiltInAtom> getBuiltInAtomsFromHead(@NonNull Set<@NonNull String> builtInNames) {
        return this.getBuiltInAtoms(this.getHeadAtoms(), builtInNames);
    }

    private @NonNull List<@NonNull SWRLAPIBuiltInAtom> getBuiltInAtoms(@NonNull List<@NonNull SWRLAtom> atoms) {
        return atoms.stream().filter(atom -> atom instanceof SWRLAPIBuiltInAtom).map(atom -> (SWRLAPIBuiltInAtom)atom).collect(Collectors.toList());
    }

    private @NonNull List<@NonNull SWRLAPIBuiltInAtom> getBuiltInAtoms(@NonNull List<@NonNull SWRLAtom> atoms, @NonNull Set<@NonNull String> builtInNames) {
        ArrayList<@NonNull SWRLAPIBuiltInAtom> result = new ArrayList<SWRLAPIBuiltInAtom>();
        atoms.stream().filter(atom -> atom instanceof SWRLAPIBuiltInAtom).forEach(atom -> {
            SWRLAPIBuiltInAtom builtInAtom = (SWRLAPIBuiltInAtom)atom;
            if (builtInNames.contains(builtInAtom.getBuiltInPrefixedName())) {
                result.add(builtInAtom);
            }
        });
        return result;
    }

    private void processSQWRLBuiltIns() throws SWRLBuiltInException {
        HashSet<@NonNull String> collectionNames = new HashSet<String>();
        HashSet<@NonNull String> cascadedUnboundVariableNames = new HashSet<String>();
        this.processSQWRLHeadBuiltIns();
        this.processSQWRLCollectionMakeBuiltIns(collectionNames);
        this.processSQWRLCollectionGroupByBuiltIns(collectionNames);
        this.processSQWRLCollectionMakeGroupArguments(collectionNames);
        this.processSQWRLCollectionOperationBuiltIns(collectionNames, cascadedUnboundVariableNames);
        this.processBuiltInsThatUseSQWRLCollectionOperationResults(cascadedUnboundVariableNames);
        this.sqwrlResult.configured();
        this.sqwrlResult.openRow();
        if (this.hasSQWRLCollections()) {
            this.sqwrlResult.setIsDistinct();
        }
    }

    private void processSQWRLHeadBuiltIns() throws SWRLBuiltInException {
        HashMap<@NonNull String, @NonNull List<@NonNull Integer>> selectedVariable2ColumnIndices = new HashMap<String, List<Integer>>();
        this.assignBuiltInIndexes();
        for (SWRLAPIBuiltInAtom builtInAtom : this.getBuiltInAtomsFromHead(SQWRLNames.getHeadBuiltInNames())) {
            String builtInName = builtInAtom.getBuiltInPrefixedName();
            this.processBuiltInArguments(builtInAtom, selectedVariable2ColumnIndices);
            if (!SQWRLNames.isSQWRLHeadSlicingBuiltIn(builtInName)) continue;
            this.processHeadSlicingBuiltIn(builtInAtom);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processHeadSlicingBuiltIn(@NonNull SWRLAPIBuiltInAtom builtInAtom) throws SQWRLException {
        int sliceN;
        String builtInPrefixedName = builtInAtom.getBuiltInPrefixedName();
        if (this.sqwrlResult.getCurrentNumberOfColumns() == 0) {
            throw new SQWRLException("slicing operator used without a select clause");
        }
        if (!this.sqwrlResult.isOrdered() && !builtInPrefixedName.equals("sqwrl:limit")) {
            throw new SQWRLException("slicing operator used without an order clause");
        }
        SWRLBuiltInArgument nArgument = builtInAtom.getBuiltInArguments().get(0);
        if (!(nArgument instanceof SWRLLiteralBuiltInArgument)) throw new SQWRLException("expecting xsd:int or xsd:integer argument for slicing operator " + builtInPrefixedName);
        SWRLLiteralBuiltInArgument sliceNArgument = (SWRLLiteralBuiltInArgument)nArgument;
        Literal literal = this.literalFactory.getLiteral(sliceNArgument.getLiteral());
        if (literal.isInt()) {
            sliceN = literal.getInt();
            if (sliceN < 1) {
                throw new SQWRLException("nth argument for slicing operator " + builtInPrefixedName + " must be a positive xsd:int or xsd:integer");
            }
        } else {
            if (!literal.isInteger()) throw new SQWRLException("expecting xsd:int or xsd:integer argument for slicing operator " + builtInPrefixedName);
            BigInteger value = literal.getInteger();
            if (value.compareTo(BigInteger.ZERO) <= 0) {
                throw new SQWRLException("nth argument for slicing operator " + builtInPrefixedName + " must be a positive xsd:int or xsd:integer");
            }
            if (value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new SQWRLException("nth argument for slicing operator " + builtInPrefixedName + " must not be greater than " + Integer.MAX_VALUE);
            }
            sliceN = value.intValue();
        }
        if (builtInAtom.getNumberOfArguments() == 1) {
            this.processHeadSliceOperationWithoutSliceSize(builtInPrefixedName, sliceN);
            return;
        } else {
            if (builtInAtom.getNumberOfArguments() != 2) throw new SQWRLException("slicing operator " + builtInPrefixedName + " expecting a maximum of 2 arguments");
            this.processHeadSliceOperationWithSliceSize(builtInAtom, builtInPrefixedName, sliceN);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processHeadSliceOperationWithSliceSize(@NonNull SWRLAPIBuiltInAtom builtInAtom, @NonNull String builtInName, int sliceN) throws SQWRLException {
        int sliceSize;
        SWRLBuiltInArgument sliceSizeArgument = builtInAtom.getBuiltInArguments().get(1);
        if (!(sliceSizeArgument instanceof SWRLLiteralBuiltInArgument)) throw new SQWRLException("expecting xsd:int or xsd:integer argument for slicing operator " + builtInName);
        SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)sliceSizeArgument;
        Literal literal = this.literalFactory.getLiteral(literalArgument.getLiteral());
        if (literal.isInt()) {
            sliceSize = literal.getInt();
            if (sliceSize < 1) {
                throw new SQWRLException("slice size argument to slicing operator " + builtInName + " must be a positive xsd:int or xsd:integer");
            }
        } else {
            if (!literal.isInteger()) throw new SQWRLException("expecting xsd:int or xsd:integer argument for slicing operator " + builtInName);
            BigInteger value = literal.getInteger();
            if (value.compareTo(BigInteger.ZERO) <= 0) {
                throw new SQWRLException("slice size argument to slicing operator " + builtInName + " must be a positive xsd:int or xsd:integer");
            }
            if (value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new SQWRLException("slice size argument to slicing operator " + builtInName + " must not be greater than " + Integer.MAX_VALUE);
            }
            sliceSize = value.intValue();
        }
        if (builtInName.equalsIgnoreCase("sqwrl:nthSlice")) {
            this.sqwrlResult.setNthSlice(sliceN, sliceSize);
            return;
        } else if (builtInName.equalsIgnoreCase("sqwrl:notNthSlice")) {
            this.sqwrlResult.setNotNthSlice(sliceN, sliceSize);
            return;
        } else if (builtInName.equalsIgnoreCase("sqwrl:nthLastSlice") || builtInName.equalsIgnoreCase("sqwrl:nthGreatestSlice")) {
            this.sqwrlResult.setNthLastSlice(sliceN, sliceSize);
            return;
        } else {
            if (!builtInName.equalsIgnoreCase("sqwrl:notNthLastSlice") && !builtInName.equalsIgnoreCase("sqwrl:notNthGreatestSlice")) throw new SQWRLException("unknown slicing operator " + builtInName);
            this.sqwrlResult.setNotNthLastSlice(sliceN, sliceSize);
        }
    }

    private void processHeadSliceOperationWithoutSliceSize(@NonNull String builtInName, int sliceN) throws SQWRLException {
        if (builtInName.equalsIgnoreCase("sqwrl:limit")) {
            this.sqwrlResult.setLimit(sliceN);
        } else if (builtInName.equalsIgnoreCase("sqwrl:nth")) {
            this.sqwrlResult.setNth(sliceN);
        } else if (builtInName.equalsIgnoreCase("sqwrl:notNth")) {
            this.sqwrlResult.setNotNth(sliceN);
        } else if (builtInName.equalsIgnoreCase("sqwrl:firstN") || builtInName.equalsIgnoreCase("sqwrl:leastN")) {
            this.sqwrlResult.setFirst(sliceN);
        } else if (builtInName.equalsIgnoreCase("sqwrl:lastN") || builtInName.equalsIgnoreCase("sqwrl:greatestN")) {
            this.sqwrlResult.setLast(sliceN);
        } else if (builtInName.equalsIgnoreCase("sqwrl:notLastN") || builtInName.equalsIgnoreCase("sqwrl:notGreatestN")) {
            this.sqwrlResult.setNotLast(sliceN);
        } else if (builtInName.equalsIgnoreCase("sqwrl:notFirstN") || builtInName.equalsIgnoreCase("sqwrl:notLeastN")) {
            this.sqwrlResult.setNotFirst(sliceN);
        } else {
            throw new SQWRLException("unknown slicing operator " + builtInName);
        }
    }

    private void processBuiltInArguments(@NonNull SWRLAPIBuiltInAtom builtInAtom, @NonNull Map<@NonNull String, @NonNull List<@NonNull Integer>> selectedVariable2ColumnIndices) throws SWRLBuiltInException {
        String builtInName = builtInAtom.getBuiltInPrefixedName();
        int columnIndex = 0;
        for (SWRLBuiltInArgument argument : builtInAtom.getBuiltInArguments()) {
            if (SQWRLNames.isSQWRLHeadSelectionBuiltIn(builtInName) || SQWRLNames.isSQWRLHeadAggregationBuiltIn(builtInName)) {
                if (argument.isVariable()) {
                    String variableName = argument.asVariable().getVariableName();
                    if (selectedVariable2ColumnIndices.containsKey(variableName)) {
                        selectedVariable2ColumnIndices.get(variableName).add(columnIndex);
                    } else {
                        selectedVariable2ColumnIndices.put(variableName, new ArrayList());
                        selectedVariable2ColumnIndices.get(variableName).add(columnIndex);
                    }
                }
                if (builtInName.equalsIgnoreCase("sqwrl:select")) {
                    this.processSelectArgument(argument);
                } else if (builtInName.equalsIgnoreCase("sqwrl:selectDistinct")) {
                    this.processSelectDistinctArgument(argument);
                } else if (builtInName.equalsIgnoreCase("sqwrl:count")) {
                    this.processCountArgument(argument);
                } else if (builtInName.equalsIgnoreCase("sqwrl:countDistinct")) {
                    this.processCountDistinctArgument(argument);
                } else if (builtInName.equalsIgnoreCase("sqwrl:min")) {
                    this.processMinArgument(argument);
                } else if (builtInName.equalsIgnoreCase("sqwrl:max")) {
                    this.processMaxArgument(argument);
                } else if (builtInName.equalsIgnoreCase("sqwrl:sum")) {
                    this.processSumArgument(argument);
                } else if (builtInName.equalsIgnoreCase("sqwrl:median")) {
                    this.processMedianArgument(argument);
                } else if (builtInName.equalsIgnoreCase("sqwrl:avg")) {
                    this.processAverageArgument(argument);
                } else if (builtInName.equalsIgnoreCase("sqwrl:orderBy")) {
                    if (!argument.isVariable()) {
                        throw new SQWRLException("only variables allowed for ordered columns - found " + argument.getClass().getName());
                    }
                    this.processOrderByArgument(selectedVariable2ColumnIndices, argument.asVariable());
                } else if (builtInName.equalsIgnoreCase("sqwrl:orderByDescending")) {
                    if (!argument.isVariable()) {
                        throw new SQWRLException("only variables allowed for ordered columns - found " + argument.getClass().getName());
                    }
                    this.processOrderByDescendingArgument(selectedVariable2ColumnIndices, argument.asVariable());
                } else if (builtInName.equalsIgnoreCase("sqwrl:columnNames")) {
                    this.processColumnNamesArgument(argument);
                }
            }
            ++columnIndex;
        }
    }

    private void processSumArgument(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        String columnName = argument.isVariable() ? "sum(?" + argument.asVariable().getVariableName() + ")" : "C" + this.sqwrlResult.getCurrentNumberOfColumns();
        this.sqwrlResult.addAggregateColumn(columnName, "sum");
    }

    private void processMaxArgument(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        String columnName = argument.isVariable() ? "max(?" + argument.asVariable().getVariableName() + ")" : "C" + this.sqwrlResult.getCurrentNumberOfColumns();
        this.sqwrlResult.addAggregateColumn(columnName, "max");
    }

    private void processMinArgument(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        String columnName = argument.isVariable() ? "min(?" + argument.asVariable().getVariableName() + ")" : "C" + this.sqwrlResult.getCurrentNumberOfColumns();
        this.sqwrlResult.addAggregateColumn(columnName, "min");
    }

    private void processCountArgument(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        String columnName = argument.isVariable() ? "count(?" + argument.asVariable().getVariableName() + ")" : "C" + this.sqwrlResult.getCurrentNumberOfColumns();
        this.sqwrlResult.addAggregateColumn(columnName, "count");
    }

    private void processCountDistinctArgument(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        String columnName = argument.isVariable() ? "countDistinct(?" + argument.asVariable().getVariableName() + ")" : "C" + this.sqwrlResult.getCurrentNumberOfColumns();
        this.sqwrlResult.addAggregateColumn(columnName, "countDistinct");
    }

    private void processSelectDistinctArgument(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        this.processSelectArgument(argument);
        this.sqwrlResult.setIsDistinct();
    }

    private void processSelectArgument(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        String columnName = argument.isVariable() ? argument.asVariable().getVariableName() : "C" + this.sqwrlResult.getCurrentNumberOfColumns();
        this.sqwrlResult.addColumn(columnName);
    }

    private void processAverageArgument(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        String columnName = argument.isVariable() ? "avg(?" + argument.asVariable().getVariableName() + ")" : "avg";
        this.sqwrlResult.addAggregateColumn(columnName, "avg");
    }

    private void processMedianArgument(@NonNull SWRLBuiltInArgument argument) throws SWRLBuiltInException {
        String columnName = argument.isVariable() ? "median(?" + argument.asVariable().getVariableName() + ")" : "C" + this.sqwrlResult.getCurrentNumberOfColumns();
        this.sqwrlResult.addAggregateColumn(columnName, "median");
    }

    private void processOrderByArgument(@NonNull Map<@NonNull String, @NonNull List<@NonNull Integer>> selectedVariable2ColumnIndices, @NonNull SWRLVariableBuiltInArgument argument) throws SQWRLException {
        String variableName = argument.getVariableName();
        if (selectedVariable2ColumnIndices.containsKey(variableName)) {
            for (int selectedColumnIndex : selectedVariable2ColumnIndices.get(variableName)) {
                this.sqwrlResult.setOrderByColumn(selectedColumnIndex, true);
            }
        } else {
            throw new SQWRLException("variable ?" + variableName + " must be selected before it can be ordered");
        }
    }

    private void processOrderByDescendingArgument(@NonNull Map<@NonNull String, @NonNull List<@NonNull Integer>> selectedVariable2ColumnIndices, @NonNull SWRLVariableBuiltInArgument argument) throws SQWRLException {
        String variableName = argument.getVariableName();
        if (selectedVariable2ColumnIndices.containsKey(variableName)) {
            for (int selectedColumnIndex : selectedVariable2ColumnIndices.get(variableName)) {
                this.sqwrlResult.setOrderByColumn(selectedColumnIndex, false);
            }
        } else {
            throw new SQWRLException("variable ?" + variableName + " must be selected before it can be ordered");
        }
    }

    private void processColumnNamesArgument(@NonNull SWRLBuiltInArgument argument) throws SQWRLException {
        Literal literal;
        if (argument instanceof SWRLLiteralBuiltInArgument) {
            SWRLLiteralBuiltInArgument literalArgument = (SWRLLiteralBuiltInArgument)argument;
            literal = this.literalFactory.getLiteral(literalArgument.getLiteral());
            if (!literal.isString()) {
                throw new SQWRLException("only string literals allowed as column names - found " + argument);
            }
        } else {
            throw new SQWRLException("only string literals allowed as column names - found " + argument);
        }
        this.sqwrlResult.addColumnDisplayName(literal.getString());
    }

    private void processSQWRLCollectionMakeBuiltIns(@NonNull Set<@NonNull String> collectionNames) throws SWRLBuiltInException {
        for (SWRLAPIBuiltInAtom builtInAtom : this.getBuiltInAtomsFromBody(SQWRLNames.getCollectionMakeBuiltInNames())) {
            String collectionName = builtInAtom.getArgumentVariableName(0);
            if (collectionNames.contains(collectionName)) continue;
            collectionNames.add(collectionName);
        }
    }

    private void processSQWRLCollectionGroupByBuiltIns(@NonNull Set<@NonNull String> collectionNames) throws SWRLBuiltInException {
        for (SWRLAPIBuiltInAtom builtInAtom : this.getBuiltInAtomsFromBody(SQWRLNames.getCollectionGroupByBuiltInNames())) {
            String collectionName = builtInAtom.getArgumentVariableName(0);
            List<@NonNull SWRLBuiltInArgument> builtInArguments = builtInAtom.getBuiltInArguments();
            List<@NonNull SWRLBuiltInArgument> groupArguments = builtInArguments.subList(1, builtInArguments.size());
            if (builtInAtom.getArguments().size() < 2) {
                throw new SQWRLException("groupBy must have at least two arguments");
            }
            if (!collectionNames.contains(collectionName)) {
                throw new SQWRLException("groupBy applied to undefined collection " + collectionName);
            }
            if (this.collectionGroupArgumentsMap.containsKey(collectionName)) {
                throw new SQWRLException("groupBy specified more than once for collection " + collectionName);
            }
            if (this.hasUnboundArgument(groupArguments)) {
                throw new SQWRLException("unbound group argument passed to groupBy for collection " + collectionName);
            }
            this.collectionGroupArgumentsMap.put(collectionName, groupArguments);
        }
    }

    private void processSQWRLCollectionMakeGroupArguments(@NonNull Set<@NonNull String> collectionNames) throws SWRLBuiltInException {
        for (SWRLAPIBuiltInAtom builtInAtom : this.getBuiltInAtomsFromBody(SQWRLNames.getCollectionMakeBuiltInNames())) {
            String collectionName = builtInAtom.getArgumentVariableName(0);
            if (!collectionNames.contains(collectionName)) {
                throw new SQWRLException("groupBy applied to undefined collection " + collectionName);
            }
            if (!this.collectionGroupArgumentsMap.containsKey(collectionName)) continue;
            builtInAtom.addArguments(this.collectionGroupArgumentsMap.get(collectionName));
        }
    }

    private void processSQWRLCollectionOperationBuiltIns(@NonNull Set<@NonNull String> collectionNames, @NonNull Set<@NonNull String> cascadedUnboundVariableNames) throws SWRLBuiltInException {
        for (SWRLAPIBuiltInAtom builtInAtom : this.getBuiltInAtomsFromBody(SQWRLNames.getCollectionOperationBuiltInNames())) {
            ArrayList<@NonNull E> allOperandCollectionGroupArguments = new ArrayList();
            builtInAtom.setUsesSQWRLCollectionResults();
            if (builtInAtom.hasUnboundArguments()) {
                Set<@NonNull String> unboundVariableNames = builtInAtom.getUnboundArgumentVariableNames();
                cascadedUnboundVariableNames.addAll(unboundVariableNames);
            }
            List<String> variableNames = this.isSQWRLCollectionCreateOperation(builtInAtom) ? builtInAtom.getArgumentsVariableNamesExceptFirst() : builtInAtom.getArgumentsVariableNames();
            variableNames.stream().filter(variableName -> collectionNames.contains(variableName) && this.collectionGroupArgumentsMap.containsKey(variableName)).forEach(variableName -> {
                builtInAtom.addArguments(this.collectionGroupArgumentsMap.get(variableName));
                allOperandCollectionGroupArguments.addAll(this.collectionGroupArgumentsMap.get(variableName));
            });
            if (!this.isSQWRLCollectionCreateOperation(builtInAtom)) continue;
            String createdCollectionName = builtInAtom.getArgumentVariableName(0);
            if (!collectionNames.contains(createdCollectionName)) {
                collectionNames.add(createdCollectionName);
            }
            if (allOperandCollectionGroupArguments.isEmpty()) continue;
            this.collectionGroupArgumentsMap.put(createdCollectionName, allOperandCollectionGroupArguments);
        }
    }

    private void processBuiltInsThatUseSQWRLCollectionOperationResults(@NonNull Set<@NonNull String> cascadedUnboundVariableNames) throws SWRLBuiltInException {
        for (SWRLAPIBuiltInAtom builtInAtom : this.getBuiltInAtomsFromBody()) {
            if (this.isSQWRLBuiltIn(builtInAtom) || !builtInAtom.usesAtLeastOneVariableOf(cascadedUnboundVariableNames)) continue;
            builtInAtom.setUsesSQWRLCollectionResults();
            if (!builtInAtom.hasUnboundArguments()) continue;
            cascadedUnboundVariableNames.addAll(builtInAtom.getUnboundArgumentVariableNames());
        }
    }

    private void assignBuiltInIndexes() {
        int builtInIndex = 0;
        for (SWRLAPIBuiltInAtom builtInAtom : this.getBuiltInAtomsFromBody()) {
            builtInAtom.setBuiltInIndex(builtInIndex++);
        }
        for (SWRLAPIBuiltInAtom builtInAtom : this.getBuiltInAtomsFromHead()) {
            builtInAtom.setBuiltInIndex(builtInIndex++);
        }
    }

    private boolean isSQWRLBuiltIn(@NonNull SWRLAPIBuiltInAtom builtInAtom) {
        return SQWRLNames.isSQWRLBuiltIn(builtInAtom.getBuiltInPrefixedName());
    }

    private boolean hasUnboundArgument(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        for (SWRLBuiltInArgument argument : arguments) {
            if (!argument.isVariable() || !argument.asVariable().isUnbound()) continue;
            return true;
        }
        return false;
    }

    private boolean isSQWRLCollectionOperation(@NonNull SWRLAPIBuiltInAtom builtInAtom) {
        return SQWRLNames.isSQWRLCollectionOperationBuiltIn(builtInAtom.getBuiltInPrefixedName());
    }

    private boolean isSQWRLCollectionCreateOperation(@NonNull SWRLAPIBuiltInAtom builtInAtom) {
        return SQWRLNames.isSQWRLCollectionCreateOperationBuiltIn(builtInAtom.getBuiltInPrefixedName());
    }

    private void generateBuiltInAtomVariableDependencies() throws SWRLBuiltInException {
        HashMap<@NonNull String, @NonNull Set<@NonNull Set<@NonNull String>>> pathMap = new HashMap<String, Set<Set<String>>>();
        HashSet<@NonNull String> rootVariableNames = new HashSet<String>();
        for (SWRLAtom atom : this.getBodyAtoms()) {
            SWRLAPIBuiltInAtom builtInAtom;
            Set<@NonNull String> thisAtomReferencedVariableNames = this.getReferencedVariableNames(atom);
            this.buildPaths(atom, rootVariableNames, pathMap);
            if (!(atom instanceof SWRLAPIBuiltInAtom) || this.isSQWRLGroupCollection(builtInAtom = (SWRLAPIBuiltInAtom)atom)) continue;
            if (this.isSQWRLCollectionOperation(builtInAtom)) break;
            if (!this.hasReferencedVariables((SWRLAtom)builtInAtom)) continue;
            HashSet<@NonNull String> pathVariableNames = new HashSet<String>();
            for (String rootVariableName : pathMap.keySet()) {
                ((Set)pathMap.get(rootVariableName)).stream().filter(path -> !Collections.disjoint(path, thisAtomReferencedVariableNames)).forEach(path -> {
                    pathVariableNames.addAll((Collection<String>)path);
                    pathVariableNames.add(rootVariableName);
                });
            }
            if (pathVariableNames.isEmpty()) continue;
            pathVariableNames.removeAll(thisAtomReferencedVariableNames);
            builtInAtom.setPathVariableNames(pathVariableNames);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void buildPaths(@NonNull SWRLAtom atom, @NonNull Set<@NonNull String> rootVariableNames, @NonNull Map<@NonNull String, @NonNull Set<@NonNull Set<@NonNull String>>> pathMap) throws SWRLBuiltInException {
        block13: {
            Set<String> currentAtomReferencedVariableNames;
            block12: {
                currentAtomReferencedVariableNames = this.getReferencedVariableNames(atom);
                if (currentAtomReferencedVariableNames.size() != 1) break block12;
                String variableName = currentAtomReferencedVariableNames.iterator().next();
                if (!this.getMatchingPaths(pathMap, variableName).isEmpty() || rootVariableNames.contains(variableName)) break block13;
                pathMap.put(variableName, new HashSet());
                rootVariableNames.add(variableName);
                break block13;
            }
            if (currentAtomReferencedVariableNames.size() > 1) {
                HashSet<@NonNull String> currentKnownAtomRootVariableNames = new HashSet<String>(currentAtomReferencedVariableNames);
                currentKnownAtomRootVariableNames.retainAll(rootVariableNames);
                if (!currentKnownAtomRootVariableNames.isEmpty()) {
                    for (String rootVariableName : currentKnownAtomRootVariableNames) {
                        HashSet<@NonNull String> dependentVariables = new HashSet<String>(currentAtomReferencedVariableNames);
                        dependentVariables.remove(rootVariableName);
                        Set<String> matchingRootVariableNames = this.getMatchingRootVariableNames(pathMap, dependentVariables);
                        if (!matchingRootVariableNames.isEmpty()) {
                            for (String matchingRootVariableName : matchingRootVariableNames) {
                                Set<@NonNull Set<@NonNull String>> paths = pathMap.get(matchingRootVariableName);
                                Set<@NonNull @NonNull T> matchedPaths = paths.stream().filter(path -> !Collections.disjoint(path, dependentVariables)).collect(Collectors.toSet());
                                for (Set matchedPath : matchedPaths) {
                                    HashSet<@NonNull String> newPath = new HashSet<String>(matchedPath);
                                    newPath.addAll(dependentVariables);
                                    paths.remove(matchedPath);
                                    paths.add(Collections.unmodifiableSet(newPath));
                                }
                            }
                            continue;
                        }
                        Set<@NonNull Set<@NonNull String>> paths = pathMap.get(rootVariableName);
                        paths.add(Collections.unmodifiableSet(dependentVariables));
                    }
                } else {
                    Set<String> matchingRootVariableNames = this.getMatchingRootVariableNames(pathMap, currentAtomReferencedVariableNames);
                    if (!matchingRootVariableNames.isEmpty()) {
                        for (String matchingRootVariableName : matchingRootVariableNames) {
                            Set<@NonNull Set<@NonNull String>> paths = pathMap.get(matchingRootVariableName);
                            Set<@NonNull @NonNull T> matchedPaths = paths.stream().filter(path -> !Collections.disjoint(path, currentAtomReferencedVariableNames)).collect(Collectors.toSet());
                            for (Set matchedPath : matchedPaths) {
                                HashSet<@NonNull String> newPath = new HashSet<String>(matchedPath);
                                newPath.addAll(currentAtomReferencedVariableNames);
                                paths.remove(matchedPath);
                                paths.add(Collections.unmodifiableSet(newPath));
                            }
                        }
                    } else {
                        for (String rootVariableName : currentAtomReferencedVariableNames) {
                            HashSet<@NonNull Set<@NonNull String>> paths = new HashSet<Set<String>>();
                            HashSet<@NonNull String> dependentVariables = new HashSet<String>(currentAtomReferencedVariableNames);
                            dependentVariables.remove(rootVariableName);
                            paths.add(Collections.unmodifiableSet(dependentVariables));
                            pathMap.put(rootVariableName, paths);
                            rootVariableNames.add(rootVariableName);
                        }
                    }
                }
            }
        }
    }

    private @NonNull Set<@NonNull String> getMatchingPaths(@NonNull Map<@NonNull String, @NonNull Set<@NonNull Set<@NonNull String>>> pathMap, @NonNull String variableName) {
        return this.getMatchingRootVariableNames(pathMap, Collections.singleton(variableName));
    }

    private @NonNull Set<@NonNull String> getMatchingRootVariableNames(@NonNull Map<@NonNull String, @NonNull Set<@NonNull Set<@NonNull String>>> pathMap, @NonNull Set<@NonNull String> variableNames) {
        HashSet<@NonNull String> matchingRootVariableNames = new HashSet<String>();
        for (String rootVariableName : pathMap.keySet()) {
            Set<@NonNull Set<@NonNull String>> pathsWithSameRoot = pathMap.get(rootVariableName);
            matchingRootVariableNames.addAll(pathsWithSameRoot.stream().filter(path -> !Collections.disjoint(path, variableNames)).map(path -> rootVariableName).collect(Collectors.toList()));
        }
        return matchingRootVariableNames;
    }

    private @NonNull Set<@NonNull String> getReferencedVariableNames(@NonNull SWRLAtom atom) throws SWRLBuiltInException {
        HashSet<@NonNull String> referencedVariableNames = new HashSet<String>();
        for (SWRLArgument argument : atom.getAllArguments()) {
            if (atom instanceof SWRLBuiltInAtom) {
                if (!(argument instanceof SWRLVariableBuiltInArgument)) continue;
                SWRLVariableBuiltInArgument variableBuiltInArgument = (SWRLVariableBuiltInArgument)argument;
                referencedVariableNames.add(variableBuiltInArgument.getVariableName());
                continue;
            }
            if (!(argument instanceof SWRLVariable)) continue;
            SWRLVariable swrlVariable = (SWRLVariable)argument;
            IRI variableIRI = swrlVariable.getIRI();
            Optional<String> variableName = this.iriResolver.iri2VariableName(variableIRI);
            if (variableName.isPresent()) {
                referencedVariableNames.add(variableName.get());
                continue;
            }
            throw new SWRLBuiltInException("internal error: could not find variable name for variable IRI " + variableIRI);
        }
        return referencedVariableNames;
    }

    private boolean hasReferencedVariables(@NonNull SWRLAtom atom) throws SWRLBuiltInException {
        return !this.getReferencedVariableNames(atom).isEmpty();
    }
}

