/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.exceptions.SWRLAPIInternalException;
import org.swrlapi.factory.SQWRLResultValueFactory;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.sqwrl.SQWRLResultManager;
import org.swrlapi.sqwrl.SQWRLResultNames;
import org.swrlapi.sqwrl.exceptions.SQWRLException;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidAggregateFunctionNameException;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidColumnIndexException;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidColumnNameException;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidColumnTypeException;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidQueryException;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidRowIndexException;
import org.swrlapi.sqwrl.exceptions.SQWRLResultStateException;
import org.swrlapi.sqwrl.values.SQWRLAnnotationPropertyResultValue;
import org.swrlapi.sqwrl.values.SQWRLClassExpressionResultValue;
import org.swrlapi.sqwrl.values.SQWRLClassResultValue;
import org.swrlapi.sqwrl.values.SQWRLDataPropertyResultValue;
import org.swrlapi.sqwrl.values.SQWRLDataRangeResultValue;
import org.swrlapi.sqwrl.values.SQWRLLiteralResultValue;
import org.swrlapi.sqwrl.values.SQWRLNamedIndividualResultValue;
import org.swrlapi.sqwrl.values.SQWRLObjectPropertyResultValue;
import org.swrlapi.sqwrl.values.SQWRLPropertyResultValue;
import org.swrlapi.sqwrl.values.SQWRLResultValue;

class DefaultSQWRLResultManager
implements SQWRLResultManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull SQWRLResultValueFactory sqwrlResultValueFactory;
    private final @NonNull List<@NonNull String> allColumnNames;
    private final @NonNull List<@NonNull String> columnDisplayNames;
    private final @NonNull List<@NonNull Integer> selectedColumnIndexes;
    private final @NonNull List<@NonNull Integer> orderByColumnIndexes;
    private final @NonNull Map<@NonNull Integer, @NonNull String> aggregateColumnIndexes;
    private int numberOfColumns;
    private int currentRowDataColumnIndex;
    private boolean isConfigured;
    private boolean isPrepared;
    private boolean isRowOpen;
    private boolean isOrdered;
    private boolean isAscending;
    private boolean isDistinct;
    private boolean hasAggregates;
    private int limit = -1;
    private int nth = -1;
    private int firstN = -1;
    private int lastN = -1;
    private int sliceSize = -1;
    private boolean notNthSelection = false;
    private boolean firstSelection = false;
    private boolean lastSelection = false;
    private boolean notFirstSelection = false;
    private boolean notLastSelection = false;
    private boolean nthSliceSelection = false;
    private boolean notNthSliceSelection = false;
    private boolean nthLastSliceSelection = false;
    private boolean notNthLastSliceSelection = false;
    private @NonNull List<@NonNull List<@NonNull SQWRLResultValue>> rows;
    private @NonNull List<@NonNull SQWRLResultValue> rowData;
    private @NonNull Map<@NonNull String, @NonNull List<@NonNull SQWRLResultValue>> columnValuesMap;
    private int currentRowIndex;

    public DefaultSQWRLResultManager(@NonNull IRIResolver iriResolver) {
        this.sqwrlResultValueFactory = SWRLAPIInternalFactory.createSQWRLResultValueFactory(iriResolver);
        this.isConfigured = false;
        this.isPrepared = false;
        this.isRowOpen = false;
        this.allColumnNames = new ArrayList<String>();
        this.aggregateColumnIndexes = new HashMap<Integer, String>();
        this.selectedColumnIndexes = new ArrayList<Integer>();
        this.orderByColumnIndexes = new ArrayList<Integer>();
        this.columnDisplayNames = new ArrayList<String>();
        this.numberOfColumns = 0;
        this.isDistinct = false;
        this.isAscending = false;
        this.isOrdered = false;
        this.rows = new ArrayList<List<SQWRLResultValue>>();
        this.rowData = new ArrayList<SQWRLResultValue>();
        this.columnValuesMap = new HashMap<String, List<SQWRLResultValue>>();
        this.currentRowIndex = -1;
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured;
    }

    @Override
    public boolean isRowOpen() {
        return this.isRowOpen;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public boolean isOrdered() {
        return this.isOrdered;
    }

    @Override
    public boolean isOrderedAscending() {
        return this.isAscending;
    }

    @Override
    public void addColumns(@NonNull List<@NonNull String> columnNames) throws SQWRLException {
        for (String columnName : columnNames) {
            this.addColumn(columnName);
        }
    }

    @Override
    public void addColumn(@NonNull String columnName) throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        this.selectedColumnIndexes.add(this.numberOfColumns);
        this.allColumnNames.add(columnName);
        ++this.numberOfColumns;
    }

    @Override
    public void addAggregateColumn(@NonNull String columnName, @NonNull String aggregateFunctionName) throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        SQWRLResultNames.checkAggregateFunctionName(aggregateFunctionName);
        this.aggregateColumnIndexes.put(this.numberOfColumns, aggregateFunctionName);
        this.allColumnNames.add(columnName);
        ++this.numberOfColumns;
    }

    @Override
    public void setOrderByColumn(int orderedColumnIndex, boolean ascending) throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        if (this.numberOfColumns == 0) {
            throw new SQWRLException("ordered clause cannot be used without a select clause");
        }
        if (orderedColumnIndex < 0 || orderedColumnIndex >= this.allColumnNames.size()) {
            throw new SQWRLException("ordered column index " + orderedColumnIndex + " out of range");
        }
        if (this.isOrdered && this.isAscending != ascending) {
            if (this.isAscending) {
                throw new SQWRLException("attempt to order column " + this.allColumnNames.get(orderedColumnIndex) + " ascending when descending was previously specified");
            }
            throw new SQWRLException("attempt to order column " + this.allColumnNames.get(orderedColumnIndex) + " descending when ascending was previously specified");
        }
        this.isOrdered = true;
        this.isAscending = ascending;
        this.orderByColumnIndexes.add(orderedColumnIndex);
    }

    @Override
    public void addColumnDisplayName(@NonNull String columnName) throws SQWRLException {
        if (columnName.length() == 0 || columnName.indexOf(44) != -1) {
            throw new SQWRLException("invalid column name " + columnName + " - no commas or empty names allowed");
        }
        this.columnDisplayNames.add(columnName);
    }

    @Override
    public void configured() throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        if (this.containsOneOf(this.selectedColumnIndexes, this.aggregateColumnIndexes.keySet())) {
            throw new SQWRLInvalidQueryException("aggregate columns cannot also be selected columns");
        }
        this.hasAggregates = !this.aggregateColumnIndexes.isEmpty();
        this.isConfigured = true;
    }

    @Override
    public void setIsDistinct() {
        this.isDistinct = true;
    }

    @Override
    public int getNumberOfColumns() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        return this.numberOfColumns;
    }

    @Override
    public int getCurrentNumberOfColumns() throws SQWRLException {
        this.throwExceptionIfConfigured();
        return this.numberOfColumns;
    }

    @Override
    public @NonNull List<@NonNull String> getColumnNames() throws SQWRLException {
        ArrayList<@NonNull String> result = new ArrayList<String>();
        this.throwExceptionIfNotConfigured();
        if (this.columnDisplayNames.size() < this.getNumberOfColumns()) {
            result.addAll(this.columnDisplayNames);
            result.addAll(this.allColumnNames.subList(this.columnDisplayNames.size(), this.allColumnNames.size()));
        } else {
            result.addAll(this.columnDisplayNames);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public @NonNull String getColumnName(int columnIndex) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.checkColumnIndex(columnIndex);
        if (columnIndex < this.columnDisplayNames.size()) {
            return this.columnDisplayNames.get(columnIndex);
        }
        return this.allColumnNames.get(columnIndex);
    }

    @Override
    public void addRow(@NonNull List<@NonNull SQWRLResultValue> row) throws SQWRLException {
        if (row.size() != this.getNumberOfColumns()) {
            throw new SQWRLException("addRow expecting " + this.getNumberOfColumns() + ", got " + row.size() + " values");
        }
        this.openRow();
        for (SQWRLResultValue value : row) {
            this.addCell(value);
        }
        this.closeRow();
    }

    @Override
    public void openRow() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        this.throwExceptionIfRowOpen();
        this.currentRowDataColumnIndex = 0;
        this.rowData = new ArrayList<SQWRLResultValue>();
        this.isRowOpen = true;
    }

    @Override
    public void addCell(@NonNull SQWRLResultValue value) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        this.throwExceptionIfRowNotOpen();
        if (this.currentRowDataColumnIndex == this.getNumberOfColumns()) {
            throw new SQWRLResultStateException("attempt to add data beyond the end of a row");
        }
        if (this.aggregateColumnIndexes.containsKey(this.currentRowDataColumnIndex) && !this.aggregateColumnIndexes.get(this.currentRowDataColumnIndex).equals("count") && !this.aggregateColumnIndexes.get(this.currentRowDataColumnIndex).equals("countDistinct") && !this.isNumericValue(value)) {
            throw new SQWRLException("attempt to add non numeric value " + value + " to min, max, sum, or avg aggregate column " + this.allColumnNames.get(this.currentRowDataColumnIndex));
        }
        this.rowData.add(value);
        ++this.currentRowDataColumnIndex;
        if (this.currentRowDataColumnIndex == this.getNumberOfColumns()) {
            this.closeRow();
        }
    }

    @Override
    public void closeRow() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        if (this.isRowOpen) {
            this.rows.add(this.rowData);
        }
        this.isRowOpen = false;
    }

    @Override
    public void prepared() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        if (this.currentRowDataColumnIndex != 0) {
            this.throwExceptionIfRowOpen();
        }
        this.isPrepared = true;
        this.isRowOpen = false;
        this.currentRowDataColumnIndex = 0;
        this.currentRowIndex = this.getNumberOfRows() > 0 ? -1 : -1;
        if (this.hasAggregates) {
            this.rows = this.aggregate(this.rows);
        } else if (this.isDistinct) {
            this.rows = this.distinct(this.rows);
        }
        if (this.isOrdered && this.rows.size() > 0) {
            this.rows = this.orderBy(this.rows, this.isAscending);
        }
        this.rows = this.processSelectionOperators(this.rows);
        this.prepareColumnVectors();
    }

    @Override
    public int getNumberOfRows() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() throws SQWRLException {
        return this.getNumberOfRows() == 0;
    }

    @Override
    public void reset() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        if (this.getNumberOfRows() > 0) {
            this.currentRowIndex = -1;
        }
    }

    @Override
    public boolean next() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        ++this.currentRowIndex;
        return this.currentRowIndex != -1 && this.currentRowIndex < this.getNumberOfRows();
    }

    @Override
    public @NonNull List<@NonNull SQWRLResultValue> getRow() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        return this.rows.get(this.currentRowIndex);
    }

    @Override
    public SQWRLResultValue getValue(@NonNull String columnName) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        int columnIndex = this.getColumnIndex(columnName);
        List<@NonNull SQWRLResultValue> row = this.rows.get(this.currentRowIndex);
        return row.get(columnIndex);
    }

    @Override
    public SQWRLResultValue getValue(int columnIndex) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        this.checkColumnIndex(columnIndex);
        List<@NonNull SQWRLResultValue> row = this.rows.get(this.currentRowIndex);
        return row.get(columnIndex);
    }

    @Override
    public SQWRLResultValue getValue(int columnIndex, int rowIndex) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.checkColumnIndex(columnIndex);
        this.checkRowIndex(rowIndex);
        return this.rows.get(rowIndex).get(columnIndex);
    }

    @Override
    public @NonNull SQWRLNamedIndividualResultValue getNamedIndividual(@NonNull String columnName) throws SQWRLException {
        if (!this.hasNamedIndividualValue(columnName)) {
            throw new SQWRLInvalidColumnTypeException("expecting named individual type for column " + columnName);
        }
        return (SQWRLNamedIndividualResultValue)this.getValue(columnName);
    }

    @Override
    public @NonNull SQWRLNamedIndividualResultValue getNamedIndividual(int columnIndex) throws SQWRLException {
        return this.getNamedIndividual(this.getColumnName(columnIndex));
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteral(@NonNull String columnName) throws SQWRLException {
        if (!this.hasLiteralValue(columnName)) {
            throw new SQWRLInvalidColumnTypeException("expecting literal type for column " + columnName);
        }
        return (SQWRLLiteralResultValue)this.getValue(columnName);
    }

    @Override
    public @NonNull SQWRLClassResultValue getClass(@NonNull String columnName) throws SQWRLException {
        if (!this.hasClassValue(columnName)) {
            throw new SQWRLInvalidColumnTypeException("expecting class type for column " + columnName);
        }
        return (SQWRLClassResultValue)this.getValue(columnName);
    }

    @Override
    public @NonNull SQWRLClassResultValue getClass(int columnIndex) throws SQWRLException {
        return this.getClass(this.getColumnName(columnIndex));
    }

    @Override
    public @NonNull SQWRLClassExpressionResultValue getClassExpression(@NonNull String columnName) throws SQWRLException {
        if (!this.hasClassExpressionValue(columnName)) {
            throw new SQWRLInvalidColumnTypeException("expecting class expression type for column " + columnName);
        }
        return (SQWRLClassExpressionResultValue)this.getValue(columnName);
    }

    @Override
    public @NonNull SQWRLClassExpressionResultValue getClassExpression(int columnIndex) throws SQWRLException {
        return this.getClassExpression(this.getColumnName(columnIndex));
    }

    @Override
    public @NonNull SQWRLObjectPropertyResultValue getObjectProperty(int columnIndex) throws SQWRLException {
        return this.getObjectProperty(this.getColumnName(columnIndex));
    }

    @Override
    public @NonNull SQWRLObjectPropertyResultValue getObjectProperty(@NonNull String columnName) throws SQWRLException {
        if (!this.hasObjectPropertyValue(columnName)) {
            throw new SQWRLInvalidColumnTypeException("expecting OWL object property in column " + columnName);
        }
        return (SQWRLObjectPropertyResultValue)this.getValue(columnName);
    }

    @Override
    public @NonNull SQWRLDataPropertyResultValue getDataProperty(int columnIndex) throws SQWRLException {
        return this.getDataProperty(this.getColumnName(columnIndex));
    }

    @Override
    public @NonNull SQWRLDataPropertyResultValue getDataProperty(@NonNull String columnName) throws SQWRLException {
        if (!this.hasDataPropertyValue(columnName)) {
            throw new SQWRLInvalidColumnTypeException("expecting OWL data property in column " + columnName);
        }
        return (SQWRLDataPropertyResultValue)this.getValue(columnName);
    }

    @Override
    public @NonNull SQWRLAnnotationPropertyResultValue getAnnotationProperty(int columnIndex) throws SQWRLException {
        return this.getAnnotationProperty(this.getColumnName(columnIndex));
    }

    @Override
    public @NonNull SQWRLAnnotationPropertyResultValue getAnnotationProperty(@NonNull String columnName) throws SQWRLException {
        if (!this.hasAnnotationPropertyValue(columnName)) {
            throw new SQWRLInvalidColumnTypeException("expecting OWL data property in column " + columnName);
        }
        return (SQWRLAnnotationPropertyResultValue)this.getValue(columnName);
    }

    @Override
    public @NonNull SQWRLDataRangeResultValue getDataRange(int columnIndex) throws SQWRLException {
        return this.getDataRange(this.getColumnName(columnIndex));
    }

    @Override
    public @NonNull SQWRLDataRangeResultValue getDataRange(@NonNull String columnName) throws SQWRLException {
        if (!this.hasDataRangeValue(columnName)) {
            throw new SQWRLInvalidColumnTypeException("expecting OWL data range in column " + columnName);
        }
        return (SQWRLDataRangeResultValue)this.getValue(columnName);
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteral(int columnIndex) throws SQWRLException {
        return this.getLiteral(this.getColumnName(columnIndex));
    }

    @Override
    public List<@NonNull SQWRLResultValue> getColumn(@NonNull String columnName) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.checkColumnName(columnName);
        return this.columnValuesMap.get(columnName);
    }

    @Override
    public List<@NonNull SQWRLResultValue> getColumn(int columnIndex) throws SQWRLException {
        return this.getColumn(this.getColumnName(columnIndex));
    }

    @Override
    public boolean hasNamedIndividualValue(@NonNull String columnName) throws SQWRLException {
        return this.getValue(columnName) instanceof SQWRLNamedIndividualResultValue;
    }

    @Override
    public boolean hasNamedIndividualValue(int columnIndex) throws SQWRLException {
        return this.getValue(columnIndex) instanceof SQWRLNamedIndividualResultValue;
    }

    @Override
    public boolean hasLiteralValue(@NonNull String columnName) throws SQWRLException {
        return this.getValue(columnName) instanceof SQWRLLiteralResultValue;
    }

    @Override
    public boolean hasLiteralValue(int columnIndex) throws SQWRLException {
        return this.getValue(columnIndex) instanceof SQWRLLiteralResultValue;
    }

    @Override
    public boolean hasClassValue(@NonNull String columnName) throws SQWRLException {
        return this.getValue(columnName) instanceof SQWRLClassResultValue;
    }

    @Override
    public boolean hasClassValue(int columnIndex) throws SQWRLException {
        return this.getValue(columnIndex) instanceof SQWRLClassResultValue;
    }

    @Override
    public boolean hasClassExpressionValue(@NonNull String columnName) throws SQWRLException {
        return this.getValue(columnName) instanceof SQWRLClassExpressionResultValue;
    }

    @Override
    public boolean hasClassExpressionValue(int columnIndex) throws SQWRLException {
        return this.getValue(columnIndex) instanceof SQWRLClassExpressionResultValue;
    }

    @Override
    public boolean hasObjectPropertyValue(@NonNull String columnName) throws SQWRLException {
        return this.getValue(columnName) instanceof SQWRLObjectPropertyResultValue;
    }

    @Override
    public boolean hasObjectPropertyValue(int columnIndex) throws SQWRLException {
        return this.getValue(columnIndex) instanceof SQWRLObjectPropertyResultValue;
    }

    @Override
    public boolean hasDataPropertyValue(@NonNull String columnName) throws SQWRLException {
        return this.getValue(columnName) instanceof SQWRLDataPropertyResultValue;
    }

    @Override
    public boolean hasDataPropertyValue(int columnIndex) throws SQWRLException {
        return this.getValue(columnIndex) instanceof SQWRLDataPropertyResultValue;
    }

    @Override
    public boolean hasAnnotationPropertyValue(@NonNull String columnName) throws SQWRLException {
        return this.getValue(columnName) instanceof SQWRLAnnotationPropertyResultValue;
    }

    @Override
    public boolean hasDataRangeValue(int columnIndex) throws SQWRLException {
        return this.getValue(columnIndex) instanceof SQWRLDataRangeResultValue;
    }

    @Override
    public boolean hasDataRangeValue(@NonNull String columnName) throws SQWRLException {
        return this.getValue(columnName) instanceof SQWRLDataRangeResultValue;
    }

    @Override
    public boolean hasAnnotationPropertyValue(int columnIndex) throws SQWRLException {
        return this.getValue(columnIndex) instanceof SQWRLPropertyResultValue;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void setNth(int nth) {
        this.nth = nth;
    }

    @Override
    public void setNotNth(int nth) {
        this.notNthSelection = true;
        this.nth = nth;
    }

    @Override
    public void setFirst(int n) {
        this.firstSelection = true;
        this.firstN = n;
    }

    @Override
    public void setLast() {
        this.lastSelection = true;
        this.lastN = 1;
    }

    @Override
    public void setLast(int n) {
        this.lastSelection = true;
        this.lastN = n;
    }

    @Override
    public void setNotFirst(int n) {
        this.notFirstSelection = true;
        this.firstN = n;
    }

    @Override
    public void setNotLast(int n) {
        this.notLastSelection = true;
        this.lastN = n;
    }

    @Override
    public void setNthSlice(int n, int sliceSize) {
        this.nthSliceSelection = true;
        this.firstN = n;
        this.sliceSize = sliceSize;
    }

    @Override
    public void setNotNthSlice(int n, int sliceSize) {
        this.notNthSliceSelection = true;
        this.firstN = n;
        this.sliceSize = sliceSize;
    }

    @Override
    public void setNthLastSlice(int n, int sliceSize) {
        this.nthLastSliceSelection = true;
        this.lastN = n;
        this.sliceSize = sliceSize;
    }

    @Override
    public void setNotNthLastSlice(int n, int sliceSize) {
        this.notNthLastSliceSelection = true;
        this.lastN = n;
        this.sliceSize = sliceSize;
    }

    private int getColumnIndex(@NonNull String columnName) throws SQWRLException {
        this.checkColumnName(columnName);
        if (this.allColumnNames.contains(columnName)) {
            return this.allColumnNames.indexOf(columnName);
        }
        return this.columnDisplayNames.indexOf(columnName);
    }

    private @NonNull List<@NonNull List<@NonNull SQWRLResultValue>> processSelectionOperators(@NonNull List<@NonNull List<@NonNull SQWRLResultValue>> sourceRows) {
        ArrayList<@NonNull List<@NonNull SQWRLResultValue>> processedRows = new ArrayList<List<SQWRLResultValue>>();
        boolean hasSelection = false;
        if (this.hasLimit()) {
            int localLimit;
            int n = localLimit = this.limit > sourceRows.size() ? sourceRows.size() : this.limit;
            if (this.limit < 0) {
                this.limit = 0;
            }
            processedRows.addAll(sourceRows.subList(0, localLimit));
            hasSelection = true;
        } else {
            if (this.hasNth()) {
                if (this.nth < 1) {
                    this.nth = 1;
                }
                if (this.nth <= sourceRows.size()) {
                    processedRows.add(sourceRows.get(this.nth - 1));
                }
                hasSelection = true;
            }
            if (this.hasNotNth()) {
                if (this.nth < 1) {
                    this.nth = 1;
                }
                if (this.nth <= sourceRows.size()) {
                    ArrayList<@NonNull List<@NonNull SQWRLResultValue>> localRows = new ArrayList<List<SQWRLResultValue>>(sourceRows);
                    localRows.remove(this.nth - 1);
                    processedRows.addAll(localRows);
                } else {
                    processedRows.addAll(sourceRows);
                }
                hasSelection = true;
            }
            if (this.hasFirstSelection()) {
                if (this.firstN < 1) {
                    this.firstN = 1;
                }
                if (this.firstN <= sourceRows.size()) {
                    processedRows.addAll(sourceRows.subList(0, this.firstN));
                }
                hasSelection = true;
            }
            if (this.hasNotFirstSelection()) {
                if (this.firstN < 1) {
                    this.firstN = 1;
                }
                if (this.firstN <= sourceRows.size()) {
                    processedRows.addAll(sourceRows.subList(this.firstN, sourceRows.size()));
                } else {
                    processedRows.addAll(sourceRows);
                }
                hasSelection = true;
            }
            if (this.hasLastSelection()) {
                if (this.lastN < 1) {
                    this.lastN = 1;
                }
                if (this.lastN <= sourceRows.size()) {
                    processedRows.addAll(sourceRows.subList(sourceRows.size() - this.lastN, sourceRows.size()));
                }
                hasSelection = true;
            }
            if (this.hasNotLastSelection()) {
                if (this.lastN < 1) {
                    this.lastN = 1;
                }
                if (this.lastN <= sourceRows.size()) {
                    processedRows.addAll(sourceRows.subList(0, sourceRows.size() - this.lastN));
                } else {
                    processedRows.addAll(sourceRows);
                }
                hasSelection = true;
            }
            if (this.hasNthSliceSelection()) {
                if (this.firstN < 1) {
                    this.firstN = 1;
                }
                if (this.firstN <= sourceRows.size()) {
                    int finish = this.firstN + this.sliceSize > sourceRows.size() ? sourceRows.size() : this.firstN + this.sliceSize - 1;
                    processedRows.addAll(sourceRows.subList(this.firstN - 1, finish));
                }
                hasSelection = true;
            }
            if (this.hasNotNthSliceSelection()) {
                if (this.firstN < 1) {
                    this.firstN = 1;
                }
                if (this.firstN <= sourceRows.size()) {
                    int finish = this.firstN + this.sliceSize > sourceRows.size() ? sourceRows.size() : this.firstN + this.sliceSize - 1;
                    processedRows.addAll(sourceRows.subList(0, this.firstN - 1));
                    if (finish <= sourceRows.size()) {
                        processedRows.addAll(sourceRows.subList(finish, sourceRows.size()));
                    }
                } else {
                    processedRows.addAll(sourceRows);
                }
                hasSelection = true;
            }
            if (this.hasNthLastSliceSelection()) {
                int finish;
                if (this.lastN < 1) {
                    this.lastN = 1;
                }
                int n = finish = this.lastN + this.sliceSize > sourceRows.size() ? sourceRows.size() : this.lastN + this.sliceSize;
                if (this.lastN <= sourceRows.size()) {
                    processedRows.addAll(sourceRows.subList(this.lastN, finish));
                }
                hasSelection = true;
            }
            if (this.hasNotNthLastSliceSelection()) {
                if (this.lastN <= sourceRows.size()) {
                    if (this.lastN < 1) {
                        this.lastN = 1;
                    }
                    int finish = this.lastN + this.sliceSize > sourceRows.size() ? sourceRows.size() : this.lastN + this.sliceSize;
                    processedRows.addAll(sourceRows.subList(0, this.lastN));
                    if (finish <= sourceRows.size()) {
                        processedRows.addAll(sourceRows.subList(finish, sourceRows.size()));
                    }
                } else {
                    processedRows.addAll(sourceRows);
                }
                hasSelection = true;
            }
        }
        if (hasSelection) {
            return processedRows;
        }
        return sourceRows;
    }

    private boolean hasLimit() {
        return this.limit != -1;
    }

    private boolean hasNth() {
        return !this.hasNotNth() && this.nth != -1;
    }

    private boolean hasNotNth() {
        return this.notNthSelection;
    }

    private boolean hasFirstSelection() {
        return this.firstSelection;
    }

    private boolean hasLastSelection() {
        return this.lastSelection;
    }

    private boolean hasNotFirstSelection() {
        return this.notFirstSelection;
    }

    private boolean hasNotLastSelection() {
        return this.notLastSelection;
    }

    private boolean hasNthSliceSelection() {
        return this.nthSliceSelection;
    }

    private boolean hasNotNthSliceSelection() {
        return this.notNthSliceSelection;
    }

    private boolean hasNthLastSliceSelection() {
        return this.nthLastSliceSelection;
    }

    private boolean hasNotNthLastSliceSelection() {
        return this.notNthLastSliceSelection;
    }

    private void prepareColumnVectors() throws SQWRLException {
        this.columnValuesMap = new HashMap<String, List<SQWRLResultValue>>();
        if (this.getNumberOfColumns() > 0) {
            int c;
            ArrayList<@NonNull ArrayList<@NonNull E>> columns = new ArrayList(this.getNumberOfColumns());
            for (c = 0; c < this.getNumberOfColumns(); ++c) {
                columns.add(new ArrayList(this.getNumberOfRows()));
            }
            for (int r = 0; r < this.getNumberOfRows(); ++r) {
                for (int c2 = 0; c2 < this.getNumberOfColumns(); ++c2) {
                    ((List)columns.get(c2)).add(this.rows.get(r).get(c2));
                }
            }
            for (c = 0; c < this.getNumberOfColumns(); ++c) {
                this.columnValuesMap.put(this.getColumnName(c), (List)columns.get(c));
            }
        }
    }

    @SideEffectFree
    public @NonNull String toString() {
        String result = "[numberOfColumns: " + this.numberOfColumns + ", isConfigured: " + this.isConfigured + ", isPrepared: " + this.isPrepared + ", isRowOpen: " + this.isRowOpen + ", isOrdered: " + this.isOrdered + ", isAscending " + this.isAscending + ", isDistinct: " + this.isDistinct + ", hasAggregates: " + this.hasAggregates + "]\n";
        result = result + "[columnDisplayNames: ";
        for (String string : this.columnDisplayNames) {
            result = result + "" + string + "";
        }
        result = result + "]\n";
        for (List list : this.rows) {
            for (SQWRLResultValue value : list) {
                result = result + "" + value + " ";
            }
            result = result + "\n";
        }
        return result;
    }

    private void throwExceptionIfConfigured() throws SQWRLException {
        if (this.isConfigured()) {
            throw new SQWRLResultStateException("attempt to do pre-configuration operations after configuration");
        }
    }

    private void throwExceptionIfNotConfigured() throws SQWRLException {
        if (!this.isConfigured()) {
            throw new SQWRLResultStateException("attempt to do post-configuration operations before configuration");
        }
    }

    private void throwExceptionIfAtEndOfResult() throws SQWRLException {
        if (this.currentRowIndex >= this.getNumberOfRows()) {
            throw new SQWRLResultStateException("attempt to get data after end of result reached");
        }
    }

    private void throwExceptionIfNotPrepared() throws SQWRLException {
        if (!this.isPrepared()) {
            throw new SQWRLResultStateException("attempt to process unprepared result");
        }
    }

    private void throwExceptionIfAlreadyConfigured() throws SQWRLException {
        if (this.isConfigured()) {
            throw new SQWRLResultStateException("attempt to configure already configured result");
        }
    }

    private void throwExceptionIfAlreadyPrepared() throws SQWRLException {
        if (this.isPrepared()) {
            throw new SQWRLResultStateException("attempt to modify prepared result");
        }
    }

    private void checkColumnName(@NonNull String columnName) throws SQWRLInvalidColumnNameException {
        if (!this.allColumnNames.contains(columnName) && !this.columnDisplayNames.contains(columnName)) {
            throw new SQWRLInvalidColumnNameException("invalid column name " + columnName);
        }
    }

    private void throwExceptionIfRowNotOpen() throws SQWRLException {
        if (!this.isRowOpen) {
            throw new SQWRLResultStateException("attempt to add data to an unopened row");
        }
    }

    private void throwExceptionIfRowOpen() throws SQWRLException {
        if (this.isRowOpen) {
            throw new SQWRLResultStateException("attempt to process result with a partially prepared row");
        }
    }

    private void checkColumnIndex(int columnIndex) throws SQWRLException {
        if (columnIndex < 0 || columnIndex >= this.getNumberOfColumns()) {
            throw new SQWRLInvalidColumnIndexException("column index " + columnIndex + " out of bounds");
        }
    }

    private void checkRowIndex(int rowIndex) throws SQWRLException {
        if (rowIndex < 0 || rowIndex >= this.getNumberOfRows()) {
            throw new SQWRLInvalidRowIndexException("row index " + rowIndex + " out of bounds");
        }
    }

    private boolean containsOneOf(@NonNull List<@NonNull Integer> collection1, @NonNull Set<@NonNull Integer> collection2) {
        for (Integer i : collection2) {
            if (!collection1.contains(i)) continue;
            return true;
        }
        return false;
    }

    private boolean isNumericValue(@NonNull SQWRLResultValue value) {
        return value instanceof SQWRLLiteralResultValue && ((SQWRLLiteralResultValue)value).isNumeric();
    }

    private @NonNull List<@NonNull List<@NonNull SQWRLResultValue>> distinct(@NonNull List<@NonNull List<@NonNull SQWRLResultValue>> sourceRows) throws SQWRLException {
        ArrayList<@NonNull List<@NonNull SQWRLResultValue>> localRows = new ArrayList<List<SQWRLResultValue>>(sourceRows);
        ArrayList<@NonNull List<@NonNull SQWRLResultValue>> processedRows = new ArrayList<List<SQWRLResultValue>>();
        SQWRLResultRowComparator rowComparator = new SQWRLResultRowComparator(this.allColumnNames, true);
        try {
            localRows.sort(rowComparator);
            for (List list : localRows) {
                if (Collections.binarySearch(processedRows, list, rowComparator) >= 0) continue;
                processedRows.add(list);
            }
        }
        catch (RuntimeException e) {
            throw new SQWRLException("Internal error comparing rows", e);
        }
        return processedRows;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull List<@NonNull List<@NonNull SQWRLResultValue>> aggregate(@NonNull List<@NonNull List<@NonNull SQWRLResultValue>> sourceRows) throws SQWRLException {
        SQWRLResultValue value;
        Map aggregateRowMap;
        ArrayList<@NonNull List<@NonNull SQWRLResultValue>> result = new ArrayList<List<SQWRLResultValue>>();
        SQWRLResultRowComparator rowComparator = new SQWRLResultRowComparator(this.allColumnNames, this.selectedColumnIndexes, true);
        HashMap<@NonNull Integer, Map<@NonNull Integer, @NonNull List<@NonNull E>>> aggregatesMap = new HashMap();
        for (List<SQWRLResultValue> row : sourceRows) {
            List<SQWRLResultValue> values;
            Optional<@NonNull Integer> optional = this.findRowIndex(result, row, rowComparator);
            if (optional.isPresent()) {
                aggregateRowMap = (Map)aggregatesMap.get(optional.get());
                for (Integer aggregateColumnIndex : this.aggregateColumnIndexes.keySet()) {
                    value = row.get(aggregateColumnIndex);
                    values = (List)aggregateRowMap.get(aggregateColumnIndex);
                    values.add(value);
                }
                continue;
            }
            aggregateRowMap = new HashMap();
            for (Integer aggregateColumnIndex : this.aggregateColumnIndexes.keySet()) {
                values = new ArrayList<SQWRLResultValue>();
                value = row.get(aggregateColumnIndex);
                values.add(value);
                aggregateRowMap.put(aggregateColumnIndex, values);
            }
            aggregatesMap.put(result.size(), aggregateRowMap);
            result.add(row);
        }
        int rowIndex = 0;
        for (List list : result) {
            aggregateRowMap = (Map)aggregatesMap.get(rowIndex);
            for (Integer aggregateColumnIndex : this.aggregateColumnIndexes.keySet()) {
                List<SQWRLLiteralResultValue> literalColumnValues;
                String aggregateFunctionName = this.aggregateColumnIndexes.get(aggregateColumnIndex);
                @NonNull List columnValues = (List)aggregateRowMap.get(aggregateColumnIndex);
                if (aggregateFunctionName.equalsIgnoreCase("min")) {
                    literalColumnValues = this.convert2LiteralResultValues(columnValues, aggregateColumnIndex);
                    value = this.min(literalColumnValues, aggregateColumnIndex);
                } else if (aggregateFunctionName.equalsIgnoreCase("max")) {
                    literalColumnValues = this.convert2LiteralResultValues(columnValues, aggregateColumnIndex);
                    value = this.max(literalColumnValues, aggregateColumnIndex);
                } else if (aggregateFunctionName.equalsIgnoreCase("sum")) {
                    literalColumnValues = this.convert2LiteralResultValues(columnValues, aggregateColumnIndex);
                    value = this.sum(literalColumnValues, aggregateColumnIndex);
                } else if (aggregateFunctionName.equalsIgnoreCase("avg")) {
                    literalColumnValues = this.convert2LiteralResultValues(columnValues, aggregateColumnIndex);
                    value = this.avg(literalColumnValues, aggregateColumnIndex);
                } else if (aggregateFunctionName.equalsIgnoreCase("median")) {
                    literalColumnValues = this.convert2LiteralResultValues(columnValues, aggregateColumnIndex);
                    value = this.median(literalColumnValues, aggregateColumnIndex);
                } else if (aggregateFunctionName.equalsIgnoreCase("count")) {
                    value = this.count(columnValues);
                } else if (aggregateFunctionName.equalsIgnoreCase("countDistinct")) {
                    value = this.countDistinct(columnValues);
                } else {
                    throw new SQWRLInvalidAggregateFunctionNameException("invalid aggregate function " + aggregateFunctionName);
                }
                list.set(aggregateColumnIndex, value);
            }
            ++rowIndex;
        }
        return result;
    }

    private @NonNull List<@NonNull List<@NonNull SQWRLResultValue>> orderBy(@NonNull List<@NonNull List<@NonNull SQWRLResultValue>> sourceRows, boolean ascending) throws SQWRLException {
        ArrayList<@NonNull List<@NonNull SQWRLResultValue>> result = new ArrayList<List<SQWRLResultValue>>(sourceRows);
        SQWRLResultRowComparator rowComparator = new SQWRLResultRowComparator(this.allColumnNames, this.orderByColumnIndexes, ascending);
        try {
            result.sort(rowComparator);
        }
        catch (RuntimeException e) {
            throw new SQWRLException("Internal error comparing rows", e);
        }
        return result;
    }

    private @NonNull SQWRLLiteralResultValue min(@NonNull List<@NonNull SQWRLLiteralResultValue> columnValues, int columnIndex) throws SQWRLException {
        if (columnValues.isEmpty()) {
            throw new SQWRLException("empty aggregate list for min");
        }
        SQWRLLiteralResultValue result = columnValues.get(0);
        int rowIndex = 0;
        for (SQWRLLiteralResultValue value : columnValues) {
            if (!this.isNumericValue(value)) {
                throw new SQWRLException("attempt to use min aggregate on column with non numeric literal " + value + " with type " + value.getOWLDatatype() + "in (0-based) row " + rowIndex + ", column " + columnIndex);
            }
            if (result == null) {
                result = value;
            } else if (value.compareTo(result) < 0) {
                result = value;
            }
            ++rowIndex;
        }
        return result;
    }

    private @NonNull SQWRLLiteralResultValue max(@NonNull List<@NonNull SQWRLLiteralResultValue> columnValues, int columnIndex) throws SQWRLException {
        if (columnValues.isEmpty()) {
            throw new SQWRLException("empty aggregate list for max");
        }
        SQWRLLiteralResultValue result = columnValues.get(0);
        int rowIndex = 0;
        for (SQWRLLiteralResultValue value : columnValues) {
            if (!this.isNumericValue(value)) {
                throw new SQWRLException("attempt to use max aggregate with non numeric literal " + value + " with type " + value.getOWLDatatype() + "in (0-based) row " + rowIndex + ", column " + columnIndex);
            }
            if (result == null) {
                result = value;
            } else if (value.compareTo(result) > 0) {
                result = value;
            }
            ++rowIndex;
        }
        return result;
    }

    private @NonNull SQWRLLiteralResultValue sum(@NonNull List<@NonNull SQWRLLiteralResultValue> columnValues, int columnIndex) throws SQWRLException {
        double sum = 0.0;
        if (columnValues.isEmpty()) {
            throw new SQWRLException("empty aggregate list for sum");
        }
        int rowIndex = 0;
        for (SQWRLLiteralResultValue value : columnValues) {
            if (!this.isNumericValue(value)) {
                throw new SQWRLException("attempt to use sum aggregate  on non numeric value: " + value + " with type " + value.getOWLDatatype() + " in (0-based) row " + rowIndex + ", column " + columnIndex);
            }
            double d = value.getDouble();
            sum += d;
            ++rowIndex;
        }
        return this.getSQWRLResultValueFactory().createLeastNarrowNumericLiteralValue(sum, columnValues);
    }

    private @NonNull SQWRLLiteralResultValue avg(@NonNull List<@NonNull SQWRLLiteralResultValue> columnValues, int columnIndex) throws SQWRLException {
        double sum = 0.0;
        int count = 0;
        if (columnValues.isEmpty()) {
            throw new SQWRLException("empty aggregate list for function avg");
        }
        int rowIndex = 0;
        for (SQWRLLiteralResultValue value : columnValues) {
            if (!this.isNumericValue(value)) {
                throw new SQWRLException("attempt to use avg aggregate on column with non literal value " + value + " with type " + value.getOWLDatatype() + " in (0-based) row " + rowIndex + ", column " + columnIndex);
            }
            double d = value.getDouble();
            ++count;
            sum += d;
            ++rowIndex;
        }
        double avgValue = sum / (double)count;
        return this.getSQWRLResultValueFactory().createLeastNarrowNumericLiteralValue(avgValue, columnValues);
    }

    private @NonNull SQWRLLiteralResultValue median(@NonNull List<@NonNull SQWRLLiteralResultValue> columnValues, int columnIndex) throws SQWRLException {
        double[] valueArray = new double[columnValues.size()];
        int count = 0;
        int middle = columnValues.size() / 2;
        int rowIndex = 0;
        for (SQWRLLiteralResultValue value : columnValues) {
            if (!this.isNumericValue(value)) {
                throw new SQWRLException("attempt to use median aggregate on column with non literal value " + value + " with type " + value.getOWLDatatype() + " in (0-based) row " + rowIndex + ", column " + columnIndex);
            }
            double d = value.getDouble();
            valueArray[count++] = d;
        }
        Arrays.sort(valueArray);
        double medianValue = columnValues.size() % 2 == 1 ? valueArray[middle] : (valueArray[middle - 1] + valueArray[middle]) / 2.0;
        return this.getSQWRLResultValueFactory().createLeastNarrowNumericLiteralValue(medianValue, columnValues);
    }

    private @NonNull SQWRLLiteralResultValue count(@NonNull List<@NonNull SQWRLResultValue> columnValues) {
        return this.getSQWRLResultValueFactory().getLiteralValue(columnValues.size());
    }

    private @NonNull SQWRLLiteralResultValue countDistinct(@NonNull List<@NonNull SQWRLResultValue> columnValues) {
        HashSet<@NonNull SQWRLResultValue> distinctValues = new HashSet<SQWRLResultValue>(columnValues);
        return this.getSQWRLResultValueFactory().getLiteralValue(distinctValues.size());
    }

    private @NonNull Optional<@NonNull Integer> findRowIndex(@NonNull List<@NonNull List<@NonNull SQWRLResultValue>> result, @NonNull List<@NonNull SQWRLResultValue> rowToFind, @NonNull Comparator<List<@NonNull SQWRLResultValue>> rowComparator) throws SQWRLException {
        int rowIndex = 0;
        try {
            for (List<SQWRLResultValue> row : result) {
                if (rowComparator.compare(rowToFind, row) == 0) {
                    return Optional.of(rowIndex);
                }
                ++rowIndex;
            }
        }
        catch (RuntimeException e) {
            throw new SQWRLException("Internal error comparing rows", e);
        }
        return Optional.empty();
    }

    private @NonNull List<@NonNull SQWRLLiteralResultValue> convert2LiteralResultValues(@NonNull List<@NonNull SQWRLResultValue> columnValues, int columnIndex) throws SQWRLException {
        ArrayList<@NonNull SQWRLLiteralResultValue> literalValues = new ArrayList<SQWRLLiteralResultValue>();
        int rowIndex = 0;
        for (SQWRLResultValue value : columnValues) {
            if (!value.isLiteral()) {
                throw new SQWRLException("Found non literal value " + value + " in (0-based) row " + rowIndex + ", column " + columnIndex + " - expecting literal");
            }
            literalValues.add(value.asLiteralResult());
            ++rowIndex;
        }
        return literalValues;
    }

    private SQWRLResultValueFactory getSQWRLResultValueFactory() {
        return this.sqwrlResultValueFactory;
    }

    private static class SQWRLResultRowComparator
    implements Comparator<List<SQWRLResultValue>> {
        private final @NonNull List<@NonNull Integer> orderByColumnIndexes;
        private final @NonNull boolean ascending;

        public SQWRLResultRowComparator(@NonNull List<@NonNull String> allColumnNames, @NonNull List<@NonNull Integer> orderByColumnIndexes, boolean ascending) {
            this.ascending = ascending;
            this.orderByColumnIndexes = orderByColumnIndexes;
        }

        public SQWRLResultRowComparator(@NonNull List<@NonNull String> allColumnNames, boolean ascending) {
            this.ascending = ascending;
            this.orderByColumnIndexes = new ArrayList<Integer>();
            for (String columnName : allColumnNames) {
                this.orderByColumnIndexes.add(allColumnNames.indexOf(columnName));
            }
        }

        @Override
        public int compare(@NonNull List<@NonNull SQWRLResultValue> row1, @NonNull List<@NonNull SQWRLResultValue> row2) {
            for (Integer columnIndex : this.orderByColumnIndexes) {
                int diff;
                block7: {
                    SQWRLResultValue value1 = row1.get(columnIndex);
                    SQWRLResultValue value2 = row2.get(columnIndex);
                    try {
                        if (value1.isLiteral() && value2.isLiteral()) {
                            diff = value1.asLiteralResult().compareTo(value2.asLiteralResult());
                            break block7;
                        }
                        if (value1.isClassExpression() && value2.isClassExpression()) {
                            diff = value1.asClassExpressionResult().compareTo(value2.asClassExpressionResult());
                            break block7;
                        }
                        if (value1.isEntity() && value2.isEntity()) {
                            diff = value1.asEntityResult().compareTo(value2.asEntityResult());
                            break block7;
                        }
                        throw new SWRLAPIInternalException("attempt to compare a " + value1.getClass().getName() + " with a " + value2.getClass().getName());
                    }
                    catch (SQWRLException e) {
                        throw new SWRLAPIInternalException("internal error comparing " + value1.getClass().getName() + " with a " + value2.getClass().getName() + ": " + (e.getMessage() != null ? e.getMessage() : ""));
                    }
                }
                if (diff == 0) continue;
                if (this.ascending) {
                    return diff;
                }
                return -diff;
            }
            return 0;
        }
    }
}

