/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyExpressionBuiltInArgument;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.factory.DefaultSQWRLAnnotationPropertyResultValue;
import org.swrlapi.factory.DefaultSQWRLClassExpressionResultValue;
import org.swrlapi.factory.DefaultSQWRLClassResultValue;
import org.swrlapi.factory.DefaultSQWRLDataPropertyExpressionResultValue;
import org.swrlapi.factory.DefaultSQWRLDataPropertyResultValue;
import org.swrlapi.factory.DefaultSQWRLDatatypeResultValue;
import org.swrlapi.factory.DefaultSQWRLLiteralResultValue;
import org.swrlapi.factory.DefaultSQWRLNamedIndividualResultValue;
import org.swrlapi.factory.DefaultSQWRLObjectPropertyExpressionResultValue;
import org.swrlapi.factory.DefaultSQWRLObjectPropertyResultValue;
import org.swrlapi.factory.OWLLiteralFactory;
import org.swrlapi.factory.SQWRLResultValueFactory;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.literal.Literal;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;
import org.swrlapi.sqwrl.values.SQWRLAnnotationPropertyResultValue;
import org.swrlapi.sqwrl.values.SQWRLClassExpressionResultValue;
import org.swrlapi.sqwrl.values.SQWRLClassResultValue;
import org.swrlapi.sqwrl.values.SQWRLDataPropertyExpressionResultValue;
import org.swrlapi.sqwrl.values.SQWRLDataPropertyResultValue;
import org.swrlapi.sqwrl.values.SQWRLDatatypeResultValue;
import org.swrlapi.sqwrl.values.SQWRLLiteralResultValue;
import org.swrlapi.sqwrl.values.SQWRLNamedIndividualResultValue;
import org.swrlapi.sqwrl.values.SQWRLObjectPropertyExpressionResultValue;
import org.swrlapi.sqwrl.values.SQWRLObjectPropertyResultValue;

public class DefaultSQWRLResultValueFactory
implements SQWRLResultValueFactory {
    private final @NonNull IRIResolver iriResolver;
    private final @NonNull OWLLiteralFactory owlLiteralFactory;

    public DefaultSQWRLResultValueFactory(@NonNull IRIResolver iriResolver) {
        this.iriResolver = iriResolver;
        this.owlLiteralFactory = SWRLAPIInternalFactory.createOWLLiteralFactory();
    }

    @Override
    public @NonNull SQWRLClassResultValue getClassValue(@NonNull SWRLClassBuiltInArgument classArgument) {
        return this.getClassValue(classArgument.getIRI());
    }

    @Override
    public @NonNull SQWRLClassResultValue getClassValue(@NonNull IRI classIRI) {
        String prefixedName = this.iri2PrefixedName(classIRI);
        String shortForm = this.iri2ShortForm(classIRI);
        return new DefaultSQWRLClassResultValue(classIRI, prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLClassExpressionResultValue getClassExpressionValue(@NonNull SWRLClassExpressionBuiltInArgument classExpressionArgument) {
        OWLClassExpression ce = classExpressionArgument.getOWLClassExpression();
        String rendering = this.getIRIResolver().render((OWLObject)ce);
        return new DefaultSQWRLClassExpressionResultValue(rendering);
    }

    @Override
    public @NonNull SQWRLNamedIndividualResultValue getNamedIndividualValue(@NonNull SWRLNamedIndividualBuiltInArgument individualArgument) {
        String prefixedName = this.iri2PrefixedName(individualArgument.getIRI());
        String shortForm = this.iri2ShortForm(individualArgument.getIRI());
        return new DefaultSQWRLNamedIndividualResultValue(individualArgument.getIRI(), prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLNamedIndividualResultValue getNamedIndividualValue(@NonNull IRI individualIRI) {
        String prefixedName = this.iri2PrefixedName(individualIRI);
        String shortForm = this.iri2ShortForm(individualIRI);
        return new DefaultSQWRLNamedIndividualResultValue(individualIRI, prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLObjectPropertyResultValue getObjectPropertyValue(@NonNull SWRLObjectPropertyBuiltInArgument objectPropertyArgument) {
        return this.getObjectPropertyValue(objectPropertyArgument.getIRI());
    }

    @Override
    public @NonNull SQWRLObjectPropertyResultValue getObjectPropertyValue(@NonNull IRI propertyIRI) {
        String prefixedName = this.iri2PrefixedName(propertyIRI);
        String shortForm = this.iri2ShortForm(propertyIRI);
        return new DefaultSQWRLObjectPropertyResultValue(propertyIRI, prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLObjectPropertyExpressionResultValue getObjectPropertyExpressionValue(SWRLObjectPropertyExpressionBuiltInArgument objectPropertyExpressionArgument) {
        OWLObjectPropertyExpression pe = objectPropertyExpressionArgument.getOWLObjectPropertyExpression();
        String rendering = this.getIRIResolver().render((OWLObject)pe);
        return new DefaultSQWRLObjectPropertyExpressionResultValue(rendering);
    }

    @Override
    public @NonNull SQWRLDataPropertyResultValue getDataPropertyValue(@NonNull SWRLDataPropertyBuiltInArgument dataPropertyArgument) {
        String prefixedName = this.iri2PrefixedName(dataPropertyArgument.getIRI());
        String shortForm = this.iri2ShortForm(dataPropertyArgument.getIRI());
        return new DefaultSQWRLDataPropertyResultValue(dataPropertyArgument.getIRI(), prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLDataPropertyResultValue getDataPropertyValue(@NonNull IRI propertyIRI) {
        String prefixedName = this.iri2PrefixedName(propertyIRI);
        String shortForm = this.iri2ShortForm(propertyIRI);
        return new DefaultSQWRLDataPropertyResultValue(propertyIRI, prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLDataPropertyExpressionResultValue getDataPropertyExpressionValue(SWRLDataPropertyExpressionBuiltInArgument dataPropertyExpressionArgument) {
        OWLDataPropertyExpression pe = dataPropertyExpressionArgument.getOWLDataPropertyExpression();
        String rendering = this.getIRIResolver().render((OWLObject)pe);
        return new DefaultSQWRLDataPropertyExpressionResultValue(rendering);
    }

    @Override
    public @NonNull SQWRLAnnotationPropertyResultValue getAnnotationPropertyValue(@NonNull SWRLAnnotationPropertyBuiltInArgument annotationPropertyArgument) {
        String prefixedName = this.iri2PrefixedName(annotationPropertyArgument.getIRI());
        String shortForm = this.iri2ShortForm(annotationPropertyArgument.getIRI());
        return new DefaultSQWRLAnnotationPropertyResultValue(annotationPropertyArgument.getIRI(), prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLAnnotationPropertyResultValue getAnnotationPropertyValue(@NonNull IRI propertyIRI) {
        String prefixedName = this.iri2PrefixedName(propertyIRI);
        String shortForm = this.iri2ShortForm(propertyIRI);
        return new DefaultSQWRLAnnotationPropertyResultValue(propertyIRI, prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLDatatypeResultValue getDatatypeValue(SWRLDatatypeBuiltInArgument datatypeArgument) {
        IRI propertyIRI = datatypeArgument.getOWLDatatype().getIRI();
        String prefixedName = this.iri2PrefixedName(propertyIRI);
        String shortForm = this.iri2ShortForm(propertyIRI);
        return new DefaultSQWRLDatatypeResultValue(propertyIRI, prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLDatatypeResultValue getDatatypeValue(IRI propertyIRI) {
        String prefixedName = this.iri2PrefixedName(propertyIRI);
        String shortForm = this.iri2ShortForm(propertyIRI);
        return new DefaultSQWRLDatatypeResultValue(propertyIRI, prefixedName, shortForm);
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(byte b) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(b), XSDVocabulary.BYTE.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(short s) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(s), XSDVocabulary.SHORT.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(int i) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(i), XSDVocabulary.INT.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(long l) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(l), XSDVocabulary.LONG.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(float f) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(f), XSDVocabulary.FLOAT.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(double d) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(d), XSDVocabulary.DOUBLE.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(@NonNull String s) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(s), XSDVocabulary.STRING.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(@NonNull BigDecimal d) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(d), XSDVocabulary.DECIMAL.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(@NonNull BigInteger i) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(i), XSDVocabulary.INTEGER.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(boolean b) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(b), XSDVocabulary.BOOLEAN.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(@NonNull URI uri) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(uri), XSDVocabulary.ANY_URI.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(@NonNull XSDTime time) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(time), XSDVocabulary.TIME.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(@NonNull XSDDate date) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(date), XSDVocabulary.DATE.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(@NonNull XSDDateTime dateTime) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(dateTime), XSDVocabulary.DATE_TIME.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(@NonNull XSDDuration duration) {
        return new DefaultSQWRLLiteralResultValue(this.getOWLLiteralFactory().getOWLLiteral(duration), XSDVocabulary.DURATION.getPrefixedName());
    }

    @Override
    public @NonNull SQWRLLiteralResultValue getLiteralValue(@NonNull OWLLiteral literal) {
        IRI datatypeIRI = literal.getDatatype().getIRI();
        return new DefaultSQWRLLiteralResultValue(literal, this.iri2PrefixedName(datatypeIRI));
    }

    @Override
    public @NonNull SQWRLLiteralResultValue createLeastNarrowNumericLiteralValue(double value, @NonNull List<@NonNull SQWRLLiteralResultValue> inputResultValues) {
        List<@NonNull OWLLiteral> numericLiterals = inputResultValues.stream().filter(Literal::isNumeric).map(Literal::getOWLLiteral).collect(Collectors.toList());
        OWLLiteral literal = this.getOWLLiteralFactory().createLeastNarrowNumericOWLLiteral(value, numericLiterals);
        return this.getLiteralValue(literal);
    }

    private @NonNull String iri2PrefixedName(IRI iri) {
        Optional<@NonNull String> prefixedName = this.iriResolver.iri2PrefixedName(iri);
        if (prefixedName.isPresent()) {
            return prefixedName.get();
        }
        throw new IllegalArgumentException("could not get prefixed name for IRI " + iri);
    }

    private @NonNull String iri2ShortForm(IRI iri) {
        Optional<@NonNull String> shortshortForm = this.iriResolver.iri2ShortForm(iri);
        if (shortshortForm.isPresent()) {
            return shortshortForm.get();
        }
        throw new IllegalArgumentException("could not get short form for IRI " + iri);
    }

    private @NonNull OWLLiteralFactory getOWLLiteralFactory() {
        return this.owlLiteralFactory;
    }

    private @NonNull IRIResolver getIRIResolver() {
        return this.iriResolver;
    }
}

