/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.core.SWRLAPIBuiltInAtom;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import uk.ac.manchester.cs.owl.owlapi.SWRLBuiltInAtomImpl;

class DefaultSWRLAPIBuiltInAtom
extends SWRLBuiltInAtomImpl
implements SWRLAPIBuiltInAtom {
    private static final long serialVersionUID = 1L;
    private final @NonNull String ruleName;
    private final @NonNull IRI builtInIRI;
    private final @NonNull String builtInPrefixedName;
    private @NonNull List<@NonNull SWRLBuiltInArgument> arguments;
    private @NonNull Set<@NonNull String> pathVariableNames = new HashSet<String>();
    private boolean sqwrlCollectionResultsUsed = false;
    private int builtInIndex = -1;

    public DefaultSWRLAPIBuiltInAtom(@NonNull String ruleName, @NonNull IRI builtInIRI, @NonNull String builtInPrefixedName, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) {
        super(builtInIRI, new ArrayList<SWRLBuiltInArgument>(arguments));
        this.ruleName = ruleName;
        this.builtInIRI = builtInIRI;
        this.builtInPrefixedName = builtInPrefixedName;
        this.arguments = new ArrayList<SWRLBuiltInArgument>(arguments);
    }

    @Override
    public @NonNull String getRuleName() {
        return this.ruleName;
    }

    @Override
    public void setBuiltInArguments(@NonNull List<@NonNull SWRLBuiltInArgument> arguments) {
        this.arguments = arguments;
    }

    @Override
    public @NonNull String getBuiltInPrefixedName() {
        return this.builtInPrefixedName;
    }

    @Override
    public @NonNull IRI getBuiltInIRI() {
        return this.builtInIRI;
    }

    @Override
    public @NonNull List<@NonNull SWRLBuiltInArgument> getBuiltInArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public int getNumberOfArguments() {
        return this.arguments.size();
    }

    @Override
    public int getBuiltInIndex() {
        return this.builtInIndex;
    }

    @Override
    public void setBuiltInIndex(int builtInIndex) {
        this.builtInIndex = builtInIndex;
    }

    @Override
    public @NonNull Set<@NonNull String> getPathVariableNames() {
        return Collections.unmodifiableSet(this.pathVariableNames);
    }

    @Override
    public boolean hasPathVariables() {
        return !this.pathVariableNames.isEmpty();
    }

    @Override
    public boolean usesAtLeastOneVariableOf(@NonNull Set<@NonNull String> variableNames) throws SWRLBuiltInException {
        HashSet<@NonNull String> s = new HashSet<String>(variableNames);
        s.retainAll(this.getArgumentsVariableNames());
        return !s.isEmpty();
    }

    @Override
    public boolean isArgumentAVariable(int argumentNumber) {
        this.checkArgumentNumber(argumentNumber);
        return this.arguments.get(argumentNumber) instanceof SWRLVariableBuiltInArgument;
    }

    @Override
    public boolean isArgumentUnbound(int argumentNumber) throws SWRLBuiltInException {
        this.checkArgumentNumber(argumentNumber);
        return this.arguments.get(argumentNumber).isVariable() && this.arguments.get(argumentNumber).asVariable().isUnbound();
    }

    @Override
    public boolean hasUnboundArguments() throws SWRLBuiltInException {
        for (SWRLBuiltInArgument argument : this.arguments) {
            if (!argument.isVariable() || !argument.asVariable().isUnbound()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasVariableArguments() {
        for (SWRLBuiltInArgument argument : this.arguments) {
            if (!argument.isVariable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull Set<@NonNull String> getUnboundArgumentVariableNames() throws SWRLBuiltInException {
        HashSet<@NonNull String> unboundArgumentVariablePrefixNames = new HashSet<String>();
        for (SWRLBuiltInArgument argument : this.arguments) {
            if (!argument.isVariable() || !argument.asVariable().isUnbound()) continue;
            unboundArgumentVariablePrefixNames.add(argument.asVariable().getVariableName());
        }
        return unboundArgumentVariablePrefixNames;
    }

    @Override
    public @NonNull String getArgumentVariableName(int argumentNumber) throws SWRLBuiltInException {
        this.checkArgumentNumber(argumentNumber);
        if (!this.arguments.get(argumentNumber).isVariable()) {
            throw new SWRLAPIException("expecting a variable for (0-offset) argument #" + argumentNumber);
        }
        return this.arguments.get(argumentNumber).asVariable().getVariableName();
    }

    @Override
    public @NonNull List<@NonNull String> getArgumentsVariableNames() throws SWRLBuiltInException {
        ArrayList<@NonNull String> argumentsVariablePrefixNames = new ArrayList<String>();
        for (SWRLBuiltInArgument argument : this.arguments) {
            if (!argument.isVariable()) continue;
            argumentsVariablePrefixNames.add(argument.asVariable().getVariableName());
        }
        return argumentsVariablePrefixNames;
    }

    @Override
    public @NonNull List<@NonNull String> getArgumentsVariableNamesExceptFirst() throws SWRLBuiltInException {
        ArrayList<@NonNull String> result = new ArrayList<String>();
        int argumentCount = 0;
        for (SWRLBuiltInArgument argument : this.arguments) {
            if (!argument.isVariable() || argumentCount++ == 0) continue;
            result.add(argument.asVariable().getVariableName());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void addArguments(@NonNull List<@NonNull SWRLBuiltInArgument> additionalArguments) {
        this.arguments.addAll(additionalArguments);
    }

    @Override
    public void setPathVariableNames(@NonNull Set<@NonNull String> variableNames) {
        this.pathVariableNames = new HashSet<String>(variableNames);
    }

    @Override
    public void setUsesSQWRLCollectionResults() {
        this.sqwrlCollectionResultsUsed = true;
    }

    @Override
    public boolean usesSQWRLCollectionResults() {
        return this.sqwrlCollectionResultsUsed;
    }

    private void checkArgumentNumber(int argumentNumber) {
        if (argumentNumber < 0 || argumentNumber > this.arguments.size()) {
            throw new SWRLAPIException("invalid (0-offset) argument #" + argumentNumber);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultSWRLAPIBuiltInAtom that = (DefaultSWRLAPIBuiltInAtom)o;
        if (this.sqwrlCollectionResultsUsed != that.sqwrlCollectionResultsUsed) {
            return false;
        }
        if (this.builtInIndex != that.builtInIndex) {
            return false;
        }
        if (!Objects.equals(this.ruleName, that.ruleName)) {
            return false;
        }
        if (!Objects.equals(this.builtInIRI, that.builtInIRI)) {
            return false;
        }
        if (!Objects.equals(this.builtInPrefixedName, that.builtInPrefixedName)) {
            return false;
        }
        if (!Objects.equals(this.arguments, that.arguments)) {
            return false;
        }
        return Objects.equals(this.pathVariableNames, that.pathVariableNames);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
        result = 31 * result + (this.builtInIRI != null ? this.builtInIRI.hashCode() : 0);
        result = 31 * result + (this.builtInPrefixedName != null ? this.builtInPrefixedName.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.pathVariableNames != null ? this.pathVariableNames.hashCode() : 0);
        result = 31 * result + (this.sqwrlCollectionResultsUsed ? 1 : 0);
        result = 31 * result + this.builtInIndex;
        return result;
    }
}

