/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLAPIBuiltInAtom;
import org.swrlapi.factory.LiteralFactory;
import org.swrlapi.factory.OWLDatatypeFactory;
import org.swrlapi.factory.OWLLiteralFactory;
import org.swrlapi.factory.SQWRLResultValueFactory;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.factory.SWRLAPIOWLDataFactory;
import org.swrlapi.factory.SWRLBuiltInArgumentFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public class DefaultSWRLAPIOWLDataFactory
extends OWLDataFactoryImpl
implements SWRLAPIOWLDataFactory {
    private static final long serialVersionUID = 1L;
    private final @NonNull IRIResolver iriResolver;
    private final @NonNull OWLLiteralFactory owlLiteralFactory;
    private final @NonNull OWLDatatypeFactory owlDatatypeFactory;
    private final @NonNull LiteralFactory literalFactory;
    private final @NonNull SWRLBuiltInArgumentFactory swrlBuiltInArgumentFactory;
    private final @NonNull SQWRLResultValueFactory sqwrlResultValueFactory;

    public DefaultSWRLAPIOWLDataFactory(@NonNull IRIResolver iriResolver) {
        this.iriResolver = iriResolver;
        this.owlDatatypeFactory = SWRLAPIInternalFactory.createOWLDatatypeFactory();
        this.owlLiteralFactory = SWRLAPIInternalFactory.createOWLLiteralFactory();
        this.literalFactory = SWRLAPIInternalFactory.createLiteralFactory();
        this.swrlBuiltInArgumentFactory = SWRLAPIInternalFactory.createSWRLBuiltInArgumentFactory(this.iriResolver);
        this.sqwrlResultValueFactory = SWRLAPIInternalFactory.createSQWRLResultValueFactory(this.iriResolver);
    }

    @Override
    public @NonNull SWRLBuiltInArgumentFactory getSWRLBuiltInArgumentFactory() {
        return this.swrlBuiltInArgumentFactory;
    }

    @Override
    public @NonNull SWRLAPIBuiltInAtom getSWRLAPIBuiltInAtom(@NonNull String ruleName, @NonNull IRI builtInIRI, @NonNull String builtInPrefixedName, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) {
        return SWRLAPIInternalFactory.createSWRLAPIBuiltInAtom(ruleName, builtInIRI, builtInPrefixedName, arguments);
    }

    @Override
    public @NonNull SQWRLResultValueFactory getSQWRLResultValueFactory() {
        return this.sqwrlResultValueFactory;
    }

    @Override
    public @NonNull OWLDeclarationAxiom getOWLClassDeclarationAxiom(@NonNull OWLClass cls) {
        return this.getOWLDeclarationAxiom((OWLEntity)cls);
    }

    @Override
    public @NonNull OWLDeclarationAxiom getOWLIndividualDeclarationAxiom(OWLNamedIndividual individual) {
        return this.getOWLDeclarationAxiom((OWLEntity)individual);
    }

    @Override
    public @NonNull OWLDeclarationAxiom getOWLObjectPropertyDeclarationAxiom(@NonNull OWLObjectProperty property) {
        return this.getOWLDeclarationAxiom((OWLEntity)property);
    }

    @Override
    public @NonNull OWLDeclarationAxiom getOWLDataPropertyDeclarationAxiom(@NonNull OWLDataProperty property) {
        return this.getOWLDeclarationAxiom((OWLEntity)property);
    }

    @Override
    public @NonNull OWLDeclarationAxiom getOWLAnnotationPropertyDeclarationAxiom(@NonNull OWLAnnotationProperty property) {
        return this.getOWLDeclarationAxiom((OWLEntity)property);
    }

    @Override
    public @NonNull OWLDeclarationAxiom getOWLDatatypeDeclarationAxiom(@NonNull OWLDatatype datatype) {
        return this.getOWLDeclarationAxiom((OWLEntity)datatype);
    }

    @Override
    public @NonNull OWLDatatypeFactory getOWLDatatypeFactory() {
        return this.owlDatatypeFactory;
    }

    @Override
    public @NonNull OWLLiteralFactory getOWLLiteralFactory() {
        return this.owlLiteralFactory;
    }

    @Override
    public @NonNull LiteralFactory getLiteralFactory() {
        return this.literalFactory;
    }

    @Override
    public @NonNull OWLClass getInjectedOWLClass() {
        IRI iri = this.iriResolver.generateIRI();
        return this.getOWLClass(iri);
    }

    @Override
    public @NonNull OWLNamedIndividual getInjectedOWLNamedIndividual() {
        IRI iri = this.iriResolver.generateIRI();
        return this.getOWLNamedIndividual(iri);
    }
}

