/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.SimpleIRIMapper;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swrlapi.builtins.SWRLBuiltInLibraryManager;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLAPIBuiltInAtom;
import org.swrlapi.core.SWRLAPIOWLOntology;
import org.swrlapi.core.SWRLAPIRule;
import org.swrlapi.core.SWRLRuleRenderer;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.exceptions.SWRLAPIInternalException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLRuleException;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.factory.SWRLAPIOWLDataFactory;
import org.swrlapi.factory.SWRLBuiltInArgumentFactory;
import org.swrlapi.parser.SWRLParseException;
import org.swrlapi.parser.SWRLParser;
import org.swrlapi.sqwrl.SQWRLQuery;
import org.swrlapi.sqwrl.SQWRLQueryRenderer;
import org.swrlapi.sqwrl.SQWRLResult;
import org.swrlapi.sqwrl.SQWRLResultGenerator;
import org.swrlapi.sqwrl.exceptions.SQWRLException;
import org.swrlapi.sqwrl.exceptions.SQWRLInvalidQueryNameException;
import org.swrlapi.ui.model.SWRLAutoCompleter;
import org.swrlapi.ui.model.SWRLRuleEngineModel;

class DefaultSWRLAPIOWLOntology
implements SWRLAPIOWLOntology,
OWLOntologyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultSWRLAPIOWLOntology.class);
    private static final String AUTOGENERATED_RULE_NAME_PREFIX = "S";
    private final @NonNull OWLOntology ontology;
    private final @NonNull IRIResolver iriResolver;
    private final @NonNull SWRLBuiltInLibraryManager swrlBuiltInLibraryManager;
    private final @NonNull SWRLAPIOWLDataFactory swrlapiOWLDataFactory;
    private final @NonNull Map<@NonNull String, @NonNull SWRLAPIRule> swrlRules;
    private final @NonNull Map<@NonNull String, @NonNull SWRLRule> owlapiRules;
    private final @NonNull Map<@NonNull String, @NonNull SQWRLQuery> sqwrlQueries;
    private final @NonNull Set<@NonNull OWLAxiom> assertedOWLAxioms;
    private final @NonNull Map<@NonNull IRI, @NonNull OWLDeclarationAxiom> classDeclarationAxioms;
    private final @NonNull Map<@NonNull IRI, @NonNull OWLDeclarationAxiom> individualDeclarationAxioms;
    private final @NonNull Map<@NonNull IRI, @NonNull OWLDeclarationAxiom> objectPropertyDeclarationAxioms;
    private final @NonNull Map<@NonNull IRI, @NonNull OWLDeclarationAxiom> dataPropertyDeclarationAxioms;
    private final @NonNull Map<@NonNull IRI, @NonNull OWLDeclarationAxiom> annotationPropertyDeclarationAxioms;
    private final @NonNull Set<SWRLRuleEngineModel> swrlRuleEngineModels;
    private boolean hasOntologyChanged = true;
    private boolean eventFreezeMode = false;

    public DefaultSWRLAPIOWLOntology(@NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) {
        this.ontology = ontology;
        this.iriResolver = iriResolver;
        this.swrlapiOWLDataFactory = SWRLAPIInternalFactory.createSWRLAPIOWLDataFactory(this.iriResolver);
        this.swrlBuiltInLibraryManager = SWRLAPIInternalFactory.createSWRLBuiltInLibraryManager();
        this.swrlRules = new HashMap<String, SWRLAPIRule>();
        this.owlapiRules = new HashMap<String, SWRLRule>();
        this.sqwrlQueries = new HashMap<String, SQWRLQuery>();
        this.assertedOWLAxioms = new HashSet<OWLAxiom>();
        this.classDeclarationAxioms = new HashMap<IRI, OWLDeclarationAxiom>();
        this.individualDeclarationAxioms = new HashMap<IRI, OWLDeclarationAxiom>();
        this.objectPropertyDeclarationAxioms = new HashMap<IRI, OWLDeclarationAxiom>();
        this.dataPropertyDeclarationAxioms = new HashMap<IRI, OWLDeclarationAxiom>();
        this.annotationPropertyDeclarationAxioms = new HashMap<IRI, OWLDeclarationAxiom>();
        this.swrlRuleEngineModels = new HashSet<SWRLRuleEngineModel>();
        DefaultSWRLAPIOWLOntology.addSWRLAPIOntologies(this.ontology);
        iriResolver.updatePrefixes(this.ontology);
    }

    @Override
    public void processOntology() throws SWRLBuiltInException {
        this.reset();
        this.iriResolver.updatePrefixes(this.ontology);
        this.processSWRLRulesAndSQWRLQueries();
        this.processOWLAxioms();
        this.notifyRegisteredRuleEngineModels();
    }

    @Override
    public void reset() {
        this.swrlRules.clear();
        this.owlapiRules.clear();
        this.sqwrlQueries.clear();
        this.getIRIResolver().reset();
        this.assertedOWLAxioms.clear();
        this.classDeclarationAxioms.clear();
        this.individualDeclarationAxioms.clear();
        this.objectPropertyDeclarationAxioms.clear();
        this.dataPropertyDeclarationAxioms.clear();
        this.annotationPropertyDeclarationAxioms.clear();
        this.hasOntologyChanged = false;
    }

    @Override
    public void registerRuleEngineModel(SWRLRuleEngineModel swrlRuleEngineModel) {
        if (this.swrlRuleEngineModels.isEmpty()) {
            this.ontology.getOWLOntologyManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
        }
        this.swrlRuleEngineModels.add(swrlRuleEngineModel);
    }

    @Override
    public void unregisterRuleEngineModel(SWRLRuleEngineModel swrlRuleEngineModel) {
        this.swrlRuleEngineModels.remove(swrlRuleEngineModel);
        if (this.swrlRuleEngineModels.isEmpty()) {
            this.ontology.getOWLOntologyManager().removeOntologyChangeListener((OWLOntologyChangeListener)this);
        }
    }

    @Override
    public @NonNull SWRLAPIRule createSWRLRule(@NonNull String ruleName, @NonNull String rule) throws SWRLParseException, SWRLBuiltInException {
        return this.createSWRLRule(ruleName, rule, "", true);
    }

    @Override
    public @NonNull SWRLAPIRule createSWRLRule(@NonNull String ruleName, @NonNull String rule, @NonNull String comment, boolean isActive) throws SWRLParseException, SWRLBuiltInException {
        Optional<SWRLRule> owlapiRule = this.createSWRLParser().parseSWRLRule(rule, false, ruleName, comment);
        if (owlapiRule.isPresent()) {
            SWRLAPIRule swrlapiRule = this.convertOWLAPIRule2SWRLAPIRule(owlapiRule.get(), ruleName, comment, isActive);
            this.addSWRLRule(swrlapiRule, owlapiRule.get());
            return swrlapiRule;
        }
        throw new SWRLParseException("Unknown error - parser failed to generate a rule");
    }

    @Override
    public void replaceSWRLRule(@NonNull String originalRuleName, @NonNull String ruleName, @NonNull String rule, @NonNull String comment, boolean isActive) throws SWRLParseException, SWRLBuiltInException {
        this.startEventFreezeMode();
        this.deleteSWRLRule(originalRuleName);
        this.finishEventFreezeMode();
        this.createSWRLRule(ruleName, rule, comment, isActive);
    }

    @Override
    public void deleteSWRLRule(@NonNull String ruleName) {
        if (this.swrlRules.containsKey(ruleName)) {
            SWRLAPIRule rule = this.swrlRules.get(ruleName);
            SWRLRule owlapiRule = this.owlapiRules.get(ruleName);
            if (rule.isSQWRLQuery()) {
                this.sqwrlQueries.remove(ruleName);
            }
            this.swrlRules.remove(ruleName);
            this.owlapiRules.remove(ruleName);
            this.ontology.getOWLOntologyManager().removeAxiom(this.ontology, (OWLAxiom)owlapiRule);
        }
    }

    @Override
    public @NonNull SQWRLQuery createSQWRLQuery(@NonNull String queryName, @NonNull String query) throws SWRLParseException, SWRLBuiltInException {
        return this.createSQWRLQuery(queryName, query, "", true);
    }

    @Override
    public @NonNull SQWRLQuery createSQWRLQuery(@NonNull String queryName, @NonNull String queryText, @NonNull String comment, boolean isActive) throws SWRLParseException, SWRLBuiltInException {
        Optional<SWRLRule> owlapiRule = this.createSWRLParser().parseSWRLRule(queryText, false, queryName, comment);
        if (owlapiRule.isPresent()) {
            SWRLAPIRule swrlapiRule = this.convertOWLAPIRule2SWRLAPIRule(owlapiRule.get(), queryName, comment, isActive);
            this.addSWRLRule(swrlapiRule, owlapiRule.get());
            if (swrlapiRule.isSQWRLQuery()) {
                SQWRLQuery query = this.createSQWRLQueryFromSWRLRule(swrlapiRule);
                this.sqwrlQueries.put(queryName, query);
                return query;
            }
            throw new SWRLParseException(queryName + " is not a SQWRL query");
        }
        throw new SWRLParseException("Unknown error - parser failed to generate a query");
    }

    @Override
    public @NonNull Set<@NonNull SWRLAPIRule> getSWRLRules() {
        return new HashSet<SWRLAPIRule>(this.swrlRules.values());
    }

    private void processSWRLRulesAndSQWRLQueries() throws SWRLBuiltInException {
        int ruleNameIndex = 0;
        this.swrlRules.clear();
        this.owlapiRules.clear();
        this.sqwrlQueries.clear();
        for (SWRLRule owlapiRule : this.getOWLOntology().getAxioms(AxiomType.SWRL_RULE, Imports.INCLUDED)) {
            Optional<@NonNull String> ruleName = this.getRuleName(owlapiRule);
            boolean isActive = this.getIsRuleEnabled(owlapiRule);
            String comment = this.getRuleComment(owlapiRule);
            String finalRuleName = ruleName.isPresent() ? ruleName.get() : AUTOGENERATED_RULE_NAME_PREFIX + ++ruleNameIndex;
            SWRLAPIRule swrlapiRule = this.convertOWLAPIRule2SWRLAPIRule(owlapiRule, finalRuleName, comment, isActive);
            this.swrlRules.put(finalRuleName, swrlapiRule);
            this.owlapiRules.put(finalRuleName, owlapiRule);
            this.assertedOWLAxioms.add((OWLAxiom)swrlapiRule);
            if (!swrlapiRule.isSQWRLQuery()) continue;
            SQWRLQuery query = this.createSQWRLQueryFromSWRLRule(swrlapiRule);
            this.sqwrlQueries.put(finalRuleName, query);
        }
    }

    @Override
    public @NonNull Optional<@NonNull SWRLAPIRule> getSWRLRule(@NonNull String ruleName) throws SWRLRuleException {
        if (!this.swrlRules.containsKey(ruleName)) {
            return Optional.empty();
        }
        return Optional.of(this.swrlRules.get(ruleName));
    }

    @Override
    public @NonNull OWLOntology getOWLOntology() {
        return this.ontology;
    }

    @Override
    public @NonNull OWLOntologyManager getOWLOntologyManager() {
        return this.ontology.getOWLOntologyManager();
    }

    @Override
    public @NonNull SWRLParser createSWRLParser() {
        return new SWRLParser(this);
    }

    @Override
    public @NonNull SWRLAutoCompleter createSWRLAutoCompleter() {
        return SWRLAPIInternalFactory.createSWRLAutoCompleter(this);
    }

    @Override
    public @NonNull SWRLRuleRenderer createSWRLRuleRenderer() {
        return SWRLAPIInternalFactory.createSWRLRuleRenderer(this.getOWLOntology(), this.getIRIResolver());
    }

    @Override
    public @NonNull SWRLBuiltInLibraryManager getSWRLBuiltInLibraryManager() {
        return this.swrlBuiltInLibraryManager;
    }

    @Override
    public Optional<String> getNextRuleName() {
        Set<String> currentSWRLRuleNames = this.swrlRules.keySet();
        for (int ruleIndex = 1; ruleIndex < Integer.MAX_VALUE; ++ruleIndex) {
            String candidateRuleName = AUTOGENERATED_RULE_NAME_PREFIX + ruleIndex;
            if (currentSWRLRuleNames.contains(candidateRuleName)) continue;
            return Optional.of(candidateRuleName);
        }
        return Optional.empty();
    }

    @Override
    public @NonNull SQWRLQueryRenderer createSQWRLQueryRenderer() {
        return SWRLAPIInternalFactory.createSQWRLQueryRenderer(this.getOWLOntology(), this.getIRIResolver());
    }

    @Override
    public int getNumberOfSWRLRules() {
        return this.swrlRules.values().size();
    }

    @Override
    public int getNumberOfOWLClassDeclarationAxioms() {
        return this.classDeclarationAxioms.values().size();
    }

    @Override
    public int getNumberOfOWLIndividualDeclarationAxioms() {
        return this.individualDeclarationAxioms.values().size();
    }

    @Override
    public int getNumberOfOWLObjectPropertyDeclarationAxioms() {
        return this.objectPropertyDeclarationAxioms.size();
    }

    @Override
    public int getNumberOfOWLDataPropertyDeclarationAxioms() {
        return this.dataPropertyDeclarationAxioms.size();
    }

    @Override
    public int getNumberOfOWLAxioms() {
        return this.assertedOWLAxioms.size();
    }

    @Override
    public @NonNull Set<@NonNull OWLAxiom> getOWLAxioms() {
        return Collections.unmodifiableSet(this.assertedOWLAxioms);
    }

    @Override
    public boolean hasAssertedOWLAxiom(@NonNull OWLAxiom axiom) {
        return this.assertedOWLAxioms.contains(axiom);
    }

    @Override
    public @NonNull Set<@NonNull String> getSQWRLQueryNames() {
        return Collections.unmodifiableSet(this.sqwrlQueries.keySet());
    }

    @Override
    public @NonNull Set<@NonNull SQWRLQuery> getSQWRLQueries() {
        return new HashSet<SQWRLQuery>(this.sqwrlQueries.values());
    }

    @Override
    public @NonNull SQWRLResult getSQWRLResult(@NonNull String queryName) throws SQWRLException {
        if (!this.sqwrlQueries.containsKey(queryName)) {
            throw new SQWRLInvalidQueryNameException(queryName);
        }
        return this.sqwrlQueries.get(queryName).getSQWRLResult();
    }

    @Override
    public @NonNull SQWRLResultGenerator getSQWRLResultGenerator(@NonNull String queryName) throws SQWRLException {
        if (!this.sqwrlQueries.containsKey(queryName)) {
            throw new SQWRLInvalidQueryNameException(queryName);
        }
        return this.sqwrlQueries.get(queryName).getSQWRLResultGenerator();
    }

    private @NonNull SQWRLQuery createSQWRLQueryFromSWRLRule(@NonNull SWRLAPIRule rule) throws SWRLBuiltInException {
        String queryName = rule.getRuleName();
        boolean active = rule.isActive();
        String comment = rule.getComment();
        return SWRLAPIInternalFactory.createSQWRLQuery(queryName, rule.getBodyAtoms(), rule.getHeadAtoms(), active, comment, this.getSWRLAPIOWLDataFactory().getLiteralFactory(), this.getIRIResolver());
    }

    private @NonNull Optional<@NonNull String> getRuleName(@NonNull SWRLRule owlapiRule) {
        OWLAnnotationProperty labelAnnotation = this.getOWLDataFactory().getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        for (OWLAnnotation annotation : owlapiRule.getAnnotations(labelAnnotation)) {
            if (!(annotation.getValue() instanceof OWLLiteral)) continue;
            OWLLiteral literal = (OWLLiteral)annotation.getValue();
            return Optional.of(literal.getLiteral());
        }
        return Optional.empty();
    }

    private boolean getIsRuleEnabled(@NonNull SWRLRule owlapiRule) {
        OWLAnnotationProperty enabledAnnotationProperty = this.getOWLDataFactory().getOWLAnnotationProperty(IRI.create((String)"http://swrl.stanford.edu/ontologies/3.3/swrla.owl#isRuleEnabled"));
        for (OWLAnnotation annotation : owlapiRule.getAnnotations(enabledAnnotationProperty)) {
            OWLLiteral literal;
            if (!(annotation.getValue() instanceof OWLLiteral) || !(literal = (OWLLiteral)annotation.getValue()).isBoolean()) continue;
            return literal.parseBoolean();
        }
        return true;
    }

    private @NonNull String getRuleComment(@NonNull SWRLRule owlapiRule) {
        OWLAnnotationProperty commentAnnotationProperty = this.getOWLDataFactory().getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_COMMENT.getIRI());
        for (OWLAnnotation annotation : owlapiRule.getAnnotations(commentAnnotationProperty)) {
            if (!(annotation.getValue() instanceof OWLLiteral)) continue;
            OWLLiteral literal = (OWLLiteral)annotation.getValue();
            return literal.getLiteral();
        }
        return "";
    }

    @Override
    public @NonNull Set<@NonNull OWLAnnotation> generateRuleAnnotations(@NonNull String ruleName, @NonNull String comment, boolean isRuleEnabled) {
        OWLAnnotation labelAnnotation = this.getOWLDataFactory().getOWLAnnotation(this.getOWLDataFactory().getRDFSLabel(), (OWLAnnotationValue)this.getOWLDataFactory().getOWLLiteral(ruleName));
        OWLAnnotation commentAnnotation = this.getOWLDataFactory().getOWLAnnotation(this.getOWLDataFactory().getRDFSComment(), (OWLAnnotationValue)this.getOWLDataFactory().getOWLLiteral(comment));
        OWLAnnotationProperty isRuleEnabledAnnotationProperty = this.getOWLDataFactory().getOWLAnnotationProperty(IRI.create((String)"http://swrl.stanford.edu/ontologies/3.3/swrla.owl#isRuleEnabled"));
        OWLAnnotation isRuleEnabledAnnotation = this.getOWLDataFactory().getOWLAnnotation(isRuleEnabledAnnotationProperty, (OWLAnnotationValue)this.getOWLDataFactory().getOWLLiteral(isRuleEnabled));
        HashSet<@NonNull OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        annotations.add(labelAnnotation);
        annotations.add(commentAnnotation);
        annotations.add(isRuleEnabledAnnotation);
        return annotations;
    }

    @Override
    public @NonNull SWRLAPIOWLDataFactory getSWRLAPIOWLDataFactory() {
        return this.swrlapiOWLDataFactory;
    }

    @Override
    public @NonNull OWLDataFactory getOWLDataFactory() {
        return this.ontology.getOWLOntologyManager().getOWLDataFactory();
    }

    @Override
    public @NonNull IRIResolver getIRIResolver() {
        return this.iriResolver;
    }

    private @NonNull String iri2PrefixedName(IRI iri) {
        Optional<@NonNull String> prefixedName = this.iriResolver.iri2PrefixedName(iri);
        if (prefixedName.isPresent()) {
            return prefixedName.get();
        }
        throw new IllegalArgumentException("could not get prefixed name for IRI " + iri);
    }

    @Override
    public void startEventFreezeMode() {
        this.eventFreezeMode = true;
    }

    @Override
    public void finishEventFreezeMode() {
        this.eventFreezeMode = false;
    }

    @Override
    public boolean hasOntologyChanged() {
        return this.hasOntologyChanged;
    }

    @Override
    public void resetOntologyChanged() {
        this.hasOntologyChanged = false;
    }

    @Override
    public boolean isSWRLBuiltInIRI(@NonNull IRI iri) {
        return this.swrlBuiltInLibraryManager.isSWRLBuiltInIRI(iri);
    }

    @Override
    public boolean isSWRLBuiltIn(@NonNull String prefixedName) {
        return this.swrlBuiltInLibraryManager.isSWRLBuiltIn(prefixedName);
    }

    @Override
    public Optional<@NonNull IRI> swrlBuiltInPrefixedName2IRI(@NonNull String prefixedNameName) {
        return this.swrlBuiltInLibraryManager.swrlBuiltInPrefixedName2IRI(prefixedNameName);
    }

    @Override
    public @NonNull Set<@NonNull IRI> getSWRLBuiltInIRIs() {
        return this.swrlBuiltInLibraryManager.getSWRLBuiltInIRIs();
    }

    @Override
    public @NonNull SQWRLResultGenerator createSQWRLResultGenerator() {
        return SWRLAPIInternalFactory.createSQWRLResultGenerator(this.iriResolver);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull SWRLAPIRule convertOWLAPIRule2SWRLAPIRule(@NonNull SWRLRule owlapiRule, @NonNull String ruleName, @NonNull String comment, boolean isActive) throws SWRLBuiltInException {
        IRI builtInIRI;
        SWRLBuiltInAtom builtInAtom;
        ArrayList<@NonNull E> owlapiBodyAtoms = new ArrayList(owlapiRule.getBody());
        ArrayList<@NonNull E> owlapiHeadAtoms = new ArrayList(owlapiRule.getHead());
        ArrayList<@NonNull SWRLAPIBuiltInAtom> swrlapiBodyAtoms = new ArrayList<SWRLAPIBuiltInAtom>();
        ArrayList<@NonNull SWRLAPIBuiltInAtom> swrlapiHeadAtoms = new ArrayList<SWRLAPIBuiltInAtom>();
        for (SWRLAtom atom : owlapiBodyAtoms) {
            if (this.isSWRLBuiltInAtom(atom)) {
                builtInAtom = (SWRLBuiltInAtom)atom;
                builtInIRI = builtInAtom.getPredicate();
                Optional<String> knownBuiltInPrefixedName = this.swrlBuiltInLibraryManager.swrlBuiltInIRI2PrefixedName(builtInIRI);
                String builtInPrefixedName = knownBuiltInPrefixedName.orElseGet(() -> this.iri2PrefixedName(builtInIRI));
                @NonNull List swrlDArguments = builtInAtom.getArguments();
                List<@NonNull SWRLBuiltInArgument> swrlBuiltInArguments = this.convertSWRLDArguments2SWRLBuiltInArguments(swrlDArguments);
                SWRLAPIBuiltInAtom swrlapiBuiltInAtom = this.getSWRLAPIOWLDataFactory().getSWRLAPIBuiltInAtom(ruleName, builtInIRI, builtInPrefixedName, swrlBuiltInArguments);
                swrlapiBodyAtoms.add(swrlapiBuiltInAtom);
                continue;
            }
            swrlapiBodyAtoms.add((SWRLAPIBuiltInAtom)atom);
        }
        for (SWRLAtom atom : owlapiHeadAtoms) {
            if (this.isSWRLBuiltInAtom(atom)) {
                builtInAtom = (SWRLBuiltInAtom)atom;
                builtInIRI = builtInAtom.getPredicate();
                String builtInPrefixedName = this.iri2PrefixedName(builtInIRI);
                @NonNull List swrlDArguments = builtInAtom.getArguments();
                List<@NonNull SWRLBuiltInArgument> swrlBuiltInArguments = this.convertSWRLDArguments2SWRLBuiltInArguments(swrlDArguments);
                SWRLAPIBuiltInAtom swrlapiBuiltInAtom = this.getSWRLAPIOWLDataFactory().getSWRLAPIBuiltInAtom(ruleName, builtInIRI, builtInPrefixedName, swrlBuiltInArguments);
                swrlapiHeadAtoms.add(swrlapiBuiltInAtom);
                continue;
            }
            swrlapiHeadAtoms.add((SWRLAPIBuiltInAtom)atom);
        }
        return SWRLAPIInternalFactory.createSWRLAPIRule(ruleName, swrlapiBodyAtoms, swrlapiHeadAtoms, comment, isActive);
    }

    private @NonNull List<@NonNull SWRLBuiltInArgument> convertSWRLDArguments2SWRLBuiltInArguments(@NonNull List<@NonNull SWRLDArgument> swrlDArguments) {
        ArrayList<@NonNull SWRLBuiltInArgument> swrlBuiltInArguments = new ArrayList<SWRLBuiltInArgument>();
        for (SWRLDArgument swrlDArgument : swrlDArguments) {
            SWRLBuiltInArgument swrlBuiltInArgument = this.convertSWRLDArgument2SWRLBuiltInArgument(swrlDArgument);
            swrlBuiltInArguments.add(swrlBuiltInArgument);
        }
        return swrlBuiltInArguments;
    }

    private @NonNull SWRLBuiltInArgument convertSWRLDArgument2SWRLBuiltInArgument(@NonNull SWRLDArgument swrlDArgument) {
        if (swrlDArgument instanceof SWRLLiteralArgument) {
            SWRLLiteralArgument swrlLiteralArgument = (SWRLLiteralArgument)swrlDArgument;
            return this.convertSWRLLiteralArgument2SWRLBuiltInArgument(swrlLiteralArgument);
        }
        if (swrlDArgument instanceof SWRLVariable) {
            SWRLVariable swrlVariable = (SWRLVariable)swrlDArgument;
            return this.convertSWRLVariable2SWRLBuiltInArgument(swrlVariable);
        }
        throw new SWRLAPIInternalException("Unknown " + SWRLDArgument.class.getName() + " class " + swrlDArgument.getClass().getName());
    }

    private @NonNull SWRLBuiltInArgument convertSWRLVariable2SWRLBuiltInArgument(@NonNull SWRLVariable swrlVariable) {
        IRI iri = swrlVariable.getIRI();
        if (this.isOWLClass(iri)) {
            OWLClass cls = this.getOWLDataFactory().getOWLClass(iri);
            return this.getSWRLBuiltInArgumentFactory().getClassBuiltInArgument(cls);
        }
        if (this.getOWLOntology().containsIndividualInSignature(iri, Imports.INCLUDED)) {
            OWLNamedIndividual individual = this.getOWLDataFactory().getOWLNamedIndividual(iri);
            return this.getSWRLBuiltInArgumentFactory().getNamedIndividualBuiltInArgument(individual);
        }
        if (this.getOWLOntology().containsObjectPropertyInSignature(iri, Imports.INCLUDED)) {
            OWLObjectProperty property = this.getOWLDataFactory().getOWLObjectProperty(iri);
            return this.getSWRLBuiltInArgumentFactory().getObjectPropertyBuiltInArgument(property);
        }
        if (this.getOWLOntology().containsDataPropertyInSignature(iri, Imports.INCLUDED)) {
            OWLDataProperty property = this.getOWLDataFactory().getOWLDataProperty(iri);
            return this.getSWRLBuiltInArgumentFactory().getDataPropertyBuiltInArgument(property);
        }
        if (this.getOWLOntology().containsAnnotationPropertyInSignature(iri, Imports.INCLUDED)) {
            OWLAnnotationProperty property = this.getOWLDataFactory().getOWLAnnotationProperty(iri);
            return this.getSWRLBuiltInArgumentFactory().getAnnotationPropertyBuiltInArgument(property);
        }
        if (this.getOWLOntology().containsDatatypeInSignature(iri, Imports.INCLUDED)) {
            OWLDatatype datatype = this.getOWLDataFactory().getOWLDatatype(iri);
            return this.getSWRLBuiltInArgumentFactory().getDatatypeBuiltInArgument(datatype);
        }
        IRI variableIRI = swrlVariable.getIRI();
        SWRLVariableBuiltInArgument argument = this.getSWRLBuiltInArgumentFactory().getVariableBuiltInArgument(variableIRI);
        return argument;
    }

    private boolean isOWLClass(@NonNull IRI iri) {
        return this.getOWLOntology().containsClassInSignature(iri, Imports.INCLUDED) || iri.equals((Object)OWLRDFVocabulary.OWL_THING.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_NOTHING.getIRI());
    }

    private @NonNull SWRLBuiltInArgument convertSWRLLiteralArgument2SWRLBuiltInArgument(@NonNull SWRLLiteralArgument swrlLiteralArgument) {
        OWLLiteral literal = swrlLiteralArgument.getLiteral();
        OWLDatatype literalDatatype = literal.getDatatype();
        if (this.isURI(literalDatatype)) {
            IRI iri = IRI.create((String)literal.getLiteral());
            if (this.isOWLClass(iri)) {
                OWLClass cls = this.getOWLDataFactory().getOWLClass(iri);
                return this.getSWRLBuiltInArgumentFactory().getClassBuiltInArgument(cls);
            }
            if (this.getOWLOntology().containsIndividualInSignature(iri)) {
                OWLNamedIndividual individual = this.getOWLDataFactory().getOWLNamedIndividual(iri);
                return this.getSWRLBuiltInArgumentFactory().getNamedIndividualBuiltInArgument(individual);
            }
            if (this.getOWLOntology().containsObjectPropertyInSignature(iri)) {
                OWLObjectProperty property = this.getOWLDataFactory().getOWLObjectProperty(iri);
                return this.getSWRLBuiltInArgumentFactory().getObjectPropertyBuiltInArgument(property);
            }
            if (this.getOWLOntology().containsDataPropertyInSignature(iri)) {
                OWLDataProperty property = this.getOWLDataFactory().getOWLDataProperty(iri);
                return this.getSWRLBuiltInArgumentFactory().getDataPropertyBuiltInArgument(property);
            }
            if (this.getOWLOntology().containsAnnotationPropertyInSignature(iri)) {
                OWLAnnotationProperty property = this.getOWLDataFactory().getOWLAnnotationProperty(iri);
                return this.getSWRLBuiltInArgumentFactory().getAnnotationPropertyBuiltInArgument(property);
            }
            if (this.getOWLOntology().containsDatatypeInSignature(iri)) {
                OWLDatatype datatype = this.getOWLDataFactory().getOWLDatatype(iri);
                return this.getSWRLBuiltInArgumentFactory().getDatatypeBuiltInArgument(datatype);
            }
            return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(literal);
        }
        return this.getSWRLBuiltInArgumentFactory().getLiteralBuiltInArgument(literal);
    }

    private boolean isSWRLBuiltInAtom(SWRLAtom atom) {
        if (atom instanceof SWRLBuiltInAtom) {
            return true;
        }
        SWRLPredicate predicate = atom.getPredicate();
        if (predicate instanceof IRI) {
            IRI iri = (IRI)predicate;
            return this.isSWRLBuiltInIRI(iri);
        }
        return false;
    }

    private boolean isURI(@NonNull OWLDatatype datatype) {
        return datatype.getIRI().equals((Object)OWL2Datatype.XSD_ANY_URI.getIRI());
    }

    private @NonNull SWRLBuiltInArgumentFactory getSWRLBuiltInArgumentFactory() {
        return this.getSWRLAPIOWLDataFactory().getSWRLBuiltInArgumentFactory();
    }

    private void addSWRLRule(@NonNull SWRLAPIRule swrlapiRule, @NonNull SWRLRule owlapiRule) {
        String ruleName = swrlapiRule.getRuleName();
        this.swrlRules.put(ruleName, swrlapiRule);
        this.owlapiRules.put(ruleName, owlapiRule);
        this.assertedOWLAxioms.add((OWLAxiom)swrlapiRule);
        this.ontology.getOWLOntologyManager().addAxiom(this.ontology, (OWLAxiom)owlapiRule);
    }

    private void processOWLAxioms() {
        this.processOWLClassDeclarationAxioms();
        this.processOWLIndividualDeclarationAxioms();
        this.processOWLObjectPropertyDeclarationAxioms();
        this.processOWLDataPropertyDeclarationAxioms();
        this.processOWLAnnotationPropertyDeclarationAxioms();
        this.processOWLClassAssertionAxioms();
        this.processOWLObjectPropertyAssertionAxioms();
        this.processOWLDataPropertyAssertionAxioms();
        this.processOWLSameIndividualAxioms();
        this.processOWLDifferentIndividualsAxioms();
        this.processOWLSubClassOfAxioms();
        this.processOWLEquivalentClassesAxioms();
        this.processOWLSubObjectPropertyOfAxioms();
        this.processOWLSubDataPropertyOfAxioms();
        this.processOWLEquivalentDataPropertiesAxioms();
        this.processOWLEquivalentObjectPropertiesAxioms();
        this.processOWLTransitiveObjectPropertyAxioms();
        this.processOWLSymmetricObjectPropertyAxioms();
        this.processOWLFunctionalObjectPropertyAxioms();
        this.processOWLInverseFunctionalObjectPropertyAxioms();
        this.processOWLFunctionalDataPropertyAxioms();
        this.processOWLObjectPropertyDomainAxioms();
        this.processOWLDataPropertyDomainAxioms();
        this.processOWLObjectPropertyRangeAxioms();
        this.processOWLDataPropertyRangeAxioms();
        this.processOWLInverseObjectPropertiesAxioms();
        this.processOWLIrreflexiveObjectPropertyAxioms();
        this.processOWLAsymmetricObjectPropertyAxioms();
        this.processOWLDisjointObjectPropertiesAxioms();
        this.processOWLDisjointDataPropertiesAxioms();
    }

    private void processOWLClassAssertionAxioms() {
        for (OWLClassAssertionAxiom axiom : this.getOWLClassAssertionAxioms()) {
            this.generateOWLIndividualDeclarationAxiomIfNecessary(axiom.getIndividual());
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void processOWLObjectPropertyAssertionAxioms() {
        for (OWLObjectPropertyAssertionAxiom axiom : this.getOWLObjectPropertyAssertionAxioms()) {
            this.generateOWLIndividualDeclarationAxiomIfNecessary(axiom.getSubject());
            this.generateOWLIndividualDeclarationAxiomIfNecessary((OWLIndividual)axiom.getObject());
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void processOWLDataPropertyAssertionAxioms() {
        for (OWLDataPropertyAssertionAxiom axiom : this.getOWLDataPropertyAssertionAxioms()) {
            this.generateOWLIndividualDeclarationAxiomIfNecessary(axiom.getSubject());
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void processOWLClassDeclarationAxioms() {
        for (OWLDeclarationAxiom axiom : this.getOWLClassDeclarationAxioms()) {
            OWLEntity cls = axiom.getEntity();
            this.classDeclarationAxioms.put(cls.getIRI(), axiom);
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void processOWLIndividualDeclarationAxioms() {
        for (OWLDeclarationAxiom axiom : this.getOWLIndividualDeclarationAxioms()) {
            OWLEntity individual = axiom.getEntity();
            this.individualDeclarationAxioms.put(individual.getIRI(), axiom);
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void processOWLObjectPropertyDeclarationAxioms() {
        for (OWLDeclarationAxiom axiom : this.getOWLObjectPropertyDeclarationAxioms()) {
            OWLEntity property = axiom.getEntity();
            this.objectPropertyDeclarationAxioms.put(property.getIRI(), axiom);
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void processOWLDataPropertyDeclarationAxioms() {
        for (OWLDeclarationAxiom axiom : this.getOWLDataPropertyDeclarationAxioms()) {
            OWLEntity property = axiom.getEntity();
            this.dataPropertyDeclarationAxioms.put(property.getIRI(), axiom);
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void processOWLAnnotationPropertyDeclarationAxioms() {
        for (OWLDeclarationAxiom axiom : this.getOWLAnnotationPropertyDeclarationAxioms()) {
            OWLEntity property = axiom.getEntity();
            this.annotationPropertyDeclarationAxioms.put(property.getIRI(), axiom);
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void processOWLSameIndividualAxioms() {
        Set<@NonNull OWLSameIndividualAxiom> axioms = this.getOWLSameIndividualAxioms();
        for (OWLSameIndividualAxiom axiom : axioms) {
            axiom.getIndividuals().forEach(this::generateOWLIndividualDeclarationAxiomIfNecessary);
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLDifferentIndividualsAxioms() {
        Set<@NonNull OWLDifferentIndividualsAxiom> axioms = this.getOWLDifferentIndividualsAxioms();
        for (OWLDifferentIndividualsAxiom axiom : axioms) {
            axiom.getIndividuals().forEach(this::generateOWLIndividualDeclarationAxiomIfNecessary);
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLSubClassOfAxioms() {
        Set<@NonNull OWLSubClassOfAxiom> axioms = this.getOWLSubClassOfAxioms();
        for (OWLSubClassOfAxiom axiom : axioms) {
            this.generateOWLClassDeclarationAxiomIfNecessary(axiom.getSubClass());
            this.generateOWLClassDeclarationAxiomIfNecessary(axiom.getSuperClass());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLEquivalentClassesAxioms() {
        Set<@NonNull OWLEquivalentClassesAxiom> axioms = this.getOWLEquivalentClassesAxioms();
        for (OWLEquivalentClassesAxiom axiom : axioms) {
            axiom.getNamedClasses().forEach(this::generateOWLClassDeclarationAxiom);
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLSubObjectPropertyOfAxioms() {
        Set<@NonNull OWLSubObjectPropertyOfAxiom> axioms = this.getOWLSubObjectPropertyOfAxioms();
        for (OWLSubObjectPropertyOfAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getSubProperty());
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getSuperProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLSubDataPropertyOfAxioms() {
        Set<@NonNull OWLSubDataPropertyOfAxiom> axioms = this.getOWLSubDataPropertyOfAxioms();
        for (OWLSubDataPropertyOfAxiom axiom : axioms) {
            this.generateOWLDataPropertyDeclarationAxiomIfNecessary((OWLDataPropertyExpression)axiom.getSubProperty());
            this.generateOWLDataPropertyDeclarationAxiomIfNecessary((OWLDataPropertyExpression)axiom.getSuperProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLTransitiveObjectPropertyAxioms() {
        Set<@NonNull OWLTransitiveObjectPropertyAxiom> axioms = this.getOWLTransitiveObjectPropertyAxioms();
        for (OWLTransitiveObjectPropertyAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLSymmetricObjectPropertyAxioms() {
        Set<@NonNull OWLSymmetricObjectPropertyAxiom> axioms = this.getOWLSymmetricObjectPropertyAxioms();
        for (OWLSymmetricObjectPropertyAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLFunctionalObjectPropertyAxioms() {
        Set<@NonNull OWLFunctionalObjectPropertyAxiom> axioms = this.getOWLFunctionalObjectPropertyAxioms();
        for (OWLFunctionalObjectPropertyAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLInverseFunctionalObjectPropertyAxioms() {
        Set<@NonNull OWLInverseFunctionalObjectPropertyAxiom> axioms = this.getOWLInverseFunctionalObjectPropertyAxioms();
        for (OWLInverseFunctionalObjectPropertyAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLFunctionalDataPropertyAxioms() {
        Set<@NonNull OWLFunctionalDataPropertyAxiom> axioms = this.getOWLFunctionalDataPropertyAxioms();
        for (OWLFunctionalDataPropertyAxiom axiom : axioms) {
            this.generateOWLDataPropertyDeclarationAxiomIfNecessary((OWLDataPropertyExpression)axiom.getProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLObjectPropertyDomainAxioms() {
        Set<@NonNull OWLObjectPropertyDomainAxiom> axioms = this.getOWLObjectPropertyDomainAxioms();
        for (OWLObjectPropertyDomainAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getProperty());
            this.generateOWLClassDeclarationAxiomIfNecessary(axiom.getDomain());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLDataPropertyDomainAxioms() {
        Set<@NonNull OWLDataPropertyDomainAxiom> axioms = this.getOWLDataPropertyDomainAxioms();
        for (OWLDataPropertyDomainAxiom axiom : axioms) {
            this.generateOWLDataPropertyDeclarationAxiomIfNecessary((OWLDataPropertyExpression)axiom.getProperty());
            this.generateOWLClassDeclarationAxiomIfNecessary(axiom.getDomain());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLObjectPropertyRangeAxioms() {
        Set<@NonNull OWLObjectPropertyRangeAxiom> axioms = this.getOWLObjectPropertyRangeAxioms();
        for (OWLObjectPropertyRangeAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getProperty());
            this.generateOWLClassDeclarationAxiomIfNecessary((OWLClassExpression)axiom.getRange());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLDataPropertyRangeAxioms() {
        Set<@NonNull OWLDataPropertyRangeAxiom> axioms = this.getOWLDataPropertyRangeAxioms();
        for (OWLDataPropertyRangeAxiom axiom : axioms) {
            this.generateOWLDataPropertyDeclarationAxiomIfNecessary((OWLDataPropertyExpression)axiom.getProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLIrreflexiveObjectPropertyAxioms() {
        Set<@NonNull OWLIrreflexiveObjectPropertyAxiom> axioms = this.getOWLIrreflexiveObjectPropertyAxioms();
        for (OWLIrreflexiveObjectPropertyAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLAsymmetricObjectPropertyAxioms() {
        Set<@NonNull OWLAsymmetricObjectPropertyAxiom> axioms = this.getOWLAsymmetricObjectPropertyAxioms();
        for (OWLAsymmetricObjectPropertyAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary((OWLObjectPropertyExpression)axiom.getProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLEquivalentObjectPropertiesAxioms() {
        Set<@NonNull OWLEquivalentObjectPropertiesAxiom> axioms = this.getOWLEquivalentObjectPropertiesAxioms();
        for (OWLEquivalentObjectPropertiesAxiom axiom : axioms) {
            axiom.getProperties().forEach(this::generateOWLObjectPropertyDeclarationAxiomIfNecessary);
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLEquivalentDataPropertiesAxioms() {
        Set<@NonNull OWLEquivalentDataPropertiesAxiom> axioms = this.getOWLEquivalentDataPropertiesAxioms();
        for (OWLEquivalentDataPropertiesAxiom axiom : axioms) {
            axiom.getProperties().forEach(this::generateOWLDataPropertyDeclarationAxiomIfNecessary);
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLInverseObjectPropertiesAxioms() {
        Set<@NonNull OWLInverseObjectPropertiesAxiom> axioms = this.getOWLInverseObjectPropertiesAxioms();
        for (OWLInverseObjectPropertiesAxiom axiom : axioms) {
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary(axiom.getFirstProperty());
            this.generateOWLObjectPropertyDeclarationAxiomIfNecessary(axiom.getSecondProperty());
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLDisjointObjectPropertiesAxioms() {
        Set<@NonNull OWLDisjointObjectPropertiesAxiom> axioms = this.getOWLDisjointObjectPropertiesAxioms();
        for (OWLDisjointObjectPropertiesAxiom axiom : axioms) {
            axiom.getProperties().forEach(this::generateOWLObjectPropertyDeclarationAxiomIfNecessary);
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void processOWLDisjointDataPropertiesAxioms() {
        Set<@NonNull OWLDisjointDataPropertiesAxiom> axioms = this.getOWLDisjointDataPropertiesAxioms();
        for (OWLDisjointDataPropertiesAxiom axiom : axioms) {
            axiom.getProperties().forEach(this::generateOWLDataPropertyDeclarationAxiomIfNecessary);
        }
        this.assertedOWLAxioms.addAll(axioms);
    }

    private void generateOWLClassDeclarationAxiom(@NonNull OWLClass cls) {
        if (!this.classDeclarationAxioms.containsKey(cls.getIRI())) {
            OWLDeclarationAxiom axiom = this.getSWRLAPIOWLDataFactory().getOWLClassDeclarationAxiom(cls);
            this.classDeclarationAxioms.put(cls.getIRI(), axiom);
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void generateOWLClassDeclarationAxiomIfNecessary(@NonNull OWLClassExpression classExpression) {
        if (classExpression instanceof OWLClass) {
            OWLClass cls = (OWLClass)classExpression;
            this.generateOWLClassDeclarationAxiom(cls);
        }
    }

    private void generateOWLIndividualDeclarationAxiomIfNecessary(@NonNull OWLIndividual individual) {
        if (individual.isNamed() && !this.individualDeclarationAxioms.containsKey(individual.asOWLNamedIndividual().getIRI())) {
            OWLDeclarationAxiom axiom = this.getSWRLAPIOWLDataFactory().getOWLIndividualDeclarationAxiom(individual.asOWLNamedIndividual());
            this.individualDeclarationAxioms.put(individual.asOWLNamedIndividual().getIRI(), axiom);
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void generateOWLObjectPropertyDeclarationAxiomIfNecessary(@NonNull OWLObjectPropertyExpression propertyExpression) {
        OWLObjectProperty property;
        if (propertyExpression instanceof OWLObjectProperty && !this.objectPropertyDeclarationAxioms.containsKey((property = (OWLObjectProperty)propertyExpression).getIRI())) {
            OWLDeclarationAxiom axiom = this.getSWRLAPIOWLDataFactory().getOWLObjectPropertyDeclarationAxiom(property);
            this.objectPropertyDeclarationAxioms.put(property.getIRI(), axiom);
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private void generateOWLDataPropertyDeclarationAxiomIfNecessary(@NonNull OWLDataPropertyExpression propertyExpression) {
        OWLDataProperty property;
        if (propertyExpression instanceof OWLDataProperty && !this.dataPropertyDeclarationAxioms.containsKey((property = (OWLDataProperty)propertyExpression).getIRI())) {
            OWLDeclarationAxiom axiom = this.getSWRLAPIOWLDataFactory().getOWLDataPropertyDeclarationAxiom(property);
            this.dataPropertyDeclarationAxioms.put(property.getIRI(), axiom);
            this.assertedOWLAxioms.add((OWLAxiom)axiom);
        }
    }

    private @NonNull Set<@NonNull OWLSameIndividualAxiom> getOWLSameIndividualAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.SAME_INDIVIDUAL, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDifferentIndividualsAxiom> getOWLDifferentIndividualsAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DIFFERENT_INDIVIDUALS, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLSubObjectPropertyOfAxiom> getOWLSubObjectPropertyOfAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.SUB_OBJECT_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLSubDataPropertyOfAxiom> getOWLSubDataPropertyOfAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.SUB_DATA_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLEquivalentClassesAxiom> getOWLEquivalentClassesAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.EQUIVALENT_CLASSES, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLClassAssertionAxiom> getOWLClassAssertionAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.CLASS_ASSERTION, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLObjectPropertyAssertionAxiom> getOWLObjectPropertyAssertionAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDataPropertyAssertionAxiom> getOWLDataPropertyAssertionAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DATA_PROPERTY_ASSERTION, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLSubClassOfAxiom> getOWLSubClassOfAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.SUBCLASS_OF, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDisjointClassesAxiom> getOWLDisjointClassesAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DISJOINT_CLASSES, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLEquivalentDataPropertiesAxiom> getOWLEquivalentDataPropertiesAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.EQUIVALENT_DATA_PROPERTIES, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLEquivalentObjectPropertiesAxiom> getOWLEquivalentObjectPropertiesAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDisjointDataPropertiesAxiom> getOWLDisjointDataPropertiesAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDisjointObjectPropertiesAxiom> getOWLDisjointObjectPropertiesAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLObjectPropertyDomainAxiom> getOWLObjectPropertyDomainAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.OBJECT_PROPERTY_DOMAIN, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDataPropertyDomainAxiom> getOWLDataPropertyDomainAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DATA_PROPERTY_DOMAIN, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLObjectPropertyRangeAxiom> getOWLObjectPropertyRangeAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.OBJECT_PROPERTY_RANGE, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDataPropertyRangeAxiom> getOWLDataPropertyRangeAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DATA_PROPERTY_RANGE, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLFunctionalObjectPropertyAxiom> getOWLFunctionalObjectPropertyAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLFunctionalDataPropertyAxiom> getOWLFunctionalDataPropertyAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.FUNCTIONAL_DATA_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLIrreflexiveObjectPropertyAxiom> getOWLIrreflexiveObjectPropertyAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLInverseFunctionalObjectPropertyAxiom> getOWLInverseFunctionalObjectPropertyAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLTransitiveObjectPropertyAxiom> getOWLTransitiveObjectPropertyAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.TRANSITIVE_OBJECT_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLSymmetricObjectPropertyAxiom> getOWLSymmetricObjectPropertyAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.SYMMETRIC_OBJECT_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLAsymmetricObjectPropertyAxiom> getOWLAsymmetricObjectPropertyAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLInverseObjectPropertiesAxiom> getOWLInverseObjectPropertiesAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.INVERSE_OBJECT_PROPERTIES, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLNegativeDataPropertyAssertionAxiom> getOWLNegativeDataPropertyAssertionAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLNegativeObjectPropertyAssertionAxiom> getOWLNegativeObjectPropertyAssertionAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLReflexiveObjectPropertyAxiom> getOWLReflexiveObjectPropertyAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.REFLEXIVE_OBJECT_PROPERTY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDisjointUnionAxiom> getOWLDisjointUnionAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DISJOINT_UNION, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLAnnotationAssertionAxiom> getOWLAnnotationAssertionAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.ANNOTATION_ASSERTION, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLSubPropertyChainOfAxiom> getOWLSubPropertyChainOfAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLHasKeyAxiom> getOWLHasKeyAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.HAS_KEY, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDatatypeDefinitionAxiom> getOWLDatatypeDefinitionAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DATATYPE_DEFINITION, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLAnnotationPropertyRangeAxiom> getOWLAnnotationPropertyRangeAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.ANNOTATION_PROPERTY_RANGE, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLAnnotationPropertyDomainAxiom> getOWLAnnotationPropertyDomainAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLSubAnnotationPropertyOfAxiom> getOWLSubAnnotationPropertyOfAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF, Imports.INCLUDED);
    }

    private @NonNull Set<@NonNull OWLDeclarationAxiom> getOWLClassDeclarationAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(owlDeclarationAxiom -> owlDeclarationAxiom.getEntity().isOWLClass()).collect(Collectors.toSet());
    }

    private @NonNull Set<@NonNull OWLDeclarationAxiom> getOWLIndividualDeclarationAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(owlDeclarationAxiom -> owlDeclarationAxiom.getEntity().isOWLNamedIndividual()).collect(Collectors.toSet());
    }

    private @NonNull Set<@NonNull OWLDeclarationAxiom> getOWLObjectPropertyDeclarationAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(owlDeclarationAxiom -> owlDeclarationAxiom.getEntity().isOWLObjectProperty()).collect(Collectors.toSet());
    }

    private @NonNull Set<@NonNull OWLDeclarationAxiom> getOWLDataPropertyDeclarationAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(owlDeclarationAxiom -> owlDeclarationAxiom.getEntity().isOWLDataProperty()).collect(Collectors.toSet());
    }

    private @NonNull Set<@NonNull OWLDeclarationAxiom> getOWLAnnotationPropertyDeclarationAxioms() {
        return this.getOWLOntology().getAxioms(AxiomType.DECLARATION, Imports.INCLUDED).stream().filter(owlDeclarationAxiom -> owlDeclarationAxiom.getEntity().isOWLAnnotationProperty()).collect(Collectors.toSet());
    }

    public void ontologiesChanged(@Nonnull List<? extends OWLOntologyChange> list) throws OWLException {
        this.hasOntologyChanged = true;
        if (!this.eventFreezeMode) {
            try {
                this.processOntology();
            }
            catch (SWRLBuiltInException e) {
                String message = "error processing SQWRL queries in ontology: " + e.getMessage();
                throw new OWLException(message);
            }
        }
    }

    private void notifyRegisteredRuleEngineModels() {
        for (SWRLRuleEngineModel swrlRuleEngineModel : this.swrlRuleEngineModels) {
            swrlRuleEngineModel.updateModel();
        }
    }

    private static void addSWRLAPIOntologies(@NonNull OWLOntology ontology) {
        ArrayList<SimpleIRIMapper> iriMappers = new ArrayList<SimpleIRIMapper>();
        iriMappers.add(new SimpleIRIMapper(IRI.create((String)"http://www.w3.org/2003/11/swrl#"), DefaultSWRLAPIOWLOntology.resourcePath2IRI("owl/swrl.owl")));
        iriMappers.add(new SimpleIRIMapper(IRI.create((String)"http://www.w3.org/2003/11/swrlb#"), DefaultSWRLAPIOWLOntology.resourcePath2IRI("owl/swrlb.owl")));
        iriMappers.add(new SimpleIRIMapper(IRI.create((String)"http://swrl.stanford.edu/ontologies/3.3/swrla.owl"), DefaultSWRLAPIOWLOntology.resourcePath2IRI("owl/swrla.owl")));
        iriMappers.add(new SimpleIRIMapper(IRI.create((String)"http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlm.owl"), DefaultSWRLAPIOWLOntology.resourcePath2IRI("owl/swrlm.owl")));
        iriMappers.add(new SimpleIRIMapper(IRI.create((String)"http://swrl.stanford.edu/ontologies/built-ins/3.3/swrlx.owl"), DefaultSWRLAPIOWLOntology.resourcePath2IRI("owl/swrlx.owl")));
        iriMappers.add(new SimpleIRIMapper(IRI.create((String)"http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl"), DefaultSWRLAPIOWLOntology.resourcePath2IRI("owl/temporal.owl")));
        iriMappers.add(new SimpleIRIMapper(IRI.create((String)"http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl"), DefaultSWRLAPIOWLOntology.resourcePath2IRI("owl/sqwrl.owl")));
        for (SimpleIRIMapper iriMapper : iriMappers) {
            ontology.getOWLOntologyManager().getIRIMappers().add((Serializable)iriMapper);
        }
    }

    private static @NonNull IRI resourcePath2IRI(@NonNull String resourceName) {
        ClassLoader classLoader = DefaultSWRLAPIOWLOntology.class.getClassLoader();
        if (classLoader == null) {
            throw new SWRLAPIException("Could not loadExternalSWRLBuiltInLibraries class loader");
        }
        URL url = classLoader.getResource(resourceName);
        if (url == null) {
            throw new SWRLAPIException("Could not loadExternalSWRLBuiltInLibraries local resource " + resourceName);
        }
        return IRI.create((URL)url);
    }
}

