/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.core.SWRLAPIBuiltInAtom;
import org.swrlapi.core.SWRLAPIRule;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.sqwrl.SQWRLNames;
import uk.ac.manchester.cs.owl.owlapi.SWRLRuleImpl;

public class DefaultSWRLAPIRule
extends SWRLRuleImpl
implements SWRLAPIRule {
    private static final long serialVersionUID = 1L;
    private final @NonNull String ruleName;
    private final @NonNull String comment;
    private final @NonNull List<@NonNull SWRLAtom> bodyAtoms;
    private final @NonNull List<@NonNull SWRLAtom> headAtoms;
    private @NonNull boolean active;

    public DefaultSWRLAPIRule(@NonNull String ruleName, @NonNull List<? extends @NonNull SWRLAtom> bodyAtoms, @NonNull List<? extends @NonNull SWRLAtom> headAtoms, @NonNull String comment, boolean isActive) throws SWRLBuiltInException {
        super(new LinkedHashSet<SWRLAtom>(bodyAtoms), new LinkedHashSet<SWRLAtom>(headAtoms), new HashSet());
        this.ruleName = ruleName;
        this.active = isActive;
        this.comment = comment;
        this.bodyAtoms = DefaultSWRLAPIRule.processBuiltInArguments(bodyAtoms);
        this.headAtoms = new ArrayList<SWRLAtom>(headAtoms);
    }

    @Override
    public @NonNull String getRuleName() {
        return this.ruleName;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isSQWRLQuery() {
        return !this.getBuiltInAtomsFromHead(SQWRLNames.getSQWRLBuiltInNames()).isEmpty() || !this.getBuiltInAtomsFromBody(SQWRLNames.getSQWRLBuiltInNames()).isEmpty();
    }

    @Override
    public @NonNull String getComment() {
        return this.comment;
    }

    @Override
    public @NonNull List<@NonNull SWRLAtom> getHeadAtoms() {
        return this.headAtoms;
    }

    @Override
    public @NonNull List<@NonNull SWRLAtom> getBodyAtoms() {
        return this.bodyAtoms;
    }

    @Override
    public @NonNull List<@NonNull SWRLAPIBuiltInAtom> getBuiltInAtomsFromHead(@NonNull Set<@NonNull String> builtInNames) {
        return this.getBuiltInAtoms(this.getHeadAtoms(), builtInNames);
    }

    @Override
    public @NonNull List<@NonNull SWRLAPIBuiltInAtom> getBuiltInAtomsFromBody(@NonNull Set<@NonNull String> builtInNames) {
        return this.getBuiltInAtoms(this.getBodyAtoms(), builtInNames);
    }

    private static List<@NonNull SWRLAtom> processBuiltInArguments(List<? extends @NonNull SWRLAtom> bodyAtoms) throws SWRLBuiltInException {
        ArrayList<@NonNull SWRLAPIBuiltInAtom> bodyBuiltInAtoms = new ArrayList<SWRLAPIBuiltInAtom>();
        ArrayList<@NonNull SWRLAtom> bodyNonBuiltInAtoms = new ArrayList<SWRLAtom>();
        HashSet<@NonNull IRI> variablesUsedByNonBuiltInBodyAtoms = new HashSet<IRI>();
        HashSet<@NonNull IRI> variablesBoundByBuiltIns = new HashSet<IRI>();
        for (SWRLAtom sWRLAtom : bodyAtoms) {
            if (sWRLAtom instanceof SWRLAPIBuiltInAtom) {
                bodyBuiltInAtoms.add((SWRLAPIBuiltInAtom)sWRLAtom);
                continue;
            }
            bodyNonBuiltInAtoms.add(sWRLAtom);
            variablesUsedByNonBuiltInBodyAtoms.addAll(DefaultSWRLAPIRule.getReferencedVariableIRIs(sWRLAtom));
        }
        for (SWRLAPIBuiltInAtom sWRLAPIBuiltInAtom : bodyBuiltInAtoms) {
            for (SWRLBuiltInArgument argument : sWRLAPIBuiltInAtom.getBuiltInArguments()) {
                IRI argumentVariableIRI;
                if (!argument.isVariable() || variablesUsedByNonBuiltInBodyAtoms.contains(argumentVariableIRI = argument.asVariable().getIRI()) || variablesBoundByBuiltIns.contains(argumentVariableIRI)) continue;
                argument.asVariable().setUnbound();
                variablesBoundByBuiltIns.add(argumentVariableIRI);
            }
        }
        List<@NonNull SWRLAtom> finalBodyAtoms = DefaultSWRLAPIRule.reorganizeBodyNonBuiltInAtoms(bodyNonBuiltInAtoms);
        ArrayList<@NonNull SWRLAtom> processedBodyAtoms = new ArrayList<SWRLAtom>(finalBodyAtoms);
        processedBodyAtoms.addAll(bodyBuiltInAtoms);
        return processedBodyAtoms;
    }

    private static @NonNull List<@NonNull SWRLAtom> reorganizeBodyNonBuiltInAtoms(@NonNull List<@NonNull SWRLAtom> bodyNonBuiltInAtoms) {
        ArrayList<@NonNull SWRLAtom> bodyClassAtoms = new ArrayList<SWRLAtom>();
        ArrayList<@NonNull SWRLAtom> bodyNonClassNonBuiltInAtoms = new ArrayList<SWRLAtom>();
        ArrayList<@NonNull SWRLAtom> result = new ArrayList<SWRLAtom>();
        for (SWRLAtom atom : bodyNonBuiltInAtoms) {
            if (atom instanceof SWRLClassAtom) {
                bodyClassAtoms.add(atom);
                continue;
            }
            bodyNonClassNonBuiltInAtoms.add(atom);
        }
        result.addAll(bodyClassAtoms);
        result.addAll(bodyNonClassNonBuiltInAtoms);
        return result;
    }

    private @NonNull List<@NonNull SWRLAPIBuiltInAtom> getBuiltInAtoms(@NonNull List<@NonNull SWRLAtom> atoms, @NonNull Set<@NonNull String> builtInNames) {
        ArrayList<@NonNull SWRLAPIBuiltInAtom> result = new ArrayList<SWRLAPIBuiltInAtom>();
        for (SWRLAtom atom : atoms) {
            SWRLAPIBuiltInAtom builtInAtom;
            if (!(atom instanceof SWRLBuiltInAtom) || !builtInNames.contains((builtInAtom = (SWRLAPIBuiltInAtom)atom).getBuiltInPrefixedName())) continue;
            result.add(builtInAtom);
        }
        return result;
    }

    private static @NonNull Set<@NonNull IRI> getReferencedVariableIRIs(@NonNull SWRLAtom atom) {
        HashSet<@NonNull IRI> referencedVariableIRIs = new HashSet<IRI>();
        for (SWRLArgument argument : atom.getAllArguments()) {
            if (!(argument instanceof SWRLVariable)) continue;
            SWRLVariable variable = (SWRLVariable)argument;
            referencedVariableIRIs.add(variable.getIRI());
        }
        return referencedVariableIRIs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultSWRLAPIRule that = (DefaultSWRLAPIRule)o;
        if (this.active != that.active) {
            return false;
        }
        if (!Objects.equals(this.ruleName, that.ruleName)) {
            return false;
        }
        if (!Objects.equals(this.comment, that.comment)) {
            return false;
        }
        if (!Objects.equals(this.bodyAtoms, that.bodyAtoms)) {
            return false;
        }
        return Objects.equals(this.headAtoms, that.headAtoms);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 31 * result + (this.bodyAtoms != null ? this.bodyAtoms.hashCode() : 0);
        result = 31 * result + (this.headAtoms != null ? this.headAtoms.hashCode() : 0);
        return result;
    }
}

