/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLAPIOWLOntology;
import org.swrlapi.ui.model.SWRLAutoCompleter;

class DefaultSWRLAutoCompleter
implements SWRLAutoCompleter {
    private static final Logger log = LoggerFactory.getLogger(DefaultSWRLAutoCompleter.class);
    private final @NonNull List<@NonNull String> renderings;

    public DefaultSWRLAutoCompleter(@NonNull SWRLAPIOWLOntology swrlapiowlOntology) {
        String prefixedName;
        IRIResolver iriResolver = swrlapiowlOntology.getIRIResolver();
        this.renderings = new ArrayList<String>();
        for (OWLEntity owlEntity : swrlapiowlOntology.getOWLOntology().getSignature(Imports.INCLUDED)) {
            Optional<@NonNull String> shortForm = iriResolver.iri2ShortForm(owlEntity.getIRI());
            if (!shortForm.isPresent()) continue;
            if (shortForm.get().startsWith(":")) {
                this.renderings.add(shortForm.get().substring(1));
            }
            this.renderings.add(shortForm.get());
        }
        for (IRI swrlBuiltInIRI : swrlapiowlOntology.getSWRLBuiltInIRIs()) {
            Optional<@NonNull String> prefixedName2 = iriResolver.iri2PrefixedName(swrlBuiltInIRI);
            if (!prefixedName2.isPresent()) continue;
            if (prefixedName2.get().startsWith(":")) {
                this.renderings.add(prefixedName2.get().substring(1));
            }
            this.renderings.add(prefixedName2.get());
        }
        for (Iterator<Object> iterator : OWLRDFVocabulary.values()) {
            prefixedName = iterator.getPrefixedName();
            if (prefixedName == null) continue;
            this.renderings.add(prefixedName);
        }
        for (Iterator<Object> iterator : XSDVocabulary.values()) {
            prefixedName = iterator.getPrefixedName();
            if (prefixedName == null) continue;
            this.renderings.add(prefixedName);
        }
        this.renderings.add("sameAs");
        this.renderings.add("differentFrom");
        this.renderings.add("and");
        this.renderings.add("or");
        this.renderings.add("not");
        Collections.sort(this.renderings);
    }

    @Override
    public @NonNull List<@NonNull String> getCompletions(@NonNull String prefix) {
        ArrayList<@NonNull String> completions = new ArrayList<String>();
        for (String rendering : this.renderings) {
            if (!rendering.startsWith(prefix)) continue;
            completions.add(rendering);
        }
        return completions;
    }
}

