/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.swrlapi.bridge.SWRLBridge;
import org.swrlapi.bridge.TargetSWRLRuleEngine;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLAPIOWLOntology;
import org.swrlapi.exceptions.SWRLBuiltInBridgeException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLRuleEngineBridgeException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineException;
import org.swrlapi.factory.OWLDatatypeFactory;
import org.swrlapi.factory.OWLLiteralFactory;
import org.swrlapi.factory.SWRLAPIOWLDataFactory;
import org.swrlapi.factory.SWRLBuiltInArgumentFactory;
import org.swrlapi.owl2rl.OWL2RLPersistenceLayer;
import org.swrlapi.sqwrl.SQWRLResult;
import org.swrlapi.sqwrl.SQWRLResultGenerator;
import org.swrlapi.sqwrl.exceptions.SQWRLException;

public class DefaultSWRLBridge
implements SWRLBridge {
    private final @NonNull SWRLAPIOWLOntology swrlapiOWLOntology;
    private final @NonNull OWL2RLPersistenceLayer owl2RLPersistenceLayer;
    private final @NonNull Set<@NonNull OWLAxiom> inferredOWLAxioms;
    private final @NonNull Set<@NonNull OWLAxiom> injectedOWLAxioms;
    private @MonotonicNonNull TargetSWRLRuleEngine targetSWRLRuleEngine;

    public DefaultSWRLBridge(@NonNull SWRLAPIOWLOntology swrlapiOWLOntology, @NonNull OWL2RLPersistenceLayer owl2RLPersistenceLayer) throws SWRLBuiltInBridgeException {
        this.swrlapiOWLOntology = swrlapiOWLOntology;
        this.owl2RLPersistenceLayer = owl2RLPersistenceLayer;
        this.inferredOWLAxioms = new HashSet<OWLAxiom>();
        this.injectedOWLAxioms = new HashSet<OWLAxiom>();
        this.swrlapiOWLOntology.getSWRLBuiltInLibraryManager().invokeAllBuiltInLibrariesResetMethod(this);
    }

    @Override
    public void setTargetSWRLRuleEngine(@NonNull TargetSWRLRuleEngine targetSWRLRuleEngine) {
        this.targetSWRLRuleEngine = targetSWRLRuleEngine;
    }

    @Override
    public void reset() throws SWRLBuiltInBridgeException {
        this.inferredOWLAxioms.clear();
        this.injectedOWLAxioms.clear();
        this.swrlapiOWLOntology.getSWRLBuiltInLibraryManager().invokeAllBuiltInLibrariesResetMethod(this);
    }

    @Override
    public boolean hasOntologyChanged() {
        return this.swrlapiOWLOntology.hasOntologyChanged();
    }

    @Override
    public void injectOWLAxiom(@NonNull OWLAxiom axiom) throws SWRLBuiltInBridgeException {
        if (!this.injectedOWLAxioms.contains(axiom)) {
            this.injectedOWLAxioms.add(axiom);
            this.exportOWLAxiom(axiom);
        }
    }

    @Override
    public @NonNull IRIResolver getIRIResolver() {
        return this.swrlapiOWLOntology.getIRIResolver();
    }

    @Override
    public @NonNull OWL2RLPersistenceLayer getOWL2RLPersistenceLayer() {
        return this.owl2RLPersistenceLayer;
    }

    @Override
    public @NonNull Set<@NonNull OWLAxiom> getInjectedOWLAxioms() {
        return Collections.unmodifiableSet(this.injectedOWLAxioms);
    }

    @Override
    public int getNumberOfInjectedOWLAxioms() {
        return this.injectedOWLAxioms.size();
    }

    @Override
    public boolean isInjectedOWLAxiom(@NonNull OWLAxiom axiom) {
        return this.injectedOWLAxioms.contains(axiom);
    }

    @Override
    public @NonNull Set<@NonNull OWLAxiom> getInferredOWLAxioms() {
        return this.inferredOWLAxioms;
    }

    @Override
    public int getNumberOfInferredOWLAxioms() {
        return this.inferredOWLAxioms.size();
    }

    @Override
    public void inferOWLAxiom(@NonNull OWLAxiom axiom) throws SWRLRuleEngineBridgeException {
        if (!this.inferredOWLAxioms.contains(axiom) && !this.swrlapiOWLOntology.hasAssertedOWLAxiom(axiom)) {
            this.inferredOWLAxioms.add(axiom);
        }
    }

    @Override
    public @NonNull List<@NonNull List<@NonNull SWRLBuiltInArgument>> invokeSWRLBuiltIn(@NonNull String ruleName, @NonNull String builtInName, int builtInIndex, boolean isInConsequent, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) throws SWRLBuiltInException {
        return this.swrlapiOWLOntology.getSWRLBuiltInLibraryManager().invokeSWRLBuiltIn(this, ruleName, builtInName, builtInIndex, isInConsequent, arguments);
    }

    public boolean isOWLClass(@NonNull IRI iri) {
        return this.getOWLOntology().containsClassInSignature(iri, Imports.INCLUDED) || iri.equals((Object)OWLRDFVocabulary.OWL_THING.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_NOTHING.getIRI());
    }

    public boolean isOWLObjectProperty(@NonNull IRI propertyIRI) {
        return this.getOWLOntology().containsObjectPropertyInSignature(propertyIRI, Imports.INCLUDED);
    }

    public boolean isOWLDataProperty(@NonNull IRI propertyIRI) {
        return this.getOWLOntology().containsDataPropertyInSignature(propertyIRI, Imports.INCLUDED);
    }

    public boolean isOWLNamedIndividual(@NonNull IRI individualIRI) {
        return this.getOWLOntology().containsIndividualInSignature(individualIRI, Imports.INCLUDED);
    }

    public @NonNull SQWRLResult getSQWRLResult(@NonNull String queryName) throws SQWRLException {
        return this.swrlapiOWLOntology.getSQWRLResult(queryName);
    }

    @Override
    public @NonNull SQWRLResultGenerator getSQWRLResultGenerator(@NonNull String queryName) throws SQWRLException {
        return this.swrlapiOWLOntology.getSQWRLResultGenerator(queryName);
    }

    private void exportOWLAxiom(@NonNull OWLAxiom axiom) throws SWRLBuiltInBridgeException {
        try {
            if (this.targetSWRLRuleEngine != null) {
                this.targetSWRLRuleEngine.defineOWLAxiom(axiom);
            }
        }
        catch (TargetSWRLRuleEngineException e) {
            throw new SWRLBuiltInBridgeException("error exporting OWL axiom " + axiom + " to target rule engine: " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    @Override
    public @NonNull OWLOntology getOWLOntology() {
        return this.swrlapiOWLOntology.getOWLOntology();
    }

    @Override
    public @NonNull OWLLiteralFactory getOWLLiteralFactory() {
        return this.getSWRLAPIOWLDataFactory().getOWLLiteralFactory();
    }

    @Override
    public @NonNull OWLDatatypeFactory getOWLDatatypeFactory() {
        return this.getSWRLAPIOWLDataFactory().getOWLDatatypeFactory();
    }

    @Override
    public @NonNull SWRLBuiltInArgumentFactory getSWRLBuiltInArgumentFactory() {
        return this.getSWRLAPIOWLDataFactory().getSWRLBuiltInArgumentFactory();
    }

    @Override
    public @NonNull SWRLAPIOWLDataFactory getSWRLAPIOWLDataFactory() {
        return this.swrlapiOWLOntology.getSWRLAPIOWLDataFactory();
    }
}

