/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.swrlapi.builtins.arguments.SQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.factory.DefaultSQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLClassBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLClassExpressionBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLDataPropertyBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLDataPropertyExpressionBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLDatatypeBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLLiteralBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLNamedIndividualBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLObjectPropertyBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLObjectPropertyExpressionBuiltInArgument;
import org.swrlapi.factory.DefaultSWRLVariableBuiltInArgument;
import org.swrlapi.factory.OWLLiteralFactory;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.factory.SWRLBuiltInArgumentFactory;
import org.swrlapi.literal.XSDDate;
import org.swrlapi.literal.XSDDateTime;
import org.swrlapi.literal.XSDDuration;
import org.swrlapi.literal.XSDTime;

class DefaultSWRLBuiltInArgumentFactory
implements SWRLBuiltInArgumentFactory {
    private final @NonNull IRIResolver iriResolver;
    private final @NonNull OWLLiteralFactory owlLiteralFactory;

    public DefaultSWRLBuiltInArgumentFactory(@NonNull IRIResolver iriResolver) {
        this.iriResolver = iriResolver;
        this.owlLiteralFactory = SWRLAPIInternalFactory.createOWLLiteralFactory();
    }

    @Override
    public @NonNull SWRLVariableBuiltInArgument getUnboundVariableBuiltInArgument(@NonNull IRI variableIRI) {
        DefaultSWRLVariableBuiltInArgument argument = new DefaultSWRLVariableBuiltInArgument(variableIRI);
        argument.setUnbound();
        return argument;
    }

    @Override
    public @NonNull SWRLVariableBuiltInArgument getVariableBuiltInArgument(@NonNull IRI variableIRI) {
        return new DefaultSWRLVariableBuiltInArgument(variableIRI);
    }

    @Override
    public @NonNull SWRLClassBuiltInArgument getClassBuiltInArgument(OWLClass cls) {
        return new DefaultSWRLClassBuiltInArgument(cls);
    }

    @Override
    public @NonNull SWRLClassExpressionBuiltInArgument getClassExpressionBuiltInArgument(OWLClassExpression ce) {
        if (ce.isAnonymous()) {
            return new DefaultSWRLClassExpressionBuiltInArgument(ce);
        }
        return new DefaultSWRLClassBuiltInArgument(ce.asOWLClass());
    }

    @Override
    public @NonNull SWRLObjectPropertyBuiltInArgument getObjectPropertyBuiltInArgument(@NonNull OWLObjectProperty property) {
        return new DefaultSWRLObjectPropertyBuiltInArgument(property);
    }

    @Override
    public @NonNull SWRLObjectPropertyExpressionBuiltInArgument getObjectPropertyExpressionBuiltInArgument(@NonNull OWLObjectPropertyExpression propertyExpression) {
        if (propertyExpression.isAnonymous()) {
            return new DefaultSWRLObjectPropertyExpressionBuiltInArgument(propertyExpression);
        }
        return new DefaultSWRLObjectPropertyBuiltInArgument(propertyExpression.asOWLObjectProperty());
    }

    @Override
    public @NonNull SWRLDataPropertyBuiltInArgument getDataPropertyBuiltInArgument(@NonNull OWLDataProperty property) {
        return new DefaultSWRLDataPropertyBuiltInArgument(property);
    }

    @Override
    public @NonNull SWRLDataPropertyExpressionBuiltInArgument getDataPropertyExpressionBuiltInArgument(@NonNull OWLDataPropertyExpression propertyExpression) {
        if (propertyExpression.isAnonymous()) {
            return new DefaultSWRLDataPropertyExpressionBuiltInArgument(propertyExpression);
        }
        return new DefaultSWRLDataPropertyBuiltInArgument(propertyExpression.asOWLDataProperty());
    }

    @Override
    public @NonNull SWRLAnnotationPropertyBuiltInArgument getAnnotationPropertyBuiltInArgument(@NonNull OWLAnnotationProperty property) {
        return new DefaultSWRLAnnotationPropertyBuiltInArgument(property);
    }

    @Override
    public @NonNull SWRLDatatypeBuiltInArgument getDatatypeBuiltInArgument(@NonNull OWLDatatype datatype) {
        return new DefaultSWRLDatatypeBuiltInArgument(datatype);
    }

    @Override
    public @NonNull SWRLNamedIndividualBuiltInArgument getNamedIndividualBuiltInArgument(@NonNull OWLNamedIndividual individual) {
        return new DefaultSWRLNamedIndividualBuiltInArgument(individual);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(@NonNull OWLLiteral literal) {
        return new DefaultSWRLLiteralBuiltInArgument(literal);
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(@NonNull String s) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(s));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(boolean b) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(b));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(short s) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(s));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(byte b) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(b));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(int i) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(i));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(long l) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(l));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(float f) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(f));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(double d) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(d));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(@NonNull BigDecimal d) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(d));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(@NonNull BigInteger i) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(i));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(@NonNull URI uri) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(uri));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(@NonNull XSDDate date) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(date));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(@NonNull XSDTime time) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(time));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(@NonNull XSDDateTime datetime) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(datetime));
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument getLiteralBuiltInArgument(@NonNull XSDDuration duration) {
        return new DefaultSWRLLiteralBuiltInArgument(this.getOWLLiteralFactory().getOWLLiteral(duration));
    }

    @Override
    public @NonNull SWRLMultiValueVariableBuiltInArgument getMultiValueVariableBuiltInArgument(@NonNull IRI variableIRI) {
        return new DefaultSWRLMultiValueVariableBuiltInArgument(variableIRI);
    }

    @Override
    public @NonNull SWRLMultiValueVariableBuiltInArgument getMultiValueVariableBuiltInArgument(@NonNull IRI variableIRI, List<@NonNull SWRLBuiltInArgument> arguments) {
        return new DefaultSWRLMultiValueVariableBuiltInArgument(variableIRI, arguments);
    }

    @Override
    public @NonNull SQWRLCollectionVariableBuiltInArgument getSQWRLCollectionVariableBuiltInArgument(@NonNull IRI variableIRI, @NonNull String queryName, @NonNull String collectionName, @NonNull String collectionGroupID) {
        return new DefaultSQWRLCollectionVariableBuiltInArgument(variableIRI, queryName, collectionName, collectionGroupID);
    }

    private @NonNull OWLLiteralFactory getOWLLiteralFactory() {
        return this.owlLiteralFactory;
    }

    private @NonNull String iri2PrefixedName(IRI iri) {
        Optional<@NonNull String> prefixedName = this.iriResolver.iri2PrefixedName(iri);
        if (prefixedName.isPresent()) {
            return prefixedName.get();
        }
        throw new IllegalArgumentException("could not get prefixed name for IRI " + iri);
    }
}

