/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentType;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentVisitor;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentVisitorEx;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.factory.DefaultSWRLBuiltInArgument;
import org.swrlapi.literal.OWLLiteralComparator;

class DefaultSWRLLiteralBuiltInArgument
extends DefaultSWRLBuiltInArgument
implements SWRLLiteralBuiltInArgument {
    private static final long serialVersionUID = 1L;
    private static final @NonNull Comparator<OWLLiteral> owlLiteralComparator = OWLLiteralComparator.COMPARATOR;
    private final @NonNull OWLLiteral literal;

    public DefaultSWRLLiteralBuiltInArgument(@NonNull OWLLiteral literal) {
        this.literal = literal;
    }

    @Override
    public @NonNull SWRLBuiltInArgumentType<?> getSWRLBuiltInArgumentType() {
        return SWRLBuiltInArgumentType.LITERAL;
    }

    public @NonNull OWLLiteral getLiteral() {
        return this.literal;
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument asSWRLLiteralBuiltInArgument() throws SWRLBuiltInException {
        return this;
    }

    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSWRLLiteralBuiltInArgument that = (DefaultSWRLLiteralBuiltInArgument)o;
        return this.literal.equals(that.literal);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        return this.literal.hashCode();
    }

    @Override
    @SideEffectFree
    @Deterministic
    public int compareTo(@NonNull OWLObject o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof SWRLLiteralBuiltInArgument)) {
            return -1;
        }
        SWRLLiteralBuiltInArgument other = (SWRLLiteralBuiltInArgument)o;
        return owlLiteralComparator.compare(this.getLiteral(), other.getLiteral());
    }

    @Override
    public void accept(@NonNull SWRLObjectVisitor visitor) {
        visitor.visit((SWRLLiteralArgument)this);
    }

    @Override
    public <O> @NonNull O accept(@NonNull SWRLObjectVisitorEx<@NonNull O> visitor) {
        return (O)visitor.visit((SWRLLiteralArgument)this);
    }

    @Override
    public void accept(@NonNull OWLObjectVisitor visitor) {
        visitor.visit((SWRLLiteralArgument)this);
    }

    @Override
    public <O> @NonNull O accept(@NonNull OWLObjectVisitorEx<@NonNull O> visitor) {
        return (O)visitor.visit((SWRLLiteralArgument)this);
    }

    @Override
    public <T> @NonNull T accept(@NonNull SWRLBuiltInArgumentVisitorEx<@NonNull T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(@NonNull SWRLBuiltInArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @SideEffectFree
    public @NonNull String toString() {
        return this.literal.getLiteral();
    }

    @Override
    public @NonNull Set<@NonNull OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return Collections.emptySet();
    }
}

