/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.swrlapi.bridge.SWRLRuleEngineBridgeController;
import org.swrlapi.bridge.TargetSWRLRuleEngine;
import org.swrlapi.builtins.SWRLBuiltInBridgeController;
import org.swrlapi.core.SWRLAPIOWLOntology;
import org.swrlapi.core.SWRLAPIRule;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.core.SWRLRuleRenderer;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.exceptions.SWRLRuleEngineException;
import org.swrlapi.exceptions.SWRLRuleException;
import org.swrlapi.exceptions.TargetSWRLRuleEngineException;
import org.swrlapi.factory.OWLInferredAxiomFilter;
import org.swrlapi.owl2rl.OWL2RLEngine;
import org.swrlapi.parser.SWRLParseException;
import org.swrlapi.parser.SWRLParser;
import org.swrlapi.sqwrl.SQWRLQuery;
import org.swrlapi.sqwrl.SQWRLQueryEngine;
import org.swrlapi.sqwrl.SQWRLQueryRenderer;
import org.swrlapi.sqwrl.SQWRLResult;
import org.swrlapi.sqwrl.exceptions.SQWRLException;
import org.swrlapi.ui.model.SWRLAutoCompleter;

class DefaultSWRLRuleAndQueryEngine
implements SWRLRuleEngine,
SQWRLQueryEngine {
    private final @NonNull SWRLAPIOWLOntology swrlapiOWLOntology;
    private final @NonNull TargetSWRLRuleEngine targetSWRLRuleEngine;
    private final @NonNull SWRLBuiltInBridgeController builtInBridgeController;
    private final @NonNull SWRLRuleEngineBridgeController ruleEngineBridgeController;

    public DefaultSWRLRuleAndQueryEngine(@NonNull SWRLAPIOWLOntology swrlapiOWLOntology, @NonNull TargetSWRLRuleEngine targetSWRLRuleEngine, @NonNull SWRLRuleEngineBridgeController ruleEngineBridgeController, @NonNull SWRLBuiltInBridgeController builtInBridgeController) throws SWRLRuleEngineException {
        this.swrlapiOWLOntology = swrlapiOWLOntology;
        this.targetSWRLRuleEngine = targetSWRLRuleEngine;
        this.builtInBridgeController = builtInBridgeController;
        this.ruleEngineBridgeController = ruleEngineBridgeController;
    }

    @Override
    public void importAssertedOWLAxioms() throws SWRLRuleEngineException {
        this.reset();
        try {
            this.exportOWLAxioms2TargetRuleEngine(this.swrlapiOWLOntology.getOWLAxioms());
        }
        catch (SWRLAPIException e) {
            throw new SWRLRuleEngineException("error exporting knowledge to rule engine: " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    @Override
    public void importSQWRLQueryAndOWLAxioms(@NonNull String queryName) throws SWRLRuleEngineException, SWRLBuiltInException {
        this.reset();
        try {
            this.exportOWLAxioms2TargetRuleEngine(this.swrlapiOWLOntology.getOWLAxioms());
            this.exportSQWRLQuery2TargetRuleEngine(queryName);
        }
        catch (SWRLAPIException e) {
            throw new SWRLRuleEngineException("error exporting SQWRL query rule engine: " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    @Override
    public void run() throws SWRLRuleEngineException {
        this.getTargetSWRLRuleEngine().runRuleEngine();
    }

    @Override
    public void exportInferredOWLAxioms() throws SWRLRuleEngineException {
        try {
            this.getSWRLAPIOWLOntology().startEventFreezeMode();
            this.writeOWLAxioms2OWLOntology(this.builtInBridgeController.getInjectedOWLAxioms());
            this.writeOWLAxioms2OWLOntology(this.ruleEngineBridgeController.getInferredOWLAxioms());
        }
        finally {
            this.getSWRLAPIOWLOntology().finishEventFreezeMode();
        }
    }

    @Override
    public void infer() throws SWRLRuleEngineException {
        this.importAssertedOWLAxioms();
        this.run();
        this.exportInferredOWLAxioms();
    }

    @Override
    public @NonNull SQWRLResult runSQWRLQuery(@NonNull String queryName) throws SQWRLException {
        try {
            this.importSQWRLQueryAndOWLAxioms(queryName);
            this.run();
            return this.getSQWRLResult(queryName);
        }
        catch (SWRLAPIException | SWRLBuiltInException e) {
            throw new SQWRLException("error running SQWRL queries: " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    @Override
    public void runSQWRLQueries() throws SQWRLException {
        try {
            this.importAssertedOWLAxioms();
            this.exportSQWRLQueries2TargetRuleEngine();
        }
        catch (SWRLBuiltInException | SWRLRuleEngineException | TargetSWRLRuleEngineException e) {
            throw new SQWRLException("error processing SQWRL queries: " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
        try {
            this.run();
        }
        catch (SWRLAPIException e) {
            throw new SQWRLException("error running SQWRL queries: " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    @Override
    public SQWRLQuery createSQWRLQuery(@NonNull String queryName, @NonNull String queryText) throws SWRLParseException, SQWRLException {
        try {
            return this.swrlapiOWLOntology.createSQWRLQuery(queryName, queryText);
        }
        catch (RuntimeException | SWRLBuiltInException e) {
            throw new SQWRLException("error creating SQWRL query: " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    @Override
    public @NonNull SQWRLResult runSQWRLQuery(@NonNull String queryName, @NonNull String queryText) throws SWRLParseException, SQWRLException {
        this.createSQWRLQuery(queryName, queryText);
        return this.runSQWRLQuery(queryName);
    }

    @Override
    public @NonNull SQWRLResult getSQWRLResult(@NonNull String queryName) throws SQWRLException {
        return this.swrlapiOWLOntology.getSQWRLResult(queryName);
    }

    @Override
    public @NonNull Set<@NonNull SQWRLQuery> getSQWRLQueries() {
        return this.swrlapiOWLOntology.getSQWRLQueries();
    }

    @Override
    public @NonNull Set<@NonNull String> getSQWRLQueryNames() {
        return this.swrlapiOWLOntology.getSQWRLQueryNames();
    }

    @Override
    public @NonNull SQWRLQueryRenderer createSQWRLQueryRenderer() {
        return this.swrlapiOWLOntology.createSQWRLQueryRenderer();
    }

    @Override
    public @NonNull OWLOntology getOWLOntology() {
        return this.getSWRLAPIOWLOntology().getOWLOntology();
    }

    @Override
    public @NonNull OWL2RLEngine getOWL2RLEngine() {
        return this.targetSWRLRuleEngine.getOWL2RLEngine();
    }

    @Override
    public int getNumberOfImportedSWRLRules() {
        return this.swrlapiOWLOntology.getNumberOfSWRLRules();
    }

    @Override
    public int getNumberOfAssertedOWLClassDeclarationAxioms() {
        return this.swrlapiOWLOntology.getNumberOfOWLClassDeclarationAxioms();
    }

    @Override
    public int getNumberOfAssertedOWLIndividualDeclarationsAxioms() {
        return this.swrlapiOWLOntology.getNumberOfOWLIndividualDeclarationAxioms();
    }

    @Override
    public int getNumberOfAssertedOWLObjectPropertyDeclarationAxioms() {
        return this.swrlapiOWLOntology.getNumberOfOWLObjectPropertyDeclarationAxioms();
    }

    @Override
    public int getNumberOfAssertedOWLDataPropertyDeclarationAxioms() {
        return this.swrlapiOWLOntology.getNumberOfOWLDataPropertyDeclarationAxioms();
    }

    @Override
    public int getNumberOfAssertedOWLAxioms() {
        return this.swrlapiOWLOntology.getNumberOfOWLAxioms();
    }

    @Override
    public int getNumberOfInferredOWLAxioms() {
        return this.ruleEngineBridgeController.getNumberOfInferredOWLAxioms();
    }

    @Override
    public int getNumberOfInjectedOWLAxioms() {
        return this.builtInBridgeController.getNumberOfInjectedOWLAxioms();
    }

    public boolean isInjectedOWLAxiom(OWLAxiom axiom) {
        return this.builtInBridgeController.isInjectedOWLAxiom(axiom);
    }

    @Override
    public @NonNull Set<@NonNull SWRLAPIRule> getSWRLRules() {
        return this.swrlapiOWLOntology.getSWRLRules();
    }

    @Override
    public Optional<@NonNull SWRLAPIRule> getSWRLRule(@NonNull String ruleName) throws SWRLRuleException {
        return this.swrlapiOWLOntology.getSWRLRule(ruleName);
    }

    @Override
    public @NonNull SWRLAPIRule createSWRLRule(@NonNull String ruleName, @NonNull String rule) throws SWRLParseException, SWRLBuiltInException {
        return this.swrlapiOWLOntology.createSWRLRule(ruleName, rule);
    }

    @Override
    public @NonNull SWRLAPIRule createSWRLRule(@NonNull String ruleName, @NonNull String rule, @NonNull String comment, boolean isActive) throws SWRLParseException, SWRLBuiltInException {
        return this.swrlapiOWLOntology.createSWRLRule(ruleName, rule, comment, isActive);
    }

    @Override
    public void replaceSWRLRule(@NonNull String originalRuleName, @NonNull String ruleName, @NonNull String rule, @NonNull String comment, boolean isActive) throws SWRLParseException, SWRLBuiltInException {
        this.swrlapiOWLOntology.replaceSWRLRule(originalRuleName, ruleName, rule, comment, isActive);
    }

    @Override
    public void deleteSWRLRule(@NonNull String ruleName) {
        this.swrlapiOWLOntology.deleteSWRLRule(ruleName);
    }

    @Override
    public boolean isSWRLBuiltInIRI(@NonNull IRI iri) {
        return this.swrlapiOWLOntology.isSWRLBuiltInIRI(iri);
    }

    @Override
    public boolean isSWRLBuiltIn(@NonNull String shortName) {
        return this.swrlapiOWLOntology.isSWRLBuiltIn(shortName);
    }

    @Override
    public @NonNull Set<@NonNull IRI> getSWRLBuiltInIRIs() {
        return Collections.unmodifiableSet(this.swrlapiOWLOntology.getSWRLBuiltInIRIs());
    }

    @Override
    public @NonNull SWRLParser createSWRLParser() {
        return this.swrlapiOWLOntology.createSWRLParser();
    }

    @Override
    public @NonNull SWRLAutoCompleter createSWRLAutoCompleter() {
        return this.swrlapiOWLOntology.createSWRLAutoCompleter();
    }

    @Override
    public @NonNull SWRLRuleRenderer createSWRLRuleRenderer() {
        return this.swrlapiOWLOntology.createSWRLRuleRenderer();
    }

    @Override
    public @NonNull Set<@NonNull OWLAxiom> getAssertedOWLAxioms() {
        return this.swrlapiOWLOntology.getOWLAxioms();
    }

    @Override
    public @NonNull Set<@NonNull OWLAxiom> getInferredOWLAxioms() {
        return this.ruleEngineBridgeController.getInferredOWLAxioms();
    }

    @Override
    public @NonNull Set<@NonNull OWLAxiom> getInjectedOWLAxioms() {
        return this.builtInBridgeController.getInjectedOWLAxioms();
    }

    @Override
    public @NonNull String getRuleEngineName() {
        return this.targetSWRLRuleEngine.getTargetRuleEngineName();
    }

    @Override
    public @NonNull String getTargetQueryEngineName() {
        return this.targetSWRLRuleEngine.getTargetRuleEngineName();
    }

    @Override
    public @NonNull String getRuleEngineVersion() {
        return this.targetSWRLRuleEngine.getTargetRuleEngineVersion();
    }

    @Override
    public @NonNull String getTargetQueryEngineVersion() {
        return this.targetSWRLRuleEngine.getTargetRuleEngineVersion();
    }

    @Override
    public @NonNull OWLReasoner getOWLReasoner() {
        return this.targetSWRLRuleEngine.getOWLReasoner();
    }

    @Override
    public void loadExternalSWRLBuiltInLibraries(@NonNull File swrlBuiltInLibraryDirectory) {
        this.swrlapiOWLOntology.getSWRLBuiltInLibraryManager().loadExternalSWRLBuiltInLibraries(swrlBuiltInLibraryDirectory);
    }

    @Override
    public @NonNull Icon getRuleEngineIcon() {
        return this.targetSWRLRuleEngine.getTargetRuleEngineIcon();
    }

    @Override
    public @NonNull Icon getTargetQueryEngineIcon() {
        return this.targetSWRLRuleEngine.getTargetRuleEngineIcon();
    }

    @Override
    public @NonNull SWRLRuleEngine getSWRLRuleEngine() {
        return this;
    }

    @Override
    public @NonNull SWRLAPIOWLOntology getSWRLAPIOWLOntology() {
        return this.swrlapiOWLOntology;
    }

    private void reset() {
        try {
            this.getTargetSWRLRuleEngine().resetRuleEngine();
            this.getBuiltInBridgeController().reset();
            this.getOWL2RLEngine().resetRuleSelectionChanged();
            this.swrlapiOWLOntology.processOntology();
        }
        catch (SWRLBuiltInException e) {
            throw new SWRLRuleEngineException("error running rule engine: " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    private void exportSQWRLQuery2TargetRuleEngine(@NonNull String activeQueryName) throws SWRLRuleEngineException, TargetSWRLRuleEngineException, SWRLBuiltInException {
        for (SQWRLQuery query : this.swrlapiOWLOntology.getSQWRLQueries()) {
            query.setActive(query.getQueryName().equalsIgnoreCase(activeQueryName));
            this.exportSQWRLQuery2TargetRuleEngine(query);
        }
    }

    private void exportSQWRLQueries2TargetRuleEngine() throws SWRLRuleEngineException, TargetSWRLRuleEngineException, SWRLBuiltInException {
        for (SQWRLQuery query : this.swrlapiOWLOntology.getSQWRLQueries()) {
            query.setActive(true);
            this.exportSQWRLQuery2TargetRuleEngine(query);
        }
    }

    private void exportSQWRLQuery2TargetRuleEngine(@NonNull SQWRLQuery query) throws SWRLRuleEngineException, TargetSWRLRuleEngineException, SWRLBuiltInException {
        this.getTargetSWRLRuleEngine().defineSQWRLQuery(query);
    }

    private @NonNull TargetSWRLRuleEngine getTargetSWRLRuleEngine() throws SWRLRuleEngineException {
        if (this.targetSWRLRuleEngine == null) {
            throw new SWRLRuleEngineException("no target rule engine specified");
        }
        return this.targetSWRLRuleEngine;
    }

    private void exportOWLAxioms2TargetRuleEngine(@NonNull Set<@NonNull OWLAxiom> axioms) throws SWRLRuleEngineException, TargetSWRLRuleEngineException {
        for (OWLAxiom axiom : axioms) {
            this.getTargetSWRLRuleEngine().defineOWLAxiom(axiom);
        }
    }

    private void writeOWLAxioms2OWLOntology(@NonNull Set<@NonNull OWLAxiom> axioms) throws SWRLRuleEngineException {
        OWLInferredAxiomFilter inferredAxiomFilter = new OWLInferredAxiomFilter(axioms);
        List filteredAxioms = axioms.stream().filter(a -> (Boolean)a.accept((OWLAxiomVisitorEx)inferredAxiomFilter) == false).collect(Collectors.toList());
        List changes = filteredAxioms.stream().map(a -> new AddAxiom(this.getOWLOntology(), a)).collect(Collectors.toList());
        try {
            this.getOWLOntologyManager().applyChanges(changes);
        }
        catch (RuntimeException e) {
            throw new SWRLRuleEngineException("Error writing OWL axioms to ontology", e);
        }
    }

    private @NonNull OWLOntologyManager getOWLOntologyManager() {
        return this.getSWRLAPIOWLOntology().getOWLOntologyManager();
    }

    private @NonNull SWRLBuiltInBridgeController getBuiltInBridgeController() {
        return this.builtInBridgeController;
    }
}

