/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.lang.reflect.Constructor;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.swrlapi.bridge.SWRLBridge;
import org.swrlapi.bridge.TargetSWRLRuleEngine;
import org.swrlapi.bridge.TargetSWRLRuleEngineCreator;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLAPIOWLOntology;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.core.SWRLRuleEngineManager;
import org.swrlapi.exceptions.InvalidSWRLRuleEngineNameException;
import org.swrlapi.exceptions.NoRegisteredSWRLRuleEnginesException;
import org.swrlapi.exceptions.SWRLRuleEngineException;
import org.swrlapi.factory.DefaultSWRLRuleAndQueryEngine;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.factory.SWRLRuleAndQueryEngineFactory;
import org.swrlapi.owl2rl.OWL2RLPersistenceLayer;
import org.swrlapi.sqwrl.SQWRLQueryEngine;

public class DefaultSWRLRuleAndQueryEngineFactory
implements SWRLRuleAndQueryEngineFactory {
    private final @NonNull SWRLRuleEngineManager ruleEngineManager = SWRLAPIInternalFactory.createSWRLRuleEngineManager();

    @Override
    public void registerRuleEngine(@NonNull TargetSWRLRuleEngineCreator ruleEngineCreator) {
        this.ruleEngineManager.registerRuleEngine(ruleEngineCreator);
    }

    @Override
    public @NonNull SWRLRuleEngine createSWRLRuleEngine(@NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) {
        if (this.ruleEngineManager.hasRegisteredRuleEngines()) {
            Optional<@NonNull String> ruleEngineName = this.ruleEngineManager.getAnyRegisteredRuleEngineName();
            if (ruleEngineName.isPresent()) {
                return this.createSWRLRuleEngine(ruleEngineName.get(), ontology, iriResolver);
            }
            throw new NoRegisteredSWRLRuleEnginesException();
        }
        throw new NoRegisteredSWRLRuleEnginesException();
    }

    @Override
    public @NonNull SWRLRuleEngine createSWRLRuleEngine(@NonNull String ruleEngineName, @NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) {
        if (this.ruleEngineManager.isRuleEngineRegistered(ruleEngineName)) {
            try {
                SWRLAPIOWLOntology swrlapiOWLOntology = SWRLAPIInternalFactory.createSWRLAPIOntology(ontology, iriResolver);
                OWL2RLPersistenceLayer owl2RLPersistenceLayer = SWRLAPIInternalFactory.createOWL2RLPersistenceLayer(ontology);
                SWRLBridge bridge = SWRLAPIInternalFactory.createSWRLBridge(swrlapiOWLOntology, owl2RLPersistenceLayer);
                Optional<TargetSWRLRuleEngineCreator> targetSWRLRuleEngineCreator = this.ruleEngineManager.getRegisteredRuleEngineCreator(ruleEngineName);
                if (targetSWRLRuleEngineCreator.isPresent()) {
                    TargetSWRLRuleEngine targetSWRLRuleEngine = targetSWRLRuleEngineCreator.get().create(bridge);
                    bridge.setTargetSWRLRuleEngine(targetSWRLRuleEngine);
                    DefaultSWRLRuleAndQueryEngine ruleEngine = new DefaultSWRLRuleAndQueryEngine(swrlapiOWLOntology, targetSWRLRuleEngine, bridge, bridge);
                    ruleEngine.importAssertedOWLAxioms();
                    return ruleEngine;
                }
                throw new SWRLRuleEngineException("Error creating rule engine " + ruleEngineName + ". Creator failed.");
            }
            catch (Throwable e) {
                throw new SWRLRuleEngineException("Error creating rule engine " + ruleEngineName + ". Exception: " + e.getClass().getCanonicalName() + ". Message: " + (e.getMessage() != null ? e.getMessage() : ""), e);
            }
        }
        throw new InvalidSWRLRuleEngineNameException(ruleEngineName);
    }

    @Override
    public @NonNull SQWRLQueryEngine createSQWRLQueryEngine(@NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) {
        Optional<@NonNull String> ruleEngineName = this.ruleEngineManager.getAnyRegisteredRuleEngineName();
        if (ruleEngineName.isPresent()) {
            return this.createSQWRLQueryEngine(ruleEngineName.get(), ontology, iriResolver);
        }
        throw new NoRegisteredSWRLRuleEnginesException();
    }

    @Override
    public @NonNull SQWRLQueryEngine createSQWRLQueryEngine(@NonNull String queryEngineName, @NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) {
        if (this.ruleEngineManager.isRuleEngineRegistered(queryEngineName)) {
            try {
                SWRLAPIOWLOntology swrlapiOWLOntology = SWRLAPIInternalFactory.createSWRLAPIOntology(ontology, iriResolver);
                OWL2RLPersistenceLayer owl2RLPersistenceLayer = SWRLAPIInternalFactory.createOWL2RLPersistenceLayer(ontology);
                SWRLBridge bridge = SWRLAPIInternalFactory.createSWRLBridge(swrlapiOWLOntology, owl2RLPersistenceLayer);
                Optional<TargetSWRLRuleEngineCreator> targetSWRLRuleEngineCreator = this.ruleEngineManager.getRegisteredRuleEngineCreator(queryEngineName);
                if (targetSWRLRuleEngineCreator.isPresent()) {
                    TargetSWRLRuleEngine targetSWRLRuleEngine = targetSWRLRuleEngineCreator.get().create(bridge);
                    bridge.setTargetSWRLRuleEngine(targetSWRLRuleEngine);
                    DefaultSWRLRuleAndQueryEngine queryEngine = new DefaultSWRLRuleAndQueryEngine(swrlapiOWLOntology, targetSWRLRuleEngine, bridge, bridge);
                    queryEngine.importAssertedOWLAxioms();
                    return queryEngine;
                }
                throw new SWRLRuleEngineException("Error creating query engine " + queryEngineName + ". Creator failed.");
            }
            catch (Throwable e) {
                throw new SWRLRuleEngineException("Error creating query engine " + queryEngineName + ". Exception: " + e.getClass().getCanonicalName() + ". Message: " + (e.getMessage() != null ? e.getMessage() : ""), e);
            }
        }
        throw new InvalidSWRLRuleEngineNameException(queryEngineName);
    }

    @Override
    public void tryToRegisterADefaultSWRLRuleEngine() {
        Optional<@NonNull TargetSWRLRuleEngineCreator> ruleEngineCreator = this.getDroolsSWRLRuleEngineCreator();
        ruleEngineCreator.ifPresent(this.ruleEngineManager::registerRuleEngine);
    }

    private Optional<@NonNull TargetSWRLRuleEngineCreator> getDroolsSWRLRuleEngineCreator() {
        return this.createClass("org.swrlapi.drools.core.DroolsSWRLRuleEngineCreator", TargetSWRLRuleEngineCreator.class);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private <T> Optional<@NonNull T> createClass(@NonNull String className, @NonNull Class<T> interfaceClass) {
        try {
            Class<@NonNull T> clazz = Class.forName(className).asSubclass(interfaceClass);
            Optional<@NonNull T> result = this.createInstance(clazz);
            return result;
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private <T> Optional<@NonNull T> createInstance(@NonNull Class<? extends @NonNull T> classToCreate) {
        try {
            Constructor<@NonNull T> constructor = classToCreate.getDeclaredConstructor(new Class[0]);
            return Optional.of(constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

