/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.Iterator;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.swrlapi.builtins.arguments.SQWRLCollectionVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLAnnotationPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLClassExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDataPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLDatatypeBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedIndividualBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLObjectPropertyExpressionBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLAPIBuiltInAtom;
import org.swrlapi.core.SWRLRuleRenderer;
import org.swrlapi.sqwrl.SQWRLNames;
import org.swrlapi.sqwrl.SQWRLQuery;
import org.swrlapi.sqwrl.SQWRLQueryRenderer;

class DefaultSWRLRuleAndQueryRenderer
implements SWRLRuleRenderer,
SQWRLQueryRenderer {
    private final @NonNull OWLOntology ontology;
    private final @NonNull IRIResolver iriResolver;

    public DefaultSWRLRuleAndQueryRenderer(@NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) {
        this.ontology = ontology;
        this.iriResolver = iriResolver;
    }

    @Override
    public @NonNull String renderSWRLRule(@NonNull SWRLRule rule) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.renderBodyAtoms(rule.getBody().iterator()));
        sb.append(" -> ");
        sb.append((CharSequence)this.renderHeadAtoms(rule.getHead().iterator()));
        return sb.toString();
    }

    @Override
    public @NonNull String renderSQWRLQuery(@NonNull SQWRLQuery query) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.renderBodyAtoms(query.getBodyAtoms().iterator()));
        sb.append(" -> ");
        sb.append((CharSequence)this.renderHeadAtoms(query.getHeadAtoms().iterator()));
        return sb.toString();
    }

    private @NonNull StringBuilder renderBodyAtoms(@NonNull Iterator<@NonNull SWRLAtom> bodyAtomIterator) {
        StringBuilder sb = new StringBuilder();
        boolean collectionMakeEncountered = false;
        boolean collectionOperationEncountered = false;
        boolean isFirst = true;
        while (bodyAtomIterator.hasNext()) {
            SWRLAtom atom = bodyAtomIterator.next();
            if (this.isSQWRLCollectionMakeBuiltInAtom(atom)) {
                if (collectionMakeEncountered) {
                    sb.append(" ^ ");
                } else {
                    sb.append(" \u02da ");
                    collectionMakeEncountered = true;
                }
            } else if (this.isSQWRLCollectionOperateBuiltInAtom(atom)) {
                if (collectionOperationEncountered) {
                    sb.append(" ^ ");
                } else {
                    sb.append(" \u02da ");
                    collectionOperationEncountered = true;
                }
            } else if (!isFirst) {
                sb.append(" ^ ");
            }
            sb.append((String)atom.accept((SWRLObjectVisitorEx)this));
            isFirst = false;
        }
        return sb;
    }

    private @NonNull StringBuilder renderHeadAtoms(@NonNull Iterator<@NonNull SWRLAtom> headAtomIterator) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (headAtomIterator.hasNext()) {
            SWRLAtom atom = headAtomIterator.next();
            if (!isFirst) {
                sb.append(" ^ ");
            }
            sb.append((String)atom.accept((SWRLObjectVisitorEx)this));
            isFirst = false;
        }
        return sb;
    }

    public @NonNull String visit(@NonNull SWRLRule swrlRule) {
        return this.renderSWRLRule(swrlRule);
    }

    public @NonNull String visit(@NonNull SWRLClassAtom classAtom) {
        OWLClassExpression classExpression = classAtom.getPredicate();
        SWRLIArgument iArgument = (SWRLIArgument)classAtom.getArgument();
        StringBuilder sb = new StringBuilder();
        sb.append(this.visit(classExpression));
        sb.append("(").append(this.visit(iArgument)).append(")");
        return sb.toString();
    }

    public @NonNull String visit(@NonNull SWRLDataRangeAtom dataRangeAtom) {
        OWLDataRange dataRange = dataRangeAtom.getPredicate();
        SWRLDArgument dArgument = (SWRLDArgument)dataRangeAtom.getArgument();
        StringBuilder sb = new StringBuilder();
        sb.append(this.visit(dataRange));
        sb.append("(").append(this.visit(dArgument)).append(")");
        return sb.toString();
    }

    public @NonNull String visit(@NonNull SWRLObjectPropertyAtom objectPropertyAtom) {
        OWLObjectPropertyExpression objectPropertyExpression = objectPropertyAtom.getPredicate();
        SWRLIArgument iArgument1 = (SWRLIArgument)objectPropertyAtom.getFirstArgument();
        SWRLIArgument iArgument2 = (SWRLIArgument)objectPropertyAtom.getSecondArgument();
        StringBuilder sb = new StringBuilder();
        sb.append(this.visit(objectPropertyExpression));
        sb.append("(").append(this.visit(iArgument1)).append(", ").append(this.visit(iArgument2)).append(")");
        return sb.toString();
    }

    public @NonNull String visit(@NonNull SWRLDataPropertyAtom dataPropertyAtom) {
        OWLDataPropertyExpression dataPropertyExpression = dataPropertyAtom.getPredicate();
        SWRLIArgument iArgument1 = (SWRLIArgument)dataPropertyAtom.getFirstArgument();
        SWRLDArgument dArgument2 = (SWRLDArgument)dataPropertyAtom.getSecondArgument();
        StringBuilder sb = new StringBuilder();
        sb.append(this.visit(dataPropertyExpression));
        sb.append("(").append(this.visit(iArgument1)).append(", ").append(this.visit(dArgument2)).append(")");
        return sb.toString();
    }

    public @NonNull String visit(@NonNull SWRLBuiltInAtom builtInAtom) {
        IRI iri = builtInAtom.getPredicate();
        String builtInPrefixedName = this.getPrefixedName(iri);
        StringBuilder sb = new StringBuilder();
        sb.append(builtInPrefixedName).append("(");
        boolean isFirst = true;
        for (SWRLDArgument argument : builtInAtom.getArguments()) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append((String)argument.accept((SWRLObjectVisitorEx)this));
            isFirst = false;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public @NonNull String visit(@NonNull SWRLAPIBuiltInAtom swrlapiBuiltInAtom) {
        String builtInPrefixedName = swrlapiBuiltInAtom.getBuiltInPrefixedName();
        StringBuilder sb = new StringBuilder(builtInPrefixedName + "(");
        boolean isFirst = true;
        for (SWRLBuiltInArgument argument : swrlapiBuiltInAtom.getBuiltInArguments()) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(argument.accept(this));
            isFirst = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public @NonNull String visit(@NonNull SWRLVariable variable) {
        IRI argumentIRI = variable.getIRI();
        if (this.getOWLOntology().containsEntityInSignature(argumentIRI)) {
            String shortForm = this.getShortForm(argumentIRI);
            return shortForm.startsWith(":") ? shortForm.substring(1) : shortForm;
        }
        com.google.common.base.Optional remainder = argumentIRI.getRemainder();
        if (remainder.isPresent()) {
            return "?" + (String)remainder.get();
        }
        throw new IllegalArgumentException("SWRL variable with IRI " + argumentIRI + " has no remainder");
    }

    public @NonNull String visit(@NonNull SWRLIndividualArgument individualArgument) {
        return this.visit(individualArgument.getIndividual());
    }

    public @NonNull String visit(@NonNull SWRLLiteralArgument literalArgument) {
        OWLLiteral literal = literalArgument.getLiteral();
        return this.visit(literal);
    }

    public @NonNull String visit(@NonNull SWRLSameIndividualAtom sameIndividualAtom) {
        SWRLIArgument iArgument1 = (SWRLIArgument)sameIndividualAtom.getFirstArgument();
        SWRLIArgument iArgument2 = (SWRLIArgument)sameIndividualAtom.getSecondArgument();
        StringBuilder sb = new StringBuilder();
        sb.append("sameAs");
        sb.append("(").append(this.visit(iArgument1)).append(", ").append(this.visit(iArgument2)).append(")");
        return sb.toString();
    }

    public @NonNull String visit(@NonNull SWRLDifferentIndividualsAtom differentIndividualsAtom) {
        SWRLIArgument iArgument1 = (SWRLIArgument)differentIndividualsAtom.getFirstArgument();
        SWRLIArgument iArgument2 = (SWRLIArgument)differentIndividualsAtom.getSecondArgument();
        StringBuilder sb = new StringBuilder();
        sb.append("differentFrom");
        sb.append("(").append(this.visit(iArgument1)).append(", ").append(this.visit(iArgument2)).append(")");
        return sb.toString();
    }

    private String visit(SWRLIArgument argument) {
        StringBuilder sb = new StringBuilder();
        if (argument instanceof SWRLIndividualArgument) {
            SWRLIndividualArgument individualArgument = (SWRLIndividualArgument)argument;
            sb.append((String)individualArgument.accept((SWRLObjectVisitorEx)this));
        } else if (argument instanceof SWRLVariable) {
            SWRLVariable variableArgument = (SWRLVariable)argument;
            sb.append((String)variableArgument.accept((SWRLObjectVisitorEx)this));
        } else {
            sb.append("[Unknown ").append(SWRLIArgument.class.getName()).append(" type ").append(argument.getClass().getName()).append("]");
        }
        return sb.toString();
    }

    private String visit(SWRLDArgument argument) {
        StringBuilder sb = new StringBuilder();
        if (argument instanceof SWRLBuiltInArgument) {
            SWRLBuiltInArgument builtInArgument = (SWRLBuiltInArgument)argument;
            sb.append(builtInArgument.accept(this));
        } else if (argument instanceof SWRLLiteralArgument) {
            SWRLLiteralArgument literalArgument = (SWRLLiteralArgument)argument;
            sb.append((String)literalArgument.accept((SWRLObjectVisitorEx)this));
        } else if (argument instanceof SWRLVariable) {
            SWRLVariable variableArgument = (SWRLVariable)argument;
            sb.append((String)variableArgument.accept((SWRLObjectVisitorEx)this));
        } else {
            sb.append("[Unknown ").append(SWRLDArgument.class.getName()).append(" type ").append(argument.getClass().getName()).append("]");
        }
        return sb.toString();
    }

    private @NonNull String visit(@NonNull OWLClassExpression classExpression) {
        if (classExpression.isAnonymous()) {
            return "[Anonymous class expressions not implemented]";
        }
        OWLClass cls = classExpression.asOWLClass();
        return this.visit(cls);
    }

    private @NonNull String visit(@NonNull OWLClass cls) {
        String classNameShortForm = this.getShortForm(cls.getIRI());
        return classNameShortForm.startsWith(":") ? classNameShortForm.substring(1) : classNameShortForm;
    }

    private @NonNull String visit(@NonNull OWLIndividual individual) {
        if (individual.isNamed()) {
            String individualNameShortForm = this.getShortForm(individual.asOWLNamedIndividual().getIRI());
            return individualNameShortForm.startsWith(":") ? individualNameShortForm.substring(1) : individualNameShortForm;
        }
        return this.iriResolver.render((OWLObject)individual);
    }

    private @NonNull String visit(@NonNull OWLObjectPropertyExpression objectPropertyExpression) {
        if (objectPropertyExpression.isAnonymous()) {
            return "[Anonymous object property expressions not implemented]";
        }
        return this.visit(objectPropertyExpression.asOWLObjectProperty());
    }

    private @NonNull String visit(@NonNull OWLObjectProperty property) {
        String objectPropertyNameShortForm = this.getShortForm(property.getIRI());
        return objectPropertyNameShortForm.startsWith(":") ? objectPropertyNameShortForm.substring(1) : objectPropertyNameShortForm;
    }

    private @NonNull String visit(@NonNull OWLDataPropertyExpression dataPropertyExpression) {
        if (dataPropertyExpression.isAnonymous()) {
            return "[Anonymous data property expressions not implemented]";
        }
        return this.visit(dataPropertyExpression.asOWLDataProperty());
    }

    private @NonNull String visit(@NonNull OWLDataProperty property) {
        String dataPropertyNameShortForm = this.getShortForm(property.getIRI());
        return dataPropertyNameShortForm.startsWith(":") ? dataPropertyNameShortForm.substring(1) : dataPropertyNameShortForm;
    }

    private @NonNull String visit(@NonNull OWLDataRange dataRange) {
        if (dataRange.isDatatype()) {
            OWLDatatype datatype = dataRange.asOWLDatatype();
            return this.getShortForm(datatype.getIRI());
        }
        return this.visit(dataRange);
    }

    @Override
    public @NonNull String visit(@NonNull SWRLClassBuiltInArgument argument) {
        OWLClass cls = argument.getOWLClass();
        String classNameShortForm = this.getShortForm(cls.getIRI());
        return classNameShortForm.startsWith(":") ? classNameShortForm.substring(1) : classNameShortForm;
    }

    @Override
    public String visit(SWRLClassExpressionBuiltInArgument argument) {
        OWLClassExpression ce = argument.getOWLClassExpression();
        return this.iriResolver.render((OWLObject)ce);
    }

    @Override
    public @NonNull String visit(@NonNull SWRLNamedIndividualBuiltInArgument argument) {
        OWLNamedIndividual individual = argument.getOWLNamedIndividual();
        String individualNameShortForm = this.getShortForm(individual.getIRI());
        return individualNameShortForm.startsWith(":") ? individualNameShortForm.substring(1) : individualNameShortForm;
    }

    @Override
    public @NonNull String visit(@NonNull SWRLObjectPropertyBuiltInArgument argument) {
        OWLObjectProperty property = argument.getOWLObjectProperty();
        String objectPropertyNameShortForm = this.getShortForm(property.getIRI());
        return objectPropertyNameShortForm.startsWith(":") ? objectPropertyNameShortForm.substring(1) : objectPropertyNameShortForm;
    }

    @Override
    public String visit(SWRLObjectPropertyExpressionBuiltInArgument argument) {
        OWLObjectPropertyExpression pe = argument.getOWLObjectPropertyExpression();
        return this.iriResolver.render((OWLObject)pe);
    }

    @Override
    public @NonNull String visit(@NonNull SWRLDataPropertyBuiltInArgument argument) {
        OWLDataProperty property = argument.getOWLDataProperty();
        String dataPropertyNameShortForm = this.getShortForm(property.getIRI());
        return dataPropertyNameShortForm.startsWith(":") ? dataPropertyNameShortForm.substring(1) : dataPropertyNameShortForm;
    }

    @Override
    public String visit(SWRLDataPropertyExpressionBuiltInArgument argument) {
        OWLDataPropertyExpression pe = argument.getOWLDataPropertyExpression();
        return this.iriResolver.render((OWLObject)pe);
    }

    @Override
    public @NonNull String visit(@NonNull SWRLAnnotationPropertyBuiltInArgument argument) {
        OWLAnnotationProperty property = argument.getOWLAnnotationProperty();
        String annotationPropertyNameShortForm = this.getShortForm(property.getIRI());
        return annotationPropertyNameShortForm.startsWith(":") ? annotationPropertyNameShortForm.substring(1) : annotationPropertyNameShortForm;
    }

    @Override
    public @NonNull String visit(@NonNull SWRLDatatypeBuiltInArgument argument) {
        OWLDatatype datatype = argument.getOWLDatatype();
        return this.getShortForm(datatype.getIRI());
    }

    @Override
    public @NonNull String visit(@NonNull SWRLLiteralBuiltInArgument argument) {
        return this.visit(argument.getLiteral());
    }

    @Override
    public @NonNull String visit(@NonNull SWRLVariableBuiltInArgument argument) {
        IRI variableIRI = argument.getIRI();
        com.google.common.base.Optional remainder = variableIRI.getRemainder();
        if (remainder.isPresent()) {
            return "?" + (String)remainder.get();
        }
        throw new IllegalArgumentException("SWRL variable with IRI " + variableIRI + " has no remainder");
    }

    @Override
    public @NonNull String visit(@NonNull SWRLMultiValueVariableBuiltInArgument argument) {
        return argument.getVariableName();
    }

    @Override
    public @NonNull String visit(@NonNull SQWRLCollectionVariableBuiltInArgument argument) {
        return argument.getVariableName();
    }

    private @NonNull String visit(@NonNull OWLLiteral literal) {
        OWLDatatype datatype = literal.getDatatype();
        String value = literal.getLiteral();
        if (datatype.isString()) {
            return "\"" + value + "\"";
        }
        if (datatype.getIRI().equals((Object)XSDVocabulary.DECIMAL.getIRI())) {
            return value;
        }
        if (datatype.isBoolean()) {
            return value;
        }
        if (datatype.getIRI().equals((Object)XSDVocabulary.INTEGER.getIRI())) {
            return value;
        }
        return "\"" + value + "\"^^" + this.visit((OWLDataRange)datatype);
    }

    private @NonNull String getShortForm(@NonNull IRI iri) {
        String shortForm = this.iri2ShortForm(iri);
        return shortForm != null ? shortForm : iri.getShortForm();
    }

    private @NonNull String getPrefixedName(@NonNull IRI iri) {
        String prefixedName = this.iri2PrefixedName(iri);
        return prefixedName != null ? prefixedName : iri.getShortForm();
    }

    private boolean isSQWRLCollectionMakeBuiltInAtom(@NonNull SWRLAtom atom) {
        return atom instanceof SWRLAPIBuiltInAtom && SQWRLNames.isSQWRLCollectionMakeBuiltIn(((SWRLAPIBuiltInAtom)atom).getBuiltInPrefixedName());
    }

    private boolean isSQWRLCollectionOperateBuiltInAtom(@NonNull SWRLAtom atom) {
        return atom instanceof SWRLAPIBuiltInAtom && SQWRLNames.isSQWRLCollectionOperationBuiltIn(((SWRLAPIBuiltInAtom)atom).getBuiltInPrefixedName());
    }

    private @NonNull String iri2PrefixedName(@NonNull IRI iri) {
        Optional<@NonNull String> prefixedName = this.iriResolver.iri2PrefixedName(iri);
        if (prefixedName.isPresent()) {
            return prefixedName.get();
        }
        throw new IllegalArgumentException("could not get prefixed name for IRI " + iri);
    }

    private @NonNull String iri2ShortForm(@NonNull IRI iri) {
        Optional<@NonNull String> shortForm = this.iriResolver.iri2ShortForm(iri);
        if (shortForm.isPresent()) {
            return shortForm.get();
        }
        throw new IllegalArgumentException("could not get short form for IRI " + iri);
    }

    private @NonNull OWLOntology getOWLOntology() {
        return this.ontology;
    }
}

