/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.awt.Component;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.swrlapi.ui.dialog.ExtensionFilter;
import org.swrlapi.ui.dialog.SWRLRuleEditorDialog;
import org.swrlapi.ui.dialog.SWRLRuleEngineDialogManager;
import org.swrlapi.ui.model.SWRLRuleEngineModel;

public class DefaultSWRLRuleEngineDialogManager
implements SWRLRuleEngineDialogManager {
    private final @NonNull SWRLRuleEngineModel swrlRuleEngineModel;
    private @MonotonicNonNull SWRLRuleEditorDialog swrlRuleEditorDialog;
    private @MonotonicNonNull File lastDirectory = null;

    public DefaultSWRLRuleEngineDialogManager(@NonNull SWRLRuleEngineModel swrlRuleEngineModel) {
        this.swrlRuleEngineModel = swrlRuleEngineModel;
        this.swrlRuleEditorDialog = new SWRLRuleEditorDialog(swrlRuleEngineModel, this);
        this.swrlRuleEditorDialog.initialize();
    }

    @Override
    public @NonNull JDialog getSWRLRuleEditorDialog(@NonNull Component parent) {
        this.createSWRLRuleEditorDialogIfNecessary();
        this.swrlRuleEditorDialog.setLocationRelativeTo(parent);
        this.swrlRuleEditorDialog.setCreateMode();
        return this.swrlRuleEditorDialog;
    }

    @Override
    public @NonNull JDialog getSWRLRuleEditorDialog(@NonNull Component parent, @NonNull String ruleName, @NonNull String ruleText, @NonNull String comment) {
        this.createSWRLRuleEditorDialogIfNecessary();
        this.swrlRuleEditorDialog.setLocationRelativeTo(parent);
        this.swrlRuleEditorDialog.setEditMode(ruleName, ruleText, comment);
        return this.swrlRuleEditorDialog;
    }

    @Override
    public int showConfirmCancelDialog(@NonNull Component parent, @NonNull String message, @NonNull String title) {
        return JOptionPane.showConfirmDialog(parent, message, title, 1);
    }

    @Override
    public boolean showConfirmDialog(@NonNull Component parent, @NonNull String message, @NonNull String title) {
        return JOptionPane.showConfirmDialog(parent, message, title, 0) == 0;
    }

    @Override
    public void showErrorMessageDialog(@NonNull Component parent, @NonNull String message, @NonNull String title) {
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }

    @Override
    public String showInputDialog(@NonNull Component parent, @NonNull String message, @NonNull String initialValue) {
        if (initialValue == null) {
            initialValue = "";
        }
        return JOptionPane.showInputDialog(parent, message, initialValue);
    }

    @Override
    public void showMessageDialog(@NonNull Component parent, @NonNull String message, @NonNull String title) {
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }

    @Override
    public @NonNull JFileChooser createFileChooser(@NonNull String title, @NonNull String fileDescription, @Nullable String fileExtension) {
        JFileChooser chooser = new JFileChooser(this.lastDirectory){
            private static final long serialVersionUID = 1L;

            @Override
            public int showDialog(Component c, String s) {
                int rval = super.showDialog(c, s);
                if (rval == 0) {
                    DefaultSWRLRuleEngineDialogManager.this.lastDirectory = this.getCurrentDirectory();
                }
                return rval;
            }
        };
        chooser.setDialogTitle(title);
        if (fileExtension == null) {
            chooser.setFileSelectionMode(1);
        } else if (fileExtension.length() > 0) {
            chooser.setFileFilter(new ExtensionFilter(fileExtension, fileDescription));
        }
        return chooser;
    }

    @Override
    public @NonNull JFileChooser createSaveFileChooser(@NonNull String title, @NonNull String fileDescription, @Nullable String fileExtension, final boolean overwrite) {
        JFileChooser chooser = new JFileChooser(this.lastDirectory){
            private static final long serialVersionUID = 1L;

            @Override
            public int showDialog(Component c, String s) {
                int rval = super.showDialog(c, s);
                if (rval == 0) {
                    DefaultSWRLRuleEngineDialogManager.this.lastDirectory = this.getCurrentDirectory();
                }
                return rval;
            }

            @Override
            public void approveSelection() {
                String title;
                String msg;
                int option;
                if (!overwrite) {
                    return;
                }
                File f = this.getSelectedFile();
                if (f.exists() && (option = JOptionPane.showConfirmDialog(this, msg = "The file '" + f.getName() + "' already exists!\nDo you want to replace it?", title = this.getDialogTitle(), 0, 2)) == 1) {
                    return;
                }
                super.approveSelection();
            }
        };
        chooser.setDialogType(1);
        chooser.setDialogTitle(title);
        if (fileExtension != null) {
            chooser.setFileFilter(new ExtensionFilter(fileExtension, fileDescription));
        }
        return chooser;
    }

    private void createSWRLRuleEditorDialogIfNecessary() {
        if (this.swrlRuleEditorDialog != null) {
            this.swrlRuleEditorDialog = new SWRLRuleEditorDialog(this.swrlRuleEngineModel, this);
            this.swrlRuleEditorDialog.initialize();
        }
    }
}

