/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.swrlapi.bridge.TargetSWRLRuleEngineCreator;
import org.swrlapi.core.SWRLRuleEngineManager;

class DefaultSWRLRuleEngineManager
implements SWRLRuleEngineManager {
    private final @NonNull Map<@NonNull String, @NonNull TargetSWRLRuleEngineCreator> registeredSWRLRuleEngines = new HashMap<String, TargetSWRLRuleEngineCreator>();

    @Override
    public void registerRuleEngine(@NonNull TargetSWRLRuleEngineCreator ruleEngineCreator) {
        String ruleEngineName = ruleEngineCreator.getRuleEngineName();
        if (this.registeredSWRLRuleEngines.containsKey(ruleEngineName)) {
            this.registeredSWRLRuleEngines.remove(ruleEngineName);
            this.registeredSWRLRuleEngines.put(ruleEngineName, ruleEngineCreator);
        } else {
            this.registeredSWRLRuleEngines.put(ruleEngineName, ruleEngineCreator);
        }
    }

    @Override
    public boolean isRuleEngineRegistered(@NonNull String ruleEngineName) {
        return this.registeredSWRLRuleEngines.containsKey(ruleEngineName);
    }

    @Override
    public boolean hasRegisteredRuleEngines() {
        return !this.registeredSWRLRuleEngines.isEmpty();
    }

    @Override
    public Optional<@NonNull String> getAnyRegisteredRuleEngineName() {
        if (this.hasRegisteredRuleEngines()) {
            return Optional.of(this.registeredSWRLRuleEngines.keySet().iterator().next());
        }
        return Optional.empty();
    }

    @Override
    public Optional<@NonNull TargetSWRLRuleEngineCreator> getRegisteredRuleEngineCreator(@NonNull String ruleEngineName) {
        if (this.registeredSWRLRuleEngines.containsKey(ruleEngineName)) {
            return Optional.of(this.registeredSWRLRuleEngines.get(ruleEngineName));
        }
        return Optional.empty();
    }

    @Override
    public @NonNull Set<@NonNull String> getRegisteredRuleEngineNames() {
        return this.registeredSWRLRuleEngines.keySet();
    }

    @Override
    public void unregisterSWRLRuleEngine(@NonNull String ruleEngineName) {
        if (this.registeredSWRLRuleEngines.containsKey(ruleEngineName)) {
            this.registeredSWRLRuleEngines.remove(ruleEngineName);
        }
    }
}

