/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.io.File;
import java.net.URI;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swrlapi.core.SWRLAPIOWLOntology;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.core.SWRLRuleRenderer;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.owl2rl.OWL2RLEngine;
import org.swrlapi.parser.SWRLParser;
import org.swrlapi.ui.model.OWL2RLModel;
import org.swrlapi.ui.model.SWRLAutoCompleter;
import org.swrlapi.ui.model.SWRLRuleEngineModel;
import org.swrlapi.ui.model.SWRLRulesAndSQWRLQueriesTableModel;

public class DefaultSWRLRuleEngineModel
implements SWRLRuleEngineModel {
    private static final Logger log = LoggerFactory.getLogger(DefaultSWRLRuleEngineModel.class);
    private final @NonNull OWLOntologyManager ontologyManager;
    private @NonNull SWRLAPIOWLOntology swrlapiOWLOntology;
    private @NonNull SWRLRuleEngine swrlRuleEngine;
    private @NonNull OWL2RLEngine owl2RLEngine;
    protected final @NonNull SWRLRulesAndSQWRLQueriesTableModel swrlRulesAndSQWRLQueriesTableModel;
    private final @NonNull OWL2RLModel owl2RLModel;

    public DefaultSWRLRuleEngineModel(@NonNull SWRLRuleEngine swrlRuleEngine) {
        this.ontologyManager = swrlRuleEngine.getSWRLAPIOWLOntology().getOWLOntologyManager();
        this.swrlRuleEngine = swrlRuleEngine;
        this.swrlapiOWLOntology = swrlRuleEngine.getSWRLAPIOWLOntology();
        this.owl2RLEngine = this.swrlRuleEngine.getOWL2RLEngine();
        this.swrlRulesAndSQWRLQueriesTableModel = SWRLAPIInternalFactory.createSWRLRulesAndSQWRLQueriesTableModel(swrlRuleEngine);
        this.owl2RLModel = SWRLAPIInternalFactory.createOWL2RLModel(this.owl2RLEngine);
    }

    @Override
    public void updateModel(@NonNull SWRLRuleEngine ruleEngine) {
        this.swrlRuleEngine = ruleEngine;
        this.swrlapiOWLOntology = ruleEngine.getSWRLAPIOWLOntology();
        this.owl2RLEngine = this.swrlRuleEngine.getOWL2RLEngine();
        this.swrlRulesAndSQWRLQueriesTableModel.updateModel(ruleEngine);
        this.owl2RLModel.updateModel(this.owl2RLEngine);
        this.updateView();
    }

    @Override
    public void registerOntologyListener() {
        this.swrlapiOWLOntology.registerRuleEngineModel(this);
    }

    @Override
    public void unregisterOntologyListener() {
        this.swrlapiOWLOntology.unregisterRuleEngineModel(this);
    }

    @Override
    public void updateModel() {
        this.swrlRulesAndSQWRLQueriesTableModel.updateModel(this.swrlRuleEngine);
        this.owl2RLModel.updateModel(this.owl2RLEngine);
        this.updateView();
    }

    protected @NonNull OWLOntology createOWLOntology() throws OWLOntologyCreationException {
        this.ontologyManager.removeOntology(this.swrlRuleEngine.getOWLOntology());
        return this.ontologyManager.createOntology();
    }

    protected void saveOWLOntology(@NonNull File file) throws OWLOntologyStorageException {
        this.getOWLOntology().getOWLOntologyManager().saveOntology(this.getOWLOntology(), IRI.create((URI)file.toURI()));
    }

    protected @NonNull OWLOntology createOWLOntology(@NonNull File file) throws OWLOntologyCreationException {
        this.ontologyManager.removeOntology(this.swrlRuleEngine.getOWLOntology());
        return this.ontologyManager.loadOntologyFromOntologyDocument(file);
    }

    @Override
    public @NonNull SWRLRuleEngine getSWRLRuleEngine() {
        return this.swrlRuleEngine;
    }

    @Override
    public @NonNull SWRLParser createSWRLParser() {
        return this.swrlRuleEngine.createSWRLParser();
    }

    @Override
    public @NonNull SWRLAutoCompleter createSWRLAutoCompleter() {
        return this.swrlRuleEngine.createSWRLAutoCompleter();
    }

    @Override
    public @NonNull SWRLRuleRenderer createSWRLRuleRenderer() {
        return this.swrlRuleEngine.createSWRLRuleRenderer();
    }

    @Override
    public @NonNull SWRLRulesAndSQWRLQueriesTableModel getSWRLRulesTableModel() {
        return this.swrlRulesAndSQWRLQueriesTableModel;
    }

    @Override
    public @NonNull OWL2RLModel getOWL2RLModel() {
        return this.owl2RLModel;
    }

    @Override
    public boolean areSWRLRulesModified() {
        return this.swrlRulesAndSQWRLQueriesTableModel.hasBeenModified();
    }

    @Override
    public void clearSWRLRulesModified() {
        this.swrlRulesAndSQWRLQueriesTableModel.clearModifiedStatus();
    }

    @Override
    public Optional<String> getNextRuleName() {
        return this.swrlapiOWLOntology.getNextRuleName();
    }

    @Override
    public boolean hasOntologyChanged() {
        return this.swrlapiOWLOntology.hasOntologyChanged();
    }

    @Override
    public void resetOntologyChanged() {
        this.swrlapiOWLOntology.resetOntologyChanged();
    }

    @Override
    public void updateView() {
        this.swrlRulesAndSQWRLQueriesTableModel.updateView();
    }

    private @NonNull OWLOntology getOWLOntology() {
        return this.swrlRuleEngine.getOWLOntology();
    }
}

