/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentType;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentVisitor;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgumentVisitorEx;
import org.swrlapi.builtins.arguments.SWRLLiteralBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLMultiValueVariableBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLNamedBuiltInArgument;
import org.swrlapi.builtins.arguments.SWRLVariableBuiltInArgument;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.factory.DefaultSWRLBuiltInArgument;

class DefaultSWRLVariableBuiltInArgument
extends DefaultSWRLBuiltInArgument
implements SWRLVariableBuiltInArgument {
    private static final long serialVersionUID = 1L;
    private final @NonNull IRI variableIRI;
    private final @NonNull String variableName;
    private @Nullable SWRLBuiltInArgument builtInResult;
    private boolean isBound;

    public DefaultSWRLVariableBuiltInArgument(@NonNull IRI variableIRI) {
        this.variableIRI = variableIRI;
        com.google.common.base.Optional remainder = variableIRI.getRemainder();
        if (!remainder.isPresent()) {
            throw new IllegalArgumentException("SWRL variable with IRI " + variableIRI + " has no remainder");
        }
        this.variableName = (String)remainder.get();
        this.builtInResult = null;
        this.isBound = true;
    }

    @Override
    public @NonNull SWRLBuiltInArgumentType<?> getSWRLBuiltInArgumentType() {
        return SWRLBuiltInArgumentType.VARIABLE;
    }

    public @NonNull IRI getIRI() {
        return this.variableIRI;
    }

    @Override
    public @NonNull SWRLVariableBuiltInArgument asVariable() {
        return this;
    }

    @Override
    public @NonNull SWRLMultiValueVariableBuiltInArgument asMultiValueVariable() {
        throw new SWRLAPIException("not a SWRLMultiVariableBuiltInArgument");
    }

    @Override
    public @NonNull SWRLLiteralBuiltInArgument asSWRLLiteralBuiltInArgument() {
        throw new SWRLAPIException("Not a SWRLLiteralBuiltInArgument");
    }

    @Override
    public @NonNull SWRLNamedBuiltInArgument asSWRLNamedBuiltInArgument() {
        throw new SWRLAPIException("Not a SWRLNamedBuiltInArgument");
    }

    @Override
    public @NonNull String getVariableName() {
        return this.variableName;
    }

    @Override
    public void setBuiltInResult(@NonNull SWRLBuiltInArgument builtInResult) throws SWRLBuiltInException {
        if (!this.isUnbound()) {
            throw new SWRLBuiltInException("attempt to bind value to bound argument " + this.toString());
        }
        this.setBound();
        this.builtInResult = builtInResult;
    }

    @Override
    public @NonNull Optional<@NonNull SWRLBuiltInArgument> getBuiltInResult() {
        if (this.builtInResult != null) {
            return Optional.of(this.builtInResult);
        }
        return Optional.empty();
    }

    @Override
    public boolean hasBuiltInResult() {
        return this.builtInResult != null;
    }

    @Override
    public boolean isUnbound() {
        return !this.isBound;
    }

    @Override
    public boolean isBound() {
        return this.isBound;
    }

    @Override
    public void setUnbound() {
        this.isBound = false;
    }

    @Override
    public void setBound() {
        this.isBound = true;
    }

    @Override
    public <T> @NonNull T accept(@NonNull SWRLBuiltInArgumentVisitorEx<@NonNull T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(@NonNull SWRLBuiltInArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(@NonNull SWRLObjectVisitor visitor) {
        visitor.visit((SWRLVariable)this);
    }

    @Override
    public <O> @NonNull O accept(@NonNull SWRLObjectVisitorEx<@NonNull O> visitor) {
        return (O)visitor.visit((SWRLVariable)this);
    }

    @Override
    public void accept(@NonNull OWLObjectVisitor visitor) {
        visitor.visit((SWRLVariable)this);
    }

    @Override
    public <O> @NonNull O accept(@NonNull OWLObjectVisitorEx<@NonNull O> visitor) {
        return (O)visitor.visit((SWRLVariable)this);
    }

    private int compareTo(@NonNull SWRLVariableBuiltInArgument o) {
        return this.getIRI().compareTo((OWLObject)o.getIRI());
    }

    @Override
    @SideEffectFree
    @Deterministic
    public int compareTo(@NonNull OWLObject o) {
        if (!(o instanceof SWRLVariableBuiltInArgument)) {
            return -1;
        }
        SWRLVariableBuiltInArgument other = (SWRLVariableBuiltInArgument)o;
        return this.compareTo(other);
    }

    @SideEffectFree
    @Deterministic
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSWRLVariableBuiltInArgument that = (DefaultSWRLVariableBuiltInArgument)o;
        if (this.isBound != that.isBound) {
            return false;
        }
        if (!Objects.equals(this.variableIRI, that.variableIRI)) {
            return false;
        }
        if (!Objects.equals(this.variableName, that.variableName)) {
            return false;
        }
        return Objects.equals(this.builtInResult, that.builtInResult);
    }

    @SideEffectFree
    @Deterministic
    public int hashCode() {
        int result = this.variableIRI != null ? this.variableIRI.hashCode() : 0;
        result = 31 * result + (this.variableName != null ? this.variableName.hashCode() : 0);
        result = 31 * result + (this.builtInResult != null ? this.builtInResult.hashCode() : 0);
        result = 31 * result + (this.isBound ? 1 : 0);
        return result;
    }

    @Override
    public @NonNull Set<@NonNull OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return new HashSet<OWLAnnotationProperty>();
    }
}

