/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class OWLInferredAxiomFilter
implements OWLAxiomVisitorEx<Boolean> {
    private final @NonNull Set<@NonNull OWLAxiom> axioms;

    public OWLInferredAxiomFilter(@NonNull Set<@NonNull OWLAxiom> axioms) {
        this.axioms = axioms;
    }

    public @NonNull Boolean visit(@NonNull OWLDeclarationAxiom owlDeclarationAxiom) {
        return true;
    }

    public @NonNull Boolean visit(@NonNull OWLDatatypeDefinitionAxiom owlDatatypeDefinitionAxiom) {
        return true;
    }

    public @NonNull Boolean visit(@NonNull OWLAnnotationAssertionAxiom owlAnnotationAssertionAxiom) {
        return true;
    }

    public @NonNull Boolean visit(@NonNull OWLSubAnnotationPropertyOfAxiom owlSubAnnotationPropertyOfAxiom) {
        return true;
    }

    public @NonNull Boolean visit(@NonNull OWLAnnotationPropertyDomainAxiom owlAnnotationPropertyDomainAxiom) {
        return true;
    }

    public @NonNull Boolean visit(@NonNull OWLAnnotationPropertyRangeAxiom owlAnnotationPropertyRangeAxiom) {
        return true;
    }

    public @NonNull Boolean visit(@NonNull OWLSubClassOfAxiom axiom) {
        OWLClassExpression subClass;
        OWLClassExpression superClass = axiom.getSuperClass();
        if (superClass.equals(subClass = axiom.getSubClass())) {
            return true;
        }
        if (superClass.isOWLThing()) {
            return true;
        }
        if (subClass.isOWLNothing()) {
            return true;
        }
        Set subClassOfAxioms = this.axioms.stream().filter(OWLSubClassOfAxiom.class::isInstance).map(OWLSubClassOfAxiom.class::cast).collect(Collectors.toSet());
        Set superClassSubClasses = subClassOfAxioms.stream().filter(sca -> sca.getSuperClass().equals(superClass)).map(sca -> sca.getSubClass()).filter(subC -> !subC.isOWLNothing() && !subC.equals(subClass) && !subC.equals(superClass)).collect(Collectors.toSet());
        Set subClassSuperClasses = subClassOfAxioms.stream().filter(sca -> sca.getSubClass().equals(subClass)).map(sca -> sca.getSuperClass()).filter(supC -> !supC.isOWLThing() && !supC.equals(superClass) && !supC.equals(subClass)).collect(Collectors.toSet());
        HashSet common = new HashSet(superClassSubClasses);
        common.retainAll(subClassSuperClasses);
        return !common.isEmpty();
    }

    public @NonNull Boolean visit(@NonNull OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLAsymmetricObjectPropertyAxiom owlAsymmetricObjectPropertyAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLReflexiveObjectPropertyAxiom owlReflexiveObjectPropertyAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLDisjointClassesAxiom owlDisjointClassesAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLDataPropertyDomainAxiom axiom) {
        return axiom.getDomain().isOWLThing();
    }

    public @NonNull Boolean visit(@NonNull OWLObjectPropertyDomainAxiom axiom) {
        return axiom.getDomain().isOWLThing();
    }

    public @NonNull Boolean visit(@NonNull OWLEquivalentObjectPropertiesAxiom axiom) {
        return axiom.getProperties().size() == 1 || axiom.getProperties().size() == 2 && axiom.getProperties().stream().anyMatch(p -> p.isOWLTopObjectProperty());
    }

    public @NonNull Boolean visit(@NonNull OWLNegativeDataPropertyAssertionAxiom owlNegativeDataPropertyAssertionAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLDifferentIndividualsAxiom axiom) {
        return axiom.getIndividuals().size() == 1;
    }

    public @NonNull Boolean visit(@NonNull OWLDisjointDataPropertiesAxiom owlDisjointDataPropertiesAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLDisjointObjectPropertiesAxiom owlDisjointObjectPropertiesAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLObjectPropertyRangeAxiom axiom) {
        return ((OWLClassExpression)axiom.getRange()).isOWLThing();
    }

    public @NonNull Boolean visit(@NonNull OWLObjectPropertyAssertionAxiom axiom) {
        return ((OWLObjectPropertyExpression)axiom.getProperty()).isOWLTopObjectProperty();
    }

    public @NonNull Boolean visit(@NonNull OWLFunctionalObjectPropertyAxiom owlFunctionalObjectPropertyAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLSubObjectPropertyOfAxiom axiom) {
        OWLObjectPropertyExpression subProperty;
        OWLObjectPropertyExpression superProperty = (OWLObjectPropertyExpression)axiom.getSuperProperty();
        if (superProperty.equals(subProperty = (OWLObjectPropertyExpression)axiom.getSubProperty())) {
            return true;
        }
        if (superProperty.isOWLTopObjectProperty()) {
            return true;
        }
        if (subProperty.isOWLBottomObjectProperty()) {
            return true;
        }
        Set subPropertyAxioms = this.axioms.stream().filter(OWLSubObjectPropertyOfAxiom.class::isInstance).map(OWLSubObjectPropertyOfAxiom.class::cast).collect(Collectors.toSet());
        Set superPropertySubProperties = subPropertyAxioms.stream().filter(sopa -> ((OWLObjectPropertyExpression)sopa.getSuperProperty()).equals(superProperty)).map(sopa -> (OWLObjectPropertyExpression)sopa.getSubProperty()).filter(subP -> !subP.isOWLBottomObjectProperty() && !subP.equals(subProperty) && !subP.equals(superProperty)).collect(Collectors.toSet());
        Set subPropertySuperProperties = subPropertyAxioms.stream().filter(sdpa -> ((OWLObjectPropertyExpression)sdpa.getSubProperty()).equals(subProperty)).map(sdpa -> (OWLObjectPropertyExpression)sdpa.getSuperProperty()).filter(supP -> !supP.isOWLTopObjectProperty() && !supP.equals(superProperty) && !supP.equals(subProperty)).collect(Collectors.toSet());
        HashSet common = new HashSet(superPropertySubProperties);
        common.retainAll(subPropertySuperProperties);
        return !common.isEmpty();
    }

    public @NonNull Boolean visit(@NonNull OWLDisjointUnionAxiom owlDisjointUnionAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLSymmetricObjectPropertyAxiom owlSymmetricObjectPropertyAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLDataPropertyRangeAxiom axiom) {
        return ((OWLDataRange)axiom.getRange()).isTopDatatype();
    }

    public @NonNull Boolean visit(@NonNull OWLFunctionalDataPropertyAxiom owlFunctionalDataPropertyAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLEquivalentDataPropertiesAxiom axiom) {
        return axiom.getProperties().size() == 1 || axiom.getProperties().size() == 2 && axiom.getProperties().stream().anyMatch(p -> p.isOWLTopDataProperty());
    }

    public @NonNull Boolean visit(@NonNull OWLClassAssertionAxiom axiom) {
        return axiom.getClassExpression().isOWLThing();
    }

    public @NonNull Boolean visit(@NonNull OWLEquivalentClassesAxiom axiom) {
        return axiom.getClassExpressions().size() == 1 || axiom.containsOWLThing();
    }

    public @NonNull Boolean visit(@NonNull OWLDataPropertyAssertionAxiom axiom) {
        return ((OWLDataPropertyExpression)axiom.getProperty()).isOWLTopDataProperty();
    }

    public @NonNull Boolean visit(@NonNull OWLTransitiveObjectPropertyAxiom owlTransitiveObjectPropertyAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLIrreflexiveObjectPropertyAxiom owlIrreflexiveObjectPropertyAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLSubDataPropertyOfAxiom axiom) {
        OWLDataPropertyExpression subProperty;
        OWLDataPropertyExpression superProperty = (OWLDataPropertyExpression)axiom.getSuperProperty();
        if (superProperty.equals(subProperty = (OWLDataPropertyExpression)axiom.getSubProperty())) {
            return true;
        }
        if (superProperty.isOWLTopDataProperty()) {
            return true;
        }
        if (subProperty.isOWLBottomDataProperty()) {
            return true;
        }
        Set subPropertyAxioms = this.axioms.stream().filter(OWLSubDataPropertyOfAxiom.class::isInstance).map(OWLSubDataPropertyOfAxiom.class::cast).collect(Collectors.toSet());
        Set superPropertySubProperties = subPropertyAxioms.stream().filter(sdpa -> ((OWLDataPropertyExpression)sdpa.getSuperProperty()).equals(superProperty)).map(sdpa -> (OWLDataPropertyExpression)sdpa.getSubProperty()).filter(subP -> !subP.isOWLBottomDataProperty() && !subP.equals(subProperty) && !subP.equals(superProperty)).collect(Collectors.toSet());
        Set subPropertySuperProperties = subPropertyAxioms.stream().filter(sdpa -> ((OWLDataPropertyExpression)sdpa.getSubProperty()).equals(subProperty)).map(sdpa -> (OWLDataPropertyExpression)sdpa.getSuperProperty()).filter(supP -> !supP.isOWLTopDataProperty() && !supP.equals(superProperty) && !supP.equals(subProperty)).collect(Collectors.toSet());
        HashSet common = new HashSet(superPropertySubProperties);
        common.retainAll(subPropertySuperProperties);
        return !common.isEmpty();
    }

    public @NonNull Boolean visit(@NonNull OWLInverseFunctionalObjectPropertyAxiom owlInverseFunctionalObjectPropertyAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLSameIndividualAxiom axiom) {
        return axiom.getIndividuals().size() <= 1;
    }

    public @NonNull Boolean visit(@NonNull OWLSubPropertyChainOfAxiom owlSubPropertyChainOfAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLInverseObjectPropertiesAxiom owlInverseObjectPropertiesAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull OWLHasKeyAxiom owlHasKeyAxiom) {
        return false;
    }

    public @NonNull Boolean visit(@NonNull SWRLRule swrlRule) {
        return true;
    }
}

