/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.io.File;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.exceptions.SWRLRuleEngineException;
import org.swrlapi.factory.DefaultFileBackedSQWRLQueryEngineModel;
import org.swrlapi.factory.DefaultFileBackedSWRLRuleEngineModel;
import org.swrlapi.factory.DefaultIRIResolver;
import org.swrlapi.factory.DefaultSQWRLQueryEngineModel;
import org.swrlapi.factory.DefaultSWRLRuleEngineDialogManager;
import org.swrlapi.factory.DefaultSWRLRuleEngineModel;
import org.swrlapi.factory.SWRLAPIInternalFactory;
import org.swrlapi.factory.SWRLRuleAndQueryEngineFactory;
import org.swrlapi.sqwrl.SQWRLQueryEngine;
import org.swrlapi.ui.dialog.SWRLRuleEngineDialogManager;
import org.swrlapi.ui.model.FileBackedSQWRLQueryEngineModel;
import org.swrlapi.ui.model.FileBackedSWRLRuleEngineModel;
import org.swrlapi.ui.model.SQWRLQueryEngineModel;
import org.swrlapi.ui.model.SWRLRuleEngineModel;

public class SWRLAPIFactory {
    private static final @NonNull SWRLRuleAndQueryEngineFactory swrlRuleAndQueryEngineFactory = SWRLAPIInternalFactory.getSWRLRuleAndQueryEngineFactory();

    public static @NonNull SWRLRuleEngine createSWRLRuleEngine(@NonNull OWLOntology ontology) throws SWRLRuleEngineException {
        IRIResolver iriResolver = SWRLAPIFactory.createIRIResolver();
        return swrlRuleAndQueryEngineFactory.createSWRLRuleEngine(ontology, iriResolver);
    }

    public static @NonNull SWRLRuleEngine createSWRLRuleEngine(@NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) throws SWRLRuleEngineException {
        return swrlRuleAndQueryEngineFactory.createSWRLRuleEngine(ontology, iriResolver);
    }

    public static @NonNull SQWRLQueryEngine createSQWRLQueryEngine(@NonNull OWLOntology ontology) throws SWRLRuleEngineException {
        IRIResolver iriResolver = SWRLAPIFactory.createIRIResolver();
        return swrlRuleAndQueryEngineFactory.createSQWRLQueryEngine(ontology, iriResolver);
    }

    public static @NonNull SQWRLQueryEngine createSQWRLQueryEngine(@NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) throws SWRLRuleEngineException {
        return swrlRuleAndQueryEngineFactory.createSQWRLQueryEngine(ontology, iriResolver);
    }

    public static @NonNull IRIResolver createIRIResolver() {
        return new DefaultIRIResolver();
    }

    public static @NonNull IRIResolver createIRIResolver(String defaultPrefix) {
        return new DefaultIRIResolver(defaultPrefix);
    }

    public static @NonNull SWRLRuleEngineModel createSWRLRuleEngineModel(@NonNull SWRLRuleEngine ruleEngine) {
        return new DefaultSWRLRuleEngineModel(ruleEngine);
    }

    public static @NonNull FileBackedSWRLRuleEngineModel createFileBackedSWRLRuleEngineModel(@NonNull SWRLRuleEngine ruleEngine, Optional<File> file) {
        return new DefaultFileBackedSWRLRuleEngineModel(ruleEngine, file);
    }

    public static @NonNull SQWRLQueryEngineModel createSQWRLQueryEngineModel(@NonNull SQWRLQueryEngine queryEngine) {
        return new DefaultSQWRLQueryEngineModel(queryEngine);
    }

    public static @NonNull FileBackedSQWRLQueryEngineModel createFileBackedSQWRLQueryEngineModel(@NonNull SQWRLQueryEngine queryEngine, Optional<File> file) {
        return new DefaultFileBackedSQWRLQueryEngineModel(queryEngine, file);
    }

    public static @NonNull SQWRLQueryEngineModel createSQWRLQueryEngineModel(@NonNull OWLOntology ontology) {
        SQWRLQueryEngine queryEngine = SWRLAPIFactory.createSQWRLQueryEngine(ontology);
        return new DefaultSQWRLQueryEngineModel(queryEngine);
    }

    public static @NonNull SWRLRuleEngineDialogManager createSWRLRuleEngineDialogManager(@NonNull SWRLRuleEngineModel swrlRuleEngineModel) {
        return new DefaultSWRLRuleEngineDialogManager(swrlRuleEngineModel);
    }
}

