/*
 * Decompiled with CFR 0.152.
 */
package org.swrlapi.factory;

import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.swrlapi.bridge.SWRLBridge;
import org.swrlapi.builtins.SWRLBuiltInLibraryManager;
import org.swrlapi.builtins.arguments.SWRLBuiltInArgument;
import org.swrlapi.core.IRIResolver;
import org.swrlapi.core.SWRLAPIBuiltInAtom;
import org.swrlapi.core.SWRLAPIOWLOntology;
import org.swrlapi.core.SWRLAPIRule;
import org.swrlapi.core.SWRLRuleEngine;
import org.swrlapi.core.SWRLRuleEngineManager;
import org.swrlapi.core.SWRLRuleRenderer;
import org.swrlapi.exceptions.SWRLAPIException;
import org.swrlapi.exceptions.SWRLBuiltInBridgeException;
import org.swrlapi.exceptions.SWRLBuiltInException;
import org.swrlapi.factory.DefaultLiteral;
import org.swrlapi.factory.DefaultLiteralFactory;
import org.swrlapi.factory.DefaultOWL2RLPersistenceLayer;
import org.swrlapi.factory.DefaultOWLDatatypeFactory;
import org.swrlapi.factory.DefaultOWLLiteralFactory;
import org.swrlapi.factory.DefaultSQWRLQuery;
import org.swrlapi.factory.DefaultSQWRLResultManager;
import org.swrlapi.factory.DefaultSQWRLResultValueFactory;
import org.swrlapi.factory.DefaultSWRLAPIBuiltInAtom;
import org.swrlapi.factory.DefaultSWRLAPIOWLDataFactory;
import org.swrlapi.factory.DefaultSWRLAPIOWLOntology;
import org.swrlapi.factory.DefaultSWRLAPIRule;
import org.swrlapi.factory.DefaultSWRLAutoCompleter;
import org.swrlapi.factory.DefaultSWRLBridge;
import org.swrlapi.factory.DefaultSWRLBuiltInArgumentFactory;
import org.swrlapi.factory.DefaultSWRLRuleAndQueryEngineFactory;
import org.swrlapi.factory.DefaultSWRLRuleAndQueryRenderer;
import org.swrlapi.factory.DefaultSWRLRuleEngineController;
import org.swrlapi.factory.DefaultSWRLRuleEngineManager;
import org.swrlapi.factory.LiteralFactory;
import org.swrlapi.factory.OWLDatatypeFactory;
import org.swrlapi.factory.OWLLiteralFactory;
import org.swrlapi.factory.SQWRLResultValueFactory;
import org.swrlapi.factory.SWRLAPIFactory;
import org.swrlapi.factory.SWRLAPIOWLDataFactory;
import org.swrlapi.factory.SWRLBuiltInArgumentFactory;
import org.swrlapi.factory.SWRLRuleAndQueryEngineFactory;
import org.swrlapi.literal.Literal;
import org.swrlapi.owl2rl.OWL2RLEngine;
import org.swrlapi.owl2rl.OWL2RLPersistenceLayer;
import org.swrlapi.sqwrl.SQWRLQuery;
import org.swrlapi.sqwrl.SQWRLQueryRenderer;
import org.swrlapi.sqwrl.SQWRLResultGenerator;
import org.swrlapi.sqwrl.SQWRLResultManager;
import org.swrlapi.ui.controller.SWRLRuleEngineController;
import org.swrlapi.ui.model.OWL2RLModel;
import org.swrlapi.ui.model.SWRLAutoCompleter;
import org.swrlapi.ui.model.SWRLRuleEngineModel;
import org.swrlapi.ui.model.SWRLRulesAndSQWRLQueriesTableModel;

public class SWRLAPIInternalFactory {
    private static final @NonNull String SQWRL_ICON_NAME = "SQWRL.gif";
    private static final @NonNull String OWL2RL_ICON_NAME = "OWL2RL.gif";
    private static final @NonNull SWRLRuleAndQueryEngineFactory swrlRuleAndQueryEngineFactory = new DefaultSWRLRuleAndQueryEngineFactory();

    public static @NonNull SWRLRuleAndQueryEngineFactory getSWRLRuleAndQueryEngineFactory() {
        return swrlRuleAndQueryEngineFactory;
    }

    public static @NonNull SWRLBuiltInLibraryManager createSWRLBuiltInLibraryManager() {
        return new SWRLBuiltInLibraryManager();
    }

    public static @NonNull SWRLRuleRenderer createSWRLRuleRenderer(@NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) {
        return new DefaultSWRLRuleAndQueryRenderer(ontology, iriResolver);
    }

    public static @NonNull SQWRLQueryRenderer createSQWRLQueryRenderer(@NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) {
        return new DefaultSWRLRuleAndQueryRenderer(ontology, iriResolver);
    }

    public static @NonNull SWRLRuleEngineManager createSWRLRuleEngineManager() {
        return new DefaultSWRLRuleEngineManager();
    }

    public static @NonNull SQWRLResultManager createSQWRLResultManager(@NonNull IRIResolver iriResolver) {
        return new DefaultSQWRLResultManager(iriResolver);
    }

    public static @NonNull OWL2RLPersistenceLayer createOWL2RLPersistenceLayer(@NonNull OWLOntology ontology) {
        return new DefaultOWL2RLPersistenceLayer(ontology);
    }

    public static @NonNull SWRLBuiltInArgumentFactory createSWRLBuiltInArgumentFactory(@NonNull IRIResolver iriResolver) {
        return new DefaultSWRLBuiltInArgumentFactory(iriResolver);
    }

    public static @NonNull SQWRLResultValueFactory createSQWRLResultValueFactory(@NonNull IRIResolver iriResolver) {
        return new DefaultSQWRLResultValueFactory(iriResolver);
    }

    public static @NonNull SQWRLQuery createSQWRLQuery(@NonNull String queryName, @NonNull List<@NonNull SWRLAtom> bodyAtoms, @NonNull List<@NonNull SWRLAtom> headAtoms, boolean active, @NonNull String comment, @NonNull LiteralFactory literalFactory, @NonNull IRIResolver iriResolver) throws SWRLBuiltInException {
        return new DefaultSQWRLQuery(queryName, bodyAtoms, headAtoms, active, comment, literalFactory, iriResolver);
    }

    public static @NonNull SWRLAPIOWLDataFactory createSWRLAPIOWLDataFactory(@NonNull IRIResolver iriResolver) {
        return new DefaultSWRLAPIOWLDataFactory(iriResolver);
    }

    public static @NonNull SWRLRulesAndSQWRLQueriesTableModel createSWRLRulesAndSQWRLQueriesTableModel(@NonNull SWRLRuleEngine swrlRuleEngine) {
        return new SWRLRulesAndSQWRLQueriesTableModel(swrlRuleEngine);
    }

    public static @NonNull OWL2RLModel createOWL2RLModel(@NonNull OWL2RLEngine owl2RLEngine) {
        return new OWL2RLModel(owl2RLEngine);
    }

    public static @NonNull LiteralFactory createLiteralFactory() {
        return new DefaultLiteralFactory();
    }

    public static @NonNull OWLDatatypeFactory createOWLDatatypeFactory() {
        return new DefaultOWLDatatypeFactory();
    }

    public static @NonNull OWLLiteralFactory createOWLLiteralFactory() {
        return new DefaultOWLLiteralFactory();
    }

    public static @NonNull SQWRLResultGenerator createSQWRLResultGenerator(@NonNull IRIResolver iriResolver) {
        return new DefaultSQWRLResultManager(iriResolver);
    }

    public static @NonNull SWRLRuleEngineController createSWRLRuleEngineController(@NonNull SWRLRuleEngineModel swrlRuleEngineModel) {
        return new DefaultSWRLRuleEngineController(swrlRuleEngineModel);
    }

    public static @NonNull Icon getSQWRLIcon() throws SWRLAPIException {
        URL url = SWRLAPIFactory.class.getResource(SQWRL_ICON_NAME);
        if (url != null) {
            return new ImageIcon(url);
        }
        throw new SWRLAPIException("No SQWRL icon found!");
    }

    public static @NonNull Icon getOWL2RLReasonerIcon() throws SWRLAPIException {
        URL url = SWRLAPIFactory.class.getResource(OWL2RL_ICON_NAME);
        if (url != null) {
            return new ImageIcon(url);
        }
        throw new SWRLAPIException("No OWL 2 RL icon found!");
    }

    public static @NonNull Literal createLiteral(OWLLiteral owlLiteral) {
        return new DefaultLiteral(owlLiteral);
    }

    public static @NonNull SWRLAPIRule createSWRLAPIRule(@NonNull String ruleName, @NonNull List<? extends SWRLAtom> bodyAtoms, @NonNull List<? extends SWRLAtom> headAtoms, @NonNull String comment, boolean isActive) throws SWRLBuiltInException {
        return new DefaultSWRLAPIRule(ruleName, bodyAtoms, headAtoms, comment, isActive);
    }

    public static @NonNull SWRLAPIBuiltInAtom createSWRLAPIBuiltInAtom(@NonNull String ruleName, @NonNull IRI builtInIRI, @NonNull String builtInPrefixedName, @NonNull List<@NonNull SWRLBuiltInArgument> arguments) {
        return new DefaultSWRLAPIBuiltInAtom(ruleName, builtInIRI, builtInPrefixedName, arguments);
    }

    public static @NonNull SWRLAPIOWLOntology createSWRLAPIOntology(@NonNull OWLOntology ontology, @NonNull IRIResolver iriResolver) throws SWRLBuiltInException {
        DefaultSWRLAPIOWLOntology swrlapiowlOntology = new DefaultSWRLAPIOWLOntology(ontology, iriResolver);
        swrlapiowlOntology.processOntology();
        return swrlapiowlOntology;
    }

    public static @NonNull SWRLAPIOWLOntology createSWRLAPIOntology(@NonNull OWLOntology ontology) throws SWRLBuiltInException {
        IRIResolver iriResolver = SWRLAPIFactory.createIRIResolver();
        DefaultSWRLAPIOWLOntology swrlapiowlOntology = new DefaultSWRLAPIOWLOntology(ontology, iriResolver);
        swrlapiowlOntology.processOntology();
        return swrlapiowlOntology;
    }

    public static @NonNull SWRLBridge createSWRLBridge(@NonNull SWRLAPIOWLOntology swrlapiOWLOntology, @NonNull OWL2RLPersistenceLayer owl2RLPersistenceLayer) throws SWRLBuiltInBridgeException {
        return new DefaultSWRLBridge(swrlapiOWLOntology, owl2RLPersistenceLayer);
    }

    public static @NonNull SWRLAutoCompleter createSWRLAutoCompleter(@NonNull SWRLAPIOWLOntology swrlapiowlOntology) {
        return new DefaultSWRLAutoCompleter(swrlapiowlOntology);
    }

    private static @NonNull OWLOntology createOWLOntology(@NonNull OWLOntologyManager ontologyManager, @NonNull File file) throws SWRLAPIException {
        try {
            return ontologyManager.loadOntologyFromOntologyDocument(file);
        }
        catch (OWLOntologyCreationException e) {
            throw new SWRLAPIException("Error create OWL ontology from file " + file.getAbsolutePath() + ": " + (e.getMessage() != null ? e.getMessage() : ""));
        }
    }

    static {
        swrlRuleAndQueryEngineFactory.tryToRegisterADefaultSWRLRuleEngine();
    }
}

